/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.analyzer.goals;

import com.linkedin.kafka.cruisecontrol.analyzer.ReplicaBalancingAction;
import com.linkedin.kafka.cruisecontrol.analyzer.goals.TopicStats;
import com.linkedin.kafka.cruisecontrol.model.Broker;
import com.linkedin.kafka.cruisecontrol.model.ClusterModel;
import com.linkedin.kafka.cruisecontrol.model.TopicImbalanceScoreType;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterTopicStats
implements TopicStats {
    private static final Logger LOG = LoggerFactory.getLogger(ClusterTopicStats.class);
    private List<String> eligibleTopicsForRebalance;
    private Map<String, Double> eligibleTopicsForRebalanceInitialScores;
    private final Map<String, Double> averageLeadersPerBrokerForTopic;
    private final Map<String, Double> averageFollowersPerBrokerForTopic;
    Map<String, Integer> brokersPerRack;
    private Map<String, Integer> currentTopicLeadersPerRack;
    private final Map<String, Integer> expectedTopicLeadersLowerLimitPerRack;
    private final Map<String, Integer> expectedTopicLeadersUpperLimitPerRack;

    public ClusterTopicStats() {
        this.averageLeadersPerBrokerForTopic = new HashMap<String, Double>();
        this.averageFollowersPerBrokerForTopic = new HashMap<String, Double>();
        this.eligibleTopicsForRebalance = new ArrayList<String>();
        this.eligibleTopicsForRebalanceInitialScores = new HashMap<String, Double>();
        this.brokersPerRack = new HashMap<String, Integer>();
        this.currentTopicLeadersPerRack = new HashMap<String, Integer>();
        this.expectedTopicLeadersLowerLimitPerRack = new HashMap<String, Integer>();
        this.expectedTopicLeadersUpperLimitPerRack = new HashMap<String, Integer>();
    }

    ClusterTopicStats(List<String> eligibleTopicsForRebalance, Map<String, Double> eligibleTopicsForRebalanceInitialScores, Map<String, Double> averageLeadersPerBrokerForTopic, Map<String, Double> averageFollowersPerBrokerForTopic, Map<String, Integer> brokersPerRack, Map<String, Integer> currentTopicLeadersPerRack, Map<String, Integer> expectedTopicLeadersLowerLimitPerRack, Map<String, Integer> expectedTopicLeadersUpperLimitPerRack) {
        this.eligibleTopicsForRebalance = eligibleTopicsForRebalance;
        this.eligibleTopicsForRebalanceInitialScores = eligibleTopicsForRebalanceInitialScores;
        this.averageLeadersPerBrokerForTopic = averageLeadersPerBrokerForTopic;
        this.averageFollowersPerBrokerForTopic = averageFollowersPerBrokerForTopic;
        this.brokersPerRack = brokersPerRack;
        this.currentTopicLeadersPerRack = currentTopicLeadersPerRack;
        this.expectedTopicLeadersLowerLimitPerRack = expectedTopicLeadersLowerLimitPerRack;
        this.expectedTopicLeadersUpperLimitPerRack = expectedTopicLeadersUpperLimitPerRack;
    }

    @Override
    public double getAverageLeadersForBrokerForTopic(String topic, Broker broker, double defaultValue) {
        return this.averageLeadersPerBrokerForTopic.getOrDefault(topic, defaultValue);
    }

    @Override
    public void initializeAverageLeadersForBrokersForTopic(ClusterModel clusterModel, String topic) {
        int numEligibleDestinationBrokers = clusterModel.eligibleDestinationBrokers().size();
        int allLeadersForTopic = clusterModel.eligibleDestinationBrokers().stream().mapToInt(broker -> broker.leaderReplicasOfTopicInBroker(topic).size()).sum();
        double avgLeaderReplicasPerBrokerForTopic = numEligibleDestinationBrokers > 0 ? (double)allLeadersForTopic / (double)numEligibleDestinationBrokers : 0.0;
        LOG.debug("Average Leader replicas per broker for topic {}: {}", (Object)topic, (Object)avgLeaderReplicasPerBrokerForTopic);
        this.averageLeadersPerBrokerForTopic.put(topic, avgLeaderReplicasPerBrokerForTopic);
    }

    @Override
    public double getAverageFollowersForBrokerForTopic(String topic, Broker broker, double defaultValue) {
        return this.averageFollowersPerBrokerForTopic.getOrDefault(topic, defaultValue);
    }

    @Override
    public void initializeAverageFollowersForBrokersForTopic(ClusterModel clusterModel, String topic) {
        int numEligibleDestinationBrokers = clusterModel.eligibleDestinationBrokers().size();
        int allFollowersForTopic = clusterModel.eligibleDestinationBrokers().stream().mapToInt(broker -> broker.followerReplicasOfTopicInBroker(topic).size()).sum();
        double avgFollowerReplicasPerBrokerForTopic = numEligibleDestinationBrokers > 0 ? (double)allFollowersForTopic / (double)numEligibleDestinationBrokers : 0.0;
        LOG.debug("Average Follower replicas per broker for topic {}: {}", (Object)topic, (Object)avgFollowerReplicasPerBrokerForTopic);
        this.averageFollowersPerBrokerForTopic.put(topic, avgFollowerReplicasPerBrokerForTopic);
    }

    @Override
    public List<Integer> replicaDistributionForTopic(ClusterModel clusterModel, String topic, Boolean isLeader, Broker hostBroker) {
        return clusterModel.replicaDistributionForTopic(topic, isLeader);
    }

    @Override
    public List<Integer> replicaDistributionAfterAction(ClusterModel clusterModel, ReplicaBalancingAction action, Boolean isLeader) {
        String topic = action.topic();
        int limitNumberOfBrokers = isLeader != false ? clusterModel.numLeaderReplicasForTopicOnEligibleDestinationBrokers(topic) : clusterModel.numFollowerReplicasForTopicOnEligibleDestinationBrokers(topic);
        return clusterModel.eligibleDestinationBrokers().stream().mapToInt(broker -> {
            int numOfReplica;
            int n = numOfReplica = isLeader != false ? broker.numLeaderReplicasOfTopicInBroker(topic) : broker.numFollowerReplicasOfTopicInBroker(topic);
            if (broker.id() == action.sourceBrokerId().intValue()) {
                return numOfReplica - 1;
            }
            if (broker.id() == action.destinationBrokerId().intValue()) {
                return numOfReplica + 1;
            }
            return numOfReplica;
        }).boxed().sorted(Comparator.reverseOrder()).limit(limitNumberOfBrokers).collect(Collectors.toList());
    }

    @Override
    public List<String> getEligibleTopicsForRebalance() {
        return this.eligibleTopicsForRebalance;
    }

    @Override
    public void setEligibleTopicsForRebalance(List<String> topics) {
        LOG.debug("Setting eligible topics for rebalance: {}", topics);
        this.eligibleTopicsForRebalance = topics;
    }

    @Override
    public Double getEligibleTopicsForRebalanceInitialScore(String topic) {
        return this.eligibleTopicsForRebalanceInitialScores.get(topic);
    }

    @Override
    public double getTopicImbalanceScore(String topic, ClusterModel clusterModel) {
        return clusterModel.topicImbalanceScore(topic, TopicImbalanceScoreType.REPLICA_DISTRIBUTION_BASED);
    }

    @Override
    public double getTopicImbalanceScore(String topic, ClusterModel clusterModel, Broker broker) {
        return clusterModel.topicImbalanceScore(topic, TopicImbalanceScoreType.REPLICA_DISTRIBUTION_BASED);
    }

    @Override
    public void logChangeInTopicImbalanceScore(String topic, ClusterModel clusterModel) {
        LOG.debug("For topic: {}, imbalance score changed from {} to {}", new Object[]{topic, this.getEligibleTopicsForRebalanceInitialScore(topic), this.getTopicImbalanceScore(topic, clusterModel)});
    }

    @Override
    public Set<Broker> getEligibleDestinationBrokers(ClusterModel clusterModel, Broker sourceBroker) {
        return clusterModel.eligibleDestinationBrokers();
    }

    @Override
    public Set<Broker> getEligibleSourceBrokers(ClusterModel clusterModel, Broker destinationBroker) {
        return clusterModel.eligibleSourceBrokers();
    }

    @Override
    public boolean hasMoreTopicLeadersForRack(String rack) {
        return this.currentTopicLeadersPerRack.get(rack) > this.expectedTopicLeadersUpperLimitPerRack.get(rack) || Objects.equals(this.currentTopicLeadersPerRack.get(rack), this.expectedTopicLeadersUpperLimitPerRack.get(rack)) && this.expectedTopicLeadersUpperLimitPerRack.get(rack) > this.expectedTopicLeadersLowerLimitPerRack.get(rack);
    }

    @Override
    public boolean hasLessTopicLeadersForRack(String rack) {
        return this.currentTopicLeadersPerRack.get(rack) < this.expectedTopicLeadersLowerLimitPerRack.get(rack);
    }

    @Override
    public boolean canAccommodateMoreTopicLeadersForRack(String rack) {
        return this.currentTopicLeadersPerRack.get(rack) < this.expectedTopicLeadersUpperLimitPerRack.get(rack);
    }

    @Override
    public boolean canAccommodateMoreTopicLeadersForRack(String rack, Broker broker) {
        return this.canAccommodateMoreTopicLeadersForRack(rack);
    }

    @Override
    public int numTopicLeadersThatCanBeMovedToRack(String rack) {
        return this.expectedTopicLeadersUpperLimitPerRack.get(rack) - this.currentTopicLeadersPerRack.get(rack);
    }

    @Override
    public boolean metRackTopicLeadersUpperBound(String rack) {
        return this.currentTopicLeadersPerRack.get(rack) < this.expectedTopicLeadersUpperLimitPerRack.get(rack) || Objects.equals(this.currentTopicLeadersPerRack.get(rack), this.expectedTopicLeadersUpperLimitPerRack.get(rack)) && Objects.equals(this.expectedTopicLeadersUpperLimitPerRack.get(rack), this.expectedTopicLeadersLowerLimitPerRack.get(rack));
    }

    @Override
    public boolean canReleaseMoreTopicLeadersForRack(String rack) {
        return this.currentTopicLeadersPerRack.get(rack) > this.expectedTopicLeadersLowerLimitPerRack.get(rack);
    }

    @Override
    public boolean canReleaseMoreTopicLeadersForRack(String rack, Broker broker) {
        return this.canReleaseMoreTopicLeadersForRack(rack);
    }

    @Override
    public int numTopicLeadersThatCanBeMovedFromRack(String rack) {
        return this.currentTopicLeadersPerRack.get(rack) - this.expectedTopicLeadersLowerLimitPerRack.get(rack);
    }

    @Override
    public boolean metRackTopicLeadersLowerBound(String rack) {
        return this.currentTopicLeadersPerRack.get(rack) >= this.expectedTopicLeadersLowerLimitPerRack.get(rack);
    }

    @Override
    public boolean isCurrentTopicLeadersCountAtUpperBoundForRack(String rack, Broker broker) {
        return Objects.equals(this.currentTopicLeadersPerRack.get(rack), this.expectedTopicLeadersUpperLimitPerRack.get(rack));
    }

    @Override
    public boolean isCurrentTopicLeadersCountAtLowerBoundForRack(String rack, Broker broker) {
        return Objects.equals(this.currentTopicLeadersPerRack.get(rack), this.expectedTopicLeadersLowerLimitPerRack.get(rack));
    }

    @Override
    public void incrementCurrentTopicLeadersPerRack(String rack, Broker broker, Integer count) {
        this.currentTopicLeadersPerRack.put(rack, this.currentTopicLeadersPerRack.get(rack) + count);
    }

    @Override
    public void decrementCurrentTopicLeadersPerRack(String rack, Broker broker, Integer count) {
        this.currentTopicLeadersPerRack.put(rack, this.currentTopicLeadersPerRack.get(rack) - count);
    }

    @Override
    public void initializeRackRelatedTopicLeaderDistribution(ClusterModel clusterModel, String topic) {
        this.currentTopicLeadersPerRack.clear();
        this.expectedTopicLeadersLowerLimitPerRack.clear();
        this.expectedTopicLeadersUpperLimitPerRack.clear();
        this.currentTopicLeadersPerRack = clusterModel.aliveRackIds().stream().collect(Collectors.toMap(rack -> rack, rack -> 0));
        int leadersForTopicOnEligibleBrokers = (int)clusterModel.eligibleDestinationBrokers().stream().mapToLong(broker -> broker.leaderReplicasOfTopicInBroker(topic).size()).sum();
        int eligibleBrokersCount = clusterModel.eligibleDestinationBrokers().size();
        for (Broker broker2 : clusterModel.eligibleDestinationBrokers()) {
            int replicaCount = broker2.numLeaderReplicasOfTopicInBroker(topic);
            this.currentTopicLeadersPerRack.compute(broker2.rack().id(), (k, v) -> v == null ? replicaCount : v + replicaCount);
        }
        for (String rack2 : clusterModel.aliveRackIds()) {
            int numBrokersInRack = this.brokersPerRack.get(rack2);
            double avgLeaderReplicasForRack = (double)(numBrokersInRack * leadersForTopicOnEligibleBrokers) / (double)eligibleBrokersCount;
            this.expectedTopicLeadersLowerLimitPerRack.put(rack2, (int)Math.floor(avgLeaderReplicasForRack));
            this.expectedTopicLeadersUpperLimitPerRack.put(rack2, (int)Math.ceil(avgLeaderReplicasForRack));
        }
        LOG.debug("Leaders per rack for topic {}: {}, expected lower limit per rack: {}, expected upper limit per rack: {}", new Object[]{topic, this.currentTopicLeadersPerRack, this.expectedTopicLeadersLowerLimitPerRack, this.expectedTopicLeadersUpperLimitPerRack});
    }

    @Override
    public void initializeBrokersCountPerRack(ClusterModel clusterModel) {
        this.brokersPerRack = clusterModel.aliveRackIds().stream().collect(Collectors.toMap(rack -> rack, rack -> 0));
        clusterModel.eligibleDestinationBrokers().forEach(broker -> this.brokersPerRack.compute(broker.rack().id(), (k, v) -> v + 1));
    }

    @Override
    public void initializeTopicsToRebalanceInitialScores(ClusterModel clusterModel, TopicImbalanceScoreType scoreType) {
        this.eligibleTopicsForRebalanceInitialScores = this.eligibleTopicsForRebalance.stream().distinct().collect(Collectors.toMap(topic -> topic, topic -> clusterModel.topicImbalanceScore((String)topic, scoreType)));
    }
}

