/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.common;

import com.linkedin.kafka.cruisecontrol.common.Resource;
import com.linkedin.kafka.cruisecontrol.model.Tenant;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.function.ToDoubleFunction;
import java.util.function.ToIntFunction;

public enum CellResource {
    CPU(0, Resource.CPU),
    NW_IN(1, Resource.NW_IN),
    NW_OUT(2, Resource.NW_OUT),
    PRODUCE_IN(3, Resource.PRODUCE_IN),
    CONSUME_OUT(4, Resource.CONSUME_OUT),
    REPLICA_COUNT(5, null);

    private static final Collection<CellResource> CACHED_VALUES;
    private final int id;
    private final Resource resource;
    private final Comparator<Tenant> globalTenantResourceUtilComparator;

    private CellResource(int id, Resource resource) {
        this.id = id;
        this.resource = resource;
        if (resource == null) {
            ToIntFunction<Tenant> tenantResourceUtilAcrossCells = Tenant::replicaCount;
            this.globalTenantResourceUtilComparator = Comparator.comparingInt(tenantResourceUtilAcrossCells).reversed();
        } else {
            ToDoubleFunction<Tenant> tenantResourceUtilAcrossCells = tenant -> tenant.utilization().eligibleSourceUtilization().map(load -> load.expectedUtilizationFor(resource)).orElse(0.0);
            this.globalTenantResourceUtilComparator = Comparator.comparingDouble(tenantResourceUtilAcrossCells).reversed();
        }
    }

    public static Collection<CellResource> cachedValues() {
        return CACHED_VALUES;
    }

    public int id() {
        return this.id;
    }

    public Resource resource() {
        return this.resource;
    }

    public Comparator<Tenant> tenantResourceUtilComparator() {
        return this.globalTenantResourceUtilComparator;
    }

    public Comparator<Tenant> tenantResourceUtilComparator(int cellId) {
        if (this.resource == null) {
            ToIntFunction<Tenant> cellSpecificTenantResourceUtil = tenant -> tenant.replicaCount(cellId);
            return Comparator.comparingInt(cellSpecificTenantResourceUtil).reversed();
        }
        ToDoubleFunction<Tenant> cellSpecificTenantResourceUtil = tenant -> tenant.utilization(cellId).eligibleSourceUtilization().map(load -> load.expectedUtilizationFor(this.resource)).orElse(0.0);
        return Comparator.comparingDouble(cellSpecificTenantResourceUtil).reversed();
    }

    static {
        CACHED_VALUES = Collections.unmodifiableSet(EnumSet.allOf(CellResource.class));
    }
}

