/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.config;

import com.linkedin.kafka.cruisecontrol.common.Resource;
import com.linkedin.kafka.cruisecontrol.config.BrokerCapacityConfigResolver;
import com.linkedin.kafka.cruisecontrol.config.BrokerCapacityInfo;
import com.linkedin.kafka.cruisecontrol.config.ClusterBrokerCapacityConfigResolver;
import io.confluent.metrics.reporter.VolumeMetricsProvider;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.DoubleUnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.kafka.common.config.ConfigException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrokerCapacityResolver
implements BrokerCapacityConfigResolver {
    private static final Logger LOG = LoggerFactory.getLogger(BrokerCapacityResolver.class);
    public static final int DEFAULT_CAPACITY_BROKER_ID = -1;
    public static final String LOG_DIRS_CONFIG = "log.dirs";
    static final double BYTES_PER_KB = 1024.0;
    private static final Double DEFAULT_CPU_CAPACITY = 100.0;
    private static final double SINGLE_UNIT_UPDATE_THRESHOLD = 1.0;
    private static final double DISK_CAPACITY_WARN_THRESHOLD = 1.0;
    private static final Map<Resource, ResourceConfig> BROKER_RESOURCE_CONFIGS = Stream.of(new AbstractMap.SimpleEntry<Resource, ResourceConfig>(Resource.NW_IN, new ResourceConfig("network.in.max.bytes.per.second", bps -> bps / 1024.0)), new AbstractMap.SimpleEntry<Resource, ResourceConfig>(Resource.PRODUCE_IN, new ResourceConfig("producer.in.max.bytes.per.second", bps -> bps / 1024.0)), new AbstractMap.SimpleEntry<Resource, ResourceConfig>(Resource.NW_OUT, new ResourceConfig("network.out.max.bytes.per.second", bps -> bps / 1024.0)), new AbstractMap.SimpleEntry<Resource, ResourceConfig>(Resource.CONSUME_OUT, new ResourceConfig("consumer.out.max.bytes.per.second", bps -> bps / 1024.0)), new AbstractMap.SimpleEntry<Resource, ResourceConfig>(Resource.RACK_BASED_CONSUME_OUT, new ResourceConfig("consumer.out.max.bytes.per.second", bps -> bps / 1024.0)), new AbstractMap.SimpleEntry<Resource, ResourceConfig>(Resource.RACK_LESS_CONSUME_OUT, new ResourceConfig("consumer.out.max.bytes.per.second", bps -> bps / 1024.0)), new AbstractMap.SimpleEntry<Resource, ResourceConfig>(Resource.MIRROR_IN, new ResourceConfig("producer.in.max.bytes.per.second", bps -> bps / 1024.0)), new AbstractMap.SimpleEntry<Resource, ResourceConfig>(Resource.REPLICATION_IN, new ResourceConfig("replication.in.max.bytes.per.second", bps -> bps / 1024.0))).collect(Collectors.toMap(AbstractMap.SimpleEntry::getKey, AbstractMap.SimpleEntry::getValue));
    private volatile Map<Integer, BrokerCapacityInfo> capacitiesForBrokers = new HashMap<Integer, BrokerCapacityInfo>();
    private volatile BrokerCapacityInfo defaultBrokerCapacityInfo = null;

    @Override
    public BrokerCapacityInfo capacityForBroker(String rack, String host, int brokerId) {
        return BrokerCapacityResolver.capacityForBroker(brokerId, this.capacitiesForBrokers, this.defaultBrokerCapacityInfo);
    }

    private static BrokerCapacityInfo capacityForBroker(int brokerId, Map<Integer, BrokerCapacityInfo> capacitiesForBrokers, BrokerCapacityInfo defaultBrokerCapacityInfo) {
        if (defaultBrokerCapacityInfo == null) {
            throw new ConfigException("not configured");
        }
        if (brokerId < 0) {
            throw new IllegalArgumentException("The broker id(" + brokerId + ") should be non-negative.");
        }
        BrokerCapacityInfo capacity = capacitiesForBrokers.get(brokerId);
        if (capacity != null) {
            return capacity;
        }
        LOG.debug("Returning default broker capacity for broker {}", (Object)brokerId);
        return defaultBrokerCapacityInfo;
    }

    @Override
    public void configure(Map<String, ?> configs) {
        LOG.info("CruiseControl: Attempting to configure Broker Capacity from config properties");
        HashMap<Resource, Double> defaultBrokerCapacity = new HashMap<Resource, Double>();
        defaultBrokerCapacity.put(Resource.CPU, DEFAULT_CPU_CAPACITY);
        for (Map.Entry<Resource, ResourceConfig> resource : BROKER_RESOURCE_CONFIGS.entrySet()) {
            Double parsedValue;
            ResourceConfig resourceConfig = resource.getValue();
            Long configValue = (Long)configs.get(resourceConfig.configName);
            try {
                parsedValue = resourceConfig.convertConfigValue(configValue.doubleValue());
            }
            catch (NumberFormatException e) {
                throw new ConfigException("Invalid capacity (unparseable) " + configValue + " for capacity measure " + String.valueOf(resourceConfig), (Object)e);
            }
            if (parsedValue < 0.0 || parsedValue == null) {
                throw new ConfigException("Negative capacity " + parsedValue + " (from " + configValue + ") is not allowed for " + String.valueOf(resourceConfig));
            }
            defaultBrokerCapacity.put(resource.getKey(), parsedValue);
        }
        Boolean populateDefaultDiskCapacityWithLocalDisk = (Boolean)configs.get("populate.default.disk.capacity.from.local");
        if (populateDefaultDiskCapacityWithLocalDisk != null && populateDefaultDiskCapacityWithLocalDisk.booleanValue()) {
            double diskCapacityInMiB = this.diskCapacityForCurrentBrokerInMiB(configs);
            if (diskCapacityInMiB < 1.0) {
                LOG.warn("Default broker disk capacity configured to {} MB", (Object)diskCapacityInMiB);
            }
            defaultBrokerCapacity.put(Resource.DISK, diskCapacityInMiB);
        }
        this.defaultBrokerCapacityInfo = BrokerCapacityInfo.builder().capacity(defaultBrokerCapacity).estimationInfo("default broker capacity").build();
    }

    @Override
    public void mergeCapacitiesForBrokers(Map<ClusterBrokerCapacityConfigResolver.Broker, Map<Resource, Double>> brokerCapacities) {
        HashMap<Integer, BrokerCapacityInfo> capacitiesToBeEnforced = new HashMap<Integer, BrokerCapacityInfo>(this.capacitiesForBrokers);
        brokerCapacities.forEach((broker, providedCapacities) -> {
            if (broker.brokerId() < 0) {
                LOG.warn("Received capacity update for broker with negative id: {}, skipping update", (Object)broker.brokerId());
                return;
            }
            BrokerCapacityInfo originalBrokerCapacity = BrokerCapacityResolver.capacityForBroker(broker.brokerId(), capacitiesToBeEnforced, this.defaultBrokerCapacityInfo);
            HashMap<Resource, Double> finalCapacities = new HashMap<Resource, Double>(originalBrokerCapacity.capacity());
            for (Map.Entry providedCapacity : providedCapacities.entrySet()) {
                double updatedCapacity;
                if ((Double)providedCapacity.getValue() < 0.0) {
                    LOG.warn("Received negative capacity update for resource {} for broker {}, skipping update", providedCapacity.getKey(), (Object)broker.brokerId());
                    continue;
                }
                double currentCapacity = originalBrokerCapacity.capacity().getOrDefault(providedCapacity.getKey(), 0.0);
                if (Math.abs(currentCapacity - (updatedCapacity = ((Double)providedCapacity.getValue()).doubleValue())) > 1.0) {
                    LOG.info("Updating {} capacity for broker {} from {} to {} {}", new Object[]{providedCapacity.getKey(), broker.brokerId(), currentCapacity, updatedCapacity, ((Resource)((Object)((Object)providedCapacity.getKey()))).unit()});
                    finalCapacities.put((Resource)((Object)((Object)providedCapacity.getKey())), (Double)providedCapacity.getValue());
                    continue;
                }
                LOG.debug("Skipping request to update {} capacity for broker {} from {} to {} {}", new Object[]{providedCapacity.getKey(), broker.brokerId(), currentCapacity, updatedCapacity, ((Resource)((Object)((Object)providedCapacity.getKey()))).unit()});
            }
            capacitiesToBeEnforced.put(broker.brokerId(), BrokerCapacityInfo.builder().estimationInfo(originalBrokerCapacity.estimationInfo()).numCpuCores(originalBrokerCapacity.numCpuCores()).capacity(finalCapacities).build());
        });
        this.capacitiesForBrokers = capacitiesToBeEnforced;
    }

    @Override
    public Map<ClusterBrokerCapacityConfigResolver.Broker, BrokerCapacityInfo> capacitiesForBrokers(List<ClusterBrokerCapacityConfigResolver.Broker> brokerIds) {
        HashMap<Integer, BrokerCapacityInfo> allBrokerCapacities = new HashMap<Integer, BrokerCapacityInfo>(this.capacitiesForBrokers);
        HashMap<ClusterBrokerCapacityConfigResolver.Broker, BrokerCapacityInfo> result = new HashMap<ClusterBrokerCapacityConfigResolver.Broker, BrokerCapacityInfo>(brokerIds.size());
        brokerIds.forEach(broker -> result.put((ClusterBrokerCapacityConfigResolver.Broker)broker, BrokerCapacityResolver.capacityForBroker(broker.brokerId(), allBrokerCapacities, this.defaultBrokerCapacityInfo)));
        return result;
    }

    @Override
    public void updateDiskCapacityForBroker(String rack, String host, int brokerId, double updateDiskCapacityInMiB) {
        this.mergeCapacitiesForBrokers(Map.of(new ClusterBrokerCapacityConfigResolver.Broker(rack, host, brokerId), Map.of(Resource.DISK, updateDiskCapacityInMiB)));
    }

    private double diskCapacityForCurrentBrokerInMiB(Map<String, ?> configs) {
        String logDir;
        String string = logDir = configs.get(LOG_DIRS_CONFIG) instanceof String ? (String)configs.get(LOG_DIRS_CONFIG) : null;
        if (logDir == null || logDir.length() == 0) {
            throw new ConfigException("Error calculating disk capacity, invalid log dir " + logDir);
        }
        VolumeMetricsProvider volumeMetricsProvider = new VolumeMetricsProvider(0L, new String[]{logDir});
        Collection volumeInfos = volumeMetricsProvider.getMetrics().values();
        if (volumeInfos.size() > 1) {
            throw new IllegalStateException("Static disk size estimation not supported for multiple volumes");
        }
        Optional volume = volumeInfos.stream().findFirst();
        if (volume.isPresent()) {
            return (double)((VolumeMetricsProvider.VolumeInfo)volume.get()).totalBytes() / 1048576.0;
        }
        throw new ConfigException("Error calculating disk capacity, couldn't find volumes for log dir" + logDir);
    }

    private static class ResourceConfig {
        String configName;
        DoubleUnaryOperator conversionFunc;

        ResourceConfig(String configId, DoubleUnaryOperator converter) {
            this.configName = Objects.requireNonNull(configId);
            this.conversionFunc = Objects.requireNonNull(converter);
        }

        Double convertConfigValue(Double configValue) {
            return this.conversionFunc.applyAsDouble(configValue);
        }
    }
}

