/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.monitor;

import com.linkedin.cruisecontrol.exception.NotEnoughValidWindowsException;
import com.linkedin.cruisecontrol.monitor.sampling.aggregator.MetricSampleAggregationResult;
import com.linkedin.cruisecontrol.monitor.sampling.aggregator.MetricSampleCompleteness;
import com.linkedin.cruisecontrol.monitor.sampling.aggregator.ValuesAndExtrapolations;
import com.linkedin.kafka.cruisecontrol.KafkaCruiseControlUtils;
import com.linkedin.kafka.cruisecontrol.async.progress.GeneratingClusterModel;
import com.linkedin.kafka.cruisecontrol.async.progress.OperationProgress;
import com.linkedin.kafka.cruisecontrol.async.progress.WaitingForClusterModel;
import com.linkedin.kafka.cruisecontrol.common.KafkaCruiseControlThreadFactory;
import com.linkedin.kafka.cruisecontrol.common.MetadataClient;
import com.linkedin.kafka.cruisecontrol.common.Resource;
import com.linkedin.kafka.cruisecontrol.config.BrokerCapacityConfigResolver;
import com.linkedin.kafka.cruisecontrol.config.BrokerCapacityInfo;
import com.linkedin.kafka.cruisecontrol.config.ClusterBrokerCapacityConfigResolver;
import com.linkedin.kafka.cruisecontrol.config.ConfigSupplier;
import com.linkedin.kafka.cruisecontrol.config.KafkaCruiseControlConfig;
import com.linkedin.kafka.cruisecontrol.config.UpdatableSbcGoalsConfig;
import com.linkedin.kafka.cruisecontrol.model.Broker;
import com.linkedin.kafka.cruisecontrol.model.ClusterModel;
import com.linkedin.kafka.cruisecontrol.model.ClusterModelHelper;
import com.linkedin.kafka.cruisecontrol.model.TopicImbalanceScoreType;
import com.linkedin.kafka.cruisecontrol.monitor.BrokerStats;
import com.linkedin.kafka.cruisecontrol.monitor.ModelCompletenessRequirements;
import com.linkedin.kafka.cruisecontrol.monitor.ModelGeneration;
import com.linkedin.kafka.cruisecontrol.monitor.MonitorUtils;
import com.linkedin.kafka.cruisecontrol.monitor.SamplerStateHandle;
import com.linkedin.kafka.cruisecontrol.monitor.SingleBrokerStats;
import com.linkedin.kafka.cruisecontrol.monitor.sampling.aggregator.KafkaPartitionMetricSampleAggregator;
import com.linkedin.kafka.cruisecontrol.monitor.sampling.aggregator.KafkaReplicaMetricSampleAggregator;
import com.linkedin.kafka.cruisecontrol.monitor.sampling.holder.PartitionEntity;
import com.linkedin.kafka.cruisecontrol.monitor.sampling.holder.ReplicaEntity;
import com.linkedin.kafka.cruisecontrol.monitor.task.MetricSamplingTask;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.Timer;
import com.yammer.metrics.core.TimerContext;
import io.confluent.databalancer.metrics.GeneralSBCMetricsRegistry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.apache.kafka.common.Cluster;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.InsufficientRebalancePlanMetricsException;
import org.apache.kafka.common.errors.RebalanceInProgressDuringPlanComputationException;
import org.apache.kafka.common.message.DescribeCellsResponseData;
import org.apache.kafka.common.utils.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoadMonitor
implements SamplerStateHandle {
    private static final Logger LOG = LoggerFactory.getLogger(LoadMonitor.class);
    private final MetricSamplingTask metricSamplingTask;
    private final KafkaReplicaMetricSampleAggregator replicaMetricSampleAggregator;
    private final KafkaPartitionMetricSampleAggregator partitionMetricSampleAggregator;
    private final Semaphore clusterModelSemaphore;
    private final ConfigSupplier configSupplier;
    private final MetadataClient metadataClient;
    private final ClusterBrokerCapacityConfigResolver brokerCapacityConfigResolver;
    private final ScheduledExecutorService loadMonitorExecutor;
    private final Timer clusterModelCreationTimer;
    private final UpdatableSbcGoalsConfig goalsConfig;
    private final int maxVolumeThroughputMb;
    private final double writeMultiplier;
    private final double readMultiplier;
    private final double networkThrottleRatio;
    private final double diskReadRatio;
    private volatile int numValidPartitionSnapshotWindows;
    private volatile int numValidReplicaSnapshotWindows;
    private volatile double monitoredPartitionsPercentage;
    private volatile double monitoredReplicasPercentage;
    private volatile int totalMonitoredSnapshotWindows;
    private volatile int numPartitionsWithExtrapolations;
    private volatile int numReassigningPartitions;
    private volatile double balancedTopicsPercentage;
    private volatile long lastUpdate;
    private volatile BrokerCapacityInfo computedCapacities;
    private volatile int numTopicsWithInconsistentRf;
    private volatile ModelGeneration cachedBrokerLoadGeneration;
    private volatile BrokerStats cachedBrokerLoadStats;
    private final Meter invalidatedWindowsRate;
    private final Histogram topicImbalancePercentageHistogram;
    Time time;
    GeneralSBCMetricsRegistry metricRegistry;
    private final SensorUpdater sensorUpdater;
    private final long additionalInvalidationDurationMs;

    public LoadMonitor(ConfigSupplier configSupplier, MetadataClient metadataClient, Time time, GeneralSBCMetricsRegistry metricRegistry, UpdatableSbcGoalsConfig goalsConfig) {
        this.configSupplier = configSupplier;
        this.metadataClient = Objects.requireNonNull(metadataClient, "The provided MetadataClient was null.");
        this.time = time;
        this.metricRegistry = metricRegistry;
        this.goalsConfig = goalsConfig;
        KafkaCruiseControlConfig config = configSupplier.getConfig();
        this.additionalInvalidationDurationMs = config.getLong("confluent.balancer.additional.invalidation.duration.ms");
        this.brokerCapacityConfigResolver = config.getConfiguredInstance("broker.capacity.config.resolver.class", BrokerCapacityConfigResolver.class);
        this.replicaMetricSampleAggregator = new KafkaReplicaMetricSampleAggregator(config);
        this.partitionMetricSampleAggregator = new KafkaPartitionMetricSampleAggregator(config, metadataClient);
        this.clusterModelSemaphore = new Semaphore(1, true);
        this.maxVolumeThroughputMb = config.getInt("max.volume.throughput.mb");
        this.writeMultiplier = config.getDouble("write.throughput.multiplier");
        this.readMultiplier = config.getDouble("read.throughput.multiplier");
        this.networkThrottleRatio = config.getDouble("calculated.throttle.ratio");
        this.diskReadRatio = config.getDouble("disk.read.ratio");
        this.metricSamplingTask = new MetricSamplingTask(config, this.replicaMetricSampleAggregator, this.partitionMetricSampleAggregator, metadataClient, time, metricRegistry, this.brokerCapacityConfigResolver);
        this.clusterModelCreationTimer = metricRegistry.newTimer(LoadMonitor.class, "cluster-model-creation-timer");
        this.loadMonitorExecutor = Executors.newScheduledThreadPool(2, new KafkaCruiseControlThreadFactory("LoadMonitorExecutor", true, LOG));
        this.sensorUpdater = new SensorUpdater();
        this.loadMonitorExecutor.scheduleAtFixedRate(this.sensorUpdater, 0L, 30000L, TimeUnit.MILLISECONDS);
        this.loadMonitorExecutor.scheduleAtFixedRate(new MetricSampleAggregatorCleaner(), 0L, 37500L, TimeUnit.MILLISECONDS);
        metricRegistry.newGauge(LoadMonitor.class, "valid-windows", () -> this.lastUpdate + 300000L > System.currentTimeMillis() ? this.numValidPartitionSnapshotWindows : -1);
        metricRegistry.newGauge(LoadMonitor.class, "valid-replica-windows", () -> this.lastUpdate + 300000L > System.currentTimeMillis() ? this.numValidReplicaSnapshotWindows : -1);
        metricRegistry.newGauge(LoadMonitor.class, "monitored-partitions-percentage", this::monitoredPartitionsPercentage);
        metricRegistry.newGauge(LoadMonitor.class, "monitored-replicas-percentage", this::monitoredReplicasPercentage);
        metricRegistry.newGauge(LoadMonitor.class, "total-monitored-windows", this::totalMonitoredSnapshotWindows);
        metricRegistry.newGauge(LoadMonitor.class, "num-partitions-with-extrapolations", this::numPartitionsWithExtrapolations);
        metricRegistry.newGauge(LoadMonitor.class, "num-topics-with-inconsistent-replication-factor", this::numTopicsWithInconsistentReplicationFactor);
        metricRegistry.newGauge(LoadMonitor.class, "num-reassigning-partitions", this::numReassigningPartitions);
        metricRegistry.newGauge(LoadMonitor.class, "balanced-topics-percentage", this::balancedTopicsPercentage);
        for (Resource resource : Arrays.asList(Resource.PRODUCE_IN, Resource.CONSUME_OUT, Resource.REPLICATION_IN)) {
            String metricName = resource == Resource.REPLICATION_IN ? "replication-inbound" : (resource == Resource.PRODUCE_IN ? "produce-inbound" : "consume-outbound");
            metricRegistry.newGauge(LoadMonitor.class, metricName, () -> this.computedCapacities == null ? -1.0 : this.computedCapacities.capacity().get((Object)resource));
        }
        this.invalidatedWindowsRate = metricRegistry.newMeter(LoadMonitor.class, "invalidated-windows-rate", "invalidated-windows-rate", TimeUnit.SECONDS);
        this.topicImbalancePercentageHistogram = metricRegistry.newHistogram(LoadMonitor.class, "topic-imbalance-percentage", false);
    }

    public void startUp() {
        this.metricSamplingTask.start();
    }

    public void shutdown() {
        LOG.info("Shutting down load monitor.");
        KafkaCruiseControlUtils.executeSilently(this.loadMonitorExecutor, ExecutorService::shutdown);
        KafkaCruiseControlUtils.executeSilently(this.metricSamplingTask, MetricSamplingTask::shutdown);
        LOG.info("Load Monitor shutdown completed.");
    }

    MetricSamplingTask.MetricSamplingTaskState metricSamplingState() {
        return this.metricSamplingTask.state();
    }

    public Cluster kafkaCluster() {
        return this.metadataClient.cluster();
    }

    @Override
    public void pauseMetricSampling(String reason) {
        this.metricSamplingTask.pauseSampling(reason);
    }

    @Override
    public void resumeMetricSampling(String reason) {
        this.metricSamplingTask.resumeSampling(reason);
    }

    @Override
    public void invalidateMetricsWindows() {
        long invalidationTimestampMs = this.time.milliseconds();
        this.invalidatedWindowsRate.mark();
        this.partitionMetricSampleAggregator.maybeInvalidateWindowsBefore(invalidationTimestampMs += this.additionalInvalidationDurationMs);
        this.replicaMetricSampleAggregator.maybeInvalidateWindowsBefore(invalidationTimestampMs);
        this.metricSamplingTask.handleInvalidation(invalidationTimestampMs);
    }

    public ClusterModelGenerator acquireForModelGeneration(OperationProgress operationProgress) throws InterruptedException {
        WaitingForClusterModel step = new WaitingForClusterModel();
        operationProgress.addStep(step);
        this.clusterModelSemaphore.acquire();
        step.done();
        return new ClusterModelGenerator();
    }

    public ClusterModel createClusterModel(long now, ModelCompletenessRequirements requirements, OperationProgress operationProgress) throws NotEnoughValidWindowsException {
        return this.createClusterModel(now, requirements, operationProgress, Collections.emptyMap(), false);
    }

    public ClusterModel createClusterModelToleratingPartitionReassignments(long now, ModelCompletenessRequirements requirements, OperationProgress operationProgress) throws NotEnoughValidWindowsException {
        return this.createClusterModel(now, requirements, operationProgress, Collections.emptyMap(), true);
    }

    public ClusterModel createClusterModel(long now, ModelCompletenessRequirements requirements, OperationProgress operationProgress, Map<Integer, Broker.Strategy> preExistingBrokerStrategiesById) throws NotEnoughValidWindowsException {
        return this.createClusterModel(now, requirements, operationProgress, preExistingBrokerStrategiesById, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClusterModel createClusterModel(long to, ModelCompletenessRequirements requirements, OperationProgress operationProgress, Map<Integer, Broker.Strategy> preExistingBrokerStrategiesById, boolean toleratePartitionReassignments) throws NotEnoughValidWindowsException {
        MetricSampleAggregationResult<ReplicaEntity> replicaMetricSampleAggregationResult;
        long start = System.currentTimeMillis();
        MetadataClient.ClusterAndGeneration clusterAndGeneration = this.metadataClient.maybeRefreshMetadata();
        Cluster cluster = clusterAndGeneration.cluster();
        MetricSampleAggregationResult<PartitionEntity> partitionMetricSampleAggregationResult = this.partitionMetricSampleAggregator.aggregate(clusterAndGeneration, to, requirements, operationProgress, "creating a cluster model");
        Map<PartitionEntity, ValuesAndExtrapolations> partitionValuesAndExtrapolations = partitionMetricSampleAggregationResult.valuesAndExtrapolations();
        if (preExistingBrokerStrategiesById != null && !preExistingBrokerStrategiesById.isEmpty() && preExistingBrokerStrategiesById.entrySet().iterator().next().getValue() == Broker.Strategy.DEAD) {
            Set<Integer> failedBrokers = preExistingBrokerStrategiesById.keySet();
            replicaMetricSampleAggregationResult = this.replicaMetricSampleAggregator.aggregate(clusterAndGeneration.cluster(), to, requirements, failedBrokers);
        } else {
            replicaMetricSampleAggregationResult = this.replicaMetricSampleAggregator.aggregate(clusterAndGeneration.cluster(), to, requirements);
        }
        Map<ReplicaEntity, ValuesAndExtrapolations> replicaValuesAndExtrapolations = replicaMetricSampleAggregationResult.valuesAndExtrapolations();
        GeneratingClusterModel step = new GeneratingClusterModel(partitionValuesAndExtrapolations.size());
        operationProgress.addStep(step);
        long currentLoadGeneration = partitionMetricSampleAggregationResult.generation();
        ModelGeneration modelGeneration = new ModelGeneration(clusterAndGeneration.generation(), currentLoadGeneration);
        MetricSampleCompleteness<PartitionEntity> completeness = partitionMetricSampleAggregationResult.completeness();
        double slightlyImbalancedTopicThreshold = this.configSupplier.getConfig().getDouble("topic.balancing.slightly.imbalanced.topic.imbalance.score.threshold");
        ClusterModel clusterModel = new ClusterModel(modelGeneration, completeness.validEntityRatio(), slightlyImbalancedTopicThreshold);
        clusterModel.isCellEnabled(this.configSupplier.getConfig().getBoolean("confluent.cells.enable"));
        TimerContext ctx = this.clusterModelCreationTimer.time();
        Map<Integer, DescribeCellsResponseData.Cell> brokerIdToCellDescription = clusterAndGeneration.brokerIdToCellDescription();
        Set<Integer> replicaExclusionsBrokers = clusterAndGeneration.replicaExclusions().keySet();
        Set<Integer> demotedBrokers = clusterAndGeneration.degradedBrokers().keySet();
        HashSet<Integer> ignoredBrokers = new HashSet<Integer>(replicaExclusionsBrokers);
        ignoredBrokers.addAll(demotedBrokers);
        Map<Integer, Broker.Strategy> finalBrokerStrategiesById = MonitorUtils.consolidateBrokerStrategies(cluster, brokerIdToCellDescription, ignoredBrokers, preExistingBrokerStrategiesById);
        Map<ClusterBrokerCapacityConfigResolver.Broker, BrokerCapacityInfo> brokerCapacitiesMap = MonitorUtils.getBrokerCapacitiesMap(cluster, this.brokerCapacityConfigResolver);
        try {
            this.createBrokers(cluster, clusterModel, brokerIdToCellDescription, finalBrokerStrategiesById, brokerCapacitiesMap);
            clusterAndGeneration.tenants().forEach(clusterModel::createTenant);
            Set<TopicPartition> reassigningPartitions = clusterAndGeneration.reassigningPartitions();
            for (TopicPartition reassigningTP : reassigningPartitions) {
                clusterModel.addReassigningPartition(reassigningTP);
            }
            this.numReassigningPartitions = reassigningPartitions.size();
            this.populateAllPartitionLoads(partitionValuesAndExtrapolations, replicaValuesAndExtrapolations, cluster, clusterModel, step, reassigningPartitions, brokerCapacitiesMap);
            if (clusterModel.hasReassigningPartitions()) {
                LOG.warn("Detected {} reassigning partitions while creating a cluster model - they are {}.", (Object)clusterModel.reassigningPartitions().size(), clusterModel.reassigningPartitions());
                if (!toleratePartitionReassignments) {
                    throw new RebalanceInProgressDuringPlanComputationException("Detected reassigning partitions while computing the cluster model. Any subsequent rebalances using this model may result in SBC inadvertently increasing the replication factor.");
                }
            }
            if (clusterAndGeneration.topicPlacements().isPresent()) {
                clusterModel.setTopicPlacements(clusterAndGeneration.topicPlacements().get());
            } else {
                clusterModel.setTopicPlacements(null);
            }
            if (!clusterModel.topics().isEmpty()) {
                this.balancedTopicsPercentage = (double)clusterModel.balancedTopics().size() / (double)clusterModel.topics().size();
                this.topicImbalancePercentageHistogram.clear();
                clusterModel.topics().forEach(topic -> this.topicImbalancePercentageHistogram.update(Math.round(clusterModel.topicImbalanceScore((String)topic, TopicImbalanceScoreType.REPLICA_DISTRIBUTION_BASED) * 100.0)));
            }
            clusterModel.setReplicaExclusions(replicaExclusionsBrokers);
            clusterModel.replicasAreInExpectedCell(ClusterModelHelper.replicasAreInExpectedCell(clusterModel));
            LOG.info("Generated cluster model in {} ms with broker strategies: {}.", (Object)(System.currentTimeMillis() - start), finalBrokerStrategiesById);
        }
        finally {
            ctx.stop();
        }
        BrokerStats brokerStats = clusterModel.brokerStats();
        LoadMonitor loadMonitor = this;
        synchronized (loadMonitor) {
            this.cachedBrokerLoadStats = brokerStats;
            this.cachedBrokerLoadGeneration = clusterModel.generation();
        }
        return clusterModel;
    }

    void createBrokers(Cluster cluster, ClusterModel clusterModel, Map<Integer, DescribeCellsResponseData.Cell> brokerIdToCellDescription, Map<Integer, Broker.Strategy> brokerStrategiesById, Map<ClusterBrokerCapacityConfigResolver.Broker, BrokerCapacityInfo> brokerCapacitiesMap) {
        double defaultDiskSize = LoadMonitor.getRandomDiskSize(brokerCapacitiesMap);
        ArrayList<Integer> brokerIdsWithEstimatedDiskCapacity = new ArrayList<Integer>();
        for (Node node : cluster.nodes()) {
            ClusterBrokerCapacityConfigResolver.Broker broker = MonitorUtils.getBroker(node);
            String rack = broker.rack();
            clusterModel.createRackIfAbsent(rack);
            BrokerCapacityInfo brokerCapacity = brokerCapacitiesMap.get(broker);
            Double diskCapacity = brokerCapacity.capacity().get((Object)Resource.DISK);
            if (diskCapacity == null) {
                LOG.debug("Disk capacity of node {} is unavailable, SBC will try to estimate the disk capacity with that from a peer node.", (Object)node.id());
                brokerIdsWithEstimatedDiskCapacity.add(node.id());
                HashMap<Resource, Double> estimatedBrokerCapacity = new HashMap<Resource, Double>(brokerCapacity.capacity());
                estimatedBrokerCapacity.put(Resource.DISK, defaultDiskSize);
                brokerCapacity = BrokerCapacityInfo.builder().capacity(estimatedBrokerCapacity).numCpuCores(brokerCapacity.numCpuCores()).estimationInfo("With disk capacity of a peer broker").build();
            }
            LOG.debug("Get capacity info for broker {}: total capacity {}.", (Object)node.id(), (Object)diskCapacity);
            int cellId = clusterModel.createCell(brokerIdToCellDescription.get(node.id())).id();
            clusterModel.createBroker(rack, cellId, node.host(), node.id(), brokerCapacity, brokerStrategiesById.get(node.id()));
        }
        LOG.info("Rack IDs: {}", (Object)String.join((CharSequence)", ", new ArrayList<String>(clusterModel.aliveRackIds())));
        if (!brokerIdsWithEstimatedDiskCapacity.isEmpty()) {
            LOG.warn("Created brokers {} with estimated disk capacity {}MiB from peer brokers.", brokerIdsWithEstimatedDiskCapacity, (Object)defaultDiskSize);
        }
    }

    private static double getRandomDiskSize(Map<ClusterBrokerCapacityConfigResolver.Broker, BrokerCapacityInfo> brokerCapacitiesMap) {
        Optional<BrokerCapacityInfo> anyBrokerCapacityWithDiskInfo = brokerCapacitiesMap.values().stream().filter(capacityMap -> capacityMap.capacity().containsKey((Object)Resource.DISK)).findAny();
        if (anyBrokerCapacityWithDiskInfo.isEmpty()) {
            throw new InsufficientRebalancePlanMetricsException("SBC cannot create a cluster model because the disk capacity metrics are missing for all brokers.");
        }
        return anyBrokerCapacityWithDiskInfo.get().capacity().get((Object)Resource.DISK);
    }

    public void populateAllPartitionLoads(Map<PartitionEntity, ValuesAndExtrapolations> partitionValuesAndExtrapolations, Map<ReplicaEntity, ValuesAndExtrapolations> replicaValuesAndExtrapolations, Cluster cluster, ClusterModel clusterModel, GeneratingClusterModel step, Set<TopicPartition> reassigningPartitions, Map<ClusterBrokerCapacityConfigResolver.Broker, BrokerCapacityInfo> brokerCapacitiesMap) {
        HashMap<String, Integer> replicationFactorByTopic = new HashMap<String, Integer>();
        HashSet<String> topicsWithInconsistentReplicationFactor = new HashSet<String>();
        ArrayList<ReplicaEntity> replicasWithMismatchingMetricWindows = new ArrayList<ReplicaEntity>();
        for (Map.Entry<PartitionEntity, ValuesAndExtrapolations> entry : partitionValuesAndExtrapolations.entrySet()) {
            TopicPartition tp = entry.getKey().tp();
            ValuesAndExtrapolations leaderLoad = entry.getValue();
            PartitionInfo partitionInfo = cluster.partition(tp);
            if (partitionInfo == null) {
                LOG.debug("Partition info for {} was not present in the metadata. It is assumed the topic was deleted", (Object)tp);
            } else {
                List<ReplicaEntity> replicasWithMismatchingWindowsForCurrentPartition = MonitorUtils.populatePartitionLoad(partitionInfo, clusterModel, tp, leaderLoad, replicaValuesAndExtrapolations, brokerCapacitiesMap);
                replicasWithMismatchingMetricWindows.addAll(replicasWithMismatchingWindowsForCurrentPartition);
                Integer topicReplicationFactor = (Integer)replicationFactorByTopic.get(tp.topic());
                if (topicReplicationFactor == null) {
                    replicationFactorByTopic.put(tp.topic(), partitionInfo.replicas().length);
                } else if (topicReplicationFactor != partitionInfo.replicas().length && !topicsWithInconsistentReplicationFactor.contains(tp.topic())) {
                    String rfByPartitionStr = cluster.partitionsForTopic(tp.topic()).stream().collect(Collectors.toMap(p -> new TopicPartition(p.topic(), p.partition()), p -> p.replicas().length)).toString();
                    if (reassigningPartitions.contains(entry.getKey().tp())) {
                        LOG.debug("Detected a topic {} with inconsistent replication factor because it is being reassigned - {}.", (Object)tp.topic(), (Object)rfByPartitionStr);
                    } else {
                        LOG.warn("Detected a topic {} with inconsistent replication factor - {}. SBC did not detect it being reassigned at this moment - it is possible that it is permanently misconfigured.", (Object)tp.topic(), (Object)rfByPartitionStr);
                        topicsWithInconsistentReplicationFactor.add(tp.topic());
                    }
                }
            }
            step.incrementPopulatedNumPartitions();
        }
        this.numTopicsWithInconsistentRf = topicsWithInconsistentReplicationFactor.size();
        if (!replicasWithMismatchingMetricWindows.isEmpty()) {
            List replicasInfo = replicasWithMismatchingMetricWindows.stream().map(replicaEntity -> String.format("%s-%s-%s", replicaEntity.tp().topic(), replicaEntity.tp().partition(), replicaEntity.brokerId())).collect(Collectors.toList());
            LOG.warn("A total of {} replicas have a mismatching number of metric windows compared to their corresponding partition. We expect replicas to have fewer metric windows in which case we will them with 0 values. We don't expect partitions to have fewer metric windows. Replicas: {}", (Object)replicasWithMismatchingMetricWindows.size(), replicasInfo);
        }
    }

    public ModelGeneration clusterModelGeneration() {
        int clusterGeneration = this.metadataClient.maybeRefreshMetadata().generation();
        return new ModelGeneration(clusterGeneration, this.partitionMetricSampleAggregator.generation());
    }

    public synchronized BrokerStats cachedBrokerLoadStats(boolean allowCapacityEstimation) {
        if (this.cachedBrokerLoadGeneration != null && (allowCapacityEstimation || !this.cachedBrokerLoadStats.isBrokerStatsEstimated()) && this.partitionMetricSampleAggregator.generation().longValue() == this.cachedBrokerLoadGeneration.loadGeneration() && this.metadataClient.maybeRefreshMetadata().generation() == this.cachedBrokerLoadGeneration.clusterGeneration()) {
            return this.cachedBrokerLoadStats;
        }
        return null;
    }

    public Set<Integer> brokersWithReplicas(int timeout) {
        Cluster kafkaCluster = this.metadataClient.maybeRefreshMetadata(timeout).cluster();
        return MonitorUtils.brokersWithReplicas(kafkaCluster);
    }

    public MetadataClient.ClusterAndGeneration maybeRefreshClusterAndGeneration() {
        return this.metadataClient.maybeRefreshMetadata();
    }

    @Override
    public MetadataClient.ClusterAndGeneration forceRefreshClusterAndGeneration() {
        return this.metadataClient.forceRefreshMetadata();
    }

    public CompletenessCheck meetCompletenessRequirements(MetadataClient.ClusterAndGeneration clusterAndGeneration, ModelCompletenessRequirements requirements, Set<Integer> failedBrokerIds) {
        int numValidReplicaWindows;
        boolean passesReplicaWindowCheck;
        boolean passesPartitionWindowCheck;
        int requiredNumValidWindows = requirements.minRequiredNumWindows();
        Object reason = "";
        double minMonitoredPartitionsPercentage = requirements.minMonitoredPartitionsPercentage();
        int numValidPartitionWindows = this.partitionMetricSampleAggregator.validWindows(clusterAndGeneration, minMonitoredPartitionsPercentage).size();
        boolean bl = passesPartitionWindowCheck = numValidPartitionWindows >= requiredNumValidWindows;
        if (!passesPartitionWindowCheck) {
            reason = (String)reason + String.format("Does not meet the minimum partition window count: required %d but had just %d valid partitions windows.", requiredNumValidWindows, numValidPartitionWindows);
        }
        boolean bl2 = passesReplicaWindowCheck = (numValidReplicaWindows = this.replicaMetricSampleAggregator.validWindows(clusterAndGeneration, minMonitoredPartitionsPercentage, failedBrokerIds).size()) >= requiredNumValidWindows;
        if (!passesReplicaWindowCheck) {
            reason = (String)reason + String.format("%sDoes not meet the minimum replica window count: required %d but had just %d valid replicas windows.", ((String)reason).isEmpty() ? "" : "; ", requiredNumValidWindows, numValidReplicaWindows);
        }
        boolean meetsRequirements = passesPartitionWindowCheck && passesReplicaWindowCheck;
        return new CompletenessCheck(meetsRequirements, (String)reason);
    }

    public CompletenessCheck meetCompletenessRequirements(MetadataClient.ClusterAndGeneration clusterAndGeneration, ModelCompletenessRequirements requirements) {
        return this.meetCompletenessRequirements(clusterAndGeneration, requirements, Collections.emptySet());
    }

    public CompletenessCheck meetCompletenessRequirements(ModelCompletenessRequirements requirements) {
        MetadataClient.ClusterAndGeneration clusterAndGeneration = this.metadataClient.maybeRefreshMetadata();
        return this.meetCompletenessRequirements(clusterAndGeneration, requirements, Collections.emptySet());
    }

    @Override
    public long computeThrottle() {
        Map<ClusterBrokerCapacityConfigResolver.Broker, BrokerCapacityInfo> brokerCapacitiesMap = this.brokerCapacityConfigResolver.capacitiesForBrokers(this.kafkaCluster().nodes().stream().map(MonitorUtils::getBroker).collect(Collectors.toList()));
        int networkCapacityMb = brokerCapacitiesMap.values().stream().map(broker -> broker.capacity().get((Object)Resource.NW_IN).intValue()).min(Comparator.naturalOrder()).map(capacity -> capacity / 1024).orElse(0);
        BrokerStats brokerStats = this.cachedBrokerLoadStats(true);
        if (brokerStats == null) {
            try {
                this.createClusterModel(this.time.milliseconds(), this.goalsConfig.config().effectiveRebalancingGoals().requirements(), new OperationProgress());
                brokerStats = this.cachedBrokerLoadStats(true);
                if (brokerStats == null) {
                    throw new IllegalStateException("Cannot compute throttle because broker load stats are unavailable");
                }
            }
            catch (NotEnoughValidWindowsException e) {
                throw new IllegalStateException("Cannot compute throttle because there are not enough valid metrics windows");
            }
        }
        double maxBrokerIngressMb = brokerStats.stats().stream().map(SingleBrokerStats::bytesIn).max(Comparator.naturalOrder()).map(ingress -> ingress / 1024.0).orElse(0.0);
        double maxBrokerEgressMb = brokerStats.stats().stream().map(SingleBrokerStats::bytesOut).max(Comparator.naturalOrder()).map(egress -> egress / 1024.0).orElse(0.0);
        double instanceLimitMb = (double)networkCapacityMb - (this.writeMultiplier * maxBrokerIngressMb + this.readMultiplier * maxBrokerEgressMb);
        double volumeLimitMb = (double)this.maxVolumeThroughputMb - (maxBrokerIngressMb + this.diskReadRatio * maxBrokerEgressMb);
        long throttle = (long)(this.networkThrottleRatio * 1024.0 * 1024.0 * Math.min(instanceLimitMb, volumeLimitMb));
        String parametersStr = String.format("networkCapacityMb: %s, maxBrokerIngressMb: %s, maxBrokerEgressMb: %s, instanceLimitMb: %s, volumeLimitMb: %s", networkCapacityMb, maxBrokerIngressMb, maxBrokerEgressMb, instanceLimitMb, volumeLimitMb);
        if (throttle < 0L) {
            LOG.error("Failed to compute a valid throttle - {} ({})", (Object)throttle, (Object)parametersStr);
            throw new IllegalStateException("Could not compute a positive throttle value");
        }
        LOG.debug(parametersStr);
        return throttle;
    }

    KafkaReplicaMetricSampleAggregator replicaSampleAggregator() {
        return this.replicaMetricSampleAggregator;
    }

    KafkaPartitionMetricSampleAggregator partitionSampleAggregator() {
        return this.partitionMetricSampleAggregator;
    }

    public Set<Integer> brokersWithOfflineReplicas(int timeout) {
        Cluster kafkaCluster = this.metadataClient.maybeRefreshMetadata(timeout).cluster();
        return MonitorUtils.brokersWithOfflineReplicas(kafkaCluster);
    }

    private int totalMonitoredSnapshotWindows() {
        return this.lastUpdate + 300000L > System.currentTimeMillis() ? this.totalMonitoredSnapshotWindows : -1;
    }

    private double monitoredPartitionsPercentage() {
        return this.lastUpdate + 300000L > System.currentTimeMillis() ? this.monitoredPartitionsPercentage : 0.0;
    }

    private double monitoredReplicasPercentage() {
        return this.lastUpdate + 300000L > System.currentTimeMillis() ? this.monitoredReplicasPercentage : 0.0;
    }

    private int numPartitionsWithExtrapolations() {
        return this.lastUpdate + 300000L > System.currentTimeMillis() ? this.numPartitionsWithExtrapolations : -1;
    }

    final int numTopicsWithInconsistentReplicationFactor() {
        return this.numTopicsWithInconsistentRf;
    }

    private int numReassigningPartitions() {
        return this.numReassigningPartitions;
    }

    private double balancedTopicsPercentage() {
        return this.balancedTopicsPercentage;
    }

    private double computeMonitoredPartitionsPercentage(MetadataClient.ClusterAndGeneration clusterAndGeneration) {
        MetricSampleAggregationResult<PartitionEntity> metricSampleAggregationResult;
        Cluster kafkaCluster = clusterAndGeneration.cluster();
        try {
            metricSampleAggregationResult = this.partitionMetricSampleAggregator.aggregate(clusterAndGeneration, System.currentTimeMillis(), new OperationProgress(), "computing the monitored partitions percentage");
        }
        catch (NotEnoughValidWindowsException e) {
            return 0.0;
        }
        Map<PartitionEntity, ValuesAndExtrapolations> partitionLoads = metricSampleAggregationResult.valuesAndExtrapolations();
        this.numPartitionsWithExtrapolations = (int)partitionLoads.values().stream().filter(ValuesAndExtrapolations::haveExtrapolations).count();
        int totalNumPartitions = MonitorUtils.totalNumPartitions(kafkaCluster);
        return totalNumPartitions > 0 ? (double)metricSampleAggregationResult.completeness().validEntityRatio() : 0.0;
    }

    private double computeMonitoredReplicasPercentage(Cluster kafkaCluster) {
        MetricSampleAggregationResult<ReplicaEntity> metricSampleAggregationResult;
        try {
            metricSampleAggregationResult = this.replicaMetricSampleAggregator.aggregate(kafkaCluster, System.currentTimeMillis());
        }
        catch (NotEnoughValidWindowsException e) {
            return 0.0;
        }
        int totalNumPartitions = MonitorUtils.totalNumPartitions(kafkaCluster);
        return totalNumPartitions > 0 ? (double)metricSampleAggregationResult.completeness().validEntityRatio() : 0.0;
    }

    private class SensorUpdater
    implements Runnable {
        static final long UPDATE_INTERVAL_MS = 30000L;
        static final long UPDATE_TIMEOUT_MS = 300000L;

        private SensorUpdater() {
        }

        @Override
        public void run() {
            try {
                MetadataClient.ClusterAndGeneration clusterAndGeneration = LoadMonitor.this.metadataClient.clusterAndGeneration();
                double minMonitoredPartitionsPercentage = LoadMonitor.this.goalsConfig.config().effectiveRebalancingGoals().requirements().minMonitoredPartitionsPercentage();
                LoadMonitor.this.numValidPartitionSnapshotWindows = LoadMonitor.this.partitionMetricSampleAggregator.validWindows(clusterAndGeneration, minMonitoredPartitionsPercentage).size();
                LoadMonitor.this.numValidReplicaSnapshotWindows = LoadMonitor.this.replicaMetricSampleAggregator.validWindows(clusterAndGeneration, minMonitoredPartitionsPercentage).size();
                LoadMonitor.this.monitoredPartitionsPercentage = LoadMonitor.this.computeMonitoredPartitionsPercentage(clusterAndGeneration);
                LoadMonitor.this.monitoredReplicasPercentage = LoadMonitor.this.computeMonitoredReplicasPercentage(clusterAndGeneration.cluster());
                LoadMonitor.this.totalMonitoredSnapshotWindows = LoadMonitor.this.partitionMetricSampleAggregator.allWindows().size();
                LoadMonitor.this.lastUpdate = System.currentTimeMillis();
                LoadMonitor.this.computedCapacities = MonitorUtils.getBrokerCapacitiesMap(clusterAndGeneration.cluster(), LoadMonitor.this.brokerCapacityConfigResolver).values().iterator().next();
            }
            catch (Throwable t) {
                LOG.warn("Load monitor sensor updater received exception ", t);
            }
        }
    }

    private class MetricSampleAggregatorCleaner
    implements Runnable {
        static final long CHECK_INTERVAL_MS = 37500L;
        static final short REFRESH_LIMIT = 8;
        private final Set<String> allTopics = new HashSet<String>();
        private int refreshCount = 0;

        private MetricSampleAggregatorCleaner() {
        }

        @Override
        public void run() {
            this.allTopics.addAll(LoadMonitor.this.metadataClient.maybeRefreshMetadata().cluster().topics());
            ++this.refreshCount;
            if (this.refreshCount % 8 == 0) {
                LoadMonitor.this.partitionMetricSampleAggregator.retainEntityGroup(this.allTopics);
                LoadMonitor.this.replicaMetricSampleAggregator.retainEntityGroup(this.allTopics);
                this.allTopics.clear();
            }
        }
    }

    public class ClusterModelGenerator
    implements AutoCloseable {
        private final AtomicBoolean closed = new AtomicBoolean(false);

        @Override
        public void close() {
            if (this.closed.compareAndSet(false, true)) {
                LoadMonitor.this.clusterModelSemaphore.release();
            }
        }

        public ClusterModel createLatestClusterModel(ModelCompletenessRequirements requirements, OperationProgress operationProgress) throws NotEnoughValidWindowsException {
            return LoadMonitor.this.createClusterModel(System.currentTimeMillis(), requirements, operationProgress);
        }

        public ClusterModel createLatestClusterModel(ModelCompletenessRequirements requirements, OperationProgress operationProgress, Map<Integer, Broker.Strategy> preExistingBrokerStrategiesById) throws NotEnoughValidWindowsException {
            return LoadMonitor.this.createClusterModel(System.currentTimeMillis(), requirements, operationProgress, preExistingBrokerStrategiesById);
        }
    }

    public static class CompletenessCheck {
        public static final CompletenessCheck SUCCESSFUL_CHECK = new CompletenessCheck(true, "");
        public final boolean meetsRequirements;
        public final String reason;

        public CompletenessCheck(boolean meetsRequirements, String reason) {
            this.meetsRequirements = meetsRequirements;
            this.reason = reason;
        }

        public String toString() {
            return "CompletenessCheck{meetsRequirements=" + this.meetsRequirements + ", reason='" + this.reason + "'}";
        }
    }
}

