/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.monitor.sampling;

import com.linkedin.kafka.cruisecontrol.common.Resource;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.kafka.common.utils.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrailingFanoutTotalCapacityProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(TrailingFanoutTotalCapacityProcessor.class);
    private final long fanoutAveragingWindowMs;
    private final Map<Integer, Map<Resource, LinkedList<Map.Entry<Double, Long>>>> previousBrokerCapacityValues = new HashMap<Integer, Map<Resource, LinkedList<Map.Entry<Double, Long>>>>();
    private final Time time;

    public TrailingFanoutTotalCapacityProcessor(long fanoutAveragingWindowMs, Time time) {
        this.fanoutAveragingWindowMs = fanoutAveragingWindowMs;
        this.time = time;
        LOG.info("TrailingFanoutTotalCapacityProcessor is configured with a fanout averaging window of {} ms", (Object)fanoutAveragingWindowMs);
    }

    public void supply(int brokerId, Resource resource, double totalCapacity, long timeMs) throws IllegalArgumentException {
        long currentTime = this.time.milliseconds();
        if (Math.abs(timeMs - currentTime) > this.fanoutAveragingWindowMs) {
            throw new IllegalArgumentException(String.format("The time of the sample (%d ms) is too old to be considered. Current time: %d ms", timeMs, currentTime));
        }
        this.cleanupOldValues(currentTime);
        this.supplyValueForTheArithmeticalAveraging(brokerId, resource, totalCapacity, timeMs);
    }

    private void supplyValueForTheArithmeticalAveraging(int brokerId, Resource resource, double totalCapacity, long timeMs) {
        Map previousCapacityValues = this.previousBrokerCapacityValues.computeIfAbsent(brokerId, k -> new HashMap());
        LinkedList<AbstractMap.SimpleEntry<Double, Long>> previousValues = previousCapacityValues.getOrDefault((Object)resource, null);
        if (previousValues == null) {
            previousValues = new LinkedList<AbstractMap.SimpleEntry<Double, Long>>();
            previousValues.add(new AbstractMap.SimpleEntry<Double, Long>(totalCapacity, timeMs));
            previousCapacityValues.put(resource, previousValues);
        } else {
            if (previousValues.getLast() != null && timeMs < (Long)((Map.Entry)previousValues.getLast()).getValue()) {
                throw new IllegalArgumentException(String.format("The provided time of the sample (%d ms) is older than the last sample (%d ms) provided to the processor.", timeMs, ((Map.Entry)previousValues.getLast()).getValue()));
            }
            previousValues.add(new AbstractMap.SimpleEntry<Double, Long>(totalCapacity, timeMs));
        }
    }

    private double computeArithmeticAverage(LinkedList<Map.Entry<Double, Long>> values) {
        return values.stream().mapToDouble(Map.Entry::getKey).sum() / (double)values.size();
    }

    private void cleanupOldValues(long currentTimeMs) {
        this.previousBrokerCapacityValues.values().forEach(brokerCapacitiesMap -> brokerCapacitiesMap.values().forEach(capacityValues -> {
            while (!capacityValues.isEmpty() && (Long)((Map.Entry)capacityValues.getFirst()).getValue() + this.fanoutAveragingWindowMs < currentTimeMs) {
                capacityValues.removeFirst();
            }
        }));
        List<Integer> brokerIdsWithoutValues = this.previousBrokerCapacityValues.entrySet().stream().filter(entry -> ((Map)entry.getValue()).values().stream().findFirst().orElse(new LinkedList()).size() == 0).map(Map.Entry::getKey).collect(Collectors.toList());
        if (!brokerIdsWithoutValues.isEmpty()) {
            LOG.info("Removing brokers {} from the fanout processor due to not having new records supplied to them in the last {} ms.", brokerIdsWithoutValues, (Object)this.fanoutAveragingWindowMs);
        }
        brokerIdsWithoutValues.forEach(this.previousBrokerCapacityValues::remove);
    }

    public Map<Integer, Map<Resource, Double>> capacitiesForBrokers(List<Integer> brokerIds) {
        this.cleanupOldValues(this.time.milliseconds());
        return brokerIds.stream().filter(this.previousBrokerCapacityValues::containsKey).collect(Collectors.toMap(brokerId -> brokerId, brokerId -> {
            Map<Resource, LinkedList<Map.Entry<Double, Long>>> capacityValues = this.previousBrokerCapacityValues.get(brokerId);
            return capacityValues.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, x -> this.computeArithmeticAverage((LinkedList)x.getValue())));
        }));
    }

    public static Map<Resource, Double> averageAllResources(Map<Integer, Map<Resource, Double>> perBrokerCapacities) {
        HashMap<Resource, Double> averagedCapacities = new HashMap<Resource, Double>();
        for (Integer n : perBrokerCapacities.keySet()) {
            Map<Resource, Double> brokerCapacity = perBrokerCapacities.get(n);
            for (Map.Entry<Resource, Double> entry : brokerCapacity.entrySet()) {
                Resource resource = entry.getKey();
                Double totalCapacity = entry.getValue();
                averagedCapacities.put(resource, averagedCapacities.getOrDefault((Object)resource, 0.0) + totalCapacity);
            }
        }
        for (Map.Entry entry : averagedCapacities.entrySet()) {
            entry.setValue((Double)entry.getValue() / (double)perBrokerCapacities.size());
        }
        return averagedCapacities;
    }
}

