/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.operation;

import io.confluent.databalancer.operation.BalancerOperationCallback;
import io.confluent.databalancer.operation.BrokerRemovalStateMachine;
import java.util.Set;
import java.util.stream.Collectors;

public interface BrokerRemovalCallback
extends BalancerOperationCallback<BrokerRemovalStateMachine.BrokerRemovalState, BrokerRemovalStateMachine.BrokerRemovalEvent> {
    public static final int MAX_UUID_LENGTH = 256;

    public static String logPrefix(String uuid) {
        return String.format("[%s]:", uuid);
    }

    public static String uuid(Set<Integer> brokersToRemove, long nowMs) {
        String brokersStr = brokersToRemove.stream().sorted().map(String::valueOf).collect(Collectors.joining("-"));
        if (brokersStr.length() > 256) {
            brokersStr = String.format("%s-truncated", brokersStr.substring(0, 256 - "-truncated".length()));
        }
        return String.format("remove-broker-%s-timestamp-%d", brokersStr, nowMs);
    }
}

