/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.cruisecontrol.metricsreporter;

import io.confluent.cruisecontrol.metricsreporter.OpenTelemetryConverter;
import io.confluent.cruisecontrol.metricsreporter.TelemetryConverter;
import io.confluent.cruisecontrol.metricsreporter.opentelemetry.SbcMetricsData;
import io.confluent.cruisecontrol.metricsreporter.opentelemetry.SbcResourceMetrics;
import io.opentelemetry.proto.metrics.v1.Metric;
import java.io.IOException;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SbcOpenTelemetryConverter
extends OpenTelemetryConverter {
    private static final Logger LOG = LoggerFactory.getLogger(SbcOpenTelemetryConverter.class);

    @Override
    public <T> void convert(byte[] bytes, TelemetryConverter.MetricConsumer<T> consumer) {
        SbcMetricsData metricsData;
        try {
            metricsData = SbcMetricsData.parseFrom(bytes);
        }
        catch (IOException e) {
            LOG.error("Received exception when parsing metric data", (Throwable)e);
            return;
        }
        for (SbcResourceMetrics resourceMetrics : metricsData.resourceMetrics()) {
            Optional resource = consumer.brokerId(resourceMetrics.brokerId());
            if (!resource.isPresent()) continue;
            resourceMetrics.scopeMetrics().stream().flatMap(scopeMetrics -> scopeMetrics.getMetricsList().stream()).filter(metric -> metric.getDataCase() == Metric.DataCase.GAUGE).forEach(metric -> SbcOpenTelemetryConverter.createPointMetrics(consumer, resource.get(), metric.getName(), metric.getGauge().getDataPointsList()));
        }
    }
}

