/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.databalancer;

import com.linkedin.kafka.cruisecontrol.KafkaCruiseControl;
import com.linkedin.kafka.cruisecontrol.KafkaCruiseControlUtils;
import com.linkedin.kafka.cruisecontrol.operation.BrokerRemovalFuture;
import io.confluent.databalancer.DataBalanceEngineContext;
import io.confluent.databalancer.metrics.CellOverloadMetrics;
import io.confluent.databalancer.metrics.DataBalancerMetricsRegistry;
import io.confluent.databalancer.metrics.GeneralSBCMetricsRegistry;
import io.confluent.databalancer.operation.BalancerStatusTracker;
import io.confluent.databalancer.operation.BrokerAdditionContextContainer;
import io.confluent.databalancer.operation.BrokerAdditionV1Context;
import io.confluent.databalancer.operation.BrokerAdditionV2StateManager;
import io.confluent.databalancer.operation.BrokerRemovalStateTracker;
import io.confluent.databalancer.operation.EvenClusterLoadStateManager;
import io.confluent.databalancer.persistence.ApiStatePersistenceStore;
import io.confluent.databalancer.utils.ImmutableSet;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import org.apache.kafka.common.utils.Time;

public class ConfluentDataBalanceEngineContext
implements DataBalanceEngineContext {
    private final DataBalancerMetricsRegistry dataBalancerMetricsRegistry;
    private final Time time;
    final Map<ImmutableSet<Integer>, BrokerRemovalFuture> brokerRemovalFutures;
    Map<ImmutableSet<Integer>, BrokerRemovalStateTracker> brokerRemovalsStateTrackers;
    private volatile BalancerStatusTracker balancerStatusTracker;
    @Nullable
    private volatile KafkaCruiseControl cruiseControl;
    @Nullable
    private volatile ApiStatePersistenceStore persistenceStore;
    @Nullable
    private volatile BrokerAdditionV2StateManager additionV2StateManager;
    @Nullable
    private volatile BrokerAdditionContextContainer brokerAdditionContextContainer;
    private volatile boolean shouldAutoHeal;
    private volatile boolean v2AdditionEnabled;
    private final boolean incrementalBalancingEnabled;

    public ConfluentDataBalanceEngineContext(DataBalancerMetricsRegistry dataBalancerMetricsRegistry, KafkaCruiseControl cruiseControl, Time time, Boolean incrementalBalancingEnabled) {
        this.dataBalancerMetricsRegistry = dataBalancerMetricsRegistry;
        this.cruiseControl = cruiseControl;
        this.time = time;
        this.incrementalBalancingEnabled = incrementalBalancingEnabled;
        this.brokerRemovalFutures = new ConcurrentHashMap<ImmutableSet<Integer>, BrokerRemovalFuture>();
        this.brokerRemovalsStateTrackers = new ConcurrentHashMap<ImmutableSet<Integer>, BrokerRemovalStateTracker>();
    }

    public Optional<KafkaCruiseControl> getCruiseControl() {
        return Optional.ofNullable(this.cruiseControl);
    }

    public boolean isCruiseControlInitialized() {
        return this.cruiseControl != null;
    }

    public void setCruiseControl(KafkaCruiseControl cruiseControl) {
        this.cruiseControl = cruiseControl;
    }

    private void closeAndClearCruiseControl() {
        KafkaCruiseControlUtils.executeSilently(this.cruiseControl, KafkaCruiseControl::shutdown);
        this.cruiseControl = null;
    }

    public Time getTime() {
        return this.time;
    }

    public GeneralSBCMetricsRegistry getDataBalancerMetricsRegistry() {
        return this.dataBalancerMetricsRegistry.dataBalancerMetricsRegistry();
    }

    public CellOverloadMetrics getCellOverloadMetrics() {
        return this.dataBalancerMetricsRegistry.cellOverloadMetrics();
    }

    @Override
    public ApiStatePersistenceStore getPersistenceStore() {
        return this.persistenceStore;
    }

    @Override
    public Map<ImmutableSet<Integer>, BrokerRemovalStateTracker> getBrokerRemovalsStateTrackers() {
        return this.brokerRemovalsStateTrackers;
    }

    @Override
    public BalancerStatusTracker getBalancerStatusTracker() {
        return this.balancerStatusTracker;
    }

    public void setBalancerStatusTracker(BalancerStatusTracker balancerStatusTracker) {
        this.balancerStatusTracker = balancerStatusTracker;
    }

    public boolean isIncrementalBalancingEnabled() {
        return this.incrementalBalancingEnabled;
    }

    public boolean shouldAutoHeal() {
        return this.shouldAutoHeal;
    }

    public void v2AdditionEnabled(boolean v2AdditionEnabled) {
        this.v2AdditionEnabled = v2AdditionEnabled;
    }

    public void shouldAutoHeal(boolean shouldAutoHeal) {
        this.shouldAutoHeal = shouldAutoHeal;
    }

    boolean v2AdditionEnabled() {
        return this.v2AdditionEnabled;
    }

    @Override
    public EvenClusterLoadStateManager getEvenClusterLoadStateManager() {
        return this.cruiseControl.context().evenClusterLoadStateManager();
    }

    @Override
    public BrokerAdditionContextContainer additionContext() {
        return this.brokerAdditionContextContainer;
    }

    public void init(ApiStatePersistenceStore persistenceStore) {
        this.persistenceStore = persistenceStore;
        BrokerAdditionV1Context additionV1Context = new BrokerAdditionV1Context(this.dataBalancerMetricsRegistry.dataBalancerMetricsRegistry());
        this.additionV2StateManager = new BrokerAdditionV2StateManager(persistenceStore);
        this.brokerAdditionContextContainer = new BrokerAdditionContextContainer(additionV1Context, this.additionV2StateManager, this.incrementalBalancingEnabled, this.v2AdditionEnabled);
    }

    public void putBrokerRemovalFuture(ImmutableSet<Integer> brokerIds, BrokerRemovalFuture future) {
        this.brokerRemovalFutures.put(brokerIds, future);
    }

    public void removeBrokerRemovalFuture(ImmutableSet<Integer> brokerIds) {
        this.brokerRemovalFutures.remove(brokerIds);
    }

    public BrokerRemovalFuture brokerRemovalFuture(ImmutableSet<Integer> brokerIds) {
        return this.brokerRemovalFutures.get(brokerIds);
    }

    private void closeAndClearPersistenceStore() {
        KafkaCruiseControlUtils.closeSilently(this.persistenceStore);
        this.persistenceStore = null;
    }

    public void closeAndClearState() {
        this.closeAndClearCruiseControl();
        this.closeAndClearPersistenceStore();
        this.dataBalancerMetricsRegistry.clearMetrics();
    }

    public BrokerAdditionContextContainer brokerAdditionContextContainer() {
        return this.brokerAdditionContextContainer;
    }
}

