/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.databalancer.event;

import com.linkedin.kafka.cruisecontrol.config.SbcGoalsConfigDelta;
import io.confluent.databalancer.DatabalancerUtils;
import io.confluent.databalancer.KafkaDataBalanceManager;
import io.confluent.databalancer.SbcContext;
import io.confluent.databalancer.event.SbcEvent;
import io.confluent.databalancer.event.SbcInternalEvent;
import io.confluent.databalancer.event.resource.SbcResourceUtils;
import io.confluent.databalancer.event.resource.SbcResources;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import kafka.common.AliveBrokersMetadata;
import kafka.server.KafkaConfig;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.config.internals.BalancerConfigs;
import org.apache.kafka.common.errors.BalancerMisconfigurationException;
import org.apache.kafka.image.BrokerReplicaExclusionsImage;
import org.apache.kafka.image.ClusterImage;
import org.apache.kafka.image.ConfigurationDelta;
import org.apache.kafka.image.ConfigurationsDelta;

public class SbcConfigUpdateEvent
extends SbcInternalEvent {
    private final ConfigurationsDelta configsDelta;

    public SbcConfigUpdateEvent(SbcContext context, ConfigurationsDelta configsDelta) {
        super(context);
        this.configsDelta = configsDelta;
    }

    @Override
    @Nonnull
    protected SbcEvent.SbcEventHandlerResult handleEvent() {
        Optional<ClusterImage> unfencedImage = SbcResourceUtils.unfencedClusterImage(this.eventContext.resourceManager());
        Optional<BrokerReplicaExclusionsImage> exclusionsImage = this.eventContext.resourceManager().maybeGetResourceValue(SbcResources.EXCLUSIONS_IMAGE);
        if (!unfencedImage.isPresent()) {
            LOG.info("Cluster metadata containing at least one unfenced broker not yet available, SBC config processing delayed.");
            return SbcEvent.SbcEventHandlerResult.needsResource(SbcResources.CLUSTER_IMAGE);
        }
        if (!exclusionsImage.isPresent()) {
            LOG.info("Exclusions metadata not yet available, SBC config processing delayed.");
            return SbcEvent.SbcEventHandlerResult.needsResource(SbcResources.EXCLUSIONS_IMAGE);
        }
        AliveBrokersMetadata brokersMetadata = DatabalancerUtils.buildAliveBrokerMetadata(unfencedImage.get(), exclusionsImage.get());
        this.handleConfigsUpdate(this.configsDelta, brokersMetadata);
        return SbcEvent.SbcEventHandlerResult.SUCCESS;
    }

    private void handleConfigsUpdate(ConfigurationsDelta configsDelta, AliveBrokersMetadata aliveBrokersMetadata) {
        try {
            SbcGoalsConfigDelta sbcGoalsConfigDelta;
            LOG.info("Balancer notified of a config change: {}", (Object)configsDelta);
            ConfigResource balancerResource = new ConfigResource(ConfigResource.Type.BROKER, "");
            Set configsToSearch = BalancerConfigs.reconfigurableConfigs();
            Map configChangesFromDelta = configsDelta.getChangesMatching(balancerResource, configsToSearch);
            Set<String> deletedConfigs = this.deletedConfigs((ConfigurationDelta)configsDelta.changes().get(balancerResource), configsToSearch);
            LOG.info("There were {} change(s) and {} deletion(s) to balancer configs. Changed Configs: {}, Deleted Configs: {}", new Object[]{configChangesFromDelta.size(), deletedConfigs.size(), configChangesFromDelta, deletedConfigs});
            if (configChangesFromDelta.isEmpty() && deletedConfigs.isEmpty()) {
                return;
            }
            ConfigDef balancerConfigDefs = new ConfigDef().defineBalancerConfigs();
            Map parsedConfigs = balancerConfigDefs.parse(configChangesFromDelta);
            Map<String, Object> parsedConfigChanges = parsedConfigs.entrySet().stream().filter(entry -> configChangesFromDelta.containsKey(entry.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            List<String> excludedNames = new ArrayList<String>();
            List<String> excludedPrefixes = new ArrayList<String>();
            SbcGoalsConfigDelta.Builder sbcGoalsConfigDeltaBuilder = SbcGoalsConfigDelta.builder();
            KafkaDataBalanceManager kdbm = this.eventContext.kafkaDataBalanceManager();
            KafkaConfig newConfig = kdbm.updateKafkaConfig(parsedConfigChanges, deletedConfigs, this.eventContext.kafkaConfig());
            for (String key : configsToSearch) {
                Object changedVal = parsedConfigChanges.get(key);
                boolean isDeleted = deletedConfigs.contains(key);
                if (changedVal != null || isDeleted) {
                    Object parsedVal = newConfig.get(key);
                    LOG.debug("There was a change in balancer config. Value of " + key + " is now " + String.valueOf(parsedVal));
                    switch (key) {
                        case "confluent.balancer.enable": {
                            kdbm.maybeEnableOrDisable((Boolean)parsedVal, Optional.of(aliveBrokersMetadata));
                            break;
                        }
                        case "confluent.balancer.heal.uneven.load.trigger": {
                            boolean autoHealMode = DatabalancerUtils.anyUnevenLoadEnabled((String)parsedVal);
                            kdbm.handleHealModeConfig(autoHealMode);
                            break;
                        }
                        case "confluent.cells.enable": {
                            Boolean cellsEnabled = (Boolean)parsedConfigChanges.get("confluent.cells.enable");
                            kdbm.handleCellEnabledConfigUpdate(cellsEnabled);
                            break;
                        }
                        case "confluent.balancer.throttle.bytes.per.second": {
                            kdbm.handleThrottleConfig((Long)parsedVal);
                            break;
                        }
                        case "confluent.balancer.goal.violation.delay.on.new.brokers.ms": {
                            kdbm.handleGoalViolationDelayOnNewBrokersConfig((Long)parsedVal);
                            break;
                        }
                        case "confluent.balancer.exclude.topic.names": {
                            excludedNames = (List)parsedVal;
                            break;
                        }
                        case "confluent.balancer.exclude.topic.prefixes": {
                            excludedPrefixes = (List)parsedVal;
                            break;
                        }
                        case "confluent.balancer.triggering.goals": {
                            sbcGoalsConfigDeltaBuilder.newTriggeringGoals((List)parsedVal);
                            break;
                        }
                        case "confluent.balancer.rebalancing.goals": {
                            sbcGoalsConfigDeltaBuilder.newRebalancingGoals((List)parsedVal);
                            break;
                        }
                        case "confluent.balancer.incremental.balancing.enabled": {
                            sbcGoalsConfigDeltaBuilder.newIncrementalBalancingEnabled((Boolean)parsedVal);
                            break;
                        }
                        case "confluent.balancer.incremental.balancing.goals": {
                            sbcGoalsConfigDeltaBuilder.newIncrementalBalancingGoals((List)parsedVal);
                            break;
                        }
                        case "confluent.balancer.cpu.low.utilization.threshold": {
                            kdbm.handleCpuLowUtilThresholdConfigUpdate((Double)parsedVal);
                            break;
                        }
                        case "confluent.balancer.cpu.goal.act.as.capacity.goal": {
                            kdbm.handleCpuGoalWorkAsCapacityConfigUpdate((Boolean)parsedVal);
                            break;
                        }
                        case "confluent.balancer.cell.overload.detection.interval.ms": {
                            kdbm.handleCellOverloadInterval((Long)parsedVal);
                            break;
                        }
                        default: {
                            LOG.error("Encountered unknown configuration " + key + " while processing balancer configs");
                            break;
                        }
                    }
                    continue;
                }
                LOG.info("There was no change in balancer config " + key);
            }
            if (!excludedNames.isEmpty() || !excludedPrefixes.isEmpty()) {
                String updatedRegex = DatabalancerUtils.generateCcTopicExclusionRegex(excludedNames, excludedPrefixes);
                kdbm.handleExcludeTopicsConfig(excludedNames, excludedPrefixes, updatedRegex);
            }
            if ((sbcGoalsConfigDelta = sbcGoalsConfigDeltaBuilder.build()).hasUpdate()) {
                try {
                    kdbm.handleGoalConfigUpdate(sbcGoalsConfigDelta);
                }
                catch (BalancerMisconfigurationException e) {
                    LOG.error(String.format("Caught an exception while trying to update the databalancer's goals (%s)", sbcGoalsConfigDelta), (Throwable)e);
                }
            }
        }
        catch (Exception e) {
            LOG.error("Caught an exception trying to process a configurations delta ({}) update", (Object)configsDelta, (Object)e);
        }
    }

    private Set<String> deletedConfigs(ConfigurationDelta configurationDelta, Set<String> configsToSearch) {
        if (configurationDelta == null) {
            return Collections.emptySet();
        }
        return configsToSearch.stream().filter(key -> {
            Optional config = configurationDelta.find(key);
            return config != null && !config.isPresent();
        }).collect(Collectors.toSet());
    }
}

