/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.databalancer.event;

import io.confluent.databalancer.SbcContext;
import io.confluent.databalancer.event.SbcEvent;
import java.util.Optional;
import kafka.common.EvenClusterLoadStatusDescriptionInternal;
import kafka.controller.ClusterBalanceManager;
import org.apache.kafka.common.requests.ApiError;
import org.slf4j.event.Level;

public class SbcEvenLoadStatusEvent
extends SbcEvent {
    private ClusterBalanceManager.BalanceManagerStatusQueryClientCallback<EvenClusterLoadStatusDescriptionInternal> cb;

    public SbcEvenLoadStatusEvent(SbcContext context, ClusterBalanceManager.BalanceManagerStatusQueryClientCallback<EvenClusterLoadStatusDescriptionInternal> cb) {
        super(context);
        this.cb = cb;
    }

    @Override
    protected Level logLevel() {
        return Level.DEBUG;
    }

    @Override
    protected SbcEvent.SbcEventHandlerResult handleEvent() {
        return new SbcEvenLoadStatusResult(this.eventContext.kafkaDataBalanceManager().evenClusterLoadStatus());
    }

    @Override
    protected void respondToClient(ApiError error, SbcEvent.SbcEventHandlerResult result) {
        Optional<Object> evenClusterStatusOpt = Optional.ofNullable(result instanceof SbcEvenLoadStatusResult ? ((SbcEvenLoadStatusResult)result).evenClusterLoadStatus : null);
        this.cb.respond(error, evenClusterStatusOpt);
    }

    private static class SbcEvenLoadStatusResult
    extends SbcEvent.SbcEventHandlerResult {
        public final EvenClusterLoadStatusDescriptionInternal evenClusterLoadStatus;

        public SbcEvenLoadStatusResult(EvenClusterLoadStatusDescriptionInternal evenClusterLoadStatus) {
            this.evenClusterLoadStatus = evenClusterLoadStatus;
        }
    }
}

