/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.databalancer.event;

import io.confluent.databalancer.SbcContext;
import io.confluent.databalancer.event.SbcEvent;
import java.util.List;
import java.util.Optional;
import kafka.common.BrokerRemovalDescriptionInternal;
import kafka.controller.ClusterBalanceManager;
import org.apache.kafka.common.requests.ApiError;
import org.slf4j.event.Level;

public class SbcListBrokerRemovalsEvent
extends SbcEvent {
    private ClusterBalanceManager.BalanceManagerStatusQueryClientCallback<List<BrokerRemovalDescriptionInternal>> cb;

    public SbcListBrokerRemovalsEvent(SbcContext context, ClusterBalanceManager.BalanceManagerStatusQueryClientCallback<List<BrokerRemovalDescriptionInternal>> cb) {
        super(context);
        this.cb = cb;
    }

    @Override
    protected Level logLevel() {
        return Level.DEBUG;
    }

    @Override
    protected SbcEvent.SbcEventHandlerResult handleEvent() {
        return new SbcListBrokerRemovalsEventResult(this.eventContext.kafkaDataBalanceManager().brokerRemovals());
    }

    @Override
    protected void respondToClient(ApiError error, SbcEvent.SbcEventHandlerResult result) {
        Optional<Object> brokerRemovalsOpt = Optional.ofNullable(result instanceof SbcListBrokerRemovalsEventResult ? ((SbcListBrokerRemovalsEventResult)result).brokerRemovals : null);
        this.cb.respond(error, brokerRemovalsOpt);
    }

    private static class SbcListBrokerRemovalsEventResult
    extends SbcEvent.SbcEventHandlerResult {
        public final List<BrokerRemovalDescriptionInternal> brokerRemovals;

        public SbcListBrokerRemovalsEventResult(List<BrokerRemovalDescriptionInternal> brokerRemovals) {
            this.brokerRemovals = brokerRemovals;
        }
    }
}

