/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.databalancer.operation;

import com.linkedin.kafka.cruisecontrol.operation.BrokerAdditionCallback;
import io.confluent.databalancer.operation.BrokerAdditionStateMachine;
import io.confluent.databalancer.operation.SingleBrokerBalancerOperationProgressListener;
import io.confluent.databalancer.operation.SingleBrokerBalancerOperationTerminationListener;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.kafka.common.utils.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class BrokerAdditionStateManager
implements BrokerAdditionCallback {
    private static final Logger LOG = LoggerFactory.getLogger(BrokerAdditionStateManager.class);
    private final int brokerId;
    private final BrokerAdditionStateMachine stateMachine;
    private final SingleBrokerBalancerOperationProgressListener<BrokerAdditionStateMachine.BrokerAdditionState> progressListener;
    private final SingleBrokerBalancerOperationTerminationListener<BrokerAdditionStateMachine.BrokerAdditionState> terminationListener;
    private final AtomicReference<Attributes> additionAttributes;
    private final AtomicReference<String> stateMetricReference;
    private final Time time;
    private volatile boolean initialized;

    public BrokerAdditionStateManager(int brokerId, SingleBrokerBalancerOperationProgressListener<BrokerAdditionStateMachine.BrokerAdditionState> progressListener, SingleBrokerBalancerOperationTerminationListener<BrokerAdditionStateMachine.BrokerAdditionState> terminationListener, AtomicReference<String> stateMetricReference, Time time) {
        this(brokerId, new BrokerAdditionStateMachine(brokerId, time), progressListener, terminationListener, stateMetricReference, time);
    }

    BrokerAdditionStateManager(int brokerId, BrokerAdditionStateMachine stateMachine, SingleBrokerBalancerOperationProgressListener<BrokerAdditionStateMachine.BrokerAdditionState> progressListener, SingleBrokerBalancerOperationTerminationListener<BrokerAdditionStateMachine.BrokerAdditionState> terminationListener, AtomicReference<String> stateMetricReference, Time time) {
        this.brokerId = brokerId;
        this.stateMachine = stateMachine;
        this.progressListener = progressListener;
        this.terminationListener = terminationListener;
        this.stateMetricReference = stateMetricReference;
        this.additionAttributes = new AtomicReference<Attributes>(new Attributes(0L, 0L, (BrokerAdditionStateMachine.BrokerAdditionState)stateMachine.currentState(), null));
        this.time = time;
    }

    public long creationTimeMs() {
        return this.additionAttributes.get().creationTimeMs;
    }

    public long lastUpdateTimeMs() {
        return this.additionAttributes.get().lastUpdateTimeMs;
    }

    public void initialize() {
        if (this.isInitialized()) {
            throw new IllegalStateException("The state manager was already initialized");
        }
        long nowMs = this.time.milliseconds();
        this.additionAttributes.set(new Attributes(nowMs, nowMs, (BrokerAdditionStateMachine.BrokerAdditionState)this.stateMachine.currentState(), null));
        this.stateMetricReference.set(((BrokerAdditionStateMachine.BrokerAdditionState)this.stateMachine.currentState()).name());
        if (this.stateMachine.currentState() == BrokerAdditionStateMachine.START_STATE) {
            this.tryNotifyProgressChanged((BrokerAdditionStateMachine.BrokerAdditionState)this.stateMachine.currentState(), null);
        }
        this.initialized = true;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    @Override
    public BrokerAdditionStateMachine.BrokerAdditionState currentState() {
        return this.additionAttributes.get().state;
    }

    public int brokerId() {
        return this.brokerId;
    }

    @Override
    public synchronized void registerEvent(BrokerAdditionStateMachine.BrokerAdditionEvent event) {
        this.registerEvent(event, (Exception)null);
    }

    @Override
    public synchronized void registerEvent(BrokerAdditionStateMachine.BrokerAdditionEvent event, Exception e) {
        this.processEvent(event, e);
    }

    public boolean isAtATerminalState() {
        return this.stateMachine.isTerminalState((BrokerAdditionStateMachine.BrokerAdditionState)this.stateMachine.currentState());
    }

    private void processEvent(BrokerAdditionStateMachine.BrokerAdditionEvent event, Exception eventException) {
        BrokerAdditionStateMachine.BrokerAdditionState newState;
        if (!this.isInitialized()) {
            throw new IllegalStateException("Cannot process a broker addition event because the state manager is not initialized");
        }
        try {
            newState = (BrokerAdditionStateMachine.BrokerAdditionState)this.stateMachine.advanceState(event);
        }
        catch (Exception exception) {
            if (eventException != null) {
                LOG.error("Unexpected exception while handling addition event {} (event exception: {})!", new Object[]{event, eventException, exception});
            } else {
                LOG.error("Unexpected exception while handling addition event {}!", (Object)event, (Object)exception);
            }
            throw exception;
        }
        this.additionAttributes.set(new Attributes(this.creationTimeMs(), this.time.milliseconds(), newState, eventException));
        this.stateMetricReference.set(newState.name());
        this.tryNotifyProgressChanged(newState, eventException);
    }

    public Optional<Exception> exception() {
        return Optional.ofNullable(this.additionAttributes.get().exception);
    }

    private void tryNotifyProgressChanged(BrokerAdditionStateMachine.BrokerAdditionState state, Exception progressException) {
        String exceptionStrAnnex = progressException == null ? "" : String.format(" with exception %s", progressException);
        try {
            this.progressListener.onProgressChanged(this.brokerId, state, progressException);
            LOG.debug("Notified progress listener of broker addition state change for broker {} to state {}{}.", new Object[]{this.brokerId, state, exceptionStrAnnex});
        }
        catch (Exception e) {
            LOG.error("Error while notifying that broker addition operation progress changed for broker {} to state {}{}", new Object[]{this.brokerId, state, exceptionStrAnnex, e});
        }
        if (this.stateMachine.isTerminalState(state)) {
            try {
                this.terminationListener.onTerminalState(this.brokerId, state, progressException);
                LOG.debug("Notified progress listener of broker addition for broker {} reaching terminal state {}{}.", new Object[]{this.brokerId, state, exceptionStrAnnex});
            }
            catch (Exception e) {
                LOG.error("Error while notifying that broker addition operation progress reached a terminal state {}{} for broker {}", new Object[]{state, exceptionStrAnnex, this.brokerId, e});
            }
        }
    }

    @Immutable
    private class Attributes {
        public final long creationTimeMs;
        public final long lastUpdateTimeMs;
        public final BrokerAdditionStateMachine.BrokerAdditionState state;
        public final Exception exception;

        public Attributes(long creationTimeMs, long lastUpdateTimeMs, BrokerAdditionStateMachine.BrokerAdditionState state, Exception exception) {
            this.creationTimeMs = creationTimeMs;
            this.lastUpdateTimeMs = lastUpdateTimeMs;
            this.state = state;
            this.exception = exception;
        }
    }
}

