/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.databalancer.operation;

import io.confluent.databalancer.operation.EvenClusterLoadStateMachine;
import io.confluent.databalancer.operation.EvenClusterLoadStateProgressListener;
import io.confluent.databalancer.persistence.ApiStatePersistenceStore;
import io.confluent.databalancer.persistence.EvenClusterLoadStateRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersistEvenClusterLoadStateListener
implements EvenClusterLoadStateProgressListener<EvenClusterLoadStateMachine.EvenClusterLoadState> {
    private static final Logger LOG = LoggerFactory.getLogger(PersistEvenClusterLoadStateListener.class);
    private final ApiStatePersistenceStore persistenceStore;

    public PersistEvenClusterLoadStateListener(ApiStatePersistenceStore persistenceStore) {
        this.persistenceStore = persistenceStore;
    }

    @Override
    public void onProgressChanged(EvenClusterLoadStateMachine.EvenClusterLoadState currentState, Long currentStateCreatedAt, Long currentStateLastUpdatedAt, Exception currentStateException, EvenClusterLoadStateMachine.EvenClusterLoadState previousState, Long previousStateCreatedAt, Long previousStateLastUpdatedAt, Exception previousStateException) {
        EvenClusterLoadStateRecord stateRecord = new EvenClusterLoadStateRecord(currentState, currentStateCreatedAt, currentStateLastUpdatedAt, currentStateException, previousState, previousStateCreatedAt, previousStateLastUpdatedAt, previousStateException);
        EvenClusterLoadStateRecord existingStateRecord = this.persistenceStore.getEvenClusterLoadStateRecord();
        try {
            this.persistenceStore.save(stateRecord);
            LOG.debug("EvenClusterLoad status changed from {} to {}", (Object)existingStateRecord, (Object)stateRecord);
        }
        catch (InterruptedException ex) {
            LOG.error("Interrupted EvenClusterLoad status update.", (Throwable)ex);
            Thread.currentThread().interrupt();
            throw new RuntimeException(ex);
        }
    }
}

