/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.protobuf.cloud.events.v1;

import com.google.protobuf.AbstractMessage;
import com.google.protobuf.AbstractMessageLite;
import com.google.protobuf.AbstractParser;
import com.google.protobuf.ByteString;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.Descriptors;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.GeneratedMessageV3;
import com.google.protobuf.Internal;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.LazyStringArrayList;
import com.google.protobuf.LazyStringList;
import com.google.protobuf.Message;
import com.google.protobuf.MessageLite;
import com.google.protobuf.Parser;
import com.google.protobuf.ProtocolMessageEnum;
import com.google.protobuf.ProtocolStringList;
import com.google.protobuf.SingleFieldBuilderV3;
import com.google.protobuf.Struct;
import com.google.protobuf.StructOrBuilder;
import com.google.protobuf.Timestamp;
import com.google.protobuf.TimestampOrBuilder;
import com.google.protobuf.UninitializedMessageException;
import com.google.protobuf.UnknownFieldSet;
import io.confluent.protobuf.cloud.events.v1.ChangeEventMetadata;
import io.confluent.protobuf.cloud.events.v1.ChangeEventMetadataOrBuilder;
import io.confluent.protobuf.cloud.events.v1.Provider;
import io.confluent.protobuf.cloud.events.v1.SiteOrBuilder;
import io.confluent.protobuf.cloud.events.v1.TrafficSites;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public final class Site
extends GeneratedMessageV3
implements SiteOrBuilder {
    private static final long serialVersionUID = 0L;
    private int bitField0_;
    public static final int NAME_FIELD_NUMBER = 1;
    private volatile Object name_ = "";
    public static final int NID_FIELD_NUMBER = 2;
    private volatile Object nid_ = "";
    public static final int CLOUD_FIELD_NUMBER = 3;
    private int cloud_ = 0;
    public static final int REGION_FIELD_NUMBER = 4;
    private volatile Object region_ = "";
    public static final int NETWORK_VERSION_FIELD_NUMBER = 5;
    private volatile Object networkVersion_ = "";
    public static final int SNI_ENABLED_FIELD_NUMBER = 6;
    private boolean sniEnabled_ = false;
    public static final int CIDR_FIELD_NUMBER = 7;
    private volatile Object cidr_ = "";
    public static final int ZONE_IDS_FIELD_NUMBER = 8;
    private LazyStringArrayList zoneIds_ = LazyStringArrayList.emptyList();
    public static final int ACTUAL_STATE_FIELD_NUMBER = 9;
    private int actualState_ = 0;
    public static final int DESIRED_STATE_FIELD_NUMBER = 10;
    private int desiredState_ = 0;
    public static final int ACCESS_PUBLIC_FIELD_NUMBER = 11;
    private boolean accessPublic_ = false;
    public static final int ACCESS_PRIVATE_FIELD_NUMBER = 12;
    private boolean accessPrivate_ = false;
    public static final int REALM_FIELD_NUMBER = 13;
    private volatile Object realm_ = "";
    public static final int EGRESS_IPS_ACTIVE_FIELD_NUMBER = 14;
    private boolean egressIpsActive_ = false;
    public static final int DEACTIVATED_FIELD_NUMBER = 15;
    private Timestamp deactivated_;
    public static final int DISPLAY_NAME_FIELD_NUMBER = 16;
    private volatile Object displayName_ = "";
    public static final int DEDICATED_FIELD_NUMBER = 17;
    private boolean dedicated_ = false;
    public static final int CONNECTION_TYPES_FIELD_NUMBER = 18;
    private List<Integer> connectionTypes_;
    private static final Internal.ListAdapter.Converter<Integer, NetworkConnectionType> connectionTypes_converter_ = new Internal.ListAdapter.Converter<Integer, NetworkConnectionType>(){

        public NetworkConnectionType convert(Integer from) {
            NetworkConnectionType result = NetworkConnectionType.forNumber(from);
            return result == null ? NetworkConnectionType.UNRECOGNIZED : result;
        }
    };
    private int connectionTypesMemoizedSerializedSize;
    public static final int NETWORK_NAME_FIELD_NUMBER = 19;
    private volatile Object networkName_ = "";
    public static final int ENVIRONMENT_ID_FIELD_NUMBER = 20;
    private volatile Object environmentId_ = "";
    public static final int CREATED_FIELD_NUMBER = 21;
    private Timestamp created_;
    public static final int MODIFIED_FIELD_NUMBER = 22;
    private Timestamp modified_;
    public static final int ACTUAL_MODIFIED_FIELD_NUMBER = 23;
    private Timestamp actualModified_;
    public static final int LAST_ERROR_MSG_FIELD_NUMBER = 24;
    private volatile Object lastErrorMsg_ = "";
    public static final int LAST_ERROR_CODE_FIELD_NUMBER = 25;
    private int lastErrorCode_ = 0;
    public static final int MANAGED_FIELD_NUMBER = 26;
    private boolean managed_ = false;
    public static final int WAS_ACTIVE_FIELD_NUMBER = 27;
    private boolean wasActive_ = false;
    public static final int ORG_DEACTIVATED_FIELD_NUMBER = 28;
    private Timestamp orgDeactivated_;
    public static final int ENVOY_INSTANCE_POOLS_FIELD_NUMBER = 29;
    private Struct envoyInstancePools_;
    public static final int TRAFFIC_RUNTIME_CONFIG_FIELD_NUMBER = 30;
    private Struct trafficRuntimeConfig_;
    public static final int DESIRED_CONNECTION_TYPES_FIELD_NUMBER = 31;
    private List<Integer> desiredConnectionTypes_;
    private static final Internal.ListAdapter.Converter<Integer, NetworkConnectionType> desiredConnectionTypes_converter_ = new Internal.ListAdapter.Converter<Integer, NetworkConnectionType>(){

        public NetworkConnectionType convert(Integer from) {
            NetworkConnectionType result = NetworkConnectionType.forNumber(from);
            return result == null ? NetworkConnectionType.UNRECOGNIZED : result;
        }
    };
    private int desiredConnectionTypesMemoizedSerializedSize;
    public static final int ID_FIELD_NUMBER = 32;
    private long id_ = 0L;
    public static final int ENVOY_INSTANCE_POOLS_STRING_FIELD_NUMBER = 33;
    private volatile Object envoyInstancePoolsString_ = "";
    public static final int TRAFFIC_RUNTIME_CONFIG_STRING_FIELD_NUMBER = 34;
    private volatile Object trafficRuntimeConfigString_ = "";
    public static final int ORG_RESOURCE_ID_FIELD_NUMBER = 35;
    private volatile Object orgResourceId_ = "";
    public static final int NEEDS_INGRESS_EDGE_FIELD_NUMBER = 36;
    private boolean needsIngressEdge_ = false;
    public static final int NETWORK_CONTEXT_ID_FIELD_NUMBER = 37;
    private volatile Object networkContextId_ = "";
    public static final int METADATA_FIELD_NUMBER = 41;
    private ChangeEventMetadata metadata_;
    private byte memoizedIsInitialized = (byte)-1;
    private static final Site DEFAULT_INSTANCE = new Site();
    private static final Parser<Site> PARSER = new AbstractParser<Site>(){

        public Site parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            Builder builder = Site.newBuilder();
            try {
                builder.mergeFrom(input, extensionRegistry);
            }
            catch (InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            catch (UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException().setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            catch (IOException e) {
                throw new InvalidProtocolBufferException(e).setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            return builder.buildPartial();
        }
    };

    private Site(GeneratedMessageV3.Builder<?> builder) {
        super(builder);
    }

    private Site() {
        this.name_ = "";
        this.nid_ = "";
        this.cloud_ = 0;
        this.region_ = "";
        this.networkVersion_ = "";
        this.cidr_ = "";
        this.zoneIds_ = LazyStringArrayList.emptyList();
        this.actualState_ = 0;
        this.desiredState_ = 0;
        this.realm_ = "";
        this.displayName_ = "";
        this.connectionTypes_ = Collections.emptyList();
        this.networkName_ = "";
        this.environmentId_ = "";
        this.lastErrorMsg_ = "";
        this.desiredConnectionTypes_ = Collections.emptyList();
        this.envoyInstancePoolsString_ = "";
        this.trafficRuntimeConfigString_ = "";
        this.orgResourceId_ = "";
        this.networkContextId_ = "";
    }

    protected Object newInstance(GeneratedMessageV3.UnusedPrivateParameter unused) {
        return new Site();
    }

    public static final Descriptors.Descriptor getDescriptor() {
        return TrafficSites.internal_static_cloud_v1_Site_descriptor;
    }

    protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
        return TrafficSites.internal_static_cloud_v1_Site_fieldAccessorTable.ensureFieldAccessorsInitialized(Site.class, Builder.class);
    }

    @Override
    public String getName() {
        Object ref = this.name_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.name_ = s;
        return s;
    }

    @Override
    public ByteString getNameBytes() {
        Object ref = this.name_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.name_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public String getNid() {
        Object ref = this.nid_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.nid_ = s;
        return s;
    }

    @Override
    public ByteString getNidBytes() {
        Object ref = this.nid_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.nid_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public int getCloudValue() {
        return this.cloud_;
    }

    @Override
    public Provider.Cloud getCloud() {
        Provider.Cloud result = Provider.Cloud.forNumber(this.cloud_);
        return result == null ? Provider.Cloud.UNRECOGNIZED : result;
    }

    @Override
    public String getRegion() {
        Object ref = this.region_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.region_ = s;
        return s;
    }

    @Override
    public ByteString getRegionBytes() {
        Object ref = this.region_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.region_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public String getNetworkVersion() {
        Object ref = this.networkVersion_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.networkVersion_ = s;
        return s;
    }

    @Override
    public ByteString getNetworkVersionBytes() {
        Object ref = this.networkVersion_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.networkVersion_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public boolean getSniEnabled() {
        return this.sniEnabled_;
    }

    @Override
    public String getCidr() {
        Object ref = this.cidr_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.cidr_ = s;
        return s;
    }

    @Override
    public ByteString getCidrBytes() {
        Object ref = this.cidr_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.cidr_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    public ProtocolStringList getZoneIdsList() {
        return this.zoneIds_;
    }

    @Override
    public int getZoneIdsCount() {
        return this.zoneIds_.size();
    }

    @Override
    public String getZoneIds(int index) {
        return this.zoneIds_.get(index);
    }

    @Override
    public ByteString getZoneIdsBytes(int index) {
        return this.zoneIds_.getByteString(index);
    }

    @Override
    public int getActualStateValue() {
        return this.actualState_;
    }

    @Override
    public State getActualState() {
        State result = State.forNumber(this.actualState_);
        return result == null ? State.UNRECOGNIZED : result;
    }

    @Override
    public int getDesiredStateValue() {
        return this.desiredState_;
    }

    @Override
    public State getDesiredState() {
        State result = State.forNumber(this.desiredState_);
        return result == null ? State.UNRECOGNIZED : result;
    }

    @Override
    public boolean getAccessPublic() {
        return this.accessPublic_;
    }

    @Override
    public boolean getAccessPrivate() {
        return this.accessPrivate_;
    }

    @Override
    public String getRealm() {
        Object ref = this.realm_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.realm_ = s;
        return s;
    }

    @Override
    public ByteString getRealmBytes() {
        Object ref = this.realm_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.realm_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public boolean getEgressIpsActive() {
        return this.egressIpsActive_;
    }

    @Override
    public boolean hasDeactivated() {
        return (this.bitField0_ & 1) != 0;
    }

    @Override
    public Timestamp getDeactivated() {
        return this.deactivated_ == null ? Timestamp.getDefaultInstance() : this.deactivated_;
    }

    @Override
    public TimestampOrBuilder getDeactivatedOrBuilder() {
        return this.deactivated_ == null ? Timestamp.getDefaultInstance() : this.deactivated_;
    }

    @Override
    public String getDisplayName() {
        Object ref = this.displayName_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.displayName_ = s;
        return s;
    }

    @Override
    public ByteString getDisplayNameBytes() {
        Object ref = this.displayName_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.displayName_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public boolean getDedicated() {
        return this.dedicated_;
    }

    @Override
    public List<NetworkConnectionType> getConnectionTypesList() {
        return new Internal.ListAdapter(this.connectionTypes_, connectionTypes_converter_);
    }

    @Override
    public int getConnectionTypesCount() {
        return this.connectionTypes_.size();
    }

    @Override
    public NetworkConnectionType getConnectionTypes(int index) {
        return (NetworkConnectionType)((Object)connectionTypes_converter_.convert((Object)this.connectionTypes_.get(index)));
    }

    @Override
    public List<Integer> getConnectionTypesValueList() {
        return this.connectionTypes_;
    }

    @Override
    public int getConnectionTypesValue(int index) {
        return this.connectionTypes_.get(index);
    }

    @Override
    public String getNetworkName() {
        Object ref = this.networkName_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.networkName_ = s;
        return s;
    }

    @Override
    public ByteString getNetworkNameBytes() {
        Object ref = this.networkName_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.networkName_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public String getEnvironmentId() {
        Object ref = this.environmentId_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.environmentId_ = s;
        return s;
    }

    @Override
    public ByteString getEnvironmentIdBytes() {
        Object ref = this.environmentId_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.environmentId_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public boolean hasCreated() {
        return (this.bitField0_ & 2) != 0;
    }

    @Override
    public Timestamp getCreated() {
        return this.created_ == null ? Timestamp.getDefaultInstance() : this.created_;
    }

    @Override
    public TimestampOrBuilder getCreatedOrBuilder() {
        return this.created_ == null ? Timestamp.getDefaultInstance() : this.created_;
    }

    @Override
    public boolean hasModified() {
        return (this.bitField0_ & 4) != 0;
    }

    @Override
    public Timestamp getModified() {
        return this.modified_ == null ? Timestamp.getDefaultInstance() : this.modified_;
    }

    @Override
    public TimestampOrBuilder getModifiedOrBuilder() {
        return this.modified_ == null ? Timestamp.getDefaultInstance() : this.modified_;
    }

    @Override
    public boolean hasActualModified() {
        return (this.bitField0_ & 8) != 0;
    }

    @Override
    public Timestamp getActualModified() {
        return this.actualModified_ == null ? Timestamp.getDefaultInstance() : this.actualModified_;
    }

    @Override
    public TimestampOrBuilder getActualModifiedOrBuilder() {
        return this.actualModified_ == null ? Timestamp.getDefaultInstance() : this.actualModified_;
    }

    @Override
    public String getLastErrorMsg() {
        Object ref = this.lastErrorMsg_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.lastErrorMsg_ = s;
        return s;
    }

    @Override
    public ByteString getLastErrorMsgBytes() {
        Object ref = this.lastErrorMsg_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.lastErrorMsg_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public int getLastErrorCode() {
        return this.lastErrorCode_;
    }

    @Override
    public boolean getManaged() {
        return this.managed_;
    }

    @Override
    public boolean getWasActive() {
        return this.wasActive_;
    }

    @Override
    public boolean hasOrgDeactivated() {
        return (this.bitField0_ & 0x10) != 0;
    }

    @Override
    public Timestamp getOrgDeactivated() {
        return this.orgDeactivated_ == null ? Timestamp.getDefaultInstance() : this.orgDeactivated_;
    }

    @Override
    public TimestampOrBuilder getOrgDeactivatedOrBuilder() {
        return this.orgDeactivated_ == null ? Timestamp.getDefaultInstance() : this.orgDeactivated_;
    }

    @Override
    public boolean hasEnvoyInstancePools() {
        return (this.bitField0_ & 0x20) != 0;
    }

    @Override
    public Struct getEnvoyInstancePools() {
        return this.envoyInstancePools_ == null ? Struct.getDefaultInstance() : this.envoyInstancePools_;
    }

    @Override
    public StructOrBuilder getEnvoyInstancePoolsOrBuilder() {
        return this.envoyInstancePools_ == null ? Struct.getDefaultInstance() : this.envoyInstancePools_;
    }

    @Override
    public boolean hasTrafficRuntimeConfig() {
        return (this.bitField0_ & 0x40) != 0;
    }

    @Override
    public Struct getTrafficRuntimeConfig() {
        return this.trafficRuntimeConfig_ == null ? Struct.getDefaultInstance() : this.trafficRuntimeConfig_;
    }

    @Override
    public StructOrBuilder getTrafficRuntimeConfigOrBuilder() {
        return this.trafficRuntimeConfig_ == null ? Struct.getDefaultInstance() : this.trafficRuntimeConfig_;
    }

    @Override
    public List<NetworkConnectionType> getDesiredConnectionTypesList() {
        return new Internal.ListAdapter(this.desiredConnectionTypes_, desiredConnectionTypes_converter_);
    }

    @Override
    public int getDesiredConnectionTypesCount() {
        return this.desiredConnectionTypes_.size();
    }

    @Override
    public NetworkConnectionType getDesiredConnectionTypes(int index) {
        return (NetworkConnectionType)((Object)desiredConnectionTypes_converter_.convert((Object)this.desiredConnectionTypes_.get(index)));
    }

    @Override
    public List<Integer> getDesiredConnectionTypesValueList() {
        return this.desiredConnectionTypes_;
    }

    @Override
    public int getDesiredConnectionTypesValue(int index) {
        return this.desiredConnectionTypes_.get(index);
    }

    @Override
    public long getId() {
        return this.id_;
    }

    @Override
    public String getEnvoyInstancePoolsString() {
        Object ref = this.envoyInstancePoolsString_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.envoyInstancePoolsString_ = s;
        return s;
    }

    @Override
    public ByteString getEnvoyInstancePoolsStringBytes() {
        Object ref = this.envoyInstancePoolsString_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.envoyInstancePoolsString_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public String getTrafficRuntimeConfigString() {
        Object ref = this.trafficRuntimeConfigString_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.trafficRuntimeConfigString_ = s;
        return s;
    }

    @Override
    public ByteString getTrafficRuntimeConfigStringBytes() {
        Object ref = this.trafficRuntimeConfigString_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.trafficRuntimeConfigString_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public String getOrgResourceId() {
        Object ref = this.orgResourceId_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.orgResourceId_ = s;
        return s;
    }

    @Override
    public ByteString getOrgResourceIdBytes() {
        Object ref = this.orgResourceId_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.orgResourceId_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public boolean getNeedsIngressEdge() {
        return this.needsIngressEdge_;
    }

    @Override
    public String getNetworkContextId() {
        Object ref = this.networkContextId_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.networkContextId_ = s;
        return s;
    }

    @Override
    public ByteString getNetworkContextIdBytes() {
        Object ref = this.networkContextId_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.networkContextId_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public boolean hasMetadata() {
        return (this.bitField0_ & 0x80) != 0;
    }

    @Override
    public ChangeEventMetadata getMetadata() {
        return this.metadata_ == null ? ChangeEventMetadata.getDefaultInstance() : this.metadata_;
    }

    @Override
    public ChangeEventMetadataOrBuilder getMetadataOrBuilder() {
        return this.metadata_ == null ? ChangeEventMetadata.getDefaultInstance() : this.metadata_;
    }

    public final boolean isInitialized() {
        byte isInitialized = this.memoizedIsInitialized;
        if (isInitialized == 1) {
            return true;
        }
        if (isInitialized == 0) {
            return false;
        }
        this.memoizedIsInitialized = 1;
        return true;
    }

    public void writeTo(CodedOutputStream output) throws IOException {
        int i;
        this.getSerializedSize();
        if (!GeneratedMessageV3.isStringEmpty((Object)this.name_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)1, (Object)this.name_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.nid_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)2, (Object)this.nid_);
        }
        if (this.cloud_ != Provider.Cloud.UNKNOWN.getNumber()) {
            output.writeEnum(3, this.cloud_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.region_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)4, (Object)this.region_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.networkVersion_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)5, (Object)this.networkVersion_);
        }
        if (this.sniEnabled_) {
            output.writeBool(6, this.sniEnabled_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.cidr_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)7, (Object)this.cidr_);
        }
        for (i = 0; i < this.zoneIds_.size(); ++i) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)8, (Object)this.zoneIds_.getRaw(i));
        }
        if (this.actualState_ != State.STATE_UNKNOWN.getNumber()) {
            output.writeEnum(9, this.actualState_);
        }
        if (this.desiredState_ != State.STATE_UNKNOWN.getNumber()) {
            output.writeEnum(10, this.desiredState_);
        }
        if (this.accessPublic_) {
            output.writeBool(11, this.accessPublic_);
        }
        if (this.accessPrivate_) {
            output.writeBool(12, this.accessPrivate_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.realm_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)13, (Object)this.realm_);
        }
        if (this.egressIpsActive_) {
            output.writeBool(14, this.egressIpsActive_);
        }
        if ((this.bitField0_ & 1) != 0) {
            output.writeMessage(15, (MessageLite)this.getDeactivated());
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.displayName_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)16, (Object)this.displayName_);
        }
        if (this.dedicated_) {
            output.writeBool(17, this.dedicated_);
        }
        if (this.getConnectionTypesList().size() > 0) {
            output.writeUInt32NoTag(146);
            output.writeUInt32NoTag(this.connectionTypesMemoizedSerializedSize);
        }
        for (i = 0; i < this.connectionTypes_.size(); ++i) {
            output.writeEnumNoTag(this.connectionTypes_.get(i).intValue());
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.networkName_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)19, (Object)this.networkName_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.environmentId_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)20, (Object)this.environmentId_);
        }
        if ((this.bitField0_ & 2) != 0) {
            output.writeMessage(21, (MessageLite)this.getCreated());
        }
        if ((this.bitField0_ & 4) != 0) {
            output.writeMessage(22, (MessageLite)this.getModified());
        }
        if ((this.bitField0_ & 8) != 0) {
            output.writeMessage(23, (MessageLite)this.getActualModified());
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.lastErrorMsg_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)24, (Object)this.lastErrorMsg_);
        }
        if (this.lastErrorCode_ != 0) {
            output.writeInt32(25, this.lastErrorCode_);
        }
        if (this.managed_) {
            output.writeBool(26, this.managed_);
        }
        if (this.wasActive_) {
            output.writeBool(27, this.wasActive_);
        }
        if ((this.bitField0_ & 0x10) != 0) {
            output.writeMessage(28, (MessageLite)this.getOrgDeactivated());
        }
        if ((this.bitField0_ & 0x20) != 0) {
            output.writeMessage(29, (MessageLite)this.getEnvoyInstancePools());
        }
        if ((this.bitField0_ & 0x40) != 0) {
            output.writeMessage(30, (MessageLite)this.getTrafficRuntimeConfig());
        }
        if (this.getDesiredConnectionTypesList().size() > 0) {
            output.writeUInt32NoTag(250);
            output.writeUInt32NoTag(this.desiredConnectionTypesMemoizedSerializedSize);
        }
        for (i = 0; i < this.desiredConnectionTypes_.size(); ++i) {
            output.writeEnumNoTag(this.desiredConnectionTypes_.get(i).intValue());
        }
        if (this.id_ != 0L) {
            output.writeInt64(32, this.id_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.envoyInstancePoolsString_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)33, (Object)this.envoyInstancePoolsString_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.trafficRuntimeConfigString_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)34, (Object)this.trafficRuntimeConfigString_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.orgResourceId_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)35, (Object)this.orgResourceId_);
        }
        if (this.needsIngressEdge_) {
            output.writeBool(36, this.needsIngressEdge_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.networkContextId_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)37, (Object)this.networkContextId_);
        }
        if ((this.bitField0_ & 0x80) != 0) {
            output.writeMessage(41, (MessageLite)this.getMetadata());
        }
        this.getUnknownFields().writeTo(output);
    }

    public int getSerializedSize() {
        int i;
        int size = this.memoizedSize;
        if (size != -1) {
            return size;
        }
        size = 0;
        if (!GeneratedMessageV3.isStringEmpty((Object)this.name_)) {
            size += GeneratedMessageV3.computeStringSize((int)1, (Object)this.name_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.nid_)) {
            size += GeneratedMessageV3.computeStringSize((int)2, (Object)this.nid_);
        }
        if (this.cloud_ != Provider.Cloud.UNKNOWN.getNumber()) {
            size += CodedOutputStream.computeEnumSize((int)3, (int)this.cloud_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.region_)) {
            size += GeneratedMessageV3.computeStringSize((int)4, (Object)this.region_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.networkVersion_)) {
            size += GeneratedMessageV3.computeStringSize((int)5, (Object)this.networkVersion_);
        }
        if (this.sniEnabled_) {
            size += CodedOutputStream.computeBoolSize((int)6, (boolean)this.sniEnabled_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.cidr_)) {
            size += GeneratedMessageV3.computeStringSize((int)7, (Object)this.cidr_);
        }
        int dataSize = 0;
        for (i = 0; i < this.zoneIds_.size(); ++i) {
            dataSize += Site.computeStringSizeNoTag((Object)this.zoneIds_.getRaw(i));
        }
        size += dataSize;
        size += 1 * this.getZoneIdsList().size();
        if (this.actualState_ != State.STATE_UNKNOWN.getNumber()) {
            size += CodedOutputStream.computeEnumSize((int)9, (int)this.actualState_);
        }
        if (this.desiredState_ != State.STATE_UNKNOWN.getNumber()) {
            size += CodedOutputStream.computeEnumSize((int)10, (int)this.desiredState_);
        }
        if (this.accessPublic_) {
            size += CodedOutputStream.computeBoolSize((int)11, (boolean)this.accessPublic_);
        }
        if (this.accessPrivate_) {
            size += CodedOutputStream.computeBoolSize((int)12, (boolean)this.accessPrivate_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.realm_)) {
            size += GeneratedMessageV3.computeStringSize((int)13, (Object)this.realm_);
        }
        if (this.egressIpsActive_) {
            size += CodedOutputStream.computeBoolSize((int)14, (boolean)this.egressIpsActive_);
        }
        if ((this.bitField0_ & 1) != 0) {
            size += CodedOutputStream.computeMessageSize((int)15, (MessageLite)this.getDeactivated());
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.displayName_)) {
            size += GeneratedMessageV3.computeStringSize((int)16, (Object)this.displayName_);
        }
        if (this.dedicated_) {
            size += CodedOutputStream.computeBoolSize((int)17, (boolean)this.dedicated_);
        }
        dataSize = 0;
        for (i = 0; i < this.connectionTypes_.size(); ++i) {
            dataSize += CodedOutputStream.computeEnumSizeNoTag((int)this.connectionTypes_.get(i));
        }
        size += dataSize;
        if (!this.getConnectionTypesList().isEmpty()) {
            size += 2;
            size += CodedOutputStream.computeUInt32SizeNoTag((int)dataSize);
        }
        this.connectionTypesMemoizedSerializedSize = dataSize;
        if (!GeneratedMessageV3.isStringEmpty((Object)this.networkName_)) {
            size += GeneratedMessageV3.computeStringSize((int)19, (Object)this.networkName_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.environmentId_)) {
            size += GeneratedMessageV3.computeStringSize((int)20, (Object)this.environmentId_);
        }
        if ((this.bitField0_ & 2) != 0) {
            size += CodedOutputStream.computeMessageSize((int)21, (MessageLite)this.getCreated());
        }
        if ((this.bitField0_ & 4) != 0) {
            size += CodedOutputStream.computeMessageSize((int)22, (MessageLite)this.getModified());
        }
        if ((this.bitField0_ & 8) != 0) {
            size += CodedOutputStream.computeMessageSize((int)23, (MessageLite)this.getActualModified());
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.lastErrorMsg_)) {
            size += GeneratedMessageV3.computeStringSize((int)24, (Object)this.lastErrorMsg_);
        }
        if (this.lastErrorCode_ != 0) {
            size += CodedOutputStream.computeInt32Size((int)25, (int)this.lastErrorCode_);
        }
        if (this.managed_) {
            size += CodedOutputStream.computeBoolSize((int)26, (boolean)this.managed_);
        }
        if (this.wasActive_) {
            size += CodedOutputStream.computeBoolSize((int)27, (boolean)this.wasActive_);
        }
        if ((this.bitField0_ & 0x10) != 0) {
            size += CodedOutputStream.computeMessageSize((int)28, (MessageLite)this.getOrgDeactivated());
        }
        if ((this.bitField0_ & 0x20) != 0) {
            size += CodedOutputStream.computeMessageSize((int)29, (MessageLite)this.getEnvoyInstancePools());
        }
        if ((this.bitField0_ & 0x40) != 0) {
            size += CodedOutputStream.computeMessageSize((int)30, (MessageLite)this.getTrafficRuntimeConfig());
        }
        dataSize = 0;
        for (i = 0; i < this.desiredConnectionTypes_.size(); ++i) {
            dataSize += CodedOutputStream.computeEnumSizeNoTag((int)this.desiredConnectionTypes_.get(i));
        }
        size += dataSize;
        if (!this.getDesiredConnectionTypesList().isEmpty()) {
            size += 2;
            size += CodedOutputStream.computeUInt32SizeNoTag((int)dataSize);
        }
        this.desiredConnectionTypesMemoizedSerializedSize = dataSize;
        if (this.id_ != 0L) {
            size += CodedOutputStream.computeInt64Size((int)32, (long)this.id_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.envoyInstancePoolsString_)) {
            size += GeneratedMessageV3.computeStringSize((int)33, (Object)this.envoyInstancePoolsString_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.trafficRuntimeConfigString_)) {
            size += GeneratedMessageV3.computeStringSize((int)34, (Object)this.trafficRuntimeConfigString_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.orgResourceId_)) {
            size += GeneratedMessageV3.computeStringSize((int)35, (Object)this.orgResourceId_);
        }
        if (this.needsIngressEdge_) {
            size += CodedOutputStream.computeBoolSize((int)36, (boolean)this.needsIngressEdge_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.networkContextId_)) {
            size += GeneratedMessageV3.computeStringSize((int)37, (Object)this.networkContextId_);
        }
        if ((this.bitField0_ & 0x80) != 0) {
            size += CodedOutputStream.computeMessageSize((int)41, (MessageLite)this.getMetadata());
        }
        this.memoizedSize = size += this.getUnknownFields().getSerializedSize();
        return size;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Site)) {
            return super.equals(obj);
        }
        Site other = (Site)obj;
        if (!this.getName().equals(other.getName())) {
            return false;
        }
        if (!this.getNid().equals(other.getNid())) {
            return false;
        }
        if (this.cloud_ != other.cloud_) {
            return false;
        }
        if (!this.getRegion().equals(other.getRegion())) {
            return false;
        }
        if (!this.getNetworkVersion().equals(other.getNetworkVersion())) {
            return false;
        }
        if (this.getSniEnabled() != other.getSniEnabled()) {
            return false;
        }
        if (!this.getCidr().equals(other.getCidr())) {
            return false;
        }
        if (!this.getZoneIdsList().equals(other.getZoneIdsList())) {
            return false;
        }
        if (this.actualState_ != other.actualState_) {
            return false;
        }
        if (this.desiredState_ != other.desiredState_) {
            return false;
        }
        if (this.getAccessPublic() != other.getAccessPublic()) {
            return false;
        }
        if (this.getAccessPrivate() != other.getAccessPrivate()) {
            return false;
        }
        if (!this.getRealm().equals(other.getRealm())) {
            return false;
        }
        if (this.getEgressIpsActive() != other.getEgressIpsActive()) {
            return false;
        }
        if (this.hasDeactivated() != other.hasDeactivated()) {
            return false;
        }
        if (this.hasDeactivated() && !this.getDeactivated().equals((Object)other.getDeactivated())) {
            return false;
        }
        if (!this.getDisplayName().equals(other.getDisplayName())) {
            return false;
        }
        if (this.getDedicated() != other.getDedicated()) {
            return false;
        }
        if (!this.connectionTypes_.equals(other.connectionTypes_)) {
            return false;
        }
        if (!this.getNetworkName().equals(other.getNetworkName())) {
            return false;
        }
        if (!this.getEnvironmentId().equals(other.getEnvironmentId())) {
            return false;
        }
        if (this.hasCreated() != other.hasCreated()) {
            return false;
        }
        if (this.hasCreated() && !this.getCreated().equals((Object)other.getCreated())) {
            return false;
        }
        if (this.hasModified() != other.hasModified()) {
            return false;
        }
        if (this.hasModified() && !this.getModified().equals((Object)other.getModified())) {
            return false;
        }
        if (this.hasActualModified() != other.hasActualModified()) {
            return false;
        }
        if (this.hasActualModified() && !this.getActualModified().equals((Object)other.getActualModified())) {
            return false;
        }
        if (!this.getLastErrorMsg().equals(other.getLastErrorMsg())) {
            return false;
        }
        if (this.getLastErrorCode() != other.getLastErrorCode()) {
            return false;
        }
        if (this.getManaged() != other.getManaged()) {
            return false;
        }
        if (this.getWasActive() != other.getWasActive()) {
            return false;
        }
        if (this.hasOrgDeactivated() != other.hasOrgDeactivated()) {
            return false;
        }
        if (this.hasOrgDeactivated() && !this.getOrgDeactivated().equals((Object)other.getOrgDeactivated())) {
            return false;
        }
        if (this.hasEnvoyInstancePools() != other.hasEnvoyInstancePools()) {
            return false;
        }
        if (this.hasEnvoyInstancePools() && !this.getEnvoyInstancePools().equals((Object)other.getEnvoyInstancePools())) {
            return false;
        }
        if (this.hasTrafficRuntimeConfig() != other.hasTrafficRuntimeConfig()) {
            return false;
        }
        if (this.hasTrafficRuntimeConfig() && !this.getTrafficRuntimeConfig().equals((Object)other.getTrafficRuntimeConfig())) {
            return false;
        }
        if (!this.desiredConnectionTypes_.equals(other.desiredConnectionTypes_)) {
            return false;
        }
        if (this.getId() != other.getId()) {
            return false;
        }
        if (!this.getEnvoyInstancePoolsString().equals(other.getEnvoyInstancePoolsString())) {
            return false;
        }
        if (!this.getTrafficRuntimeConfigString().equals(other.getTrafficRuntimeConfigString())) {
            return false;
        }
        if (!this.getOrgResourceId().equals(other.getOrgResourceId())) {
            return false;
        }
        if (this.getNeedsIngressEdge() != other.getNeedsIngressEdge()) {
            return false;
        }
        if (!this.getNetworkContextId().equals(other.getNetworkContextId())) {
            return false;
        }
        if (this.hasMetadata() != other.hasMetadata()) {
            return false;
        }
        if (this.hasMetadata() && !this.getMetadata().equals(other.getMetadata())) {
            return false;
        }
        return this.getUnknownFields().equals((Object)other.getUnknownFields());
    }

    public int hashCode() {
        if (this.memoizedHashCode != 0) {
            return this.memoizedHashCode;
        }
        int hash = 41;
        hash = 19 * hash + Site.getDescriptor().hashCode();
        hash = 37 * hash + 1;
        hash = 53 * hash + this.getName().hashCode();
        hash = 37 * hash + 2;
        hash = 53 * hash + this.getNid().hashCode();
        hash = 37 * hash + 3;
        hash = 53 * hash + this.cloud_;
        hash = 37 * hash + 4;
        hash = 53 * hash + this.getRegion().hashCode();
        hash = 37 * hash + 5;
        hash = 53 * hash + this.getNetworkVersion().hashCode();
        hash = 37 * hash + 6;
        hash = 53 * hash + Internal.hashBoolean((boolean)this.getSniEnabled());
        hash = 37 * hash + 7;
        hash = 53 * hash + this.getCidr().hashCode();
        if (this.getZoneIdsCount() > 0) {
            hash = 37 * hash + 8;
            hash = 53 * hash + this.getZoneIdsList().hashCode();
        }
        hash = 37 * hash + 9;
        hash = 53 * hash + this.actualState_;
        hash = 37 * hash + 10;
        hash = 53 * hash + this.desiredState_;
        hash = 37 * hash + 11;
        hash = 53 * hash + Internal.hashBoolean((boolean)this.getAccessPublic());
        hash = 37 * hash + 12;
        hash = 53 * hash + Internal.hashBoolean((boolean)this.getAccessPrivate());
        hash = 37 * hash + 13;
        hash = 53 * hash + this.getRealm().hashCode();
        hash = 37 * hash + 14;
        hash = 53 * hash + Internal.hashBoolean((boolean)this.getEgressIpsActive());
        if (this.hasDeactivated()) {
            hash = 37 * hash + 15;
            hash = 53 * hash + this.getDeactivated().hashCode();
        }
        hash = 37 * hash + 16;
        hash = 53 * hash + this.getDisplayName().hashCode();
        hash = 37 * hash + 17;
        hash = 53 * hash + Internal.hashBoolean((boolean)this.getDedicated());
        if (this.getConnectionTypesCount() > 0) {
            hash = 37 * hash + 18;
            hash = 53 * hash + this.connectionTypes_.hashCode();
        }
        hash = 37 * hash + 19;
        hash = 53 * hash + this.getNetworkName().hashCode();
        hash = 37 * hash + 20;
        hash = 53 * hash + this.getEnvironmentId().hashCode();
        if (this.hasCreated()) {
            hash = 37 * hash + 21;
            hash = 53 * hash + this.getCreated().hashCode();
        }
        if (this.hasModified()) {
            hash = 37 * hash + 22;
            hash = 53 * hash + this.getModified().hashCode();
        }
        if (this.hasActualModified()) {
            hash = 37 * hash + 23;
            hash = 53 * hash + this.getActualModified().hashCode();
        }
        hash = 37 * hash + 24;
        hash = 53 * hash + this.getLastErrorMsg().hashCode();
        hash = 37 * hash + 25;
        hash = 53 * hash + this.getLastErrorCode();
        hash = 37 * hash + 26;
        hash = 53 * hash + Internal.hashBoolean((boolean)this.getManaged());
        hash = 37 * hash + 27;
        hash = 53 * hash + Internal.hashBoolean((boolean)this.getWasActive());
        if (this.hasOrgDeactivated()) {
            hash = 37 * hash + 28;
            hash = 53 * hash + this.getOrgDeactivated().hashCode();
        }
        if (this.hasEnvoyInstancePools()) {
            hash = 37 * hash + 29;
            hash = 53 * hash + this.getEnvoyInstancePools().hashCode();
        }
        if (this.hasTrafficRuntimeConfig()) {
            hash = 37 * hash + 30;
            hash = 53 * hash + this.getTrafficRuntimeConfig().hashCode();
        }
        if (this.getDesiredConnectionTypesCount() > 0) {
            hash = 37 * hash + 31;
            hash = 53 * hash + this.desiredConnectionTypes_.hashCode();
        }
        hash = 37 * hash + 32;
        hash = 53 * hash + Internal.hashLong((long)this.getId());
        hash = 37 * hash + 33;
        hash = 53 * hash + this.getEnvoyInstancePoolsString().hashCode();
        hash = 37 * hash + 34;
        hash = 53 * hash + this.getTrafficRuntimeConfigString().hashCode();
        hash = 37 * hash + 35;
        hash = 53 * hash + this.getOrgResourceId().hashCode();
        hash = 37 * hash + 36;
        hash = 53 * hash + Internal.hashBoolean((boolean)this.getNeedsIngressEdge());
        hash = 37 * hash + 37;
        hash = 53 * hash + this.getNetworkContextId().hashCode();
        if (this.hasMetadata()) {
            hash = 37 * hash + 41;
            hash = 53 * hash + this.getMetadata().hashCode();
        }
        this.memoizedHashCode = hash = 29 * hash + this.getUnknownFields().hashCode();
        return hash;
    }

    public static Site parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
        return (Site)PARSER.parseFrom(data);
    }

    public static Site parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (Site)PARSER.parseFrom(data, extensionRegistry);
    }

    public static Site parseFrom(ByteString data) throws InvalidProtocolBufferException {
        return (Site)PARSER.parseFrom(data);
    }

    public static Site parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (Site)PARSER.parseFrom(data, extensionRegistry);
    }

    public static Site parseFrom(byte[] data) throws InvalidProtocolBufferException {
        return (Site)PARSER.parseFrom(data);
    }

    public static Site parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (Site)PARSER.parseFrom(data, extensionRegistry);
    }

    public static Site parseFrom(InputStream input) throws IOException {
        return (Site)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input);
    }

    public static Site parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (Site)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static Site parseDelimitedFrom(InputStream input) throws IOException {
        return (Site)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input);
    }

    public static Site parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (Site)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static Site parseFrom(CodedInputStream input) throws IOException {
        return (Site)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input);
    }

    public static Site parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (Site)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public Builder newBuilderForType() {
        return Site.newBuilder();
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(Site prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    protected Builder newBuilderForType(GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
    }

    public static Site getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public static Parser<Site> parser() {
        return PARSER;
    }

    public Parser<Site> getParserForType() {
        return PARSER;
    }

    public Site getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
    }

    public static final class Builder
    extends GeneratedMessageV3.Builder<Builder>
    implements SiteOrBuilder {
        private int bitField0_;
        private int bitField1_;
        private Object name_ = "";
        private Object nid_ = "";
        private int cloud_ = 0;
        private Object region_ = "";
        private Object networkVersion_ = "";
        private boolean sniEnabled_;
        private Object cidr_ = "";
        private LazyStringArrayList zoneIds_ = LazyStringArrayList.emptyList();
        private int actualState_ = 0;
        private int desiredState_ = 0;
        private boolean accessPublic_;
        private boolean accessPrivate_;
        private Object realm_ = "";
        private boolean egressIpsActive_;
        private Timestamp deactivated_;
        private SingleFieldBuilderV3<Timestamp, Timestamp.Builder, TimestampOrBuilder> deactivatedBuilder_;
        private Object displayName_ = "";
        private boolean dedicated_;
        private List<Integer> connectionTypes_ = Collections.emptyList();
        private Object networkName_ = "";
        private Object environmentId_ = "";
        private Timestamp created_;
        private SingleFieldBuilderV3<Timestamp, Timestamp.Builder, TimestampOrBuilder> createdBuilder_;
        private Timestamp modified_;
        private SingleFieldBuilderV3<Timestamp, Timestamp.Builder, TimestampOrBuilder> modifiedBuilder_;
        private Timestamp actualModified_;
        private SingleFieldBuilderV3<Timestamp, Timestamp.Builder, TimestampOrBuilder> actualModifiedBuilder_;
        private Object lastErrorMsg_ = "";
        private int lastErrorCode_;
        private boolean managed_;
        private boolean wasActive_;
        private Timestamp orgDeactivated_;
        private SingleFieldBuilderV3<Timestamp, Timestamp.Builder, TimestampOrBuilder> orgDeactivatedBuilder_;
        private Struct envoyInstancePools_;
        private SingleFieldBuilderV3<Struct, Struct.Builder, StructOrBuilder> envoyInstancePoolsBuilder_;
        private Struct trafficRuntimeConfig_;
        private SingleFieldBuilderV3<Struct, Struct.Builder, StructOrBuilder> trafficRuntimeConfigBuilder_;
        private List<Integer> desiredConnectionTypes_ = Collections.emptyList();
        private long id_;
        private Object envoyInstancePoolsString_ = "";
        private Object trafficRuntimeConfigString_ = "";
        private Object orgResourceId_ = "";
        private boolean needsIngressEdge_;
        private Object networkContextId_ = "";
        private ChangeEventMetadata metadata_;
        private SingleFieldBuilderV3<ChangeEventMetadata, ChangeEventMetadata.Builder, ChangeEventMetadataOrBuilder> metadataBuilder_;

        public static final Descriptors.Descriptor getDescriptor() {
            return TrafficSites.internal_static_cloud_v1_Site_descriptor;
        }

        protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
            return TrafficSites.internal_static_cloud_v1_Site_fieldAccessorTable.ensureFieldAccessorsInitialized(Site.class, Builder.class);
        }

        private Builder() {
            this.maybeForceBuilderInitialization();
        }

        private Builder(GeneratedMessageV3.BuilderParent parent) {
            super(parent);
            this.maybeForceBuilderInitialization();
        }

        private void maybeForceBuilderInitialization() {
            if (alwaysUseFieldBuilders) {
                this.getDeactivatedFieldBuilder();
                this.getCreatedFieldBuilder();
                this.getModifiedFieldBuilder();
                this.getActualModifiedFieldBuilder();
                this.getOrgDeactivatedFieldBuilder();
                this.getEnvoyInstancePoolsFieldBuilder();
                this.getTrafficRuntimeConfigFieldBuilder();
                this.getMetadataFieldBuilder();
            }
        }

        public Builder clear() {
            super.clear();
            this.bitField0_ = 0;
            this.bitField1_ = 0;
            this.name_ = "";
            this.nid_ = "";
            this.cloud_ = 0;
            this.region_ = "";
            this.networkVersion_ = "";
            this.sniEnabled_ = false;
            this.cidr_ = "";
            this.zoneIds_ = LazyStringArrayList.emptyList();
            this.actualState_ = 0;
            this.desiredState_ = 0;
            this.accessPublic_ = false;
            this.accessPrivate_ = false;
            this.realm_ = "";
            this.egressIpsActive_ = false;
            this.deactivated_ = null;
            if (this.deactivatedBuilder_ != null) {
                this.deactivatedBuilder_.dispose();
                this.deactivatedBuilder_ = null;
            }
            this.displayName_ = "";
            this.dedicated_ = false;
            this.connectionTypes_ = Collections.emptyList();
            this.bitField0_ &= 0xFFFDFFFF;
            this.networkName_ = "";
            this.environmentId_ = "";
            this.created_ = null;
            if (this.createdBuilder_ != null) {
                this.createdBuilder_.dispose();
                this.createdBuilder_ = null;
            }
            this.modified_ = null;
            if (this.modifiedBuilder_ != null) {
                this.modifiedBuilder_.dispose();
                this.modifiedBuilder_ = null;
            }
            this.actualModified_ = null;
            if (this.actualModifiedBuilder_ != null) {
                this.actualModifiedBuilder_.dispose();
                this.actualModifiedBuilder_ = null;
            }
            this.lastErrorMsg_ = "";
            this.lastErrorCode_ = 0;
            this.managed_ = false;
            this.wasActive_ = false;
            this.orgDeactivated_ = null;
            if (this.orgDeactivatedBuilder_ != null) {
                this.orgDeactivatedBuilder_.dispose();
                this.orgDeactivatedBuilder_ = null;
            }
            this.envoyInstancePools_ = null;
            if (this.envoyInstancePoolsBuilder_ != null) {
                this.envoyInstancePoolsBuilder_.dispose();
                this.envoyInstancePoolsBuilder_ = null;
            }
            this.trafficRuntimeConfig_ = null;
            if (this.trafficRuntimeConfigBuilder_ != null) {
                this.trafficRuntimeConfigBuilder_.dispose();
                this.trafficRuntimeConfigBuilder_ = null;
            }
            this.desiredConnectionTypes_ = Collections.emptyList();
            this.bitField0_ &= 0xBFFFFFFF;
            this.id_ = 0L;
            this.envoyInstancePoolsString_ = "";
            this.trafficRuntimeConfigString_ = "";
            this.orgResourceId_ = "";
            this.needsIngressEdge_ = false;
            this.networkContextId_ = "";
            this.metadata_ = null;
            if (this.metadataBuilder_ != null) {
                this.metadataBuilder_.dispose();
                this.metadataBuilder_ = null;
            }
            return this;
        }

        public Descriptors.Descriptor getDescriptorForType() {
            return TrafficSites.internal_static_cloud_v1_Site_descriptor;
        }

        public Site getDefaultInstanceForType() {
            return Site.getDefaultInstance();
        }

        public Site build() {
            Site result = this.buildPartial();
            if (!result.isInitialized()) {
                throw Builder.newUninitializedMessageException((Message)result);
            }
            return result;
        }

        public Site buildPartial() {
            Site result = new Site(this);
            this.buildPartialRepeatedFields(result);
            if (this.bitField0_ != 0) {
                this.buildPartial0(result);
            }
            if (this.bitField1_ != 0) {
                this.buildPartial1(result);
            }
            this.onBuilt();
            return result;
        }

        private void buildPartialRepeatedFields(Site result) {
            if ((this.bitField0_ & 0x20000) != 0) {
                this.connectionTypes_ = Collections.unmodifiableList(this.connectionTypes_);
                this.bitField0_ &= 0xFFFDFFFF;
            }
            result.connectionTypes_ = this.connectionTypes_;
            if ((this.bitField0_ & 0x40000000) != 0) {
                this.desiredConnectionTypes_ = Collections.unmodifiableList(this.desiredConnectionTypes_);
                this.bitField0_ &= 0xBFFFFFFF;
            }
            result.desiredConnectionTypes_ = this.desiredConnectionTypes_;
        }

        private void buildPartial0(Site result) {
            int from_bitField0_ = this.bitField0_;
            if ((from_bitField0_ & 1) != 0) {
                result.name_ = this.name_;
            }
            if ((from_bitField0_ & 2) != 0) {
                result.nid_ = this.nid_;
            }
            if ((from_bitField0_ & 4) != 0) {
                result.cloud_ = this.cloud_;
            }
            if ((from_bitField0_ & 8) != 0) {
                result.region_ = this.region_;
            }
            if ((from_bitField0_ & 0x10) != 0) {
                result.networkVersion_ = this.networkVersion_;
            }
            if ((from_bitField0_ & 0x20) != 0) {
                result.sniEnabled_ = this.sniEnabled_;
            }
            if ((from_bitField0_ & 0x40) != 0) {
                result.cidr_ = this.cidr_;
            }
            if ((from_bitField0_ & 0x80) != 0) {
                this.zoneIds_.makeImmutable();
                result.zoneIds_ = this.zoneIds_;
            }
            if ((from_bitField0_ & 0x100) != 0) {
                result.actualState_ = this.actualState_;
            }
            if ((from_bitField0_ & 0x200) != 0) {
                result.desiredState_ = this.desiredState_;
            }
            if ((from_bitField0_ & 0x400) != 0) {
                result.accessPublic_ = this.accessPublic_;
            }
            if ((from_bitField0_ & 0x800) != 0) {
                result.accessPrivate_ = this.accessPrivate_;
            }
            if ((from_bitField0_ & 0x1000) != 0) {
                result.realm_ = this.realm_;
            }
            if ((from_bitField0_ & 0x2000) != 0) {
                result.egressIpsActive_ = this.egressIpsActive_;
            }
            int to_bitField0_ = 0;
            if ((from_bitField0_ & 0x4000) != 0) {
                result.deactivated_ = this.deactivatedBuilder_ == null ? this.deactivated_ : (Timestamp)this.deactivatedBuilder_.build();
                to_bitField0_ |= 1;
            }
            if ((from_bitField0_ & 0x8000) != 0) {
                result.displayName_ = this.displayName_;
            }
            if ((from_bitField0_ & 0x10000) != 0) {
                result.dedicated_ = this.dedicated_;
            }
            if ((from_bitField0_ & 0x40000) != 0) {
                result.networkName_ = this.networkName_;
            }
            if ((from_bitField0_ & 0x80000) != 0) {
                result.environmentId_ = this.environmentId_;
            }
            if ((from_bitField0_ & 0x100000) != 0) {
                result.created_ = this.createdBuilder_ == null ? this.created_ : (Timestamp)this.createdBuilder_.build();
                to_bitField0_ |= 2;
            }
            if ((from_bitField0_ & 0x200000) != 0) {
                result.modified_ = this.modifiedBuilder_ == null ? this.modified_ : (Timestamp)this.modifiedBuilder_.build();
                to_bitField0_ |= 4;
            }
            if ((from_bitField0_ & 0x400000) != 0) {
                result.actualModified_ = this.actualModifiedBuilder_ == null ? this.actualModified_ : (Timestamp)this.actualModifiedBuilder_.build();
                to_bitField0_ |= 8;
            }
            if ((from_bitField0_ & 0x800000) != 0) {
                result.lastErrorMsg_ = this.lastErrorMsg_;
            }
            if ((from_bitField0_ & 0x1000000) != 0) {
                result.lastErrorCode_ = this.lastErrorCode_;
            }
            if ((from_bitField0_ & 0x2000000) != 0) {
                result.managed_ = this.managed_;
            }
            if ((from_bitField0_ & 0x4000000) != 0) {
                result.wasActive_ = this.wasActive_;
            }
            if ((from_bitField0_ & 0x8000000) != 0) {
                result.orgDeactivated_ = this.orgDeactivatedBuilder_ == null ? this.orgDeactivated_ : (Timestamp)this.orgDeactivatedBuilder_.build();
                to_bitField0_ |= 0x10;
            }
            if ((from_bitField0_ & 0x10000000) != 0) {
                result.envoyInstancePools_ = this.envoyInstancePoolsBuilder_ == null ? this.envoyInstancePools_ : (Struct)this.envoyInstancePoolsBuilder_.build();
                to_bitField0_ |= 0x20;
            }
            if ((from_bitField0_ & 0x20000000) != 0) {
                result.trafficRuntimeConfig_ = this.trafficRuntimeConfigBuilder_ == null ? this.trafficRuntimeConfig_ : (Struct)this.trafficRuntimeConfigBuilder_.build();
                to_bitField0_ |= 0x40;
            }
            if ((from_bitField0_ & Integer.MIN_VALUE) != 0) {
                result.id_ = this.id_;
            }
            Site site = result;
            site.bitField0_ = site.bitField0_ | to_bitField0_;
        }

        private void buildPartial1(Site result) {
            int from_bitField1_ = this.bitField1_;
            if ((from_bitField1_ & 1) != 0) {
                result.envoyInstancePoolsString_ = this.envoyInstancePoolsString_;
            }
            if ((from_bitField1_ & 2) != 0) {
                result.trafficRuntimeConfigString_ = this.trafficRuntimeConfigString_;
            }
            if ((from_bitField1_ & 4) != 0) {
                result.orgResourceId_ = this.orgResourceId_;
            }
            if ((from_bitField1_ & 8) != 0) {
                result.needsIngressEdge_ = this.needsIngressEdge_;
            }
            if ((from_bitField1_ & 0x10) != 0) {
                result.networkContextId_ = this.networkContextId_;
            }
            int to_bitField0_ = 0;
            if ((from_bitField1_ & 0x20) != 0) {
                result.metadata_ = this.metadataBuilder_ == null ? this.metadata_ : (ChangeEventMetadata)this.metadataBuilder_.build();
                to_bitField0_ |= 0x80;
            }
            Site site = result;
            site.bitField0_ = site.bitField0_ | to_bitField0_;
        }

        public Builder clone() {
            return (Builder)super.clone();
        }

        public Builder setField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.setField(field, value);
        }

        public Builder clearField(Descriptors.FieldDescriptor field) {
            return (Builder)super.clearField(field);
        }

        public Builder clearOneof(Descriptors.OneofDescriptor oneof) {
            return (Builder)super.clearOneof(oneof);
        }

        public Builder setRepeatedField(Descriptors.FieldDescriptor field, int index, Object value) {
            return (Builder)super.setRepeatedField(field, index, value);
        }

        public Builder addRepeatedField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.addRepeatedField(field, value);
        }

        public Builder mergeFrom(Message other) {
            if (other instanceof Site) {
                return this.mergeFrom((Site)other);
            }
            super.mergeFrom(other);
            return this;
        }

        public Builder mergeFrom(Site other) {
            if (other == Site.getDefaultInstance()) {
                return this;
            }
            if (!other.getName().isEmpty()) {
                this.name_ = other.name_;
                this.bitField0_ |= 1;
                this.onChanged();
            }
            if (!other.getNid().isEmpty()) {
                this.nid_ = other.nid_;
                this.bitField0_ |= 2;
                this.onChanged();
            }
            if (other.cloud_ != 0) {
                this.setCloudValue(other.getCloudValue());
            }
            if (!other.getRegion().isEmpty()) {
                this.region_ = other.region_;
                this.bitField0_ |= 8;
                this.onChanged();
            }
            if (!other.getNetworkVersion().isEmpty()) {
                this.networkVersion_ = other.networkVersion_;
                this.bitField0_ |= 0x10;
                this.onChanged();
            }
            if (other.getSniEnabled()) {
                this.setSniEnabled(other.getSniEnabled());
            }
            if (!other.getCidr().isEmpty()) {
                this.cidr_ = other.cidr_;
                this.bitField0_ |= 0x40;
                this.onChanged();
            }
            if (!other.zoneIds_.isEmpty()) {
                if (this.zoneIds_.isEmpty()) {
                    this.zoneIds_ = other.zoneIds_;
                    this.bitField0_ |= 0x80;
                } else {
                    this.ensureZoneIdsIsMutable();
                    this.zoneIds_.addAll((Collection)other.zoneIds_);
                }
                this.onChanged();
            }
            if (other.actualState_ != 0) {
                this.setActualStateValue(other.getActualStateValue());
            }
            if (other.desiredState_ != 0) {
                this.setDesiredStateValue(other.getDesiredStateValue());
            }
            if (other.getAccessPublic()) {
                this.setAccessPublic(other.getAccessPublic());
            }
            if (other.getAccessPrivate()) {
                this.setAccessPrivate(other.getAccessPrivate());
            }
            if (!other.getRealm().isEmpty()) {
                this.realm_ = other.realm_;
                this.bitField0_ |= 0x1000;
                this.onChanged();
            }
            if (other.getEgressIpsActive()) {
                this.setEgressIpsActive(other.getEgressIpsActive());
            }
            if (other.hasDeactivated()) {
                this.mergeDeactivated(other.getDeactivated());
            }
            if (!other.getDisplayName().isEmpty()) {
                this.displayName_ = other.displayName_;
                this.bitField0_ |= 0x8000;
                this.onChanged();
            }
            if (other.getDedicated()) {
                this.setDedicated(other.getDedicated());
            }
            if (!other.connectionTypes_.isEmpty()) {
                if (this.connectionTypes_.isEmpty()) {
                    this.connectionTypes_ = other.connectionTypes_;
                    this.bitField0_ &= 0xFFFDFFFF;
                } else {
                    this.ensureConnectionTypesIsMutable();
                    this.connectionTypes_.addAll(other.connectionTypes_);
                }
                this.onChanged();
            }
            if (!other.getNetworkName().isEmpty()) {
                this.networkName_ = other.networkName_;
                this.bitField0_ |= 0x40000;
                this.onChanged();
            }
            if (!other.getEnvironmentId().isEmpty()) {
                this.environmentId_ = other.environmentId_;
                this.bitField0_ |= 0x80000;
                this.onChanged();
            }
            if (other.hasCreated()) {
                this.mergeCreated(other.getCreated());
            }
            if (other.hasModified()) {
                this.mergeModified(other.getModified());
            }
            if (other.hasActualModified()) {
                this.mergeActualModified(other.getActualModified());
            }
            if (!other.getLastErrorMsg().isEmpty()) {
                this.lastErrorMsg_ = other.lastErrorMsg_;
                this.bitField0_ |= 0x800000;
                this.onChanged();
            }
            if (other.getLastErrorCode() != 0) {
                this.setLastErrorCode(other.getLastErrorCode());
            }
            if (other.getManaged()) {
                this.setManaged(other.getManaged());
            }
            if (other.getWasActive()) {
                this.setWasActive(other.getWasActive());
            }
            if (other.hasOrgDeactivated()) {
                this.mergeOrgDeactivated(other.getOrgDeactivated());
            }
            if (other.hasEnvoyInstancePools()) {
                this.mergeEnvoyInstancePools(other.getEnvoyInstancePools());
            }
            if (other.hasTrafficRuntimeConfig()) {
                this.mergeTrafficRuntimeConfig(other.getTrafficRuntimeConfig());
            }
            if (!other.desiredConnectionTypes_.isEmpty()) {
                if (this.desiredConnectionTypes_.isEmpty()) {
                    this.desiredConnectionTypes_ = other.desiredConnectionTypes_;
                    this.bitField0_ &= 0xBFFFFFFF;
                } else {
                    this.ensureDesiredConnectionTypesIsMutable();
                    this.desiredConnectionTypes_.addAll(other.desiredConnectionTypes_);
                }
                this.onChanged();
            }
            if (other.getId() != 0L) {
                this.setId(other.getId());
            }
            if (!other.getEnvoyInstancePoolsString().isEmpty()) {
                this.envoyInstancePoolsString_ = other.envoyInstancePoolsString_;
                this.bitField1_ |= 1;
                this.onChanged();
            }
            if (!other.getTrafficRuntimeConfigString().isEmpty()) {
                this.trafficRuntimeConfigString_ = other.trafficRuntimeConfigString_;
                this.bitField1_ |= 2;
                this.onChanged();
            }
            if (!other.getOrgResourceId().isEmpty()) {
                this.orgResourceId_ = other.orgResourceId_;
                this.bitField1_ |= 4;
                this.onChanged();
            }
            if (other.getNeedsIngressEdge()) {
                this.setNeedsIngressEdge(other.getNeedsIngressEdge());
            }
            if (!other.getNetworkContextId().isEmpty()) {
                this.networkContextId_ = other.networkContextId_;
                this.bitField1_ |= 0x10;
                this.onChanged();
            }
            if (other.hasMetadata()) {
                this.mergeMetadata(other.getMetadata());
            }
            this.mergeUnknownFields(other.getUnknownFields());
            this.onChanged();
            return this;
        }

        public final boolean isInitialized() {
            return true;
        }

        public Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            if (extensionRegistry == null) {
                throw new NullPointerException();
            }
            try {
                boolean done = false;
                block48: while (!done) {
                    int tag = input.readTag();
                    switch (tag) {
                        case 0: {
                            done = true;
                            continue block48;
                        }
                        case 10: {
                            this.name_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 1;
                            continue block48;
                        }
                        case 18: {
                            this.nid_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 2;
                            continue block48;
                        }
                        case 24: {
                            this.cloud_ = input.readEnum();
                            this.bitField0_ |= 4;
                            continue block48;
                        }
                        case 34: {
                            this.region_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 8;
                            continue block48;
                        }
                        case 42: {
                            this.networkVersion_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 0x10;
                            continue block48;
                        }
                        case 48: {
                            this.sniEnabled_ = input.readBool();
                            this.bitField0_ |= 0x20;
                            continue block48;
                        }
                        case 58: {
                            this.cidr_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 0x40;
                            continue block48;
                        }
                        case 66: {
                            String s = input.readStringRequireUtf8();
                            this.ensureZoneIdsIsMutable();
                            this.zoneIds_.add((Object)s);
                            continue block48;
                        }
                        case 72: {
                            this.actualState_ = input.readEnum();
                            this.bitField0_ |= 0x100;
                            continue block48;
                        }
                        case 80: {
                            this.desiredState_ = input.readEnum();
                            this.bitField0_ |= 0x200;
                            continue block48;
                        }
                        case 88: {
                            this.accessPublic_ = input.readBool();
                            this.bitField0_ |= 0x400;
                            continue block48;
                        }
                        case 96: {
                            this.accessPrivate_ = input.readBool();
                            this.bitField0_ |= 0x800;
                            continue block48;
                        }
                        case 106: {
                            this.realm_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 0x1000;
                            continue block48;
                        }
                        case 112: {
                            this.egressIpsActive_ = input.readBool();
                            this.bitField0_ |= 0x2000;
                            continue block48;
                        }
                        case 122: {
                            input.readMessage((MessageLite.Builder)this.getDeactivatedFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 0x4000;
                            continue block48;
                        }
                        case 130: {
                            this.displayName_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 0x8000;
                            continue block48;
                        }
                        case 136: {
                            this.dedicated_ = input.readBool();
                            this.bitField0_ |= 0x10000;
                            continue block48;
                        }
                        case 144: {
                            int tmpRaw = input.readEnum();
                            this.ensureConnectionTypesIsMutable();
                            this.connectionTypes_.add(tmpRaw);
                            continue block48;
                        }
                        case 146: {
                            int tmpRaw;
                            int length = input.readRawVarint32();
                            int oldLimit = input.pushLimit(length);
                            while (input.getBytesUntilLimit() > 0) {
                                tmpRaw = input.readEnum();
                                this.ensureConnectionTypesIsMutable();
                                this.connectionTypes_.add(tmpRaw);
                            }
                            input.popLimit(oldLimit);
                            continue block48;
                        }
                        case 154: {
                            this.networkName_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 0x40000;
                            continue block48;
                        }
                        case 162: {
                            this.environmentId_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 0x80000;
                            continue block48;
                        }
                        case 170: {
                            input.readMessage((MessageLite.Builder)this.getCreatedFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 0x100000;
                            continue block48;
                        }
                        case 178: {
                            input.readMessage((MessageLite.Builder)this.getModifiedFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 0x200000;
                            continue block48;
                        }
                        case 186: {
                            input.readMessage((MessageLite.Builder)this.getActualModifiedFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 0x400000;
                            continue block48;
                        }
                        case 194: {
                            this.lastErrorMsg_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 0x800000;
                            continue block48;
                        }
                        case 200: {
                            this.lastErrorCode_ = input.readInt32();
                            this.bitField0_ |= 0x1000000;
                            continue block48;
                        }
                        case 208: {
                            this.managed_ = input.readBool();
                            this.bitField0_ |= 0x2000000;
                            continue block48;
                        }
                        case 216: {
                            this.wasActive_ = input.readBool();
                            this.bitField0_ |= 0x4000000;
                            continue block48;
                        }
                        case 226: {
                            input.readMessage((MessageLite.Builder)this.getOrgDeactivatedFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 0x8000000;
                            continue block48;
                        }
                        case 234: {
                            input.readMessage((MessageLite.Builder)this.getEnvoyInstancePoolsFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 0x10000000;
                            continue block48;
                        }
                        case 242: {
                            input.readMessage((MessageLite.Builder)this.getTrafficRuntimeConfigFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 0x20000000;
                            continue block48;
                        }
                        case 248: {
                            int tmpRaw = input.readEnum();
                            this.ensureDesiredConnectionTypesIsMutable();
                            this.desiredConnectionTypes_.add(tmpRaw);
                            continue block48;
                        }
                        case 250: {
                            int tmpRaw;
                            int length = input.readRawVarint32();
                            int oldLimit = input.pushLimit(length);
                            while (input.getBytesUntilLimit() > 0) {
                                tmpRaw = input.readEnum();
                                this.ensureDesiredConnectionTypesIsMutable();
                                this.desiredConnectionTypes_.add(tmpRaw);
                            }
                            input.popLimit(oldLimit);
                            continue block48;
                        }
                        case 256: {
                            this.id_ = input.readInt64();
                            this.bitField0_ |= Integer.MIN_VALUE;
                            continue block48;
                        }
                        case 266: {
                            this.envoyInstancePoolsString_ = input.readStringRequireUtf8();
                            this.bitField1_ |= 1;
                            continue block48;
                        }
                        case 274: {
                            this.trafficRuntimeConfigString_ = input.readStringRequireUtf8();
                            this.bitField1_ |= 2;
                            continue block48;
                        }
                        case 282: {
                            this.orgResourceId_ = input.readStringRequireUtf8();
                            this.bitField1_ |= 4;
                            continue block48;
                        }
                        case 288: {
                            this.needsIngressEdge_ = input.readBool();
                            this.bitField1_ |= 8;
                            continue block48;
                        }
                        case 298: {
                            this.networkContextId_ = input.readStringRequireUtf8();
                            this.bitField1_ |= 0x10;
                            continue block48;
                        }
                        case 330: {
                            input.readMessage((MessageLite.Builder)this.getMetadataFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField1_ |= 0x20;
                            continue block48;
                        }
                    }
                    if (super.parseUnknownField(input, extensionRegistry, tag)) continue;
                    done = true;
                }
            }
            catch (InvalidProtocolBufferException e) {
                throw e.unwrapIOException();
            }
            finally {
                this.onChanged();
            }
            return this;
        }

        @Override
        public String getName() {
            Object ref = this.name_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.name_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getNameBytes() {
            Object ref = this.name_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.name_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setName(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.name_ = value;
            this.bitField0_ |= 1;
            this.onChanged();
            return this;
        }

        public Builder clearName() {
            this.name_ = Site.getDefaultInstance().getName();
            this.bitField0_ &= 0xFFFFFFFE;
            this.onChanged();
            return this;
        }

        public Builder setNameBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            Site.checkByteStringIsUtf8((ByteString)value);
            this.name_ = value;
            this.bitField0_ |= 1;
            this.onChanged();
            return this;
        }

        @Override
        public String getNid() {
            Object ref = this.nid_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.nid_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getNidBytes() {
            Object ref = this.nid_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.nid_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setNid(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.nid_ = value;
            this.bitField0_ |= 2;
            this.onChanged();
            return this;
        }

        public Builder clearNid() {
            this.nid_ = Site.getDefaultInstance().getNid();
            this.bitField0_ &= 0xFFFFFFFD;
            this.onChanged();
            return this;
        }

        public Builder setNidBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            Site.checkByteStringIsUtf8((ByteString)value);
            this.nid_ = value;
            this.bitField0_ |= 2;
            this.onChanged();
            return this;
        }

        @Override
        public int getCloudValue() {
            return this.cloud_;
        }

        public Builder setCloudValue(int value) {
            this.cloud_ = value;
            this.bitField0_ |= 4;
            this.onChanged();
            return this;
        }

        @Override
        public Provider.Cloud getCloud() {
            Provider.Cloud result = Provider.Cloud.forNumber(this.cloud_);
            return result == null ? Provider.Cloud.UNRECOGNIZED : result;
        }

        public Builder setCloud(Provider.Cloud value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.bitField0_ |= 4;
            this.cloud_ = value.getNumber();
            this.onChanged();
            return this;
        }

        public Builder clearCloud() {
            this.bitField0_ &= 0xFFFFFFFB;
            this.cloud_ = 0;
            this.onChanged();
            return this;
        }

        @Override
        public String getRegion() {
            Object ref = this.region_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.region_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getRegionBytes() {
            Object ref = this.region_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.region_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setRegion(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.region_ = value;
            this.bitField0_ |= 8;
            this.onChanged();
            return this;
        }

        public Builder clearRegion() {
            this.region_ = Site.getDefaultInstance().getRegion();
            this.bitField0_ &= 0xFFFFFFF7;
            this.onChanged();
            return this;
        }

        public Builder setRegionBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            Site.checkByteStringIsUtf8((ByteString)value);
            this.region_ = value;
            this.bitField0_ |= 8;
            this.onChanged();
            return this;
        }

        @Override
        public String getNetworkVersion() {
            Object ref = this.networkVersion_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.networkVersion_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getNetworkVersionBytes() {
            Object ref = this.networkVersion_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.networkVersion_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setNetworkVersion(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.networkVersion_ = value;
            this.bitField0_ |= 0x10;
            this.onChanged();
            return this;
        }

        public Builder clearNetworkVersion() {
            this.networkVersion_ = Site.getDefaultInstance().getNetworkVersion();
            this.bitField0_ &= 0xFFFFFFEF;
            this.onChanged();
            return this;
        }

        public Builder setNetworkVersionBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            Site.checkByteStringIsUtf8((ByteString)value);
            this.networkVersion_ = value;
            this.bitField0_ |= 0x10;
            this.onChanged();
            return this;
        }

        @Override
        public boolean getSniEnabled() {
            return this.sniEnabled_;
        }

        public Builder setSniEnabled(boolean value) {
            this.sniEnabled_ = value;
            this.bitField0_ |= 0x20;
            this.onChanged();
            return this;
        }

        public Builder clearSniEnabled() {
            this.bitField0_ &= 0xFFFFFFDF;
            this.sniEnabled_ = false;
            this.onChanged();
            return this;
        }

        @Override
        public String getCidr() {
            Object ref = this.cidr_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.cidr_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getCidrBytes() {
            Object ref = this.cidr_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.cidr_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setCidr(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.cidr_ = value;
            this.bitField0_ |= 0x40;
            this.onChanged();
            return this;
        }

        public Builder clearCidr() {
            this.cidr_ = Site.getDefaultInstance().getCidr();
            this.bitField0_ &= 0xFFFFFFBF;
            this.onChanged();
            return this;
        }

        public Builder setCidrBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            Site.checkByteStringIsUtf8((ByteString)value);
            this.cidr_ = value;
            this.bitField0_ |= 0x40;
            this.onChanged();
            return this;
        }

        private void ensureZoneIdsIsMutable() {
            if (!this.zoneIds_.isModifiable()) {
                this.zoneIds_ = new LazyStringArrayList((LazyStringList)this.zoneIds_);
            }
            this.bitField0_ |= 0x80;
        }

        public ProtocolStringList getZoneIdsList() {
            this.zoneIds_.makeImmutable();
            return this.zoneIds_;
        }

        @Override
        public int getZoneIdsCount() {
            return this.zoneIds_.size();
        }

        @Override
        public String getZoneIds(int index) {
            return this.zoneIds_.get(index);
        }

        @Override
        public ByteString getZoneIdsBytes(int index) {
            return this.zoneIds_.getByteString(index);
        }

        public Builder setZoneIds(int index, String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensureZoneIdsIsMutable();
            this.zoneIds_.set(index, value);
            this.bitField0_ |= 0x80;
            this.onChanged();
            return this;
        }

        public Builder addZoneIds(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensureZoneIdsIsMutable();
            this.zoneIds_.add((Object)value);
            this.bitField0_ |= 0x80;
            this.onChanged();
            return this;
        }

        public Builder addAllZoneIds(Iterable<String> values) {
            this.ensureZoneIdsIsMutable();
            AbstractMessageLite.Builder.addAll(values, (List)this.zoneIds_);
            this.bitField0_ |= 0x80;
            this.onChanged();
            return this;
        }

        public Builder clearZoneIds() {
            this.zoneIds_ = LazyStringArrayList.emptyList();
            this.bitField0_ &= 0xFFFFFF7F;
            this.onChanged();
            return this;
        }

        public Builder addZoneIdsBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            Site.checkByteStringIsUtf8((ByteString)value);
            this.ensureZoneIdsIsMutable();
            this.zoneIds_.add(value);
            this.bitField0_ |= 0x80;
            this.onChanged();
            return this;
        }

        @Override
        public int getActualStateValue() {
            return this.actualState_;
        }

        public Builder setActualStateValue(int value) {
            this.actualState_ = value;
            this.bitField0_ |= 0x100;
            this.onChanged();
            return this;
        }

        @Override
        public State getActualState() {
            State result = State.forNumber(this.actualState_);
            return result == null ? State.UNRECOGNIZED : result;
        }

        public Builder setActualState(State value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.bitField0_ |= 0x100;
            this.actualState_ = value.getNumber();
            this.onChanged();
            return this;
        }

        public Builder clearActualState() {
            this.bitField0_ &= 0xFFFFFEFF;
            this.actualState_ = 0;
            this.onChanged();
            return this;
        }

        @Override
        public int getDesiredStateValue() {
            return this.desiredState_;
        }

        public Builder setDesiredStateValue(int value) {
            this.desiredState_ = value;
            this.bitField0_ |= 0x200;
            this.onChanged();
            return this;
        }

        @Override
        public State getDesiredState() {
            State result = State.forNumber(this.desiredState_);
            return result == null ? State.UNRECOGNIZED : result;
        }

        public Builder setDesiredState(State value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.bitField0_ |= 0x200;
            this.desiredState_ = value.getNumber();
            this.onChanged();
            return this;
        }

        public Builder clearDesiredState() {
            this.bitField0_ &= 0xFFFFFDFF;
            this.desiredState_ = 0;
            this.onChanged();
            return this;
        }

        @Override
        public boolean getAccessPublic() {
            return this.accessPublic_;
        }

        public Builder setAccessPublic(boolean value) {
            this.accessPublic_ = value;
            this.bitField0_ |= 0x400;
            this.onChanged();
            return this;
        }

        public Builder clearAccessPublic() {
            this.bitField0_ &= 0xFFFFFBFF;
            this.accessPublic_ = false;
            this.onChanged();
            return this;
        }

        @Override
        public boolean getAccessPrivate() {
            return this.accessPrivate_;
        }

        public Builder setAccessPrivate(boolean value) {
            this.accessPrivate_ = value;
            this.bitField0_ |= 0x800;
            this.onChanged();
            return this;
        }

        public Builder clearAccessPrivate() {
            this.bitField0_ &= 0xFFFFF7FF;
            this.accessPrivate_ = false;
            this.onChanged();
            return this;
        }

        @Override
        public String getRealm() {
            Object ref = this.realm_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.realm_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getRealmBytes() {
            Object ref = this.realm_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.realm_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setRealm(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.realm_ = value;
            this.bitField0_ |= 0x1000;
            this.onChanged();
            return this;
        }

        public Builder clearRealm() {
            this.realm_ = Site.getDefaultInstance().getRealm();
            this.bitField0_ &= 0xFFFFEFFF;
            this.onChanged();
            return this;
        }

        public Builder setRealmBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            Site.checkByteStringIsUtf8((ByteString)value);
            this.realm_ = value;
            this.bitField0_ |= 0x1000;
            this.onChanged();
            return this;
        }

        @Override
        public boolean getEgressIpsActive() {
            return this.egressIpsActive_;
        }

        public Builder setEgressIpsActive(boolean value) {
            this.egressIpsActive_ = value;
            this.bitField0_ |= 0x2000;
            this.onChanged();
            return this;
        }

        public Builder clearEgressIpsActive() {
            this.bitField0_ &= 0xFFFFDFFF;
            this.egressIpsActive_ = false;
            this.onChanged();
            return this;
        }

        @Override
        public boolean hasDeactivated() {
            return (this.bitField0_ & 0x4000) != 0;
        }

        @Override
        public Timestamp getDeactivated() {
            if (this.deactivatedBuilder_ == null) {
                return this.deactivated_ == null ? Timestamp.getDefaultInstance() : this.deactivated_;
            }
            return (Timestamp)this.deactivatedBuilder_.getMessage();
        }

        public Builder setDeactivated(Timestamp value) {
            if (this.deactivatedBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.deactivated_ = value;
            } else {
                this.deactivatedBuilder_.setMessage((AbstractMessage)value);
            }
            this.bitField0_ |= 0x4000;
            this.onChanged();
            return this;
        }

        public Builder setDeactivated(Timestamp.Builder builderForValue) {
            if (this.deactivatedBuilder_ == null) {
                this.deactivated_ = builderForValue.build();
            } else {
                this.deactivatedBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.bitField0_ |= 0x4000;
            this.onChanged();
            return this;
        }

        public Builder mergeDeactivated(Timestamp value) {
            if (this.deactivatedBuilder_ == null) {
                if ((this.bitField0_ & 0x4000) != 0 && this.deactivated_ != null && this.deactivated_ != Timestamp.getDefaultInstance()) {
                    this.getDeactivatedBuilder().mergeFrom(value);
                } else {
                    this.deactivated_ = value;
                }
            } else {
                this.deactivatedBuilder_.mergeFrom((AbstractMessage)value);
            }
            if (this.deactivated_ != null) {
                this.bitField0_ |= 0x4000;
                this.onChanged();
            }
            return this;
        }

        public Builder clearDeactivated() {
            this.bitField0_ &= 0xFFFFBFFF;
            this.deactivated_ = null;
            if (this.deactivatedBuilder_ != null) {
                this.deactivatedBuilder_.dispose();
                this.deactivatedBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public Timestamp.Builder getDeactivatedBuilder() {
            this.bitField0_ |= 0x4000;
            this.onChanged();
            return (Timestamp.Builder)this.getDeactivatedFieldBuilder().getBuilder();
        }

        @Override
        public TimestampOrBuilder getDeactivatedOrBuilder() {
            if (this.deactivatedBuilder_ != null) {
                return (TimestampOrBuilder)this.deactivatedBuilder_.getMessageOrBuilder();
            }
            return this.deactivated_ == null ? Timestamp.getDefaultInstance() : this.deactivated_;
        }

        private SingleFieldBuilderV3<Timestamp, Timestamp.Builder, TimestampOrBuilder> getDeactivatedFieldBuilder() {
            if (this.deactivatedBuilder_ == null) {
                this.deactivatedBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getDeactivated(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.deactivated_ = null;
            }
            return this.deactivatedBuilder_;
        }

        @Override
        public String getDisplayName() {
            Object ref = this.displayName_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.displayName_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getDisplayNameBytes() {
            Object ref = this.displayName_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.displayName_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setDisplayName(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.displayName_ = value;
            this.bitField0_ |= 0x8000;
            this.onChanged();
            return this;
        }

        public Builder clearDisplayName() {
            this.displayName_ = Site.getDefaultInstance().getDisplayName();
            this.bitField0_ &= 0xFFFF7FFF;
            this.onChanged();
            return this;
        }

        public Builder setDisplayNameBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            Site.checkByteStringIsUtf8((ByteString)value);
            this.displayName_ = value;
            this.bitField0_ |= 0x8000;
            this.onChanged();
            return this;
        }

        @Override
        public boolean getDedicated() {
            return this.dedicated_;
        }

        public Builder setDedicated(boolean value) {
            this.dedicated_ = value;
            this.bitField0_ |= 0x10000;
            this.onChanged();
            return this;
        }

        public Builder clearDedicated() {
            this.bitField0_ &= 0xFFFEFFFF;
            this.dedicated_ = false;
            this.onChanged();
            return this;
        }

        private void ensureConnectionTypesIsMutable() {
            if ((this.bitField0_ & 0x20000) == 0) {
                this.connectionTypes_ = new ArrayList<Integer>(this.connectionTypes_);
                this.bitField0_ |= 0x20000;
            }
        }

        @Override
        public List<NetworkConnectionType> getConnectionTypesList() {
            return new Internal.ListAdapter(this.connectionTypes_, connectionTypes_converter_);
        }

        @Override
        public int getConnectionTypesCount() {
            return this.connectionTypes_.size();
        }

        @Override
        public NetworkConnectionType getConnectionTypes(int index) {
            return (NetworkConnectionType)((Object)connectionTypes_converter_.convert((Object)this.connectionTypes_.get(index)));
        }

        public Builder setConnectionTypes(int index, NetworkConnectionType value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensureConnectionTypesIsMutable();
            this.connectionTypes_.set(index, value.getNumber());
            this.onChanged();
            return this;
        }

        public Builder addConnectionTypes(NetworkConnectionType value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensureConnectionTypesIsMutable();
            this.connectionTypes_.add(value.getNumber());
            this.onChanged();
            return this;
        }

        public Builder addAllConnectionTypes(Iterable<? extends NetworkConnectionType> values) {
            this.ensureConnectionTypesIsMutable();
            for (NetworkConnectionType networkConnectionType : values) {
                this.connectionTypes_.add(networkConnectionType.getNumber());
            }
            this.onChanged();
            return this;
        }

        public Builder clearConnectionTypes() {
            this.connectionTypes_ = Collections.emptyList();
            this.bitField0_ &= 0xFFFDFFFF;
            this.onChanged();
            return this;
        }

        @Override
        public List<Integer> getConnectionTypesValueList() {
            return Collections.unmodifiableList(this.connectionTypes_);
        }

        @Override
        public int getConnectionTypesValue(int index) {
            return this.connectionTypes_.get(index);
        }

        public Builder setConnectionTypesValue(int index, int value) {
            this.ensureConnectionTypesIsMutable();
            this.connectionTypes_.set(index, value);
            this.onChanged();
            return this;
        }

        public Builder addConnectionTypesValue(int value) {
            this.ensureConnectionTypesIsMutable();
            this.connectionTypes_.add(value);
            this.onChanged();
            return this;
        }

        public Builder addAllConnectionTypesValue(Iterable<Integer> values) {
            this.ensureConnectionTypesIsMutable();
            for (int value : values) {
                this.connectionTypes_.add(value);
            }
            this.onChanged();
            return this;
        }

        @Override
        public String getNetworkName() {
            Object ref = this.networkName_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.networkName_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getNetworkNameBytes() {
            Object ref = this.networkName_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.networkName_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setNetworkName(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.networkName_ = value;
            this.bitField0_ |= 0x40000;
            this.onChanged();
            return this;
        }

        public Builder clearNetworkName() {
            this.networkName_ = Site.getDefaultInstance().getNetworkName();
            this.bitField0_ &= 0xFFFBFFFF;
            this.onChanged();
            return this;
        }

        public Builder setNetworkNameBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            Site.checkByteStringIsUtf8((ByteString)value);
            this.networkName_ = value;
            this.bitField0_ |= 0x40000;
            this.onChanged();
            return this;
        }

        @Override
        public String getEnvironmentId() {
            Object ref = this.environmentId_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.environmentId_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getEnvironmentIdBytes() {
            Object ref = this.environmentId_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.environmentId_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setEnvironmentId(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.environmentId_ = value;
            this.bitField0_ |= 0x80000;
            this.onChanged();
            return this;
        }

        public Builder clearEnvironmentId() {
            this.environmentId_ = Site.getDefaultInstance().getEnvironmentId();
            this.bitField0_ &= 0xFFF7FFFF;
            this.onChanged();
            return this;
        }

        public Builder setEnvironmentIdBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            Site.checkByteStringIsUtf8((ByteString)value);
            this.environmentId_ = value;
            this.bitField0_ |= 0x80000;
            this.onChanged();
            return this;
        }

        @Override
        public boolean hasCreated() {
            return (this.bitField0_ & 0x100000) != 0;
        }

        @Override
        public Timestamp getCreated() {
            if (this.createdBuilder_ == null) {
                return this.created_ == null ? Timestamp.getDefaultInstance() : this.created_;
            }
            return (Timestamp)this.createdBuilder_.getMessage();
        }

        public Builder setCreated(Timestamp value) {
            if (this.createdBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.created_ = value;
            } else {
                this.createdBuilder_.setMessage((AbstractMessage)value);
            }
            this.bitField0_ |= 0x100000;
            this.onChanged();
            return this;
        }

        public Builder setCreated(Timestamp.Builder builderForValue) {
            if (this.createdBuilder_ == null) {
                this.created_ = builderForValue.build();
            } else {
                this.createdBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.bitField0_ |= 0x100000;
            this.onChanged();
            return this;
        }

        public Builder mergeCreated(Timestamp value) {
            if (this.createdBuilder_ == null) {
                if ((this.bitField0_ & 0x100000) != 0 && this.created_ != null && this.created_ != Timestamp.getDefaultInstance()) {
                    this.getCreatedBuilder().mergeFrom(value);
                } else {
                    this.created_ = value;
                }
            } else {
                this.createdBuilder_.mergeFrom((AbstractMessage)value);
            }
            if (this.created_ != null) {
                this.bitField0_ |= 0x100000;
                this.onChanged();
            }
            return this;
        }

        public Builder clearCreated() {
            this.bitField0_ &= 0xFFEFFFFF;
            this.created_ = null;
            if (this.createdBuilder_ != null) {
                this.createdBuilder_.dispose();
                this.createdBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public Timestamp.Builder getCreatedBuilder() {
            this.bitField0_ |= 0x100000;
            this.onChanged();
            return (Timestamp.Builder)this.getCreatedFieldBuilder().getBuilder();
        }

        @Override
        public TimestampOrBuilder getCreatedOrBuilder() {
            if (this.createdBuilder_ != null) {
                return (TimestampOrBuilder)this.createdBuilder_.getMessageOrBuilder();
            }
            return this.created_ == null ? Timestamp.getDefaultInstance() : this.created_;
        }

        private SingleFieldBuilderV3<Timestamp, Timestamp.Builder, TimestampOrBuilder> getCreatedFieldBuilder() {
            if (this.createdBuilder_ == null) {
                this.createdBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getCreated(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.created_ = null;
            }
            return this.createdBuilder_;
        }

        @Override
        public boolean hasModified() {
            return (this.bitField0_ & 0x200000) != 0;
        }

        @Override
        public Timestamp getModified() {
            if (this.modifiedBuilder_ == null) {
                return this.modified_ == null ? Timestamp.getDefaultInstance() : this.modified_;
            }
            return (Timestamp)this.modifiedBuilder_.getMessage();
        }

        public Builder setModified(Timestamp value) {
            if (this.modifiedBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.modified_ = value;
            } else {
                this.modifiedBuilder_.setMessage((AbstractMessage)value);
            }
            this.bitField0_ |= 0x200000;
            this.onChanged();
            return this;
        }

        public Builder setModified(Timestamp.Builder builderForValue) {
            if (this.modifiedBuilder_ == null) {
                this.modified_ = builderForValue.build();
            } else {
                this.modifiedBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.bitField0_ |= 0x200000;
            this.onChanged();
            return this;
        }

        public Builder mergeModified(Timestamp value) {
            if (this.modifiedBuilder_ == null) {
                if ((this.bitField0_ & 0x200000) != 0 && this.modified_ != null && this.modified_ != Timestamp.getDefaultInstance()) {
                    this.getModifiedBuilder().mergeFrom(value);
                } else {
                    this.modified_ = value;
                }
            } else {
                this.modifiedBuilder_.mergeFrom((AbstractMessage)value);
            }
            if (this.modified_ != null) {
                this.bitField0_ |= 0x200000;
                this.onChanged();
            }
            return this;
        }

        public Builder clearModified() {
            this.bitField0_ &= 0xFFDFFFFF;
            this.modified_ = null;
            if (this.modifiedBuilder_ != null) {
                this.modifiedBuilder_.dispose();
                this.modifiedBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public Timestamp.Builder getModifiedBuilder() {
            this.bitField0_ |= 0x200000;
            this.onChanged();
            return (Timestamp.Builder)this.getModifiedFieldBuilder().getBuilder();
        }

        @Override
        public TimestampOrBuilder getModifiedOrBuilder() {
            if (this.modifiedBuilder_ != null) {
                return (TimestampOrBuilder)this.modifiedBuilder_.getMessageOrBuilder();
            }
            return this.modified_ == null ? Timestamp.getDefaultInstance() : this.modified_;
        }

        private SingleFieldBuilderV3<Timestamp, Timestamp.Builder, TimestampOrBuilder> getModifiedFieldBuilder() {
            if (this.modifiedBuilder_ == null) {
                this.modifiedBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getModified(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.modified_ = null;
            }
            return this.modifiedBuilder_;
        }

        @Override
        public boolean hasActualModified() {
            return (this.bitField0_ & 0x400000) != 0;
        }

        @Override
        public Timestamp getActualModified() {
            if (this.actualModifiedBuilder_ == null) {
                return this.actualModified_ == null ? Timestamp.getDefaultInstance() : this.actualModified_;
            }
            return (Timestamp)this.actualModifiedBuilder_.getMessage();
        }

        public Builder setActualModified(Timestamp value) {
            if (this.actualModifiedBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.actualModified_ = value;
            } else {
                this.actualModifiedBuilder_.setMessage((AbstractMessage)value);
            }
            this.bitField0_ |= 0x400000;
            this.onChanged();
            return this;
        }

        public Builder setActualModified(Timestamp.Builder builderForValue) {
            if (this.actualModifiedBuilder_ == null) {
                this.actualModified_ = builderForValue.build();
            } else {
                this.actualModifiedBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.bitField0_ |= 0x400000;
            this.onChanged();
            return this;
        }

        public Builder mergeActualModified(Timestamp value) {
            if (this.actualModifiedBuilder_ == null) {
                if ((this.bitField0_ & 0x400000) != 0 && this.actualModified_ != null && this.actualModified_ != Timestamp.getDefaultInstance()) {
                    this.getActualModifiedBuilder().mergeFrom(value);
                } else {
                    this.actualModified_ = value;
                }
            } else {
                this.actualModifiedBuilder_.mergeFrom((AbstractMessage)value);
            }
            if (this.actualModified_ != null) {
                this.bitField0_ |= 0x400000;
                this.onChanged();
            }
            return this;
        }

        public Builder clearActualModified() {
            this.bitField0_ &= 0xFFBFFFFF;
            this.actualModified_ = null;
            if (this.actualModifiedBuilder_ != null) {
                this.actualModifiedBuilder_.dispose();
                this.actualModifiedBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public Timestamp.Builder getActualModifiedBuilder() {
            this.bitField0_ |= 0x400000;
            this.onChanged();
            return (Timestamp.Builder)this.getActualModifiedFieldBuilder().getBuilder();
        }

        @Override
        public TimestampOrBuilder getActualModifiedOrBuilder() {
            if (this.actualModifiedBuilder_ != null) {
                return (TimestampOrBuilder)this.actualModifiedBuilder_.getMessageOrBuilder();
            }
            return this.actualModified_ == null ? Timestamp.getDefaultInstance() : this.actualModified_;
        }

        private SingleFieldBuilderV3<Timestamp, Timestamp.Builder, TimestampOrBuilder> getActualModifiedFieldBuilder() {
            if (this.actualModifiedBuilder_ == null) {
                this.actualModifiedBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getActualModified(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.actualModified_ = null;
            }
            return this.actualModifiedBuilder_;
        }

        @Override
        public String getLastErrorMsg() {
            Object ref = this.lastErrorMsg_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.lastErrorMsg_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getLastErrorMsgBytes() {
            Object ref = this.lastErrorMsg_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.lastErrorMsg_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setLastErrorMsg(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.lastErrorMsg_ = value;
            this.bitField0_ |= 0x800000;
            this.onChanged();
            return this;
        }

        public Builder clearLastErrorMsg() {
            this.lastErrorMsg_ = Site.getDefaultInstance().getLastErrorMsg();
            this.bitField0_ &= 0xFF7FFFFF;
            this.onChanged();
            return this;
        }

        public Builder setLastErrorMsgBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            Site.checkByteStringIsUtf8((ByteString)value);
            this.lastErrorMsg_ = value;
            this.bitField0_ |= 0x800000;
            this.onChanged();
            return this;
        }

        @Override
        public int getLastErrorCode() {
            return this.lastErrorCode_;
        }

        public Builder setLastErrorCode(int value) {
            this.lastErrorCode_ = value;
            this.bitField0_ |= 0x1000000;
            this.onChanged();
            return this;
        }

        public Builder clearLastErrorCode() {
            this.bitField0_ &= 0xFEFFFFFF;
            this.lastErrorCode_ = 0;
            this.onChanged();
            return this;
        }

        @Override
        public boolean getManaged() {
            return this.managed_;
        }

        public Builder setManaged(boolean value) {
            this.managed_ = value;
            this.bitField0_ |= 0x2000000;
            this.onChanged();
            return this;
        }

        public Builder clearManaged() {
            this.bitField0_ &= 0xFDFFFFFF;
            this.managed_ = false;
            this.onChanged();
            return this;
        }

        @Override
        public boolean getWasActive() {
            return this.wasActive_;
        }

        public Builder setWasActive(boolean value) {
            this.wasActive_ = value;
            this.bitField0_ |= 0x4000000;
            this.onChanged();
            return this;
        }

        public Builder clearWasActive() {
            this.bitField0_ &= 0xFBFFFFFF;
            this.wasActive_ = false;
            this.onChanged();
            return this;
        }

        @Override
        public boolean hasOrgDeactivated() {
            return (this.bitField0_ & 0x8000000) != 0;
        }

        @Override
        public Timestamp getOrgDeactivated() {
            if (this.orgDeactivatedBuilder_ == null) {
                return this.orgDeactivated_ == null ? Timestamp.getDefaultInstance() : this.orgDeactivated_;
            }
            return (Timestamp)this.orgDeactivatedBuilder_.getMessage();
        }

        public Builder setOrgDeactivated(Timestamp value) {
            if (this.orgDeactivatedBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.orgDeactivated_ = value;
            } else {
                this.orgDeactivatedBuilder_.setMessage((AbstractMessage)value);
            }
            this.bitField0_ |= 0x8000000;
            this.onChanged();
            return this;
        }

        public Builder setOrgDeactivated(Timestamp.Builder builderForValue) {
            if (this.orgDeactivatedBuilder_ == null) {
                this.orgDeactivated_ = builderForValue.build();
            } else {
                this.orgDeactivatedBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.bitField0_ |= 0x8000000;
            this.onChanged();
            return this;
        }

        public Builder mergeOrgDeactivated(Timestamp value) {
            if (this.orgDeactivatedBuilder_ == null) {
                if ((this.bitField0_ & 0x8000000) != 0 && this.orgDeactivated_ != null && this.orgDeactivated_ != Timestamp.getDefaultInstance()) {
                    this.getOrgDeactivatedBuilder().mergeFrom(value);
                } else {
                    this.orgDeactivated_ = value;
                }
            } else {
                this.orgDeactivatedBuilder_.mergeFrom((AbstractMessage)value);
            }
            if (this.orgDeactivated_ != null) {
                this.bitField0_ |= 0x8000000;
                this.onChanged();
            }
            return this;
        }

        public Builder clearOrgDeactivated() {
            this.bitField0_ &= 0xF7FFFFFF;
            this.orgDeactivated_ = null;
            if (this.orgDeactivatedBuilder_ != null) {
                this.orgDeactivatedBuilder_.dispose();
                this.orgDeactivatedBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public Timestamp.Builder getOrgDeactivatedBuilder() {
            this.bitField0_ |= 0x8000000;
            this.onChanged();
            return (Timestamp.Builder)this.getOrgDeactivatedFieldBuilder().getBuilder();
        }

        @Override
        public TimestampOrBuilder getOrgDeactivatedOrBuilder() {
            if (this.orgDeactivatedBuilder_ != null) {
                return (TimestampOrBuilder)this.orgDeactivatedBuilder_.getMessageOrBuilder();
            }
            return this.orgDeactivated_ == null ? Timestamp.getDefaultInstance() : this.orgDeactivated_;
        }

        private SingleFieldBuilderV3<Timestamp, Timestamp.Builder, TimestampOrBuilder> getOrgDeactivatedFieldBuilder() {
            if (this.orgDeactivatedBuilder_ == null) {
                this.orgDeactivatedBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getOrgDeactivated(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.orgDeactivated_ = null;
            }
            return this.orgDeactivatedBuilder_;
        }

        @Override
        public boolean hasEnvoyInstancePools() {
            return (this.bitField0_ & 0x10000000) != 0;
        }

        @Override
        public Struct getEnvoyInstancePools() {
            if (this.envoyInstancePoolsBuilder_ == null) {
                return this.envoyInstancePools_ == null ? Struct.getDefaultInstance() : this.envoyInstancePools_;
            }
            return (Struct)this.envoyInstancePoolsBuilder_.getMessage();
        }

        public Builder setEnvoyInstancePools(Struct value) {
            if (this.envoyInstancePoolsBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.envoyInstancePools_ = value;
            } else {
                this.envoyInstancePoolsBuilder_.setMessage((AbstractMessage)value);
            }
            this.bitField0_ |= 0x10000000;
            this.onChanged();
            return this;
        }

        public Builder setEnvoyInstancePools(Struct.Builder builderForValue) {
            if (this.envoyInstancePoolsBuilder_ == null) {
                this.envoyInstancePools_ = builderForValue.build();
            } else {
                this.envoyInstancePoolsBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.bitField0_ |= 0x10000000;
            this.onChanged();
            return this;
        }

        public Builder mergeEnvoyInstancePools(Struct value) {
            if (this.envoyInstancePoolsBuilder_ == null) {
                if ((this.bitField0_ & 0x10000000) != 0 && this.envoyInstancePools_ != null && this.envoyInstancePools_ != Struct.getDefaultInstance()) {
                    this.getEnvoyInstancePoolsBuilder().mergeFrom(value);
                } else {
                    this.envoyInstancePools_ = value;
                }
            } else {
                this.envoyInstancePoolsBuilder_.mergeFrom((AbstractMessage)value);
            }
            if (this.envoyInstancePools_ != null) {
                this.bitField0_ |= 0x10000000;
                this.onChanged();
            }
            return this;
        }

        public Builder clearEnvoyInstancePools() {
            this.bitField0_ &= 0xEFFFFFFF;
            this.envoyInstancePools_ = null;
            if (this.envoyInstancePoolsBuilder_ != null) {
                this.envoyInstancePoolsBuilder_.dispose();
                this.envoyInstancePoolsBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public Struct.Builder getEnvoyInstancePoolsBuilder() {
            this.bitField0_ |= 0x10000000;
            this.onChanged();
            return (Struct.Builder)this.getEnvoyInstancePoolsFieldBuilder().getBuilder();
        }

        @Override
        public StructOrBuilder getEnvoyInstancePoolsOrBuilder() {
            if (this.envoyInstancePoolsBuilder_ != null) {
                return (StructOrBuilder)this.envoyInstancePoolsBuilder_.getMessageOrBuilder();
            }
            return this.envoyInstancePools_ == null ? Struct.getDefaultInstance() : this.envoyInstancePools_;
        }

        private SingleFieldBuilderV3<Struct, Struct.Builder, StructOrBuilder> getEnvoyInstancePoolsFieldBuilder() {
            if (this.envoyInstancePoolsBuilder_ == null) {
                this.envoyInstancePoolsBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getEnvoyInstancePools(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.envoyInstancePools_ = null;
            }
            return this.envoyInstancePoolsBuilder_;
        }

        @Override
        public boolean hasTrafficRuntimeConfig() {
            return (this.bitField0_ & 0x20000000) != 0;
        }

        @Override
        public Struct getTrafficRuntimeConfig() {
            if (this.trafficRuntimeConfigBuilder_ == null) {
                return this.trafficRuntimeConfig_ == null ? Struct.getDefaultInstance() : this.trafficRuntimeConfig_;
            }
            return (Struct)this.trafficRuntimeConfigBuilder_.getMessage();
        }

        public Builder setTrafficRuntimeConfig(Struct value) {
            if (this.trafficRuntimeConfigBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.trafficRuntimeConfig_ = value;
            } else {
                this.trafficRuntimeConfigBuilder_.setMessage((AbstractMessage)value);
            }
            this.bitField0_ |= 0x20000000;
            this.onChanged();
            return this;
        }

        public Builder setTrafficRuntimeConfig(Struct.Builder builderForValue) {
            if (this.trafficRuntimeConfigBuilder_ == null) {
                this.trafficRuntimeConfig_ = builderForValue.build();
            } else {
                this.trafficRuntimeConfigBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.bitField0_ |= 0x20000000;
            this.onChanged();
            return this;
        }

        public Builder mergeTrafficRuntimeConfig(Struct value) {
            if (this.trafficRuntimeConfigBuilder_ == null) {
                if ((this.bitField0_ & 0x20000000) != 0 && this.trafficRuntimeConfig_ != null && this.trafficRuntimeConfig_ != Struct.getDefaultInstance()) {
                    this.getTrafficRuntimeConfigBuilder().mergeFrom(value);
                } else {
                    this.trafficRuntimeConfig_ = value;
                }
            } else {
                this.trafficRuntimeConfigBuilder_.mergeFrom((AbstractMessage)value);
            }
            if (this.trafficRuntimeConfig_ != null) {
                this.bitField0_ |= 0x20000000;
                this.onChanged();
            }
            return this;
        }

        public Builder clearTrafficRuntimeConfig() {
            this.bitField0_ &= 0xDFFFFFFF;
            this.trafficRuntimeConfig_ = null;
            if (this.trafficRuntimeConfigBuilder_ != null) {
                this.trafficRuntimeConfigBuilder_.dispose();
                this.trafficRuntimeConfigBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public Struct.Builder getTrafficRuntimeConfigBuilder() {
            this.bitField0_ |= 0x20000000;
            this.onChanged();
            return (Struct.Builder)this.getTrafficRuntimeConfigFieldBuilder().getBuilder();
        }

        @Override
        public StructOrBuilder getTrafficRuntimeConfigOrBuilder() {
            if (this.trafficRuntimeConfigBuilder_ != null) {
                return (StructOrBuilder)this.trafficRuntimeConfigBuilder_.getMessageOrBuilder();
            }
            return this.trafficRuntimeConfig_ == null ? Struct.getDefaultInstance() : this.trafficRuntimeConfig_;
        }

        private SingleFieldBuilderV3<Struct, Struct.Builder, StructOrBuilder> getTrafficRuntimeConfigFieldBuilder() {
            if (this.trafficRuntimeConfigBuilder_ == null) {
                this.trafficRuntimeConfigBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getTrafficRuntimeConfig(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.trafficRuntimeConfig_ = null;
            }
            return this.trafficRuntimeConfigBuilder_;
        }

        private void ensureDesiredConnectionTypesIsMutable() {
            if ((this.bitField0_ & 0x40000000) == 0) {
                this.desiredConnectionTypes_ = new ArrayList<Integer>(this.desiredConnectionTypes_);
                this.bitField0_ |= 0x40000000;
            }
        }

        @Override
        public List<NetworkConnectionType> getDesiredConnectionTypesList() {
            return new Internal.ListAdapter(this.desiredConnectionTypes_, desiredConnectionTypes_converter_);
        }

        @Override
        public int getDesiredConnectionTypesCount() {
            return this.desiredConnectionTypes_.size();
        }

        @Override
        public NetworkConnectionType getDesiredConnectionTypes(int index) {
            return (NetworkConnectionType)((Object)desiredConnectionTypes_converter_.convert((Object)this.desiredConnectionTypes_.get(index)));
        }

        public Builder setDesiredConnectionTypes(int index, NetworkConnectionType value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensureDesiredConnectionTypesIsMutable();
            this.desiredConnectionTypes_.set(index, value.getNumber());
            this.onChanged();
            return this;
        }

        public Builder addDesiredConnectionTypes(NetworkConnectionType value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensureDesiredConnectionTypesIsMutable();
            this.desiredConnectionTypes_.add(value.getNumber());
            this.onChanged();
            return this;
        }

        public Builder addAllDesiredConnectionTypes(Iterable<? extends NetworkConnectionType> values) {
            this.ensureDesiredConnectionTypesIsMutable();
            for (NetworkConnectionType networkConnectionType : values) {
                this.desiredConnectionTypes_.add(networkConnectionType.getNumber());
            }
            this.onChanged();
            return this;
        }

        public Builder clearDesiredConnectionTypes() {
            this.desiredConnectionTypes_ = Collections.emptyList();
            this.bitField0_ &= 0xBFFFFFFF;
            this.onChanged();
            return this;
        }

        @Override
        public List<Integer> getDesiredConnectionTypesValueList() {
            return Collections.unmodifiableList(this.desiredConnectionTypes_);
        }

        @Override
        public int getDesiredConnectionTypesValue(int index) {
            return this.desiredConnectionTypes_.get(index);
        }

        public Builder setDesiredConnectionTypesValue(int index, int value) {
            this.ensureDesiredConnectionTypesIsMutable();
            this.desiredConnectionTypes_.set(index, value);
            this.onChanged();
            return this;
        }

        public Builder addDesiredConnectionTypesValue(int value) {
            this.ensureDesiredConnectionTypesIsMutable();
            this.desiredConnectionTypes_.add(value);
            this.onChanged();
            return this;
        }

        public Builder addAllDesiredConnectionTypesValue(Iterable<Integer> values) {
            this.ensureDesiredConnectionTypesIsMutable();
            for (int value : values) {
                this.desiredConnectionTypes_.add(value);
            }
            this.onChanged();
            return this;
        }

        @Override
        public long getId() {
            return this.id_;
        }

        public Builder setId(long value) {
            this.id_ = value;
            this.bitField0_ |= Integer.MIN_VALUE;
            this.onChanged();
            return this;
        }

        public Builder clearId() {
            this.bitField0_ &= Integer.MAX_VALUE;
            this.id_ = 0L;
            this.onChanged();
            return this;
        }

        @Override
        public String getEnvoyInstancePoolsString() {
            Object ref = this.envoyInstancePoolsString_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.envoyInstancePoolsString_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getEnvoyInstancePoolsStringBytes() {
            Object ref = this.envoyInstancePoolsString_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.envoyInstancePoolsString_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setEnvoyInstancePoolsString(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.envoyInstancePoolsString_ = value;
            this.bitField1_ |= 1;
            this.onChanged();
            return this;
        }

        public Builder clearEnvoyInstancePoolsString() {
            this.envoyInstancePoolsString_ = Site.getDefaultInstance().getEnvoyInstancePoolsString();
            this.bitField1_ &= 0xFFFFFFFE;
            this.onChanged();
            return this;
        }

        public Builder setEnvoyInstancePoolsStringBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            Site.checkByteStringIsUtf8((ByteString)value);
            this.envoyInstancePoolsString_ = value;
            this.bitField1_ |= 1;
            this.onChanged();
            return this;
        }

        @Override
        public String getTrafficRuntimeConfigString() {
            Object ref = this.trafficRuntimeConfigString_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.trafficRuntimeConfigString_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getTrafficRuntimeConfigStringBytes() {
            Object ref = this.trafficRuntimeConfigString_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.trafficRuntimeConfigString_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setTrafficRuntimeConfigString(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.trafficRuntimeConfigString_ = value;
            this.bitField1_ |= 2;
            this.onChanged();
            return this;
        }

        public Builder clearTrafficRuntimeConfigString() {
            this.trafficRuntimeConfigString_ = Site.getDefaultInstance().getTrafficRuntimeConfigString();
            this.bitField1_ &= 0xFFFFFFFD;
            this.onChanged();
            return this;
        }

        public Builder setTrafficRuntimeConfigStringBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            Site.checkByteStringIsUtf8((ByteString)value);
            this.trafficRuntimeConfigString_ = value;
            this.bitField1_ |= 2;
            this.onChanged();
            return this;
        }

        @Override
        public String getOrgResourceId() {
            Object ref = this.orgResourceId_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.orgResourceId_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getOrgResourceIdBytes() {
            Object ref = this.orgResourceId_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.orgResourceId_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setOrgResourceId(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.orgResourceId_ = value;
            this.bitField1_ |= 4;
            this.onChanged();
            return this;
        }

        public Builder clearOrgResourceId() {
            this.orgResourceId_ = Site.getDefaultInstance().getOrgResourceId();
            this.bitField1_ &= 0xFFFFFFFB;
            this.onChanged();
            return this;
        }

        public Builder setOrgResourceIdBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            Site.checkByteStringIsUtf8((ByteString)value);
            this.orgResourceId_ = value;
            this.bitField1_ |= 4;
            this.onChanged();
            return this;
        }

        @Override
        public boolean getNeedsIngressEdge() {
            return this.needsIngressEdge_;
        }

        public Builder setNeedsIngressEdge(boolean value) {
            this.needsIngressEdge_ = value;
            this.bitField1_ |= 8;
            this.onChanged();
            return this;
        }

        public Builder clearNeedsIngressEdge() {
            this.bitField1_ &= 0xFFFFFFF7;
            this.needsIngressEdge_ = false;
            this.onChanged();
            return this;
        }

        @Override
        public String getNetworkContextId() {
            Object ref = this.networkContextId_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.networkContextId_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getNetworkContextIdBytes() {
            Object ref = this.networkContextId_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.networkContextId_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setNetworkContextId(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.networkContextId_ = value;
            this.bitField1_ |= 0x10;
            this.onChanged();
            return this;
        }

        public Builder clearNetworkContextId() {
            this.networkContextId_ = Site.getDefaultInstance().getNetworkContextId();
            this.bitField1_ &= 0xFFFFFFEF;
            this.onChanged();
            return this;
        }

        public Builder setNetworkContextIdBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            Site.checkByteStringIsUtf8((ByteString)value);
            this.networkContextId_ = value;
            this.bitField1_ |= 0x10;
            this.onChanged();
            return this;
        }

        @Override
        public boolean hasMetadata() {
            return (this.bitField1_ & 0x20) != 0;
        }

        @Override
        public ChangeEventMetadata getMetadata() {
            if (this.metadataBuilder_ == null) {
                return this.metadata_ == null ? ChangeEventMetadata.getDefaultInstance() : this.metadata_;
            }
            return (ChangeEventMetadata)this.metadataBuilder_.getMessage();
        }

        public Builder setMetadata(ChangeEventMetadata value) {
            if (this.metadataBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.metadata_ = value;
            } else {
                this.metadataBuilder_.setMessage((AbstractMessage)value);
            }
            this.bitField1_ |= 0x20;
            this.onChanged();
            return this;
        }

        public Builder setMetadata(ChangeEventMetadata.Builder builderForValue) {
            if (this.metadataBuilder_ == null) {
                this.metadata_ = builderForValue.build();
            } else {
                this.metadataBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.bitField1_ |= 0x20;
            this.onChanged();
            return this;
        }

        public Builder mergeMetadata(ChangeEventMetadata value) {
            if (this.metadataBuilder_ == null) {
                if ((this.bitField1_ & 0x20) != 0 && this.metadata_ != null && this.metadata_ != ChangeEventMetadata.getDefaultInstance()) {
                    this.getMetadataBuilder().mergeFrom(value);
                } else {
                    this.metadata_ = value;
                }
            } else {
                this.metadataBuilder_.mergeFrom((AbstractMessage)value);
            }
            if (this.metadata_ != null) {
                this.bitField1_ |= 0x20;
                this.onChanged();
            }
            return this;
        }

        public Builder clearMetadata() {
            this.bitField1_ &= 0xFFFFFFDF;
            this.metadata_ = null;
            if (this.metadataBuilder_ != null) {
                this.metadataBuilder_.dispose();
                this.metadataBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public ChangeEventMetadata.Builder getMetadataBuilder() {
            this.bitField1_ |= 0x20;
            this.onChanged();
            return (ChangeEventMetadata.Builder)this.getMetadataFieldBuilder().getBuilder();
        }

        @Override
        public ChangeEventMetadataOrBuilder getMetadataOrBuilder() {
            if (this.metadataBuilder_ != null) {
                return (ChangeEventMetadataOrBuilder)this.metadataBuilder_.getMessageOrBuilder();
            }
            return this.metadata_ == null ? ChangeEventMetadata.getDefaultInstance() : this.metadata_;
        }

        private SingleFieldBuilderV3<ChangeEventMetadata, ChangeEventMetadata.Builder, ChangeEventMetadataOrBuilder> getMetadataFieldBuilder() {
            if (this.metadataBuilder_ == null) {
                this.metadataBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getMetadata(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.metadata_ = null;
            }
            return this.metadataBuilder_;
        }

        public final Builder setUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.setUnknownFields(unknownFields);
        }

        public final Builder mergeUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.mergeUnknownFields(unknownFields);
        }
    }

    public static enum NetworkConnectionType implements ProtocolMessageEnum
    {
        UNKNOWN_TYPE(0),
        PUBLIC(1),
        PRIVATE_LINK(2),
        TRANSIT_GATEWAY(3),
        VPC_PEERING(4),
        UNRECOGNIZED(-1);

        public static final int UNKNOWN_TYPE_VALUE = 0;
        public static final int PUBLIC_VALUE = 1;
        public static final int PRIVATE_LINK_VALUE = 2;
        public static final int TRANSIT_GATEWAY_VALUE = 3;
        public static final int VPC_PEERING_VALUE = 4;
        private static final Internal.EnumLiteMap<NetworkConnectionType> internalValueMap;
        private static final NetworkConnectionType[] VALUES;
        private final int value;

        public final int getNumber() {
            if (this == UNRECOGNIZED) {
                throw new IllegalArgumentException("Can't get the number of an unknown enum value.");
            }
            return this.value;
        }

        @Deprecated
        public static NetworkConnectionType valueOf(int value) {
            return NetworkConnectionType.forNumber(value);
        }

        public static NetworkConnectionType forNumber(int value) {
            switch (value) {
                case 0: {
                    return UNKNOWN_TYPE;
                }
                case 1: {
                    return PUBLIC;
                }
                case 2: {
                    return PRIVATE_LINK;
                }
                case 3: {
                    return TRANSIT_GATEWAY;
                }
                case 4: {
                    return VPC_PEERING;
                }
            }
            return null;
        }

        public static Internal.EnumLiteMap<NetworkConnectionType> internalGetValueMap() {
            return internalValueMap;
        }

        public final Descriptors.EnumValueDescriptor getValueDescriptor() {
            if (this == UNRECOGNIZED) {
                throw new IllegalStateException("Can't get the descriptor of an unrecognized enum value.");
            }
            return (Descriptors.EnumValueDescriptor)NetworkConnectionType.getDescriptor().getValues().get(this.ordinal());
        }

        public final Descriptors.EnumDescriptor getDescriptorForType() {
            return NetworkConnectionType.getDescriptor();
        }

        public static final Descriptors.EnumDescriptor getDescriptor() {
            return (Descriptors.EnumDescriptor)Site.getDescriptor().getEnumTypes().get(1);
        }

        public static NetworkConnectionType valueOf(Descriptors.EnumValueDescriptor desc) {
            if (desc.getType() != NetworkConnectionType.getDescriptor()) {
                throw new IllegalArgumentException("EnumValueDescriptor is not for this type.");
            }
            if (desc.getIndex() == -1) {
                return UNRECOGNIZED;
            }
            return VALUES[desc.getIndex()];
        }

        private NetworkConnectionType(int value) {
            this.value = value;
        }

        static {
            internalValueMap = new Internal.EnumLiteMap<NetworkConnectionType>(){

                public NetworkConnectionType findValueByNumber(int number) {
                    return NetworkConnectionType.forNumber(number);
                }
            };
            VALUES = NetworkConnectionType.values();
        }
    }

    public static enum State implements ProtocolMessageEnum
    {
        STATE_UNKNOWN(0),
        FAILED(1),
        CREATING_NETWORK(2),
        ACTIVE(3),
        DESTROYING_NETWORK(4),
        DESTROYED(5),
        UNRECOGNIZED(-1);

        public static final int STATE_UNKNOWN_VALUE = 0;
        public static final int FAILED_VALUE = 1;
        public static final int CREATING_NETWORK_VALUE = 2;
        public static final int ACTIVE_VALUE = 3;
        public static final int DESTROYING_NETWORK_VALUE = 4;
        public static final int DESTROYED_VALUE = 5;
        private static final Internal.EnumLiteMap<State> internalValueMap;
        private static final State[] VALUES;
        private final int value;

        public final int getNumber() {
            if (this == UNRECOGNIZED) {
                throw new IllegalArgumentException("Can't get the number of an unknown enum value.");
            }
            return this.value;
        }

        @Deprecated
        public static State valueOf(int value) {
            return State.forNumber(value);
        }

        public static State forNumber(int value) {
            switch (value) {
                case 0: {
                    return STATE_UNKNOWN;
                }
                case 1: {
                    return FAILED;
                }
                case 2: {
                    return CREATING_NETWORK;
                }
                case 3: {
                    return ACTIVE;
                }
                case 4: {
                    return DESTROYING_NETWORK;
                }
                case 5: {
                    return DESTROYED;
                }
            }
            return null;
        }

        public static Internal.EnumLiteMap<State> internalGetValueMap() {
            return internalValueMap;
        }

        public final Descriptors.EnumValueDescriptor getValueDescriptor() {
            if (this == UNRECOGNIZED) {
                throw new IllegalStateException("Can't get the descriptor of an unrecognized enum value.");
            }
            return (Descriptors.EnumValueDescriptor)State.getDescriptor().getValues().get(this.ordinal());
        }

        public final Descriptors.EnumDescriptor getDescriptorForType() {
            return State.getDescriptor();
        }

        public static final Descriptors.EnumDescriptor getDescriptor() {
            return (Descriptors.EnumDescriptor)Site.getDescriptor().getEnumTypes().get(0);
        }

        public static State valueOf(Descriptors.EnumValueDescriptor desc) {
            if (desc.getType() != State.getDescriptor()) {
                throw new IllegalArgumentException("EnumValueDescriptor is not for this type.");
            }
            if (desc.getIndex() == -1) {
                return UNRECOGNIZED;
            }
            return VALUES[desc.getIndex()];
        }

        private State(int value) {
            this.value = value;
        }

        static {
            internalValueMap = new Internal.EnumLiteMap<State>(){

                public State findValueByNumber(int number) {
                    return State.forNumber(number);
                }
            };
            VALUES = State.values();
        }
    }
}

