/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.security.auth.store.data;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.confluent.security.auth.store.data.AuthEntryType;
import io.confluent.security.auth.store.data.AuthKey;
import io.confluent.security.authorizer.Scope;
import java.util.Objects;

public class IpFilteringKey
extends AuthKey {
    private final String operationGroup;
    private final Scope scope;

    @JsonCreator
    public IpFilteringKey(@JsonProperty(value="operation_group") String operationGroup, @JsonProperty(value="scope") Scope scope) {
        this.operationGroup = Objects.requireNonNull(operationGroup, "operationGroup cannot be null");
        this.scope = Objects.requireNonNull(scope, "scope cannot be null");
    }

    @JsonProperty
    public String operationGroup() {
        return this.operationGroup;
    }

    @JsonProperty
    public Scope scope() {
        return this.scope;
    }

    @Override
    @JsonIgnore
    public AuthEntryType entryType() {
        return AuthEntryType.IP_FILTERING;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        IpFilteringKey that = (IpFilteringKey)o;
        return Objects.equals(this.operationGroup, that.operationGroup) && Objects.equals(this.scope, that.scope);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.entryType().name(), this.operationGroup, this.scope);
    }

    public String toString() {
        return "IpFilteringKey{operationGroup=" + this.operationGroup + ", scope=" + String.valueOf(this.scope) + "}";
    }
}

