/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.shaded.org.hamcrest.object;

import org.testcontainers.shaded.org.hamcrest.Description;
import org.testcontainers.shaded.org.hamcrest.Matcher;
import org.testcontainers.shaded.org.hamcrest.TypeSafeMatcher;

public class IsCompatibleType<T>
extends TypeSafeMatcher<Class<?>> {
    private final Class<T> type;

    public IsCompatibleType(Class<T> type) {
        this.type = type;
    }

    @Override
    public boolean matchesSafely(Class<?> cls) {
        return this.type.isAssignableFrom(cls);
    }

    @Override
    public void describeMismatchSafely(Class<?> cls, Description mismatchDescription) {
        mismatchDescription.appendValue(cls.getName());
    }

    @Override
    public void describeTo(Description description) {
        description.appendText("type < ").appendText(this.type.getName());
    }

    public static <T> Matcher<Class<?>> typeCompatibleWith(Class<T> baseType) {
        return new IsCompatibleType<T>(baseType);
    }
}

