/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.tools.migrations;

import com.github.rvesse.airline.Cli;
import com.github.rvesse.airline.annotations.Parser;
import com.github.rvesse.airline.help.Help;
import com.github.rvesse.airline.help.cli.CliGlobalUsageGenerator;
import com.github.rvesse.airline.model.GlobalMetadata;
import com.github.rvesse.airline.model.OptionMetadata;
import com.github.rvesse.airline.parser.ParseResult;
import com.github.rvesse.airline.parser.ParseState;
import com.github.rvesse.airline.parser.errors.ParseCommandMissingException;
import com.github.rvesse.airline.parser.errors.ParseCommandUnrecognizedException;
import com.github.rvesse.airline.parser.errors.ParseException;
import com.github.rvesse.airline.parser.errors.handlers.CollectAll;
import com.google.common.annotations.VisibleForTesting;
import io.confluent.ksql.tools.migrations.MigrationException;
import io.confluent.ksql.tools.migrations.commands.ApplyMigrationCommand;
import io.confluent.ksql.tools.migrations.commands.BaseCommand;
import io.confluent.ksql.tools.migrations.commands.CreateMigrationCommand;
import io.confluent.ksql.tools.migrations.commands.DestroyMigrationsCommand;
import io.confluent.ksql.tools.migrations.commands.InitializeMigrationCommand;
import io.confluent.ksql.tools.migrations.commands.MigrationInfoCommand;
import io.confluent.ksql.tools.migrations.commands.NewMigrationCommand;
import io.confluent.ksql.tools.migrations.commands.ValidateMigrationsCommand;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@com.github.rvesse.airline.annotations.Cli(name="ksql-migrations", description="This tool provides easy and automated schema migrations for ksqlDB environments. This allows control over ksqlDB schemas, recreate schemas from scratch and migrations for current schemas to newer versions.", commands={NewMigrationCommand.class, CreateMigrationCommand.class, ApplyMigrationCommand.class, MigrationInfoCommand.class, DestroyMigrationsCommand.class, ValidateMigrationsCommand.class, InitializeMigrationCommand.class, Help.class}, parserConfiguration=@Parser(errorHandler=CollectAll.class))
public final class Migrations {
    private static final Logger LOGGER = LogManager.getLogger(Migrations.class);

    private Migrations() {
    }

    public static void main(String[] args) {
        Optional<Runnable> command;
        Cli cli = new Cli(Migrations.class);
        try {
            command = Migrations.parseCommandFromArgs((Cli<Runnable>)cli, args);
        }
        catch (MigrationException e) {
            LOGGER.error(e.getMessage());
            System.exit(1);
            return;
        }
        if (!command.isPresent()) {
            System.exit(0);
            return;
        }
        if (command.get() instanceof Help) {
            command.get().run();
            System.exit(0);
            return;
        }
        System.exit(((BaseCommand)command.get()).runCommand());
    }

    @VisibleForTesting
    static Optional<Runnable> parseCommandFromArgs(Cli<Runnable> cli, String[] args) {
        ParseResult result = cli.parseWithResult(args);
        if (result.wasSuccessful()) {
            return Optional.of((Runnable)result.getCommand());
        }
        if (Migrations.isGlobalHelpMessageRequested(result.getErrors())) {
            try {
                new CliGlobalUsageGenerator().usage(cli.getMetadata(), (OutputStream)System.out);
                return Optional.empty();
            }
            catch (IOException e) {
                throw new MigrationException("Failed to print help: " + e.getMessage());
            }
        }
        if (Migrations.isCommandSpecificHelpMessageRequested((ParseState<Runnable>)result.getState())) {
            String commandName = result.getState().getCommand().getName();
            try {
                Help.help((GlobalMetadata)cli.getMetadata(), Collections.singletonList(commandName), (OutputStream)System.out);
                return Optional.empty();
            }
            catch (IOException e) {
                throw new MigrationException("Failed to print help for command '" + commandName + "': " + e.getMessage());
            }
        }
        ParseException e = (ParseException)result.getErrors().stream().findFirst().orElseThrow(() -> new IllegalStateException("Failed to parse statement yet no errors were collected"));
        throw new MigrationException(e.getMessage());
    }

    private static boolean isGlobalHelpMessageRequested(Collection<ParseException> errors) {
        return errors.stream().anyMatch(e -> e instanceof ParseCommandMissingException) || errors.stream().filter(e -> e instanceof ParseCommandUnrecognizedException).map(e -> (ParseCommandUnrecognizedException)e).flatMap(e -> e.getUnparsedInput().stream()).anyMatch(inp -> inp.equals("--help") || inp.equals("-h"));
    }

    private static boolean isCommandSpecificHelpMessageRequested(ParseState<Runnable> parseState) {
        for (Pair option : parseState.getParsedOptions()) {
            if (!((OptionMetadata)option.getKey()).getTitle().equals("help") || !((Boolean)option.getValue()).booleanValue()) continue;
            return true;
        }
        return false;
    }
}

