/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.tools.migrations.commands;

import com.github.rvesse.airline.annotations.Arguments;
import com.github.rvesse.airline.annotations.Command;
import com.github.rvesse.airline.annotations.Option;
import com.github.rvesse.airline.annotations.help.Examples;
import com.github.rvesse.airline.annotations.restrictions.Once;
import com.github.rvesse.airline.annotations.restrictions.Required;
import com.github.rvesse.airline.annotations.restrictions.ranges.IntegerRange;
import com.google.common.annotations.VisibleForTesting;
import io.confluent.ksql.tools.migrations.MigrationConfig;
import io.confluent.ksql.tools.migrations.MigrationException;
import io.confluent.ksql.tools.migrations.commands.BaseCommand;
import io.confluent.ksql.tools.migrations.util.MigrationFile;
import io.confluent.ksql.tools.migrations.util.MigrationsDirectoryUtil;
import io.confluent.ksql.util.KsqlException;
import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.List;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Command(name="create", description="Creates a blank migration file with the specified description, which can then be populated with ksqlDB statements and applied as the next schema version.")
@Examples(examples={"$ ksql-migrations --config-file <config-file> create Add_users"}, descriptions={"Creates a new migrations file with the next available version number (e.g. V000002__Add_users.sql)"})
public class CreateMigrationCommand
extends BaseCommand {
    private static final Logger LOGGER = LogManager.getLogger(CreateMigrationCommand.class);
    private static final String INVALID_FILENAME_CHARS_PATTERN = "\\s|/|\\\\|:|\\*|\\?|\"|<|>|\\|";
    @Option(name={"-v", "--version"}, description="(Optional) The schema version to initialize. Defaults to the next schema version based on existing migration files.")
    @IntegerRange(min=1, max=999999)
    @Once
    private int version;
    @Required
    @Once
    @Arguments(title={"description"}, description="The description for the migration.")
    private String description;

    @Override
    protected int command() {
        MigrationConfig config;
        if (!this.validateConfigFilePresent()) {
            return 1;
        }
        try {
            config = MigrationConfig.load(this.getConfigFile());
        }
        catch (MigrationException | KsqlException e) {
            LOGGER.error(e.getMessage());
            return 1;
        }
        return this.command(MigrationsDirectoryUtil.getMigrationsDir(this.getConfigFile(), config));
    }

    @VisibleForTesting
    int command(String migrationsDir) {
        if (!this.validateVersionDoesNotAlreadyExist(migrationsDir) || !this.validateDescriptionNotEmpty()) {
            return 1;
        }
        try {
            int newVersion = this.version != 0 ? this.version : CreateMigrationCommand.getLatestVersion(migrationsDir) + 1;
            this.createMigrationsFile(newVersion, migrationsDir);
        }
        catch (MigrationException e) {
            LOGGER.error(e.getMessage());
            return 1;
        }
        return 0;
    }

    @Override
    protected Logger getLogger() {
        return LOGGER;
    }

    private boolean validateVersionDoesNotAlreadyExist(String migrationsDir) {
        Optional<MigrationFile> existingMigration;
        if (this.version == 0) {
            return true;
        }
        try {
            existingMigration = MigrationsDirectoryUtil.getMigrationForVersion(String.valueOf(this.version), migrationsDir);
        }
        catch (MigrationException e) {
            LOGGER.error(e.getMessage());
            return false;
        }
        if (existingMigration.isPresent()) {
            LOGGER.error("Found existing migrations file for version {}: {}", (Object)this.version, (Object)existingMigration.get().getFilepath());
            return false;
        }
        return true;
    }

    private boolean validateDescriptionNotEmpty() {
        if (this.description.isEmpty()) {
            LOGGER.error("Description cannot be empty.");
            return false;
        }
        return true;
    }

    private void createMigrationsFile(int newVersion, String migrationsDir) {
        if (newVersion <= 0) {
            throw new MigrationException("Invalid version file version: " + newVersion + ". Version must be a positive integer.");
        }
        if (newVersion > 999999) {
            throw new MigrationException("Invalid version file version: " + newVersion + ". Version must fit into a six-digit integer.");
        }
        String filename = CreateMigrationCommand.getNewFileName(newVersion, this.description);
        String filePath = Paths.get(migrationsDir, filename).toString();
        try {
            LOGGER.info("Creating migration file: " + filePath);
            boolean result = new File(filePath).createNewFile();
            if (!result) {
                throw new IllegalStateException("File should not exist");
            }
            LOGGER.info("Migration file successfully created");
        }
        catch (IOException | IllegalStateException e) {
            throw new MigrationException(String.format("Failed to create file %s: %s", filePath, e.getMessage()));
        }
    }

    private static int getLatestVersion(String migrationsDir) {
        List<Integer> allVersions = MigrationsDirectoryUtil.getAllVersions(migrationsDir);
        return allVersions.size() != 0 ? allVersions.get(allVersions.size() - 1) : 0;
    }

    private static String getNewFileName(int newVersion, String description) {
        String versionPrefix = MigrationsDirectoryUtil.getFilePrefixForVersion(String.valueOf(newVersion));
        String descriptionSuffix = description.replaceAll(INVALID_FILENAME_CHARS_PATTERN, "_");
        return versionPrefix + "__" + descriptionSuffix + ".sql";
    }
}

