/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.tools.migrations.commands;

import com.github.rvesse.airline.annotations.Arguments;
import com.github.rvesse.airline.annotations.Command;
import com.github.rvesse.airline.annotations.restrictions.Required;
import com.google.common.collect.ImmutableList;
import io.confluent.ksql.tools.migrations.MigrationConfig;
import io.confluent.ksql.tools.migrations.commands.BaseCommand;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.file.FileSystemException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import org.apache.kafka.common.config.types.Password;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Command(name="new-project", description="Creates a new migrations project directory structure and config file.")
public class NewMigrationCommand
extends BaseCommand {
    static final String NEW_COMMAND_NAME = "new-project";
    private static final Logger LOGGER = LogManager.getLogger(NewMigrationCommand.class);
    @Required
    @Arguments(description="project-path: the path that will be used as the root directory for this migrations project.\nksql-server-url: the address of the ksqlDB server to connect to.", title={"project-path", "ksql-server-url"})
    private List<String> args;
    private static final List<String> METADATA_CONFIGS = ImmutableList.of((Object)"ksql.migrations.stream.name", (Object)"ksql.migrations.table.name", (Object)"ksql.migrations.stream.topic.name", (Object)"ksql.migrations.table.topic.name", (Object)"ksql.migrations.topic.replicas");
    private static final List<String> TLS_CONFIGS = ImmutableList.of((Object)"ssl.truststore.location", (Object)"ssl.truststore.password", (Object)"ssl.keystore.location", (Object)"ssl.keystore.password", (Object)"ssl.key.password", (Object)"ssl.key.alias", (Object)"ssl.alpn", (Object)"ssl.verify.host");
    private static final List<String> SERVER_AUTH_CONFIGS = ImmutableList.of((Object)"ksql.auth.basic.username", (Object)"ksql.auth.basic.password");
    private static final List<String> MIGRATIONS_STRUCTURE_CONFIGS = ImmutableList.of((Object)"ksql.migrations.dir.override");

    @Override
    protected int command() {
        if (this.getConfigFile() != null && !this.getConfigFile().equals("")) {
            LOGGER.error("This command does not expect a config file to be passed. Rather, this command will create one as part of preparing the migrations directory.");
            return 1;
        }
        if (this.args.size() != 2) {
            LOGGER.error("Unexpected number of arguments to `{} {}`. Expected: 2. Got: {}. See `{} help {}` for usage.", (Object)"ksql-migrations", (Object)NEW_COMMAND_NAME, (Object)this.args.size(), (Object)"ksql-migrations", (Object)NEW_COMMAND_NAME);
            return 1;
        }
        String projectPath = this.args.get(0);
        String ksqlServerUrl = this.args.get(1);
        LOGGER.info("Creating new migrations project at {}", (Object)projectPath);
        if (this.tryCreateDirectory(projectPath) && this.tryCreateDirectory(Paths.get(projectPath, "migrations").toString()) && this.tryCreatePropertiesFile(Paths.get(projectPath, "ksql-migrations.properties").toString(), ksqlServerUrl)) {
            LOGGER.info("Migrations project directory created successfully");
            return 0;
        }
        return 1;
    }

    @Override
    protected Logger getLogger() {
        return LOGGER;
    }

    private boolean tryCreateDirectory(String path) {
        File directory = new File(path);
        if (directory.exists() && directory.isDirectory()) {
            LOGGER.warn(path + " already exists. Skipping directory creation.");
            return true;
        }
        if (directory.exists() && !directory.isDirectory()) {
            LOGGER.error(path + " already exists as a file. Cannot create directory.");
            return false;
        }
        try {
            LOGGER.info("Creating directory: " + path);
            Files.createDirectories(Paths.get(path, new String[0]), new FileAttribute[0]);
        }
        catch (FileSystemException e) {
            LOGGER.error("Permission denied: create directory " + path);
            return false;
        }
        catch (IOException e) {
            LOGGER.error(String.format("Failed to create directory %s: %s", path, e.getMessage()));
            return false;
        }
        return true;
    }

    private boolean tryCreatePropertiesFile(String path, String ksqlServerUrl) {
        try {
            File file = new File(path);
            if (!file.exists()) {
                LOGGER.info("Creating file: " + path);
            }
            if (!file.createNewFile()) {
                LOGGER.error("Failed to create file. File already exists: {}", (Object)path);
                return false;
            }
        }
        catch (IOException e) {
            LOGGER.error(String.format("Failed to create file %s: %s", path, e.getMessage()));
            return false;
        }
        String initialConfig = NewMigrationCommand.createInitialConfig(ksqlServerUrl);
        LOGGER.info("Writing to config file: " + initialConfig);
        try (PrintWriter out = new PrintWriter(path, Charset.defaultCharset().name());){
            out.println(initialConfig);
        }
        catch (FileNotFoundException | UnsupportedEncodingException e) {
            LOGGER.error(String.format("Failed to write to config file %s: %s", path, e.getMessage()));
            return false;
        }
        return true;
    }

    private static String createInitialConfig(String ksqlServerUrl) {
        StringBuilder builder = new StringBuilder();
        builder.append("ksql.server.url=" + ksqlServerUrl);
        NewMigrationCommand.appendConfigs(builder, "Migrations metadata configs", METADATA_CONFIGS);
        NewMigrationCommand.appendConfigs(builder, "TLS configs", TLS_CONFIGS);
        NewMigrationCommand.appendConfigs(builder, "ksqlDB server authentication configs", SERVER_AUTH_CONFIGS);
        NewMigrationCommand.appendConfigs(builder, "Migrations directory configs", MIGRATIONS_STRUCTURE_CONFIGS);
        return builder.toString();
    }

    private static void appendConfigs(StringBuilder builder, String headerText, List<String> configs) {
        builder.append("\n\n# ");
        builder.append(headerText);
        builder.append(":");
        for (String cfg : configs) {
            Object value = MigrationConfig.DEFAULT_CONFIG.values().get(cfg);
            builder.append("\n# ");
            builder.append(cfg);
            builder.append("=");
            builder.append((Object)(value == null || value instanceof Password ? "" : value));
        }
    }
}

