/*
 * Decompiled with CFR 0.152.
 */
package com.kjetland.jackson.jsonSchema;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.introspect.AnnotatedClass;
import com.fasterxml.jackson.databind.introspect.AnnotatedClassResolver;
import com.fasterxml.jackson.databind.introspect.ClassIntrospector;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonAnyFormatVisitor;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonArrayFormatVisitor;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonBooleanFormatVisitor;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatTypes;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitable;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonIntegerFormatVisitor;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonMapFormatVisitor;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonNullFormatVisitor;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonNumberFormatVisitor;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonObjectFormatVisitor;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonStringFormatVisitor;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonValueFormat;
import com.fasterxml.jackson.databind.jsontype.TypeIdResolver;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.jsontype.impl.MinimalClassNameIdResolver;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.kjetland.jackson.jsonSchema.AbstractJsonFormatVisitorWithSerializerProvider;
import com.kjetland.jackson.jsonSchema.DefinitionsHandler;
import com.kjetland.jackson.jsonSchema.JsonSchemaGenerator;
import com.kjetland.jackson.jsonSchema.Utils;
import com.kjetland.jackson.jsonSchema.annotations.JsonSchemaAdditional;
import com.kjetland.jackson.jsonSchema.annotations.JsonSchemaDefault;
import com.kjetland.jackson.jsonSchema.annotations.JsonSchemaDescription;
import com.kjetland.jackson.jsonSchema.annotations.JsonSchemaExamples;
import com.kjetland.jackson.jsonSchema.annotations.JsonSchemaInject;
import com.kjetland.jackson.jsonSchema.annotations.JsonSchemaOptions;
import com.kjetland.jackson.jsonSchema.annotations.JsonSchemaTitle;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.validation.constraints.DecimalMax;
import javax.validation.constraints.DecimalMin;
import javax.validation.constraints.Email;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class JsonSchemaGeneratorVisitor
extends AbstractJsonFormatVisitorWithSerializerProvider
implements JsonFormatVisitorWrapper {
    private static final Logger log = LoggerFactory.getLogger(JsonSchemaGeneratorVisitor.class);
    final JsonSchemaGenerator ctx;
    final int level;
    final ObjectNode node;
    final DefinitionsHandler definitionsHandler;
    final BeanProperty currentProperty;

    private <T extends Annotation> T tryGetAnnotation(Class<T> annotationClass) {
        return this.ctx.selectAnnotation(this.currentProperty, annotationClass);
    }

    JsonSchemaGeneratorVisitor createChildVisitor(ObjectNode childNode, BeanProperty currentProperty) {
        return new JsonSchemaGeneratorVisitor(this.ctx, this.level + 1, childNode, this.definitionsHandler, currentProperty);
    }

    String extractDefaultValue() {
        JsonProperty jp = this.tryGetAnnotation(JsonProperty.class);
        if (jp != null && jp.defaultValue() != null && !jp.defaultValue().isEmpty()) {
            return jp.defaultValue();
        }
        JsonSchemaDefault jsd = this.tryGetAnnotation(JsonSchemaDefault.class);
        if (jsd != null) {
            return jsd.value();
        }
        return null;
    }

    public JsonStringFormatVisitor expectStringFormat(JavaType type) {
        Email emailAnnotation;
        JsonSchemaExamples examplesAnnotation;
        String defaultValue;
        Pattern.List patternListAnnotation;
        Pattern patternAnnotation;
        log.trace("expectStringFormat {}", (Object)type);
        this.node.put("type", "string");
        NotBlank notBlankAnnotation = this.tryGetAnnotation(NotBlank.class);
        if (notBlankAnnotation != null) {
            this.node.put("pattern", "^.*\\S+.*$");
        }
        if ((patternAnnotation = this.tryGetAnnotation(Pattern.class)) != null) {
            this.node.put("pattern", patternAnnotation.regexp());
        }
        if ((patternListAnnotation = this.tryGetAnnotation(Pattern.List.class)) != null) {
            String pattern = "^";
            for (Pattern p : patternListAnnotation.value()) {
                pattern = pattern + "(?=" + p.regexp() + ")";
            }
            pattern = pattern + ".*$";
            this.node.put("pattern", pattern);
        }
        if ((defaultValue = this.extractDefaultValue()) != null) {
            this.node.put("default", defaultValue);
        }
        if ((examplesAnnotation = this.tryGetAnnotation(JsonSchemaExamples.class)) != null) {
            ArrayNode examples = JsonNodeFactory.instance.arrayNode();
            for (String example : examplesAnnotation.value()) {
                examples.add(example);
            }
            this.node.set("examples", (JsonNode)examples);
        }
        if ((emailAnnotation = this.tryGetAnnotation(Email.class)) != null) {
            this.node.put("format", "email");
        }
        Size minAndMaxLengthAnnotation = this.tryGetAnnotation(Size.class);
        NotNull notNullAnnotation = this.tryGetAnnotation(NotNull.class);
        NotEmpty notEmptyAnnotation = this.tryGetAnnotation(NotEmpty.class);
        if (minAndMaxLengthAnnotation != null) {
            if (minAndMaxLengthAnnotation.min() != 0) {
                this.node.put("minLength", minAndMaxLengthAnnotation.min());
            }
            if (minAndMaxLengthAnnotation.max() != Integer.MAX_VALUE) {
                this.node.put("maxLength", minAndMaxLengthAnnotation.max());
            }
        } else if (this.ctx.config.useMinLengthForNotNull && notNullAnnotation != null) {
            this.node.put("minLength", 1);
        } else if (notEmptyAnnotation != null || notBlankAnnotation != null) {
            this.node.put("minLength", 1);
        }
        return new MyJsonValueFormatVisitor();
    }

    public JsonArrayFormatVisitor expectArrayFormat(JavaType type) {
        String defaultValue;
        NotEmpty notEmptyAnnotation;
        log.trace("expectArrayFormat {}", (Object)type);
        this.node.put("type", "array");
        if (this.ctx.config.uniqueItemClasses.stream().anyMatch(c -> type.getRawClass().isAssignableFrom((Class<?>)c))) {
            this.node.put("uniqueItems", true);
            this.node.put("format", "checkbox");
        } else if (this.ctx.config.defaultArrayFormat != null) {
            this.node.put("format", this.ctx.config.defaultArrayFormat);
        }
        Size sizeAnnotation = this.tryGetAnnotation(Size.class);
        if (sizeAnnotation != null) {
            this.node.put("minItems", sizeAnnotation.min());
            this.node.put("maxItems", sizeAnnotation.max());
        }
        if ((notEmptyAnnotation = this.tryGetAnnotation(NotEmpty.class)) != null) {
            this.node.put("minItems", 1);
        }
        if ((defaultValue = this.extractDefaultValue()) != null) {
            this.node.put("default", defaultValue);
        }
        final ObjectNode itemsNode = JsonNodeFactory.instance.objectNode();
        this.node.set("items", (JsonNode)itemsNode);
        final JavaType preferredElementType = type.getContentType();
        class MyVisitor
        extends AbstractJsonFormatVisitorWithSerializerProvider
        implements JsonArrayFormatVisitor {
            MyVisitor() {
            }

            public void itemsFormat(JsonFormatVisitable handler, JavaType elementType) throws JsonMappingException {
                log.trace("expectArrayFormat - handler: $handler - elementType: {} - preferredElementType: {}", (Object)elementType, (Object)preferredElementType);
                JavaType type = JsonSchemaGeneratorVisitor.this.ctx.tryToReMapType(preferredElementType);
                JsonSchemaGeneratorVisitor visitor = JsonSchemaGeneratorVisitor.this.createChildVisitor(itemsNode, null);
                JsonSchemaGeneratorVisitor.this.ctx.objectMapper.acceptJsonFormatVisitor(type, (JsonFormatVisitorWrapper)visitor);
            }

            public void itemsFormat(JsonFormatTypes format) {
                log.trace("itemsFormat - format: {}", (Object)format);
                itemsNode.put("type", format.value());
            }
        }
        return new MyVisitor();
    }

    public JsonNumberFormatVisitor expectNumberFormat(JavaType type) {
        JsonSchemaExamples examplesAnnotation;
        String defaultValue;
        DecimalMax decimalMaxAnnotation;
        DecimalMin decimalMinAnnotation;
        Max maxAnnotation;
        log.trace("expectNumberFormat");
        this.node.put("type", "number");
        Min minAnnotation = this.tryGetAnnotation(Min.class);
        if (minAnnotation != null) {
            this.node.put("minimum", minAnnotation.value());
        }
        if ((maxAnnotation = this.tryGetAnnotation(Max.class)) != null) {
            this.node.put("maximum", maxAnnotation.value());
        }
        if ((decimalMinAnnotation = this.tryGetAnnotation(DecimalMin.class)) != null) {
            this.node.put("minimum", Double.valueOf(decimalMinAnnotation.value()));
        }
        if ((decimalMaxAnnotation = this.tryGetAnnotation(DecimalMax.class)) != null) {
            this.node.put("maximum", Double.valueOf(decimalMaxAnnotation.value()));
        }
        if ((defaultValue = this.extractDefaultValue()) != null) {
            this.node.put("default", Double.valueOf(defaultValue));
        }
        if (this.currentProperty != null && (examplesAnnotation = (JsonSchemaExamples)this.currentProperty.getAnnotation(JsonSchemaExamples.class)) != null) {
            ArrayNode examples = JsonNodeFactory.instance.arrayNode();
            for (String example : examplesAnnotation.value()) {
                examples.add(example);
            }
            this.node.set("examples", (JsonNode)examples);
        }
        return new MyJsonValueFormatVisitor();
    }

    public JsonAnyFormatVisitor expectAnyFormat(JavaType type) {
        log.warn("Unable to process {} - it is probably using custom serializer which does not override acceptJsonFormatVisitor", (Object)type);
        return new JsonAnyFormatVisitor(){};
    }

    public JsonIntegerFormatVisitor expectIntegerFormat(JavaType type) {
        JsonSchemaExamples examplesAnnotation;
        String defaultValue;
        Max maxAnnotation;
        log.trace("expectIntegerFormat");
        this.node.put("type", "integer");
        Min minAnnotation = this.tryGetAnnotation(Min.class);
        if (minAnnotation != null) {
            this.node.put("minimum", minAnnotation.value());
        }
        if ((maxAnnotation = this.tryGetAnnotation(Max.class)) != null) {
            this.node.put("maximum", maxAnnotation.value());
        }
        if ((defaultValue = this.extractDefaultValue()) != null) {
            this.node.put("default", Integer.valueOf(defaultValue));
        }
        if (this.currentProperty != null && (examplesAnnotation = (JsonSchemaExamples)this.currentProperty.getAnnotation(JsonSchemaExamples.class)) != null) {
            ArrayNode examples = JsonNodeFactory.instance.arrayNode();
            for (String example : examplesAnnotation.value()) {
                examples.add(example);
            }
            this.node.set("examples", (JsonNode)examples);
        }
        return new MyJsonValueFormatVisitor();
    }

    public JsonNullFormatVisitor expectNullFormat(JavaType type) {
        log.trace("expectNullFormat {}", (Object)type);
        this.node.put("type", "null");
        return new JsonNullFormatVisitor.Base();
    }

    public JsonBooleanFormatVisitor expectBooleanFormat(JavaType type) {
        log.trace("expectBooleanFormat");
        this.node.put("type", "boolean");
        String defaultValue = this.extractDefaultValue();
        if (defaultValue != null) {
            this.node.put("default", Boolean.valueOf(defaultValue));
        }
        return new MyJsonValueFormatVisitor();
    }

    public JsonMapFormatVisitor expectMapFormat(JavaType type) throws JsonMappingException {
        String defaultValue;
        log.trace("expectMapFormat {}", (Object)type);
        this.node.put("type", "object");
        NotEmpty notEmptyAnnotation = this.tryGetAnnotation(NotEmpty.class);
        if (notEmptyAnnotation != null) {
            this.node.put("minProperties", 1);
        }
        if ((defaultValue = this.extractDefaultValue()) != null) {
            this.node.put("default", defaultValue);
        }
        ObjectNode additionalPropsObject = JsonNodeFactory.instance.objectNode();
        this.definitionsHandler.pushWorkInProgress();
        JsonSchemaGeneratorVisitor childVisitor = this.createChildVisitor(additionalPropsObject, null);
        this.ctx.objectMapper.acceptJsonFormatVisitor(this.ctx.tryToReMapType(type.getContentType()), (JsonFormatVisitorWrapper)childVisitor);
        this.definitionsHandler.popworkInProgress();
        this.node.set("additionalProperties", (JsonNode)additionalPropsObject);
        class MapVisitor
        extends AbstractJsonFormatVisitorWithSerializerProvider
        implements JsonMapFormatVisitor {
            MapVisitor() {
            }

            public void keyFormat(JsonFormatVisitable handler, JavaType keyType) {
                log.trace("JsonMapFormatVisitor.keyFormat handler: $handler - keyType: $keyType");
            }

            public void valueFormat(JsonFormatVisitable handler, JavaType valueType) {
                log.trace("JsonMapFormatVisitor.valueFormat handler: $handler - valueType: $valueType");
            }
        }
        return new MapVisitor();
    }

    private PolymorphismInfo extractPolymorphismInfo(JavaType type) throws JsonMappingException {
        JavaType baseType = Utils.getSuperClass(type);
        if (baseType == null) {
            return null;
        }
        TypeSerializer serializer = this.ctx.getTypeSerializer(baseType);
        if (serializer == null) {
            return null;
        }
        JsonTypeInfo.As inclusionMethod = serializer.getTypeInclusion();
        if (inclusionMethod == JsonTypeInfo.As.PROPERTY || inclusionMethod == JsonTypeInfo.As.EXISTING_PROPERTY) {
            TypeIdResolver idResolver = serializer.getTypeIdResolver();
            assert (idResolver != null);
            String id = idResolver instanceof MinimalClassNameIdResolver ? Utils.extractMinimalClassnameId(baseType, type) : idResolver.idFromValueAndType(null, type.getRawClass());
            return new PolymorphismInfo(serializer.getPropertyName(), id);
        }
        throw new IllegalStateException("We do not support polymorphism using jsonTypeInfo.include() = " + inclusionMethod);
    }

    private List<Class<?>> extractSubTypes(JavaType type) {
        return this.extractSubTypes(type.getRawClass());
    }

    private List<Class<?>> extractSubTypes(Class<?> type) {
        AnnotatedClass ac = AnnotatedClassResolver.resolveWithoutSuperTypes((MapperConfig)this.ctx.objectMapper.getDeserializationConfig(), type, (ClassIntrospector.MixInResolver)this.ctx.objectMapper.getDeserializationConfig());
        JsonTypeInfo jsonTypeInfo = (JsonTypeInfo)ac.getAnnotation(JsonTypeInfo.class);
        if (jsonTypeInfo == null) {
            return Collections.unmodifiableList(new ArrayList());
        }
        if (jsonTypeInfo.use() == JsonTypeInfo.Id.NAME) {
            JsonSubTypes subTypeAnn = type.getDeclaredAnnotation(JsonSubTypes.class);
            if (subTypeAnn == null) {
                Collection resolvedSubTypes = this.ctx.objectMapper.getSubtypeResolver().collectAndResolveSubtypesByClass((MapperConfig)this.ctx.objectMapper.getDeserializationConfig(), ac);
                return resolvedSubTypes.stream().map(e -> e.getType()).filter(c -> type.isAssignableFrom((Class<?>)c) && type != c).collect(Collectors.toList());
            }
            JsonSubTypes.Type[] subTypes = subTypeAnn.value();
            return Stream.of(subTypes).map(subType -> subType.value()).flatMap(subType -> {
                List<Class<?>> subSubTypes = this.extractSubTypes((Class<?>)subType);
                if (!subSubTypes.isEmpty()) {
                    return subSubTypes.stream();
                }
                return Stream.of(subType);
            }).collect(Collectors.toList());
        }
        return this.ctx.config.subclassesResolver.getSubclasses(type);
    }

    public JsonObjectFormatVisitor expectObjectFormat(JavaType type) throws JsonMappingException {
        List<Class<?>> subTypes;
        String defaultValue = this.extractDefaultValue();
        if (defaultValue != null) {
            this.node.put("default", defaultValue);
        }
        if (!(subTypes = this.extractSubTypes(type)).isEmpty()) {
            ArrayNode anyOfArrayNode = JsonNodeFactory.instance.arrayNode();
            this.node.set("oneOf", (JsonNode)anyOfArrayNode);
            for (Class<?> subType : subTypes) {
                log.trace("polymorphism - subType: $subType");
                DefinitionsHandler.DefinitionInfo definitionInfo = this.definitionsHandler.getOrCreateDefinition(this.ctx.objectMapper.constructType(subType), (t, objectNode) -> {
                    JsonSchemaGeneratorVisitor childVisitor = this.createChildVisitor(objectNode, null);
                    this.ctx.objectMapper.acceptJsonFormatVisitor(this.ctx.tryToReMapType(subType), (JsonFormatVisitorWrapper)childVisitor);
                    return null;
                });
                ObjectNode thisOneOfNode = JsonNodeFactory.instance.objectNode();
                thisOneOfNode.put("$ref", definitionInfo.ref());
                JsonSchemaTitle titleAnnotation = subType.getDeclaredAnnotation(JsonSchemaTitle.class);
                if (titleAnnotation != null) {
                    thisOneOfNode.put("title", titleAnnotation.value());
                }
                anyOfArrayNode.add((JsonNode)thisOneOfNode);
            }
            return null;
        }
        if (this.level == 0) {
            return this.objectBuilder(type, this.node);
        }
        DefinitionsHandler.DefinitionInfo definitionInfo = this.definitionsHandler.getOrCreateDefinition(type, this::objectBuilder);
        if (definitionInfo.ref() != null) {
            this.node.put("$ref", definitionInfo.ref());
        }
        return definitionInfo.jsonObjectFormatVisitor();
    }

    private JsonObjectFormatVisitor objectBuilder(JavaType type, final ObjectNode thisObjectNode) throws JsonMappingException {
        JsonSchemaInject injectAnnotation;
        boolean injectOverridesAll;
        JsonSchemaOptions optionsAnnotation;
        JsonSchemaDescription descriptionAnnotation;
        thisObjectNode.put("type", "object");
        thisObjectNode.put("additionalProperties", !this.ctx.config.failOnUnknownProperties);
        AnnotatedClass ac = AnnotatedClassResolver.resolve((MapperConfig)this.ctx.objectMapper.getDeserializationConfig(), (JavaType)type, (ClassIntrospector.MixInResolver)this.ctx.objectMapper.getDeserializationConfig());
        String format = this.ctx.resolvePropertyFormat(type);
        if (format != null) {
            thisObjectNode.put("format", format);
        }
        if ((descriptionAnnotation = (JsonSchemaDescription)ac.getAnnotations().get(JsonSchemaDescription.class)) != null) {
            thisObjectNode.put("description", descriptionAnnotation.value());
        } else {
            JsonPropertyDescription descriptionAnnotation2 = (JsonPropertyDescription)ac.getAnnotations().get(JsonPropertyDescription.class);
            if (descriptionAnnotation2 != null) {
                thisObjectNode.put("description", descriptionAnnotation2.value());
            }
        }
        JsonSchemaTitle titleAnnotation = (JsonSchemaTitle)ac.getAnnotations().get(JsonSchemaTitle.class);
        if (titleAnnotation != null) {
            thisObjectNode.put("title", titleAnnotation.value());
        }
        if ((optionsAnnotation = (JsonSchemaOptions)ac.getAnnotations().get(JsonSchemaOptions.class)) != null) {
            ObjectNode optionsNode = Utils.getOptionsNode(thisObjectNode);
            for (JsonSchemaOptions.Item item : optionsAnnotation.items()) {
                optionsNode.put(item.name(), item.value());
            }
        }
        if (injectOverridesAll = (injectAnnotation = this.ctx.selectAnnotation(ac, JsonSchemaInject.class)) != null ? this.ctx.injectFromAnnotation(thisObjectNode, injectAnnotation) : false) {
            return null;
        }
        final ObjectNode propertiesNode = Utils.getOrCreateObjectChild(thisObjectNode, "properties");
        PolymorphismInfo polyInfo = this.extractPolymorphismInfo(type);
        if (polyInfo != null) {
            thisObjectNode.put("title", polyInfo.subTypeName);
            ArrayNode enumValuesNode = JsonNodeFactory.instance.arrayNode();
            enumValuesNode.add(polyInfo.subTypeName);
            ObjectNode enumObjectNode = Utils.getOrCreateObjectChild(propertiesNode, polyInfo.typePropertyName);
            enumObjectNode.put("type", "string");
            enumObjectNode.set("enum", (JsonNode)enumValuesNode);
            enumObjectNode.put("default", polyInfo.subTypeName);
            if (this.ctx.config.hidePolymorphismTypeProperty) {
                ObjectNode optionsNode = JsonNodeFactory.instance.objectNode();
                enumObjectNode.set("options", (JsonNode)optionsNode);
                optionsNode.put("hidden", true);
            }
            Utils.getRequiredArrayNode(thisObjectNode).add(polyInfo.typePropertyName);
            if (this.ctx.config.useMultipleEditorSelectViaProperty) {
                ObjectNode objectOptionsNode = Utils.getOrCreateObjectChild(thisObjectNode, "options");
                ObjectNode multipleEditorSelectViaPropertyNode = Utils.getOrCreateObjectChild(objectOptionsNode, "multiple_editor_select_via_property");
                multipleEditorSelectViaPropertyNode.put("property", polyInfo.typePropertyName);
                multipleEditorSelectViaPropertyNode.put("value", polyInfo.subTypeName);
            }
        }
        class MyObjectVisitor
        extends AbstractJsonFormatVisitorWithSerializerProvider
        implements JsonObjectFormatVisitor {
            int nextPropertyOrderIndex = 1;

            MyObjectVisitor() {
            }

            public void optionalProperty(BeanProperty prop) throws JsonMappingException {
                log.trace("JsonObjectFormatVisitor.optionalProperty: prop: {}", (Object)prop);
                this.handleProperty(prop.getName(), prop.getType(), prop, false);
            }

            public void optionalProperty(String name, JsonFormatVisitable handler, JavaType propertyTypeHint) throws JsonMappingException {
                log.trace("JsonObjectFormatVisitor.optionalProperty: name:{} handler:{} propertyTypeHint:{}", new Object[]{name, handler, propertyTypeHint});
                this.handleProperty(name, propertyTypeHint, null, false);
            }

            public void property(BeanProperty prop) throws JsonMappingException {
                log.trace("JsonObjectFormatVisitor.property: prop:{}", (Object)prop);
                this.handleProperty(prop.getName(), prop.getType(), prop, true);
            }

            public void property(String name, JsonFormatVisitable handler, JavaType propertyTypeHint) throws JsonMappingException {
                log.trace("JsonObjectFormatVisitor.property: name:{} handler:{} propertyTypeHint:{}", new Object[]{name, handler, propertyTypeHint});
                this.handleProperty(name, propertyTypeHint, null, true);
            }

            void handleProperty(String propertyName, JavaType propertyType, BeanProperty prop, Boolean jsonPropertyRequired) throws JsonMappingException {
                JsonSchemaInject injectAnn2;
                JsonSchemaInject injectAnn;
                JsonSchemaAdditional additionalAnn;
                class PropertyNode {
                    private final ObjectNode main;
                    private final ObjectNode meta;

                    public PropertyNode(ObjectNode main, ObjectNode meta) {
                        this.main = main;
                        this.meta = meta;
                    }

                    public ObjectNode main() {
                        return this.main;
                    }

                    public ObjectNode meta() {
                        return this.meta;
                    }

                    public boolean equals(Object o) {
                        if (o == this) {
                            return true;
                        }
                        if (!(o instanceof PropertyNode)) {
                            return false;
                        }
                        PropertyNode other = (PropertyNode)o;
                        if (!other.canEqual(this)) {
                            return false;
                        }
                        ObjectNode this$main = this.main();
                        ObjectNode other$main = other.main();
                        if (this$main == null ? other$main != null : !this$main.equals(other$main)) {
                            return false;
                        }
                        ObjectNode this$meta = this.meta();
                        ObjectNode other$meta = other.meta();
                        return !(this$meta == null ? other$meta != null : !this$meta.equals(other$meta));
                    }

                    protected boolean canEqual(Object other) {
                        return other instanceof PropertyNode;
                    }

                    public int hashCode() {
                        int PRIME = 59;
                        int result = 1;
                        ObjectNode $main = this.main();
                        result = result * 59 + ($main == null ? 43 : $main.hashCode());
                        ObjectNode $meta = this.meta();
                        result = result * 59 + ($meta == null ? 43 : $meta.hashCode());
                        return result;
                    }

                    public String toString() {
                        return "PropertyNode(main=" + this.main() + ", meta=" + this.meta() + ")";
                    }
                }
                PropertyNode thisPropertyNode;
                log.trace("JsonObjectFormatVisitor - {}: {}", (Object)propertyName, (Object)propertyType);
                if (propertiesNode.get(propertyName) != null) {
                    log.debug("Ignoring property '{}' in $propertyType since it has already been added, probably as type-property using polymorphism", (Object)propertyName);
                    return;
                }
                boolean requiredProperty = propertyType.getRawClass().isPrimitive() || jsonPropertyRequired != false || JsonSchemaGeneratorVisitor.this.ctx.validationAnnotationRequired(prop);
                boolean optionalType = Optional.class.isAssignableFrom(propertyType.getRawClass()) || propertyType.getRawClass().getName().equals("scala.Option");
                ObjectNode node = JsonNodeFactory.instance.objectNode();
                propertiesNode.set(propertyName, (JsonNode)node);
                if (JsonSchemaGeneratorVisitor.this.ctx.config.usePropertyOrdering) {
                    node.put("propertyOrder", this.nextPropertyOrderIndex);
                    ++this.nextPropertyOrderIndex;
                }
                if (!requiredProperty && (JsonSchemaGeneratorVisitor.this.ctx.config.useOneOfForOption && optionalType || JsonSchemaGeneratorVisitor.this.ctx.config.useOneOfForNullables && !optionalType)) {
                    ArrayNode oneOfArray = JsonNodeFactory.instance.arrayNode();
                    node.set("oneOf", (JsonNode)oneOfArray);
                    ObjectNode oneOfNull = JsonNodeFactory.instance.objectNode();
                    oneOfNull.put("type", "null");
                    oneOfNull.put("title", "Not included");
                    oneOfArray.add((JsonNode)oneOfNull);
                    ObjectNode oneOfReal = JsonNodeFactory.instance.objectNode();
                    oneOfArray.add((JsonNode)oneOfReal);
                    thisPropertyNode = new PropertyNode(oneOfReal, node);
                } else {
                    thisPropertyNode = new PropertyNode(node, node);
                }
                JsonSchemaGeneratorVisitor childVisitor = JsonSchemaGeneratorVisitor.this.createChildVisitor(thisPropertyNode.main, prop);
                JsonSchemaGeneratorVisitor.this.definitionsHandler.pushWorkInProgress();
                if ((Optional.class.isAssignableFrom(propertyType.getRawClass()) || propertyType.getRawClass().getName().equals("scala.Option")) && propertyType.containedTypeCount() >= 1) {
                    JavaType optionType = Utils.resolveElementType(propertyType, prop, JsonSchemaGeneratorVisitor.this.ctx.objectMapper);
                    JsonSchemaGeneratorVisitor.this.ctx.objectMapper.acceptJsonFormatVisitor(JsonSchemaGeneratorVisitor.this.ctx.tryToReMapType(optionType), (JsonFormatVisitorWrapper)childVisitor);
                } else {
                    JsonSchemaGeneratorVisitor.this.ctx.objectMapper.acceptJsonFormatVisitor(JsonSchemaGeneratorVisitor.this.ctx.tryToReMapType(propertyType), (JsonFormatVisitorWrapper)childVisitor);
                }
                JsonSchemaGeneratorVisitor.this.definitionsHandler.popworkInProgress();
                if (requiredProperty) {
                    Utils.getRequiredArrayNode(thisObjectNode).add(propertyName);
                }
                if (prop == null) {
                    return;
                }
                String format = JsonSchemaGeneratorVisitor.this.ctx.resolvePropertyFormat(prop);
                if (format != null) {
                    thisPropertyNode.main.put("format", format);
                }
                JsonSchemaDescription descriptionAnn = (JsonSchemaDescription)prop.getAnnotation(JsonSchemaDescription.class);
                JsonPropertyDescription descriptionAnn2 = (JsonPropertyDescription)prop.getAnnotation(JsonPropertyDescription.class);
                if (descriptionAnn != null) {
                    thisPropertyNode.meta.put("description", descriptionAnn.value());
                } else if (descriptionAnn2 != null) {
                    thisPropertyNode.meta.put("description", descriptionAnn2.value());
                }
                JsonSchemaTitle titleAnn = (JsonSchemaTitle)prop.getAnnotation(JsonSchemaTitle.class);
                if (titleAnn != null) {
                    thisPropertyNode.meta.put("title", titleAnn.value());
                } else if (JsonSchemaGeneratorVisitor.this.ctx.config.autoGenerateTitleForProperties) {
                    String title = Utils.camelCaseToSentenceCase(propertyName);
                    thisPropertyNode.meta.put("title", title);
                }
                JsonSchemaOptions optionsAnn = (JsonSchemaOptions)prop.getAnnotation(JsonSchemaOptions.class);
                if (optionsAnn != null) {
                    ObjectNode optionsNode = Utils.getOrCreateObjectChild(thisPropertyNode.meta, "options");
                    for (JsonSchemaOptions.Item option : optionsAnn.items()) {
                        optionsNode.put(option.name(), option.value());
                    }
                }
                if ((additionalAnn = (JsonSchemaAdditional)prop.getAnnotation(JsonSchemaAdditional.class)) != null) {
                    ObjectNode optionsNode = Utils.getOrCreateObjectChild(thisPropertyNode.meta, "options");
                    optionsNode.put("additional", true);
                }
                if ((injectAnn = JsonSchemaGeneratorVisitor.this.ctx.selectAnnotation(prop, JsonSchemaInject.class)) == null && (injectAnn2 = prop.getType().getRawClass().getAnnotation(JsonSchemaInject.class)) != null && JsonSchemaGeneratorVisitor.this.ctx.annotationIsApplicable(injectAnn2)) {
                    injectAnn = injectAnn2;
                }
                if (injectAnn != null) {
                    JsonSchemaGeneratorVisitor.this.ctx.injectFromAnnotation(thisPropertyNode.meta, injectAnn);
                }
            }
        }
        return new MyObjectVisitor();
    }

    public JsonSchemaGeneratorVisitor(JsonSchemaGenerator ctx, int level, ObjectNode node, DefinitionsHandler definitionsHandler, BeanProperty currentProperty) {
        this.ctx = ctx;
        this.level = level;
        this.node = node;
        this.definitionsHandler = definitionsHandler;
        this.currentProperty = currentProperty;
    }

    static class PolymorphismInfo {
        private final String typePropertyName;
        private final String subTypeName;

        public PolymorphismInfo(String typePropertyName, String subTypeName) {
            this.typePropertyName = typePropertyName;
            this.subTypeName = subTypeName;
        }

        public String typePropertyName() {
            return this.typePropertyName;
        }

        public String subTypeName() {
            return this.subTypeName;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PolymorphismInfo)) {
                return false;
            }
            PolymorphismInfo other = (PolymorphismInfo)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$typePropertyName = this.typePropertyName();
            String other$typePropertyName = other.typePropertyName();
            if (this$typePropertyName == null ? other$typePropertyName != null : !this$typePropertyName.equals(other$typePropertyName)) {
                return false;
            }
            String this$subTypeName = this.subTypeName();
            String other$subTypeName = other.subTypeName();
            return !(this$subTypeName == null ? other$subTypeName != null : !this$subTypeName.equals(other$subTypeName));
        }

        protected boolean canEqual(Object other) {
            return other instanceof PolymorphismInfo;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $typePropertyName = this.typePropertyName();
            result = result * 59 + ($typePropertyName == null ? 43 : $typePropertyName.hashCode());
            String $subTypeName = this.subTypeName();
            result = result * 59 + ($subTypeName == null ? 43 : $subTypeName.hashCode());
            return result;
        }

        public String toString() {
            return "JsonSchemaGeneratorVisitor.PolymorphismInfo(typePropertyName=" + this.typePropertyName() + ", subTypeName=" + this.subTypeName() + ")";
        }
    }

    class MyJsonValueFormatVisitor
    extends AbstractJsonFormatVisitorWithSerializerProvider
    implements JsonStringFormatVisitor,
    JsonNumberFormatVisitor,
    JsonIntegerFormatVisitor,
    JsonBooleanFormatVisitor {
        MyJsonValueFormatVisitor() {
        }

        public void format(JsonValueFormat format) {
            JsonSchemaGeneratorVisitor.this.node.put("format", format.toString());
        }

        public void enumTypes(Set<String> enums) {
            log.trace("JsonStringFormatVisitor-enum.enumTypes: {}", enums);
            ArrayNode enumValuesNode = JsonNodeFactory.instance.arrayNode();
            for (String e : enums) {
                enumValuesNode.add(e);
            }
            JsonSchemaGeneratorVisitor.this.node.set("enum", (JsonNode)enumValuesNode);
        }

        public void numberType(JsonParser.NumberType type) {
            log.trace("JsonNumberFormatVisitor.numberType: {}", (Object)type);
        }
    }
}

