/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.security.trustservice.store.data;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class IdentityProvider {
    private final String orgId;
    private final String providerId;
    private final String issuer;
    private final String subjectClaim;
    private final String jwksEndpoint;

    @JsonCreator
    public IdentityProvider(@JsonProperty(value="orgId") String orgId, @JsonProperty(value="providerId") String providerId, @JsonProperty(value="issuer") String issuer, @JsonProperty(value="jwksEndpoint") String jwksEndpoint, @JsonProperty(value="subjectClaim") String subjectClaim) {
        this.orgId = orgId;
        this.providerId = providerId;
        this.issuer = issuer;
        this.jwksEndpoint = jwksEndpoint;
        this.subjectClaim = subjectClaim == null ? "sub" : subjectClaim;
    }

    @JsonProperty(value="orgId")
    public String orgId() {
        return this.orgId;
    }

    @JsonProperty(value="providerId")
    public String providerId() {
        return this.providerId;
    }

    @JsonProperty(value="issuer")
    public String issuer() {
        return this.issuer;
    }

    @JsonProperty(value="subjectClaim")
    public String subjectClaim() {
        return this.subjectClaim;
    }

    @JsonProperty(value="jwksEndpoint")
    public String jwksEndpoint() {
        return this.jwksEndpoint;
    }

    public int hashCode() {
        return Objects.hash(this.providerId, this.orgId, this.issuer, this.jwksEndpoint, this.subjectClaim);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IdentityProvider)) {
            return false;
        }
        IdentityProvider that = (IdentityProvider)o;
        return Objects.equals(this.providerId, that.providerId) && Objects.equals(this.issuer, that.issuer) && Objects.equals(this.jwksEndpoint, that.jwksEndpoint) && Objects.equals(this.subjectClaim, that.subjectClaim) && Objects.equals(this.orgId, that.orgId);
    }
}

