/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.version.metrics;

import io.confluent.ksql.version.metrics.KsqlVersionChecker;
import io.confluent.ksql.version.metrics.VersionCheckerAgent;
import io.confluent.ksql.version.metrics.collector.KsqlModuleType;
import io.confluent.support.metrics.BaseSupportConfig;
import io.confluent.support.metrics.PhoneHomeConfig;
import java.time.Clock;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class KsqlVersionCheckerAgent
implements VersionCheckerAgent {
    private static final long MAX_INTERVAL = TimeUnit.DAYS.toMillis(1L);
    private final boolean enableSettlingTime;
    private final Clock clock;
    private final VersionCheckerFactory versionCheckerFactory;
    private volatile long requestTime;
    private final Supplier<Boolean> activeQuerySupplier;
    private static final Logger log = LogManager.getLogger(KsqlVersionCheckerAgent.class);

    public KsqlVersionCheckerAgent(Supplier<Boolean> activeQuerySupplier) {
        this(activeQuerySupplier, true, Clock.systemDefaultZone(), KsqlVersionChecker::new);
    }

    KsqlVersionCheckerAgent(Supplier<Boolean> activeQuerySupplier, boolean enableSettlingTime, Clock clock, VersionCheckerFactory versionCheckerFactory) {
        this.enableSettlingTime = enableSettlingTime;
        this.activeQuerySupplier = Objects.requireNonNull(activeQuerySupplier, "activeQuerySupplier");
        this.clock = Objects.requireNonNull(clock, "clock");
        this.versionCheckerFactory = Objects.requireNonNull(versionCheckerFactory, "versionCheckerFactory");
    }

    @Override
    public void start(KsqlModuleType moduleType, Properties ksqlProperties) {
        PhoneHomeConfig ksqlVersionCheckerConfig = new PhoneHomeConfig(ksqlProperties, "ksql");
        if (!ksqlVersionCheckerConfig.isProactiveSupportEnabled()) {
            log.warn(KsqlVersionCheckerAgent.legalDisclaimerProactiveSupportDisabled());
            return;
        }
        try {
            KsqlVersionChecker ksqlVersionChecker = this.versionCheckerFactory.create(ksqlVersionCheckerConfig, moduleType, this.enableSettlingTime, this::isActive);
            ksqlVersionChecker.init();
            ksqlVersionChecker.setUncaughtExceptionHandler((t, e) -> log.error("Uncaught exception in thread '{}':", (Object)t.getName(), (Object)e));
            ksqlVersionChecker.start();
            long reportIntervalMs = ksqlVersionCheckerConfig.getReportIntervalMs();
            long reportIntervalHours = reportIntervalMs / 3600000L;
            log.warn(KsqlVersionCheckerAgent.legalDisclaimerProactiveSupportEnabled(reportIntervalHours));
        }
        catch (Exception e2) {
            log.error("Failed to start KsqlVersionCheckerAgent: {}", (Object)e2.getMessage());
        }
    }

    private static String legalDisclaimerProactiveSupportEnabled(long reportIntervalHours) {
        return "Please note that the version check feature of KSQL is enabled.  With this enabled, this instance is configured to collect and report anonymously the version information to Confluent, Inc. (\"Confluent\") or its parent, subsidiaries, affiliates or service providers every " + reportIntervalHours + "hours.  This Metadata may be transferred to any country in which Confluent maintains facilities.  For a more in depth discussion of how Confluent processes such information, please read our Privacy Policy located at http://www.confluent.io/privacy. By proceeding with `confluent.support.metrics.enable=true`, you agree to all such collection, transfer and use of Version information by Confluent. You can turn the version check  feature off by setting `confluent.support.metrics.enable=false` in the KSQL configuration and restarting the KSQL.  See the Confluent Platform documentation for further information.";
    }

    private static String legalDisclaimerProactiveSupportDisabled() {
        return "The version check feature of KSQL  is disabled.";
    }

    @Override
    public void updateLastRequestTime() {
        this.requestTime = this.clock.millis();
    }

    private boolean hasRecentRequests() {
        return this.clock.millis() - this.requestTime < MAX_INTERVAL;
    }

    private boolean isActive() {
        return this.hasRecentRequests() || this.activeQuerySupplier.get() != false;
    }

    @FunctionalInterface
    static interface VersionCheckerFactory {
        public KsqlVersionChecker create(BaseSupportConfig var1, KsqlModuleType var2, boolean var3, Supplier<Boolean> var4);
    }
}

