/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.client.rest.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;

public class UrlList {
    private final Random random = new Random();
    private final AtomicInteger index;
    private final List<String> urls;

    public UrlList(List<String> urls) {
        if (urls == null || urls.isEmpty()) {
            throw new IllegalArgumentException("Expected at least one URL to be passed in constructor");
        }
        this.urls = new ArrayList<String>(urls);
        this.index = new AtomicInteger(0);
    }

    public UrlList(String url) {
        this(Collections.singletonList(url));
    }

    public void randomizeIndex() {
        this.index.set(this.random.nextInt(this.urls.size()));
    }

    public List<String> urls() {
        return this.urls;
    }

    public String current() {
        return this.urls.get(this.index.get());
    }

    public void fail(String url) {
        int currentIndex = this.index.get();
        if (this.urls.get(currentIndex).equals(url)) {
            this.index.compareAndSet(currentIndex, (currentIndex + 1) % this.urls.size());
        }
    }

    public int size() {
        return this.urls.size();
    }

    public String toString() {
        return String.join((CharSequence)",", this.urls);
    }
}

