/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.metastore;

import com.google.common.collect.Iterators;
import io.confluent.ksql.schema.ksql.types.SqlType;
import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;

public interface TypeRegistry {
    public static final TypeRegistry EMPTY = new TypeRegistry(){

        @Override
        public boolean registerType(String name, SqlType type) {
            return false;
        }

        @Override
        public boolean deleteType(String name) {
            return false;
        }

        @Override
        public Optional<SqlType> resolveType(String name) {
            return Optional.empty();
        }

        @Override
        public Iterator<CustomType> types() {
            return Iterators.forArray((Object[])new CustomType[0]);
        }
    };

    public boolean registerType(String var1, SqlType var2);

    public boolean deleteType(String var1);

    public Optional<SqlType> resolveType(String var1);

    public Iterator<CustomType> types();

    public static class CustomType {
        private final String name;
        private final SqlType type;

        public CustomType(String name, SqlType type) {
            this.name = Objects.requireNonNull(name, "name");
            this.type = Objects.requireNonNull(type, "type");
        }

        public String getName() {
            return this.name;
        }

        public SqlType getType() {
            return this.type;
        }
    }
}

