/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.avro;

import io.confluent.connect.schema.AbstractDataConfig;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.common.config.ConfigDef;

public class AvroDataConfig
extends AbstractDataConfig {
    public static final String ENHANCED_AVRO_SCHEMA_SUPPORT_CONFIG = "enhanced.avro.schema.support";
    public static final boolean ENHANCED_AVRO_SCHEMA_SUPPORT_DEFAULT = false;
    public static final String ENHANCED_AVRO_SCHEMA_SUPPORT_DOC = "Toggle for enabling/disabling enhanced avro schema support: Enum symbol preservation and Package Name awareness";
    public static final String SCRUB_INVALID_NAMES_CONFIG = "scrub.invalid.names";
    public static final boolean SCRUB_INVALID_NAMES_DEFAULT = false;
    public static final String SCRUB_INVALID_NAMES_DOC = "Whether to scrub invalid names by replacing invalid characters with valid ones";
    public static final String CONNECT_META_DATA_CONFIG = "connect.meta.data";
    public static final boolean CONNECT_META_DATA_DEFAULT = true;
    public static final String CONNECT_META_DATA_DOC = "Toggle for enabling/disabling connect converter to add its meta data to the output schema or not";
    public static final String ALLOW_OPTIONAL_MAP_KEYS_CONFIG = "allow.optional.map.keys";
    public static final boolean ALLOW_OPTIONAL_MAP_KEYS_DEFAULT = false;
    public static final String ALLOW_OPTIONAL_MAP_KEYS_DOC = "Allow optional string map key when converting from Connect Schema to Avro Schema.";
    public static final String FLATTEN_SINGLETON_UNIONS_CONFIG = "flatten.singleton.unions";
    public static final boolean FLATTEN_SINGLETON_UNIONS_DEFAULT = true;
    public static final String FLATTEN_SINGLETON_UNIONS_DOC = "Whether to flatten singleton unions";
    @Deprecated
    public static final String DISCARD_TYPE_DOC_DEFAULT_CONFIG = "discard.type.doc.default";
    public static final boolean DISCARD_TYPE_DOC_DEFAULT_DEFAULT = false;
    public static final String DISCARD_TYPE_DOC_DEFAULT_DOC = "Only Avro field doc and default will be retained during conversion of Avro and Connect schema.";

    public static ConfigDef baseConfigDef() {
        return AbstractDataConfig.baseConfigDef().define(ENHANCED_AVRO_SCHEMA_SUPPORT_CONFIG, ConfigDef.Type.BOOLEAN, (Object)false, ConfigDef.Importance.MEDIUM, ENHANCED_AVRO_SCHEMA_SUPPORT_DOC).define(SCRUB_INVALID_NAMES_CONFIG, ConfigDef.Type.BOOLEAN, (Object)false, ConfigDef.Importance.MEDIUM, SCRUB_INVALID_NAMES_DOC).define(CONNECT_META_DATA_CONFIG, ConfigDef.Type.BOOLEAN, (Object)true, ConfigDef.Importance.LOW, CONNECT_META_DATA_DOC).define(DISCARD_TYPE_DOC_DEFAULT_CONFIG, ConfigDef.Type.BOOLEAN, (Object)false, ConfigDef.Importance.LOW, DISCARD_TYPE_DOC_DEFAULT_DOC).define(ALLOW_OPTIONAL_MAP_KEYS_CONFIG, ConfigDef.Type.BOOLEAN, (Object)false, ConfigDef.Importance.LOW, ALLOW_OPTIONAL_MAP_KEYS_DOC).define(FLATTEN_SINGLETON_UNIONS_CONFIG, ConfigDef.Type.BOOLEAN, (Object)true, ConfigDef.Importance.LOW, FLATTEN_SINGLETON_UNIONS_DOC);
    }

    public AvroDataConfig(Map<?, ?> props) {
        super(AvroDataConfig.baseConfigDef(), props);
    }

    public boolean isEnhancedAvroSchemaSupport() {
        return this.getBoolean(ENHANCED_AVRO_SCHEMA_SUPPORT_CONFIG);
    }

    public boolean isConnectMetaData() {
        return this.getBoolean(CONNECT_META_DATA_CONFIG);
    }

    public boolean isScrubInvalidNames() {
        return this.getBoolean(SCRUB_INVALID_NAMES_CONFIG);
    }

    public boolean isDiscardTypeDocDefault() {
        return this.getBoolean(DISCARD_TYPE_DOC_DEFAULT_CONFIG);
    }

    public boolean isAllowOptionalMapKeys() {
        return this.getBoolean(ALLOW_OPTIONAL_MAP_KEYS_CONFIG);
    }

    public boolean isFlattenSingletonUnions() {
        return this.getBoolean(FLATTEN_SINGLETON_UNIONS_CONFIG);
    }

    public static class Builder {
        private final Map<String, Object> props = new HashMap<String, Object>();

        public Builder with(String key, Object value) {
            this.props.put(key, value);
            return this;
        }

        public AvroDataConfig build() {
            return new AvroDataConfig(this.props);
        }
    }
}

