/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.transforms;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.kafka.common.cache.Cache;
import org.apache.kafka.common.cache.LRUCache;
import org.apache.kafka.common.cache.SynchronizedCache;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.utils.AppInfoParser;
import org.apache.kafka.common.utils.ConfigUtils;
import org.apache.kafka.connect.components.Versioned;
import org.apache.kafka.connect.connector.ConnectRecord;
import org.apache.kafka.connect.data.Field;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.transforms.Transformation;
import org.apache.kafka.connect.transforms.util.Requirements;
import org.apache.kafka.connect.transforms.util.SchemaUtil;
import org.apache.kafka.connect.transforms.util.SimpleConfig;

public abstract class ReplaceField<R extends ConnectRecord<R>>
implements Transformation<R>,
Versioned {
    public static final String OVERVIEW_DOC = "Filter or rename fields.<p/>Use the concrete transformation type designed for the record key (<code>" + Key.class.getName() + "</code>) or value (<code>" + Value.class.getName() + "</code>).";
    public static final ConfigDef CONFIG_DEF = new ConfigDef().define("exclude", ConfigDef.Type.LIST, Collections.emptyList(), ConfigDef.Importance.MEDIUM, "Fields to exclude. This takes precedence over the fields to include.").define("blacklist", ConfigDef.Type.LIST, null, ConfigDef.Importance.LOW, "Deprecated. Use exclude instead.").define("include", ConfigDef.Type.LIST, Collections.emptyList(), ConfigDef.Importance.MEDIUM, "Fields to include. If specified, only these fields will be used.").define("whitelist", ConfigDef.Type.LIST, null, ConfigDef.Importance.LOW, "Deprecated. Use include instead.").define("renames", ConfigDef.Type.LIST, Collections.emptyList(), (ConfigDef.Validator)ConfigDef.LambdaValidator.with((name, value) -> {
        List valueList = (List)value;
        ReplaceField.parseRenameMappings(valueList);
    }, () -> "list of colon-delimited pairs, e.g. <code>foo:bar,abc:xyz</code>"), ConfigDef.Importance.MEDIUM, "Field rename mappings.").define("replace.null.with.default", ConfigDef.Type.BOOLEAN, (Object)true, ConfigDef.Importance.MEDIUM, "Whether to replace fields that have a default value and that are null to the default value. When set to true, the default value is used, otherwise null is used.");
    private static final String PURPOSE = "field replacement";
    private Set<String> exclude;
    private Set<String> include;
    private Map<String, String> renames;
    private Map<String, String> reverseRenames;
    private boolean replaceNullWithDefault;
    private Cache<Schema, Schema> schemaUpdateCache;

    public String version() {
        return AppInfoParser.getVersion();
    }

    public void configure(Map<String, ?> configs) {
        SimpleConfig config = new SimpleConfig(CONFIG_DEF, ConfigUtils.translateDeprecatedConfigs(configs, (String[][])new String[][]{{"include", "whitelist"}, {"exclude", "blacklist"}}));
        this.exclude = new HashSet<String>(config.getList("exclude"));
        this.include = new HashSet<String>(config.getList("include"));
        this.renames = ReplaceField.parseRenameMappings(config.getList("renames"));
        this.reverseRenames = ReplaceField.invert(this.renames);
        this.replaceNullWithDefault = config.getBoolean("replace.null.with.default");
        this.schemaUpdateCache = new SynchronizedCache((Cache)new LRUCache(16));
    }

    static Map<String, String> parseRenameMappings(List<String> mappings) {
        HashMap<String, String> m = new HashMap<String, String>();
        for (String mapping : mappings) {
            String[] parts = mapping.split(":");
            if (parts.length != 2) {
                throw new ConfigException("renames", mappings, "Invalid rename mapping: " + mapping);
            }
            m.put(parts[0], parts[1]);
        }
        return m;
    }

    static Map<String, String> invert(Map<String, String> source) {
        HashMap<String, String> m = new HashMap<String, String>();
        for (Map.Entry<String, String> e : source.entrySet()) {
            m.put(e.getValue(), e.getKey());
        }
        return m;
    }

    boolean filter(String fieldName) {
        return !this.exclude.contains(fieldName) && (this.include.isEmpty() || this.include.contains(fieldName));
    }

    String renamed(String fieldName) {
        String mapping = this.renames.get(fieldName);
        return mapping == null ? fieldName : mapping;
    }

    String reverseRenamed(String fieldName) {
        String mapping = this.reverseRenames.get(fieldName);
        return mapping == null ? fieldName : mapping;
    }

    public R apply(R record) {
        if (this.operatingValue(record) == null) {
            return record;
        }
        if (this.operatingSchema(record) == null) {
            return this.applySchemaless(record);
        }
        return this.applyWithSchema(record);
    }

    private R applySchemaless(R record) {
        Map<String, Object> value = Requirements.requireMap(this.operatingValue(record), PURPOSE);
        HashMap<String, Object> updatedValue = new HashMap<String, Object>(value.size());
        for (Map.Entry<String, Object> e : value.entrySet()) {
            String fieldName = e.getKey();
            if (!this.filter(fieldName)) continue;
            Object fieldValue = e.getValue();
            updatedValue.put(this.renamed(fieldName), fieldValue);
        }
        return this.newRecord(record, null, updatedValue);
    }

    private R applyWithSchema(R record) {
        Struct value = Requirements.requireStruct(this.operatingValue(record), PURPOSE);
        Schema updatedSchema = (Schema)this.schemaUpdateCache.get((Object)value.schema());
        if (updatedSchema == null) {
            updatedSchema = this.makeUpdatedSchema(value.schema());
            this.schemaUpdateCache.put((Object)value.schema(), (Object)updatedSchema);
        }
        Struct updatedValue = new Struct(updatedSchema);
        for (Field field : updatedSchema.fields()) {
            Object fieldValue = this.replaceNullWithDefault ? value.get(this.reverseRenamed(field.name())) : value.getWithoutDefault(this.reverseRenamed(field.name()));
            updatedValue.put(field.name(), fieldValue);
        }
        return this.newRecord(record, updatedSchema, updatedValue);
    }

    private Schema makeUpdatedSchema(Schema schema) {
        SchemaBuilder builder = SchemaUtil.copySchemaBasics(schema, SchemaBuilder.struct());
        for (Field field : schema.fields()) {
            if (!this.filter(field.name())) continue;
            builder.field(this.renamed(field.name()), field.schema());
        }
        return builder.build();
    }

    public ConfigDef config() {
        return CONFIG_DEF;
    }

    public void close() {
        this.schemaUpdateCache = null;
    }

    protected abstract Schema operatingSchema(R var1);

    protected abstract Object operatingValue(R var1);

    protected abstract R newRecord(R var1, Schema var2, Object var3);

    static interface ConfigName {
        public static final String EXCLUDE = "exclude";
        public static final String INCLUDE = "include";
        public static final String RENAMES = "renames";
        public static final String REPLACE_NULL_WITH_DEFAULT_CONFIG = "replace.null.with.default";
    }

    public static class Key<R extends ConnectRecord<R>>
    extends ReplaceField<R> {
        @Override
        protected Schema operatingSchema(R record) {
            return record.keySchema();
        }

        @Override
        protected Object operatingValue(R record) {
            return record.key();
        }

        @Override
        protected R newRecord(R record, Schema updatedSchema, Object updatedValue) {
            return (R)record.newRecord(record.topic(), record.kafkaPartition(), updatedSchema, updatedValue, record.valueSchema(), record.value(), record.timestamp());
        }
    }

    public static class Value<R extends ConnectRecord<R>>
    extends ReplaceField<R> {
        @Override
        protected Schema operatingSchema(R record) {
            return record.valueSchema();
        }

        @Override
        protected Object operatingValue(R record) {
            return record.value();
        }

        @Override
        protected R newRecord(R record, Schema updatedSchema, Object updatedValue) {
            return (R)record.newRecord(record.topic(), record.kafkaPartition(), record.keySchema(), record.key(), updatedSchema, updatedValue, record.timestamp());
        }
    }
}

