/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.admin;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import org.apache.kafka.clients.admin.internals.CoordinatorKey;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.TopicPartition;

public class ListConsumerGroupOffsetsResult {
    final Map<String, KafkaFuture<Map<TopicPartition, OffsetAndMetadata>>> futures;

    ListConsumerGroupOffsetsResult(Map<CoordinatorKey, KafkaFuture<Map<TopicPartition, OffsetAndMetadata>>> futures) {
        this.futures = futures.entrySet().stream().collect(Collectors.toMap(e -> ((CoordinatorKey)e.getKey()).idValue, Map.Entry::getValue));
    }

    public KafkaFuture<Map<TopicPartition, OffsetAndMetadata>> partitionsToOffsetAndMetadata() {
        if (this.futures.size() != 1) {
            throw new IllegalStateException("Offsets from multiple consumer groups were requested. Use partitionsToOffsetAndMetadata(groupId) instead to get future for a specific group.");
        }
        return this.futures.values().iterator().next();
    }

    public KafkaFuture<Map<TopicPartition, OffsetAndMetadata>> partitionsToOffsetAndMetadata(String groupId) {
        if (!this.futures.containsKey(groupId)) {
            throw new IllegalArgumentException("Offsets for consumer group '" + groupId + "' were not requested.");
        }
        return this.futures.get(groupId);
    }

    public KafkaFuture<Map<String, Map<TopicPartition, OffsetAndMetadata>>> all() {
        return KafkaFuture.allOf(this.futures.values().toArray(new KafkaFuture[0])).thenApply(nil -> {
            HashMap listedConsumerGroupOffsets = new HashMap(this.futures.size());
            this.futures.forEach((key, future) -> {
                try {
                    listedConsumerGroupOffsets.put(key, (Map)future.get());
                }
                catch (InterruptedException | ExecutionException e) {
                    throw new RuntimeException(e);
                }
            });
            return listedConsumerGroupOffsets;
        });
    }
}

