/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.admin;

import java.util.ArrayList;
import java.util.List;
import org.apache.kafka.clients.admin.PartitionTruncationInformation;
import org.apache.kafka.common.Confluent;
import org.apache.kafka.common.annotation.InterfaceStability;
import org.apache.kafka.common.message.AlterMirrorsResponseData;

@InterfaceStability.Evolving
@Confluent
public class TruncateAndRestoreResult {
    private final long messagesTruncated;
    private final List<PartitionTruncationInformation> partitionLevelTruncationData;

    public TruncateAndRestoreResult(AlterMirrorsResponseData.AlterMirrorResult result) {
        this.messagesTruncated = result.messagesTruncated();
        ArrayList<PartitionTruncationInformation> list = new ArrayList<PartitionTruncationInformation>();
        for (AlterMirrorsResponseData.MirrorPartitionResponseData data : result.partitionLevelTruncationData()) {
            list.add(new PartitionTruncationInformation(data));
        }
        this.partitionLevelTruncationData = list;
    }

    public TruncateAndRestoreResult(long messagesTruncated, List<PartitionTruncationInformation> partitionLevelTruncationData) {
        this.messagesTruncated = messagesTruncated;
        this.partitionLevelTruncationData = partitionLevelTruncationData;
    }

    public long messagesTruncated() {
        return this.messagesTruncated;
    }

    public List<PartitionTruncationInformation> partitionLevelTruncationData() {
        return this.partitionLevelTruncationData;
    }
}

