/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.shaded.io.reactivex.subjects;

import io.confluent.shaded.io.reactivex.Observer;
import io.confluent.shaded.io.reactivex.annotations.CheckReturnValue;
import io.confluent.shaded.io.reactivex.annotations.NonNull;
import io.confluent.shaded.io.reactivex.annotations.Nullable;
import io.confluent.shaded.io.reactivex.disposables.Disposable;
import io.confluent.shaded.io.reactivex.internal.functions.ObjectHelper;
import io.confluent.shaded.io.reactivex.plugins.RxJavaPlugins;
import io.confluent.shaded.io.reactivex.subjects.Subject;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;

public final class PublishSubject<T>
extends Subject<T> {
    static final PublishDisposable[] TERMINATED = new PublishDisposable[0];
    static final PublishDisposable[] EMPTY = new PublishDisposable[0];
    final AtomicReference<PublishDisposable<T>[]> subscribers = new AtomicReference<PublishDisposable[]>(EMPTY);
    Throwable error;

    @CheckReturnValue
    @NonNull
    public static <T> PublishSubject<T> create() {
        return new PublishSubject<T>();
    }

    PublishSubject() {
    }

    @Override
    protected void subscribeActual(Observer<? super T> t) {
        PublishDisposable<T> ps = new PublishDisposable<T>(t, this);
        t.onSubscribe(ps);
        if (this.add(ps)) {
            if (ps.isDisposed()) {
                this.remove(ps);
            }
        } else {
            Throwable ex = this.error;
            if (ex != null) {
                t.onError(ex);
            } else {
                t.onComplete();
            }
        }
    }

    boolean add(PublishDisposable<T> ps) {
        PublishDisposable[] b;
        PublishDisposable<T>[] a;
        do {
            if ((a = this.subscribers.get()) == TERMINATED) {
                return false;
            }
            int n = a.length;
            b = new PublishDisposable[n + 1];
            System.arraycopy(a, 0, b, 0, n);
            b[n] = ps;
        } while (!this.subscribers.compareAndSet(a, b));
        return true;
    }

    void remove(PublishDisposable<T> ps) {
        PublishDisposable[] b;
        PublishDisposable<T>[] a;
        do {
            if ((a = this.subscribers.get()) == TERMINATED || a == EMPTY) {
                return;
            }
            int n = a.length;
            int j = -1;
            for (int i = 0; i < n; ++i) {
                if (a[i] != ps) continue;
                j = i;
                break;
            }
            if (j < 0) {
                return;
            }
            if (n == 1) {
                b = EMPTY;
                continue;
            }
            b = new PublishDisposable[n - 1];
            System.arraycopy(a, 0, b, 0, j);
            System.arraycopy(a, j + 1, b, j, n - j - 1);
        } while (!this.subscribers.compareAndSet(a, b));
    }

    @Override
    public void onSubscribe(Disposable d) {
        if (this.subscribers.get() == TERMINATED) {
            d.dispose();
        }
    }

    @Override
    public void onNext(T t) {
        ObjectHelper.requireNonNull(t, "onNext called with null. Null values are generally not allowed in 2.x operators and sources.");
        for (PublishDisposable<T> pd : this.subscribers.get()) {
            pd.onNext(t);
        }
    }

    @Override
    public void onError(Throwable t) {
        ObjectHelper.requireNonNull(t, "onError called with null. Null values are generally not allowed in 2.x operators and sources.");
        if (this.subscribers.get() == TERMINATED) {
            RxJavaPlugins.onError(t);
            return;
        }
        this.error = t;
        for (PublishDisposable pd : this.subscribers.getAndSet(TERMINATED)) {
            pd.onError(t);
        }
    }

    @Override
    public void onComplete() {
        if (this.subscribers.get() == TERMINATED) {
            return;
        }
        for (PublishDisposable pd : this.subscribers.getAndSet(TERMINATED)) {
            pd.onComplete();
        }
    }

    @Override
    public boolean hasObservers() {
        return this.subscribers.get().length != 0;
    }

    @Override
    @Nullable
    public Throwable getThrowable() {
        if (this.subscribers.get() == TERMINATED) {
            return this.error;
        }
        return null;
    }

    @Override
    public boolean hasThrowable() {
        return this.subscribers.get() == TERMINATED && this.error != null;
    }

    @Override
    public boolean hasComplete() {
        return this.subscribers.get() == TERMINATED && this.error == null;
    }

    static final class PublishDisposable<T>
    extends AtomicBoolean
    implements Disposable {
        private static final long serialVersionUID = 3562861878281475070L;
        final Observer<? super T> downstream;
        final PublishSubject<T> parent;

        PublishDisposable(Observer<? super T> actual, PublishSubject<T> parent) {
            this.downstream = actual;
            this.parent = parent;
        }

        public void onNext(T t) {
            if (!this.get()) {
                this.downstream.onNext(t);
            }
        }

        public void onError(Throwable t) {
            if (this.get()) {
                RxJavaPlugins.onError(t);
            } else {
                this.downstream.onError(t);
            }
        }

        public void onComplete() {
            if (!this.get()) {
                this.downstream.onComplete();
            }
        }

        @Override
        public void dispose() {
            if (this.compareAndSet(false, true)) {
                this.parent.remove(this);
            }
        }

        @Override
        public boolean isDisposed() {
            return this.get();
        }
    }
}

