/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.resourcemanager.api.client;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.confluent.resourcemanager.api.client.ApiException;
import io.confluent.resourcemanager.api.client.ClientImpl;
import io.confluent.resourcemanager.api.client.GroupVersionResource;
import io.confluent.resourcemanager.api.client.ListRequest;
import io.confluent.resourcemanager.api.model.HasMetadata;
import io.confluent.resourcemanager.api.model.ObjectList;
import io.confluent.resourcemanager.api.model.Status;
import io.confluent.resourcemanager.api.model.location.Location;
import io.confluent.resourcemanager.api.model.scope.Scoping;
import io.confluent.resourcemanager.api.openapi.Adapter;
import io.confluent.resourcemanager.protobuf.apis.meta.v1.ScopeAttribute;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;

abstract class Request<T> {
    final HttpUrl.Builder urlBuilder;
    final OkHttpClient httpClient;
    protected GroupVersionResource gvr;
    protected Scoping scoping;
    final JavaType deserializeInto;
    String objectName;
    List<ScopeAttribute> scope;
    Location location;
    protected String kind;

    Request(String baseUrl, OkHttpClient httpClient, JavaType deserializeInto, GroupVersionResource gvr, Location location, Scoping scoping, List<ScopeAttribute> scope) {
        this.urlBuilder = HttpUrl.parse((String)Objects.requireNonNull(baseUrl)).newBuilder();
        this.httpClient = Objects.requireNonNull(httpClient);
        this.deserializeInto = Objects.requireNonNull(deserializeInto);
        this.gvr = Objects.requireNonNull(gvr);
        this.location = Objects.requireNonNull(location);
        this.scoping = Objects.requireNonNull(scoping);
        this.scope = scope;
    }

    protected void maybePopulateAdapterFields(Object obj) {
        if (obj instanceof Adapter) {
            Adapter adapter = (Adapter)obj;
            adapter.setGroupVersionResource(this.gvr);
            adapter.setScoping(this.scoping);
            adapter.setKind(this.kind);
        } else if (obj instanceof Optional) {
            Optional optional = (Optional)obj;
            optional.ifPresent(this::maybePopulateAdapterFields);
        } else if (obj instanceof ObjectList) {
            ObjectList objList = (ObjectList)obj;
            objList.items().forEach(this::maybePopulateAdapterFields);
        }
    }

    private HttpUrl buildUrl() {
        if (this.location != Location.Default()) {
            this.urlBuilder.addPathSegment("locations").addPathSegment(this.location.toString());
        }
        this.urlBuilder.addPathSegment("apis").addPathSegment(this.gvr.group()).addPathSegment(this.gvr.version());
        this.addScopePath();
        this.urlBuilder.addPathSegment(this.gvr.resource());
        if (this.objectName != null) {
            this.urlBuilder.addEncodedPathSegment(this.objectName);
        }
        return this.urlBuilder.build();
    }

    private void addScopePath() {
        this.scoping.getScopingAttributes().forEach(scopingAttribute -> {
            Optional<String> scopeValue = this.scope.stream().filter(scopeAttribute -> scopeAttribute.getName().equalsIgnoreCase(scopingAttribute.name())).map(ScopeAttribute::getValue).findFirst();
            if (scopeValue.isPresent()) {
                this.urlBuilder.addPathSegment(scopingAttribute.getResource());
                this.urlBuilder.addEncodedPathSegment(scopeValue.get());
            } else if (this.getClass() != ListRequest.class) {
                throw new IllegalArgumentException(String.format("Scoping attribute: [%s], not found in scope", scopingAttribute.name()));
            }
        });
    }

    protected static byte[] serializeObject(HasMetadata object) throws JsonProcessingException {
        JsonNode originalNode = ClientImpl.OBJECT_MAPPER.valueToTree((Object)object);
        ObjectNode objectNode = (ObjectNode)originalNode;
        if (!objectNode.has("apiVersion")) {
            objectNode.put("apiVersion", object.getApiVersion());
        }
        if (!objectNode.has("kind")) {
            objectNode.put("kind", object.getKind());
        }
        return ClientImpl.OBJECT_MAPPER.writeValueAsBytes((Object)objectNode);
    }

    public abstract CompletableFuture<T> execute();

    CompletableFuture<T> exec(Preprocessor<Request.Builder> preprocess) {
        Request.Builder builder;
        HttpUrl url = this.buildUrl();
        try {
            builder = preprocess.preprocess(new Request.Builder().url(url));
        }
        catch (Exception exc) {
            return CompletableFuture.failedFuture(exc);
        }
        final CompletableFuture fut = new CompletableFuture();
        this.httpClient.newCall(builder.build()).enqueue(new Callback(){

            public void onFailure(Call call, IOException exc) {
                fut.completeExceptionally(exc);
            }

            public void onResponse(Call call, Response resp) {
                String body;
                try {
                    body = resp.body().string();
                }
                catch (IOException exc) {
                    fut.completeExceptionally(exc);
                    return;
                }
                if (resp.isSuccessful()) {
                    try {
                        Object out = ClientImpl.OBJECT_MAPPER.readValue(body, Request.this.deserializeInto);
                        Request.this.maybePopulateAdapterFields(out);
                        fut.complete(out);
                    }
                    catch (IOException exc) {
                        fut.completeExceptionally(exc);
                    }
                    return;
                }
                try {
                    Status status = Request.parseStatus(body);
                    if (resp.code() == 404 && (Request.this.kind != null && Request.this.kind.equals(status.details().kind()) || Request.this.gvr.resource().equals(status.details().kind())) && Request.this.gvr.group().equals(status.details().group()) && status.details().causes().stream().anyMatch(cause -> cause.reason().equals("ObjectNotFound"))) {
                        Optional out = Optional.empty();
                        fut.complete(out);
                        return;
                    }
                    fut.completeExceptionally(new ApiException(status));
                }
                catch (IOException ex) {
                    fut.completeExceptionally(new ApiException(new Status(null, "Failure", body, null, null, resp.code())));
                }
            }
        });
        return fut;
    }

    private static Status parseStatus(String body) throws JsonProcessingException, IOException {
        Status status = (Status)ClientImpl.OBJECT_MAPPER.readValue(body, Status.class);
        return status;
    }

    @FunctionalInterface
    public static interface Preprocessor<T> {
        public T preprocess(T var1) throws IOException;
    }
}

