/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.resourcemanager.api.client;

import com.fasterxml.jackson.databind.JavaType;
import io.confluent.flink.watch.v1alpha1.WatchEvent;
import io.confluent.resourcemanager.api.client.ClientImpl;
import io.confluent.resourcemanager.api.model.HasMetadata;
import java.io.IOException;

public record WatchEvent<T extends HasMetadata>(EventType eventType, T object, String continueToken) {
    static <T extends HasMetadata> WatchEvent<T> fromV1Alpha1Event(io.confluent.flink.watch.v1alpha1.WatchEvent event, JavaType javaType) throws IOException {
        EventType eventType = EventType.fromV1Alpha1WatchEventType(event.getEventType());
        byte[] serialized = event.getRawJsonObject().toByteArray();
        if (serialized.length == 0) {
            return new WatchEvent<Object>(eventType, null, event.getContinueToken());
        }
        HasMetadata object = (HasMetadata)ClientImpl.OBJECT_MAPPER.readValue(event.getRawJsonObject().toByteArray(), javaType);
        return new WatchEvent<HasMetadata>(eventType, object, event.getContinueToken());
    }

    public static enum EventType {
        SNAPSHOT,
        CREATED,
        UPDATED,
        DELETED,
        END_OF_SNAPSHOT,
        UNKNOWN;


        private static EventType fromV1Alpha1WatchEventType(WatchEvent.EventType eventType) {
            return switch (eventType) {
                case WatchEvent.EventType.CREATED -> CREATED;
                case WatchEvent.EventType.SNAPSHOT -> SNAPSHOT;
                case WatchEvent.EventType.UPDATED -> UPDATED;
                case WatchEvent.EventType.DELETED -> DELETED;
                case WatchEvent.EventType.END_OF_SNAPSHOT -> END_OF_SNAPSHOT;
                default -> UNKNOWN;
            };
        }
    }
}

