/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.resourcemanager.api.generated.model;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import io.confluent.resourcemanager.api.generated.model.FlinkV1ScalingStatus;
import io.confluent.resourcemanager.api.generated.model.SqlV3StatementResultsSpec;
import java.io.Serializable;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"detail", "expirationTimestamp", "failureReason", "jobId", "latestOffsets", "latestOffsetsTimestamp", "phase", "phaseChangedAt", "publicPhase", "restService", "results", "scalingStatus"})
public class SqlV3StatementStatus
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_DETAIL = "detail";
    private String detail;
    public static final String JSON_PROPERTY_EXPIRATION_TIMESTAMP = "expirationTimestamp";
    private OffsetDateTime expirationTimestamp;
    public static final String JSON_PROPERTY_FAILURE_REASON = "failureReason";
    private String failureReason;
    public static final String JSON_PROPERTY_JOB_ID = "jobId";
    private String jobId;
    public static final String JSON_PROPERTY_LATEST_OFFSETS = "latestOffsets";
    private Map<String, String> latestOffsets = new HashMap<String, String>();
    public static final String JSON_PROPERTY_LATEST_OFFSETS_TIMESTAMP = "latestOffsetsTimestamp";
    private OffsetDateTime latestOffsetsTimestamp;
    public static final String JSON_PROPERTY_PHASE = "phase";
    private PhaseEnum phase;
    public static final String JSON_PROPERTY_PHASE_CHANGED_AT = "phaseChangedAt";
    private OffsetDateTime phaseChangedAt;
    public static final String JSON_PROPERTY_PUBLIC_PHASE = "publicPhase";
    private PublicPhaseEnum publicPhase;
    public static final String JSON_PROPERTY_REST_SERVICE = "restService";
    private String restService;
    public static final String JSON_PROPERTY_RESULTS = "results";
    private SqlV3StatementResultsSpec results;
    public static final String JSON_PROPERTY_SCALING_STATUS = "scalingStatus";
    private FlinkV1ScalingStatus scalingStatus;
    private Map<String, Object> additionalProperties;

    public SqlV3StatementStatus detail(String detail) {
        this.detail = detail;
        return this;
    }

    @Nullable
    @JsonProperty(value="detail")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDetail() {
        return this.detail;
    }

    @JsonProperty(value="detail")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDetail(String detail) {
        this.detail = detail;
    }

    public SqlV3StatementStatus expirationTimestamp(OffsetDateTime expirationTimestamp) {
        this.expirationTimestamp = expirationTimestamp;
        return this;
    }

    @Nullable
    @JsonProperty(value="expirationTimestamp")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getExpirationTimestamp() {
        return this.expirationTimestamp;
    }

    @JsonProperty(value="expirationTimestamp")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setExpirationTimestamp(OffsetDateTime expirationTimestamp) {
        this.expirationTimestamp = expirationTimestamp;
    }

    public SqlV3StatementStatus failureReason(String failureReason) {
        this.failureReason = failureReason;
        return this;
    }

    @Nullable
    @JsonProperty(value="failureReason")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getFailureReason() {
        return this.failureReason;
    }

    @JsonProperty(value="failureReason")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFailureReason(String failureReason) {
        this.failureReason = failureReason;
    }

    public SqlV3StatementStatus jobId(String jobId) {
        this.jobId = jobId;
        return this;
    }

    @Nullable
    @JsonProperty(value="jobId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getJobId() {
        return this.jobId;
    }

    @JsonProperty(value="jobId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setJobId(String jobId) {
        this.jobId = jobId;
    }

    public SqlV3StatementStatus latestOffsets(Map<String, String> latestOffsets) {
        this.latestOffsets = latestOffsets;
        return this;
    }

    public SqlV3StatementStatus putLatestOffsetsItem(String key, String latestOffsetsItem) {
        if (this.latestOffsets == null) {
            this.latestOffsets = new HashMap<String, String>();
        }
        this.latestOffsets.put(key, latestOffsetsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="latestOffsets")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, String> getLatestOffsets() {
        return this.latestOffsets;
    }

    @JsonProperty(value="latestOffsets")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLatestOffsets(Map<String, String> latestOffsets) {
        this.latestOffsets = latestOffsets;
    }

    public SqlV3StatementStatus latestOffsetsTimestamp(OffsetDateTime latestOffsetsTimestamp) {
        this.latestOffsetsTimestamp = latestOffsetsTimestamp;
        return this;
    }

    @Nullable
    @JsonProperty(value="latestOffsetsTimestamp")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getLatestOffsetsTimestamp() {
        return this.latestOffsetsTimestamp;
    }

    @JsonProperty(value="latestOffsetsTimestamp")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLatestOffsetsTimestamp(OffsetDateTime latestOffsetsTimestamp) {
        this.latestOffsetsTimestamp = latestOffsetsTimestamp;
    }

    public SqlV3StatementStatus phase(PhaseEnum phase) {
        this.phase = phase;
        return this;
    }

    @Nullable
    @JsonProperty(value="phase")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public PhaseEnum getPhase() {
        return this.phase;
    }

    @JsonProperty(value="phase")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPhase(PhaseEnum phase) {
        this.phase = phase;
    }

    public SqlV3StatementStatus phaseChangedAt(OffsetDateTime phaseChangedAt) {
        this.phaseChangedAt = phaseChangedAt;
        return this;
    }

    @Nullable
    @JsonProperty(value="phaseChangedAt")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getPhaseChangedAt() {
        return this.phaseChangedAt;
    }

    @JsonProperty(value="phaseChangedAt")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPhaseChangedAt(OffsetDateTime phaseChangedAt) {
        this.phaseChangedAt = phaseChangedAt;
    }

    public SqlV3StatementStatus publicPhase(PublicPhaseEnum publicPhase) {
        this.publicPhase = publicPhase;
        return this;
    }

    @Nullable
    @JsonProperty(value="publicPhase")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public PublicPhaseEnum getPublicPhase() {
        return this.publicPhase;
    }

    @JsonProperty(value="publicPhase")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPublicPhase(PublicPhaseEnum publicPhase) {
        this.publicPhase = publicPhase;
    }

    public SqlV3StatementStatus restService(String restService) {
        this.restService = restService;
        return this;
    }

    @Nullable
    @JsonProperty(value="restService")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getRestService() {
        return this.restService;
    }

    @JsonProperty(value="restService")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRestService(String restService) {
        this.restService = restService;
    }

    public SqlV3StatementStatus results(SqlV3StatementResultsSpec results) {
        this.results = results;
        return this;
    }

    @Nullable
    @JsonProperty(value="results")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SqlV3StatementResultsSpec getResults() {
        return this.results;
    }

    @JsonProperty(value="results")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setResults(SqlV3StatementResultsSpec results) {
        this.results = results;
    }

    public SqlV3StatementStatus scalingStatus(FlinkV1ScalingStatus scalingStatus) {
        this.scalingStatus = scalingStatus;
        return this;
    }

    @Nullable
    @JsonProperty(value="scalingStatus")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public FlinkV1ScalingStatus getScalingStatus() {
        return this.scalingStatus;
    }

    @JsonProperty(value="scalingStatus")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setScalingStatus(FlinkV1ScalingStatus scalingStatus) {
        this.scalingStatus = scalingStatus;
    }

    @JsonAnySetter
    public SqlV3StatementStatus putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SqlV3StatementStatus sqlV3StatementStatus = (SqlV3StatementStatus)o;
        return Objects.equals(this.detail, sqlV3StatementStatus.detail) && Objects.equals(this.expirationTimestamp, sqlV3StatementStatus.expirationTimestamp) && Objects.equals(this.failureReason, sqlV3StatementStatus.failureReason) && Objects.equals(this.jobId, sqlV3StatementStatus.jobId) && Objects.equals(this.latestOffsets, sqlV3StatementStatus.latestOffsets) && Objects.equals(this.latestOffsetsTimestamp, sqlV3StatementStatus.latestOffsetsTimestamp) && Objects.equals((Object)this.phase, (Object)sqlV3StatementStatus.phase) && Objects.equals(this.phaseChangedAt, sqlV3StatementStatus.phaseChangedAt) && Objects.equals((Object)this.publicPhase, (Object)sqlV3StatementStatus.publicPhase) && Objects.equals(this.restService, sqlV3StatementStatus.restService) && Objects.equals(this.results, sqlV3StatementStatus.results) && Objects.equals(this.scalingStatus, sqlV3StatementStatus.scalingStatus) && Objects.equals(this.additionalProperties, sqlV3StatementStatus.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.detail, this.expirationTimestamp, this.failureReason, this.jobId, this.latestOffsets, this.latestOffsetsTimestamp, this.phase, this.phaseChangedAt, this.publicPhase, this.restService, this.results, this.scalingStatus, super.hashCode(), this.additionalProperties});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SqlV3StatementStatus {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    detail: ").append(this.toIndentedString(this.detail)).append("\n");
        sb.append("    expirationTimestamp: ").append(this.toIndentedString(this.expirationTimestamp)).append("\n");
        sb.append("    failureReason: ").append(this.toIndentedString(this.failureReason)).append("\n");
        sb.append("    jobId: ").append(this.toIndentedString(this.jobId)).append("\n");
        sb.append("    latestOffsets: ").append(this.toIndentedString(this.latestOffsets)).append("\n");
        sb.append("    latestOffsetsTimestamp: ").append(this.toIndentedString(this.latestOffsetsTimestamp)).append("\n");
        sb.append("    phase: ").append(this.toIndentedString((Object)this.phase)).append("\n");
        sb.append("    phaseChangedAt: ").append(this.toIndentedString(this.phaseChangedAt)).append("\n");
        sb.append("    publicPhase: ").append(this.toIndentedString((Object)this.publicPhase)).append("\n");
        sb.append("    restService: ").append(this.toIndentedString(this.restService)).append("\n");
        sb.append("    results: ").append(this.toIndentedString(this.results)).append("\n");
        sb.append("    scalingStatus: ").append(this.toIndentedString(this.scalingStatus)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum PhaseEnum {
        COMPLETED("Completed"),
        DEGRADED("Degraded"),
        DELETING("Deleting"),
        FAILED("Failed"),
        FAILING("Failing"),
        PENDING("Pending"),
        PLANNING("Planning"),
        RESUMING("Resuming"),
        RUNNING("Running"),
        STOPPED("Stopped"),
        STOPPING("Stopping");

        private String value;

        private PhaseEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static PhaseEnum fromValue(String value) {
            for (PhaseEnum b : PhaseEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum PublicPhaseEnum {
        COMPLETED("COMPLETED"),
        DEGRADED("DEGRADED"),
        DELETING("DELETING"),
        FAILED("FAILED"),
        FAILING("FAILING"),
        PENDING("PENDING"),
        RUNNING("RUNNING"),
        STOPPED("STOPPED"),
        STOPPING("STOPPING");

        private String value;

        private PublicPhaseEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static PublicPhaseEnum fromValue(String value) {
            for (PublicPhaseEnum b : PublicPhaseEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

