/*
 * Decompiled with CFR 0.152.
 */
package kafka.cluster;

import java.io.Serializable;
import java.util.List;
import java.util.Optional;
import kafka.cluster.RackAndRequiredReplicaCountsAndEligibleBrokers;
import kafka.cluster.RackIndexAndAssignment;
import kafka.cluster.RackIndexAndReplicasCount;
import kafka.cluster.RequiredReplicaCountsAndEligibleBrokers;
import kafka.controller.ReplicaAssignment;
import kafka.controller.ReplicaAssignment$;
import kafka.utils.CoreUtils$;
import org.apache.kafka.admin.AdminUtils;
import org.apache.kafka.admin.BrokerMetadata;
import org.apache.kafka.common.errors.InvalidConfigurationException;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.ApiError;
import org.apache.kafka.metadata.TopicPlacement;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqOps;
import scala.collection.Set;
import scala.collection.immutable.$colon$colon;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.jdk.OptionConverters;
import scala.jdk.OptionConverters$;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;

public final class Observer$ {
    public static final Observer$ MODULE$ = new Observer$();
    private static final String RackConstraintKey = "rack";

    public String RackConstraintKey() {
        return RackConstraintKey;
    }

    public Map<Object, ReplicaAssignment> getReplicaAssignment(Seq<BrokerMetadata> brokers, Option<TopicPlacement> topicPlacement, int numPartitions, int replicationFactor, boolean topicPlacementRackMixingSupportedEnabled, int fixedStartIndex, int startPartitionId) {
        if (topicPlacementRackMixingSupportedEnabled) {
            return this.getReplicaAssignmentWithRackMixingSupport(brokers, topicPlacement, numPartitions, replicationFactor, fixedStartIndex, startPartitionId);
        }
        return this.getReplicaAssignmentWithoutRackMixingSupport(brokers, topicPlacement, numPartitions, replicationFactor, fixedStartIndex, startPartitionId);
    }

    public int getReplicaAssignment$default$6() {
        return -1;
    }

    public int getReplicaAssignment$default$7() {
        return -1;
    }

    private Map<Object, ReplicaAssignment> getReplicaAssignmentWithoutRackMixingSupport(Seq<BrokerMetadata> brokers, Option<TopicPlacement> topicPlacementOpt, int numPartitions, int replicationFactor, int fixedStartIndex, int startPartitionId) {
        Tuple2<Seq<Tuple2<Object, Seq<BrokerMetadata>>>, Seq<Tuple2<Object, Seq<BrokerMetadata>>>> tuple2;
        Option<TopicPlacement> option = topicPlacementOpt;
        if (option instanceof Some) {
            scala.collection.immutable.Set observerRacks;
            Some some = (Some)option;
            TopicPlacement topicPlacement = (TopicPlacement)some.value();
            Buffer<TopicPlacement.ConstraintCount> syncReplicaConstraints = CollectionConverters$.MODULE$.ListHasAsScala(topicPlacement.replicas()).asScala();
            Buffer<TopicPlacement.ConstraintCount> observerConstraints = CollectionConverters$.MODULE$.ListHasAsScala(topicPlacement.observers()).asScala();
            scala.collection.immutable.Set syncReplicaRacks = ((IterableOnceOps)syncReplicaConstraints.flatMap((Function1<TopicPlacement.ConstraintCount, Option> & Serializable)x$1 -> CollectionConverters$.MODULE$.MapHasAsScala(x$1.constraints()).asScala().get(MODULE$.RackConstraintKey()))).toSet();
            scala.collection.immutable.Set duplicatedRacks = (scala.collection.immutable.Set)syncReplicaRacks.intersect(observerRacks = ((IterableOnceOps)observerConstraints.flatMap((Function1<TopicPlacement.ConstraintCount, Option> & Serializable)x$2 -> CollectionConverters$.MODULE$.MapHasAsScala(x$2.constraints()).asScala().get(MODULE$.RackConstraintKey()))).toSet());
            if (duplicatedRacks.nonEmpty()) {
                String duplicatedRacksStr = duplicatedRacks.mkString(",");
                throw new InvalidConfigurationException("Topic placement contains duplicated racks " + duplicatedRacksStr + " for sync replicas and observers. Make sure IBP >= 3.3 and CP >= 7.3.");
            }
            tuple2 = new Tuple2<Seq<Tuple2<Object, Seq<BrokerMetadata>>>, Seq<Tuple2<Object, Seq<BrokerMetadata>>>>(this.partitionBrokersByConstraint(brokers, syncReplicaConstraints), this.partitionBrokersByConstraint(brokers, observerConstraints));
        } else if (None$.MODULE$.equals(option)) {
            tuple2 = new Tuple2<Seq<Tuple2<Object, Seq<BrokerMetadata>>>, Seq<Tuple2<Object, Seq<BrokerMetadata>>>>((Seq<Tuple2<Object, Seq<BrokerMetadata>>>)new $colon$colon<Nothing$>((Nothing$)((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(BoxesRunTime.boxToInteger(replicationFactor)), brokers)), Nil$.MODULE$), (Seq<Tuple2<Object, Seq<BrokerMetadata>>>)Seq$.MODULE$.empty());
        } else {
            throw new MatchError(option);
        }
        Tuple2<Seq<Tuple2<Object, Seq<BrokerMetadata>>>, Seq<Tuple2<Object, Seq<BrokerMetadata>>>> tuple22 = tuple2;
        if (tuple22 == null) {
            throw new MatchError(tuple22);
        }
        Seq replicationAndSyncEligible = tuple22._1();
        Seq replicationAndObserverEligible = (Seq)tuple22._2();
        Tuple2<Seq, Seq> tuple23 = new Tuple2<Seq, Seq>(replicationAndSyncEligible, replicationAndObserverEligible);
        Seq replicationAndSyncEligible2 = tuple23._1();
        Seq replicationAndObserverEligible2 = tuple23._2();
        this.validatePartitioning((Seq)((IterableOps)replicationAndSyncEligible2.$plus$plus(replicationAndObserverEligible2)).map((Function1<Tuple2, Seq> & Serializable)x$4 -> (Seq)x$4._2()));
        return this.partitionReplicaAssignment(this.assignReplicasToPartitions(replicationAndSyncEligible2, numPartitions, fixedStartIndex, startPartitionId), this.assignReplicasToPartitions(replicationAndObserverEligible2, numPartitions, fixedStartIndex, startPartitionId));
    }

    private Map<Object, ReplicaAssignment> getReplicaAssignmentWithRackMixingSupport(Seq<BrokerMetadata> brokers, Option<TopicPlacement> topicPlacement2, int numPartitions, int replicationFactor, int fixedStartIndex, int startPartitionId) {
        Seq requiredReplicaCountsAndEligibleBrokers = (Seq)topicPlacement2.map((Function1<TopicPlacement, Seq> & Serializable)topicPlacement -> MODULE$.buildRequiredReplicaCountsAndEligibleBrokers((TopicPlacement)topicPlacement, brokers)).getOrElse((Function0<Seq> & Serializable)() -> new $colon$colon<Nothing$>((Nothing$)((Object)new RequiredReplicaCountsAndEligibleBrokers(replicationFactor, 0, brokers, new Some<Object>(BoxesRunTime.boxToInteger(0)), None$.MODULE$)), Nil$.MODULE$));
        this.validatePartitioning((Seq)requiredReplicaCountsAndEligibleBrokers.map((Function1<RequiredReplicaCountsAndEligibleBrokers, Seq> & Serializable)x$5 -> x$5.eligibleBrokers()));
        Tuple2<scala.collection.mutable.Map<Object, Seq<Object>>, scala.collection.mutable.Map<Object, Seq<Object>>> tuple2 = this.assignReplicasToPartitionsWithRackMixingSupport(requiredReplicaCountsAndEligibleBrokers, numPartitions, fixedStartIndex, startPartitionId);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        scala.collection.mutable.Map<Object, Seq<Object>> syncReplicaAssignments = tuple2._1();
        scala.collection.mutable.Map<Object, Seq<Object>> observerAssignments = tuple2._2();
        Tuple2<scala.collection.mutable.Map<Object, Seq<Object>>, scala.collection.mutable.Map<Object, Seq<Object>>> tuple22 = new Tuple2<scala.collection.mutable.Map<Object, Seq<Object>>, scala.collection.mutable.Map<Object, Seq<Object>>>(syncReplicaAssignments, observerAssignments);
        scala.collection.mutable.Map<Object, Seq<Object>> syncReplicaAssignments2 = tuple22._1();
        scala.collection.mutable.Map<Object, Seq<Object>> observerAssignments2 = tuple22._2();
        return this.partitionReplicaAssignment(syncReplicaAssignments2, observerAssignments2);
    }

    public void validateTopicPlacementUpdate(TopicPlacement topicPlacement, Seq<BrokerMetadata> brokers) {
        this.validatePartitioning((Seq)this.buildRequiredReplicaCountsAndEligibleBrokers(topicPlacement, brokers).map((Function1<RequiredReplicaCountsAndEligibleBrokers, Seq> & Serializable)x$7 -> x$7.eligibleBrokers()));
    }

    public Seq<RequiredReplicaCountsAndEligibleBrokers> buildRequiredReplicaCountsAndEligibleBrokers(TopicPlacement topicPlacement, Seq<BrokerMetadata> brokers) {
        Map syncReplicasKeyedByRack = (Map)((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(topicPlacement.replicas()).asScala().zipWithIndex()).foldLeft(Map$.MODULE$.empty(), (Function2<scala.collection.mutable.Map, Tuple2, scala.collection.mutable.Map> & Serializable)(map, constraintCountAndIndex) -> MODULE$.keyByRackFunc("Replicas contains duplicate constraint", (scala.collection.mutable.Map<Map<String, String>, RackIndexAndReplicasCount>)map, (Tuple2<TopicPlacement.ConstraintCount, Object>)constraintCountAndIndex));
        Map observersKeyedByRack = (Map)((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(topicPlacement.observers()).asScala().zipWithIndex()).foldLeft(Map$.MODULE$.empty(), (Function2<scala.collection.mutable.Map, Tuple2, scala.collection.mutable.Map> & Serializable)(map, constraintCountAndIndex) -> MODULE$.keyByRackFunc("Observers contains duplicate constraint", (scala.collection.mutable.Map<Map<String, String>, RackIndexAndReplicasCount>)map, (Tuple2<TopicPlacement.ConstraintCount, Object>)constraintCountAndIndex));
        scala.collection.immutable.Seq requiredReplicaCountsAndEligibleBrokers = ((IterableOnceOps)syncReplicasKeyedByRack.keySet().$plus$plus(observersKeyedByRack.keySet()).map((Function1<Map, RackAndRequiredReplicaCountsAndEligibleBrokers> & Serializable)rack -> {
            Tuple2<Integer, None$> tuple2;
            Tuple2<Integer, None$> tuple22;
            Option option = syncReplicasKeyedByRack.get(rack);
            if (option instanceof Some) {
                Some some = (Some)option;
                RackIndexAndReplicasCount x = (RackIndexAndReplicasCount)some.value();
                tuple22 = new Tuple2<Integer, Some<Integer>>(BoxesRunTime.boxToInteger(x.replicaCount()), new Some<Integer>(BoxesRunTime.boxToInteger(x.rackIndex())));
            } else if (None$.MODULE$.equals(option)) {
                tuple22 = new Tuple2<Integer, None$>(BoxesRunTime.boxToInteger(0), None$.MODULE$);
            } else {
                throw new MatchError(option);
            }
            Tuple2<Integer, None$> tuple23 = tuple22;
            if (tuple23 == null) {
                throw new MatchError(tuple23);
            }
            int syncReplicas = tuple23._1$mcI$sp();
            Option syncReplicaIndex = tuple23._2();
            Tuple2<Integer, Option> tuple24 = new Tuple2<Integer, Option>(BoxesRunTime.boxToInteger(syncReplicas), syncReplicaIndex);
            int syncReplicas2 = tuple24._1$mcI$sp();
            Option syncReplicaIndex2 = tuple24._2();
            Option option2 = observersKeyedByRack.get(rack);
            if (option2 instanceof Some) {
                Some some = (Some)option2;
                RackIndexAndReplicasCount x = (RackIndexAndReplicasCount)some.value();
                tuple2 = new Tuple2<Integer, Some<Integer>>(BoxesRunTime.boxToInteger(x.replicaCount()), new Some<Integer>(BoxesRunTime.boxToInteger(x.rackIndex())));
            } else if (None$.MODULE$.equals(option2)) {
                tuple2 = new Tuple2<Integer, None$>(BoxesRunTime.boxToInteger(0), None$.MODULE$);
            } else {
                throw new MatchError(option2);
            }
            Tuple2<Integer, None$> tuple25 = tuple2;
            if (tuple25 == null) {
                throw new MatchError(tuple25);
            }
            int observers = tuple25._1$mcI$sp();
            Option observersIndex = tuple25._2();
            Tuple2<Integer, Option> tuple26 = new Tuple2<Integer, Option>(BoxesRunTime.boxToInteger(observers), observersIndex);
            int observers2 = tuple26._1$mcI$sp();
            Option observersIndex2 = tuple26._2();
            Seq matchedBrokers = (Seq)brokers.filter((Function1<BrokerMetadata, Object> & Serializable)broker -> BoxesRunTime.boxToBoolean(Observer$.MODULE$.brokerMatchesPlacementConstraint(broker, rack)));
            return new RackAndRequiredReplicaCountsAndEligibleBrokers((Map<String, String>)rack, new RequiredReplicaCountsAndEligibleBrokers(syncReplicas2, observers2, matchedBrokers, syncReplicaIndex2, observersIndex2));
        })).toSeq();
        scala.collection.immutable.Seq invalidRacks = (scala.collection.immutable.Seq)requiredReplicaCountsAndEligibleBrokers.filter((Function1<RackAndRequiredReplicaCountsAndEligibleBrokers, Object> & Serializable)x -> BoxesRunTime.boxToBoolean(Observer$.$anonfun$buildRequiredReplicaCountsAndEligibleBrokers$5(x)));
        if (invalidRacks.size() > 0) {
            scala.collection.immutable.Seq errMsgs = (scala.collection.immutable.Seq)invalidRacks.map((Function1<RackAndRequiredReplicaCountsAndEligibleBrokers, String> & Serializable)x0$1 -> {
                RackAndRequiredReplicaCountsAndEligibleBrokers rackAndRequiredReplicaCountsAndEligibleBrokers = x0$1;
                return "for constraint " + rackAndRequiredReplicaCountsAndEligibleBrokers.rack() + " there are " + rackAndRequiredReplicaCountsAndEligibleBrokers.countsAndEligibleBrokers().eligibleBrokers().size() + " matching brokers but the topic placement requires " + rackAndRequiredReplicaCountsAndEligibleBrokers.countsAndEligibleBrokers().syncReplicas() + " sync replicas and " + rackAndRequiredReplicaCountsAndEligibleBrokers.countsAndEligibleBrokers().observers() + " observers";
            });
            String detailedErrMsg = errMsgs.mkString(", ");
            throw new InvalidConfigurationException("Failed to satisfy the topic placement: " + detailedErrMsg);
        }
        return (Seq)requiredReplicaCountsAndEligibleBrokers.map((Function1<RackAndRequiredReplicaCountsAndEligibleBrokers, RequiredReplicaCountsAndEligibleBrokers> & Serializable)x$10 -> x$10.countsAndEligibleBrokers());
    }

    private scala.collection.mutable.Map<Map<String, String>, RackIndexAndReplicasCount> keyByRackFunc(String errorMsg, scala.collection.mutable.Map<Map<String, String>, RackIndexAndReplicasCount> map, Tuple2<TopicPlacement.ConstraintCount, Object> constraintCountAndIndex) {
        Option option = map.get(CollectionConverters$.MODULE$.MapHasAsScala(constraintCountAndIndex._1().constraints()).asScala());
        if (option instanceof Some) {
            throw new InvalidConfigurationException(errorMsg);
        }
        if (!None$.MODULE$.equals(option)) {
            throw new MatchError(option);
        }
        map.put(CollectionConverters$.MODULE$.MapHasAsScala(constraintCountAndIndex._1().constraints()).asScala(), new RackIndexAndReplicasCount(constraintCountAndIndex._2$mcI$sp(), constraintCountAndIndex._1().count()));
        return map;
    }

    private scala.collection.mutable.Map<Object, Seq<Object>> assignReplicasToPartitions(Seq<Tuple2<Object, Seq<BrokerMetadata>>> replicationAndBrokers, int partitions, int fixedStartIndex, int startPartitionId) {
        return (scala.collection.mutable.Map)((IterableOnceOps)replicationAndBrokers.map((Function1<Tuple2, Map> & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                int replication = tuple2._1$mcI$sp();
                Seq brokerList = (Seq)tuple2._2();
                return CoreUtils$.MODULE$.replicaToBrokerAssignmentAsScala(AdminUtils.assignReplicasToBrokers(CollectionConverters$.MODULE$.SeqHasAsJava(brokerList).asJava(), partitions, replication, fixedStartIndex, startPartitionId));
            }
            throw new MatchError(tuple2);
        })).foldLeft(Map$.MODULE$.empty(), (Function2<scala.collection.mutable.Map, Map, scala.collection.mutable.Map> & Serializable)(mergedAssignment, currentAssignment) -> MODULE$.mergeAssignmentMap((scala.collection.mutable.Map<Object, Seq<Object>>)mergedAssignment, (Map<Object, Seq<Object>>)currentAssignment));
    }

    private Tuple2<scala.collection.mutable.Map<Object, Seq<Object>>, scala.collection.mutable.Map<Object, Seq<Object>>> assignReplicasToPartitionsWithRackMixingSupport(Seq<RequiredReplicaCountsAndEligibleBrokers> requiredReplicaCountsAndEligibleBrokers, int numPartitions, int fixedStartIndex, int startPartitionId) {
        Seq syncReplicaAndObserverAssignments = (Seq)requiredReplicaCountsAndEligibleBrokers.map((Function1<RequiredReplicaCountsAndEligibleBrokers, scala.collection.mutable.Map> & Serializable)countsAndBrokers -> {
            int numSyncReplicas = countsAndBrokers.syncReplicas();
            int numObservers = countsAndBrokers.observers();
            int replicationFactor = numSyncReplicas + numObservers;
            java.util.Map<Integer, List<Integer>> adminUtilsAssignmentMap = AdminUtils.assignReplicasToBrokers(CollectionConverters$.MODULE$.SeqHasAsJava(countsAndBrokers.eligibleBrokers()).asJava(), numPartitions, replicationFactor, fixedStartIndex, startPartitionId);
            return (scala.collection.mutable.Map)CollectionConverters$.MODULE$.MapHasAsScala(adminUtilsAssignmentMap).asScala().map((Function1<Tuple2, Tuple2> & Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    Integer partition = (Integer)tuple2._1();
                    List adminUtilsAssignment = (List)tuple2._2();
                    Tuple2 tuple22 = ((IterableOps)CollectionConverters$.MODULE$.ListHasAsScala(adminUtilsAssignment).asScala().map((Function1<Integer, Object> & Serializable)i -> BoxesRunTime.boxToInteger(Predef$.MODULE$.Integer2int(i)))).splitAt(numSyncReplicas);
                    if (tuple22 == null) {
                        throw new MatchError(tuple22);
                    }
                    Buffer syncReplicaAssignment = (Buffer)tuple22._1();
                    Buffer observerAssignment = (Buffer)tuple22._2();
                    Tuple2<Buffer, Buffer> tuple23 = new Tuple2<Buffer, Buffer>(syncReplicaAssignment, observerAssignment);
                    Buffer syncReplicaAssignment2 = tuple23._1();
                    Buffer observerAssignment2 = tuple23._2();
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(BoxesRunTime.boxToInteger(Predef$.MODULE$.Integer2int(partition))), new Tuple2<RackIndexAndAssignment, RackIndexAndAssignment>(new RackIndexAndAssignment(countsAndBrokers.syncReplicasRackIndex(), syncReplicaAssignment2.toSeq()), new RackIndexAndAssignment(countsAndBrokers.observersRackIndex(), observerAssignment2)));
                }
                throw new MatchError(tuple2);
            });
        });
        Seq syncReplicaUnorderedAssignments = (Seq)syncReplicaAndObserverAssignments.map((Function1<Map, Map> & Serializable)assignment -> (Map)assignment.map((Function1<Tuple2, Tuple2> & Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 != null) {
                int partition = tuple2._1$mcI$sp();
                Tuple2 tuple22 = (Tuple2)tuple2._2();
                if (tuple22 != null) {
                    RackIndexAndAssignment indexAndAssignment = (RackIndexAndAssignment)tuple22._1();
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(BoxesRunTime.boxToInteger(partition)), indexAndAssignment);
                }
            }
            throw new MatchError(tuple2);
        }));
        Seq syncReplicaOrderedAssignments = (Seq)((IterableOps)((IterableOps)((SeqOps)((IterableOps)syncReplicaUnorderedAssignments.flatMap((Function1<Map, scala.collection.immutable.Seq> & Serializable)x -> x.toSeq())).filter((Function1<Tuple2, Object> & Serializable)x -> BoxesRunTime.boxToBoolean(Observer$.$anonfun$assignReplicasToPartitionsWithRackMixingSupport$7(x)))).sortWith((Function2<Tuple2, Tuple2, Object> & Serializable)(t1, t2) -> BoxesRunTime.boxToBoolean(Observer$.MODULE$.sortWithPartitionAndRackIndex(t1, t2)))).map((Function1<Tuple2, Tuple2> & Serializable)x -> new Tuple2<Integer, Seq<Object>>(BoxesRunTime.boxToInteger(x._1$mcI$sp()), ((RackIndexAndAssignment)x._2()).assignment()))).map((Function1<Tuple2, Map> & Serializable)x -> (Map)scala.collection.Map$.MODULE$.apply(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(BoxesRunTime.boxToInteger(x._1$mcI$sp())), x._2())})));
        Seq observerUnorderedAssignments = (Seq)syncReplicaAndObserverAssignments.map((Function1<Map, Map> & Serializable)assignment -> (Map)assignment.map((Function1<Tuple2, Tuple2> & Serializable)x0$3 -> {
            Tuple2 tuple2 = x0$3;
            if (tuple2 != null) {
                int partition = tuple2._1$mcI$sp();
                Tuple2 tuple22 = (Tuple2)tuple2._2();
                if (tuple22 != null) {
                    RackIndexAndAssignment observerAssignment = (RackIndexAndAssignment)tuple22._2();
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(BoxesRunTime.boxToInteger(partition)), observerAssignment);
                }
            }
            throw new MatchError(tuple2);
        }));
        Seq observerOrderedAssignments = (Seq)((IterableOps)((IterableOps)((SeqOps)((IterableOps)observerUnorderedAssignments.flatMap((Function1<Map, scala.collection.immutable.Seq> & Serializable)x -> x.toSeq())).filter((Function1<Tuple2, Object> & Serializable)x -> BoxesRunTime.boxToBoolean(Observer$.$anonfun$assignReplicasToPartitionsWithRackMixingSupport$14(x)))).sortWith((Function2<Tuple2, Tuple2, Object> & Serializable)(t1, t2) -> BoxesRunTime.boxToBoolean(Observer$.MODULE$.sortWithPartitionAndRackIndex(t1, t2)))).map((Function1<Tuple2, Tuple2> & Serializable)x -> new Tuple2<Integer, Seq<Object>>(BoxesRunTime.boxToInteger(x._1$mcI$sp()), ((RackIndexAndAssignment)x._2()).assignment()))).map((Function1<Tuple2, Map> & Serializable)x -> (Map)scala.collection.Map$.MODULE$.apply(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(BoxesRunTime.boxToInteger(x._1$mcI$sp())), x._2())})));
        return new Tuple2<scala.collection.mutable.Map<Object, Seq<Object>>, scala.collection.mutable.Map<Object, Seq<Object>>>((scala.collection.mutable.Map<Object, Seq<Object>>)syncReplicaOrderedAssignments.foldLeft(Map$.MODULE$.empty(), (Function2<scala.collection.mutable.Map, Map, scala.collection.mutable.Map> & Serializable)(mergedAssignment, currentAssignment) -> MODULE$.mergeAssignmentMap((scala.collection.mutable.Map<Object, Seq<Object>>)mergedAssignment, (Map<Object, Seq<Object>>)currentAssignment)), (scala.collection.mutable.Map<Object, Seq<Object>>)observerOrderedAssignments.foldLeft(Map$.MODULE$.empty(), (Function2<scala.collection.mutable.Map, Map, scala.collection.mutable.Map> & Serializable)(mergedAssignment, currentAssignment) -> MODULE$.mergeAssignmentMap((scala.collection.mutable.Map<Object, Seq<Object>>)mergedAssignment, (Map<Object, Seq<Object>>)currentAssignment)));
    }

    public boolean sortWithPartitionAndRackIndex(Tuple2<Object, RackIndexAndAssignment> t1, Tuple2<Object, RackIndexAndAssignment> t2) {
        Option<Object> option = t1._2().rackIndex();
        if (!(option instanceof Some)) {
            if (None$.MODULE$.equals(option)) {
                throw new IllegalStateException("The rack index of t1 is None which is not sortable.");
            }
            throw new MatchError(option);
        }
        Some some = (Some)option;
        int v = BoxesRunTime.unboxToInt(some.value());
        int t1RackIndex = v;
        Option<Object> option2 = t2._2().rackIndex();
        if (!(option2 instanceof Some)) {
            if (None$.MODULE$.equals(option2)) {
                throw new IllegalStateException("The rack index of t2 is None which is not sortable.");
            }
            throw new MatchError(option2);
        }
        Some some2 = (Some)option2;
        int v2 = BoxesRunTime.unboxToInt(some2.value());
        int t2RackIndex = v2;
        if (t1._1$mcI$sp() < t2._1$mcI$sp()) {
            return true;
        }
        if (t1._1$mcI$sp() > t2._1$mcI$sp()) {
            return false;
        }
        return t1RackIndex < t2RackIndex;
    }

    private Map<Object, ReplicaAssignment> partitionReplicaAssignment(Map<Object, Seq<Object>> syncReplicas, Map<Object, Seq<Object>> observerReplicas) {
        if (observerReplicas.nonEmpty()) {
            Set set = syncReplicas.keySet();
            Set set2 = observerReplicas.keySet();
            if (set == null ? set2 != null : !((Object)set).equals(set2)) {
                int syncSize = syncReplicas.keySet().size();
                int observerSize = observerReplicas.keySet().size();
                throw new InvalidConfigurationException("Must assign observers to all or none of the partitions. " + syncSize + " partitions with sync replicas. " + observerSize + " partitions with observers.");
            }
        }
        return (Map)syncReplicas.map((Function1<Tuple2, Tuple2> & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                int partition = tuple2._1$mcI$sp();
                Seq replicas = (Seq)tuple2._2();
                Seq observerAssignment = (Seq)observerReplicas.getOrElse(BoxesRunTime.boxToInteger(partition), (Function0<Seq> & Serializable)() -> (Seq)Seq$.MODULE$.empty());
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(BoxesRunTime.boxToInteger(partition)), ReplicaAssignment$.MODULE$.apply((Seq)replicas.$plus$plus(observerAssignment), observerAssignment));
            }
            throw new MatchError(tuple2);
        });
    }

    public Seq<Tuple2<Object, Seq<BrokerMetadata>>> partitionBrokersByConstraint(Seq<BrokerMetadata> brokers, Seq<TopicPlacement.ConstraintCount> constraints) {
        return (Seq)constraints.map((Function1<TopicPlacement.ConstraintCount, Tuple2> & Serializable)constraint -> {
            Seq matchedBrokers = (Seq)brokers.filter((Function1<BrokerMetadata, Object> & Serializable)broker -> BoxesRunTime.boxToBoolean(Observer$.MODULE$.brokerMatchesPlacementConstraint(broker, constraint)));
            if (matchedBrokers.size() < constraint.count()) {
                throw new InvalidConfigurationException("Number of broker found (" + matchedBrokers.size() + ") matching constraint " + constraint + " is less than required count " + constraint.count());
            }
            return new Tuple2<Integer, Seq>(BoxesRunTime.boxToInteger(constraint.count()), matchedBrokers);
        });
    }

    public void validatePartitioning(Seq<Seq<BrokerMetadata>> partitionedBrokers) {
        Tuple2<Integer, Object> tuple2 = partitionedBrokers.foldLeft(new Tuple2<Integer, Object>(BoxesRunTime.boxToInteger(0), Predef$.MODULE$.Set().empty()), (Function2<Tuple2, Seq, Tuple2> & Serializable)(acc, brokers) -> {
            Tuple2 tuple2 = acc;
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            int count = tuple2._1$mcI$sp();
            scala.collection.immutable.Set allBrokers = (scala.collection.immutable.Set)tuple2._2();
            Tuple2<Integer, scala.collection.immutable.Set> tuple22 = new Tuple2<Integer, scala.collection.immutable.Set>(BoxesRunTime.boxToInteger(count), allBrokers);
            int count2 = tuple22._1$mcI$sp();
            scala.collection.immutable.Set allBrokers2 = tuple22._2();
            if (brokers.toSet().size() != brokers.size()) {
                throw new InvalidConfigurationException("Duplicate eligible brokers " + brokers + " match a placement constraints.");
            }
            return new Tuple2(BoxesRunTime.boxToInteger(count2 + brokers.size()), allBrokers2.$plus$plus(brokers));
        });
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        int count = tuple2._1$mcI$sp();
        scala.collection.immutable.Set allBrokers = (scala.collection.immutable.Set)tuple2._2();
        Tuple2<Integer, scala.collection.immutable.Set> tuple22 = new Tuple2<Integer, scala.collection.immutable.Set>(BoxesRunTime.boxToInteger(count), allBrokers);
        int count2 = tuple22._1$mcI$sp();
        scala.collection.immutable.Set allBrokers2 = tuple22._2();
        if (count2 != allBrokers2.size()) {
            throw new InvalidConfigurationException("Some brokers satisfy more than one placement constraints: " + partitionedBrokers);
        }
    }

    public scala.collection.mutable.Map<Object, Seq<Object>> mergeAssignmentMap(scala.collection.mutable.Map<Object, Seq<Object>> mergedAssignment, Map<Object, Seq<Object>> currentAssignment) {
        return (scala.collection.mutable.Map)mergedAssignment.$plus$plus(currentAssignment.map((Function1<Tuple2, Tuple2> & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                int partitionId = tuple2._1$mcI$sp();
                Seq replicaIds = (Seq)tuple2._2();
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(BoxesRunTime.boxToInteger(partitionId)), MODULE$.mergeReplicaLists((Seq)mergedAssignment.getOrElse(BoxesRunTime.boxToInteger(partitionId), (Function0<Seq> & Serializable)() -> (Seq)Seq$.MODULE$.empty()), replicaIds));
            }
            throw new MatchError(tuple2);
        }));
    }

    public Seq<Object> mergeReplicaLists(Seq<Object> brokerList1, Seq<Object> brokerList2) {
        Seq commonReplicas = (Seq)brokerList1.intersect(brokerList2);
        if (commonReplicas.nonEmpty()) {
            throw new InvalidConfigurationException("Replica with ids (" + commonReplicas + ") satisfy more than one placement constraints.");
        }
        return (Seq)brokerList1.$plus$plus(brokerList2);
    }

    public boolean brokerMatchesPlacementConstraint(BrokerMetadata broker, TopicPlacement.ConstraintCount constraint) {
        return this.brokerMatchesPlacementConstraint(broker, CollectionConverters$.MODULE$.MapHasAsScala(constraint.constraints()).asScala());
    }

    public boolean brokerMatchesPlacementConstraint(BrokerMetadata broker, Map<String, String> rack2) {
        scala.collection.immutable.Map properties = Option$.MODULE$.option2Iterable(OptionConverters.RichOptional$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptional(broker.rack)).map((Function1<String, Tuple2> & Serializable)rack -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(MODULE$.RackConstraintKey()), rack))).toMap($less$colon$less$.MODULE$.refl());
        return TopicPlacement.ConstraintCount.isSubset(CollectionConverters$.MODULE$.MapHasAsJava(rack2).asJava(), CollectionConverters$.MODULE$.MapHasAsJava(properties).asJava());
    }

    public Option<ApiError> validateAssignment(Option<TopicPlacement> topicPlacement, ReplicaAssignment.Assignment assignment, Map<Object, Map<String, String>> liveBrokerAttributes) {
        return this.validateAssignmentStructure(assignment).orElse((Function0<Option> & Serializable)() -> topicPlacement.flatMap((Function1<TopicPlacement, Option> & Serializable)placementConstraint -> OptionConverters.RichOptional$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptional(TopicPlacement.validateAssignment(placementConstraint, CollectionConverters$.MODULE$.SeqHasAsJava((Seq)assignment.syncReplicas().map((Function1<Object, TopicPlacement.Replica> & Serializable)id -> Observer$.$anonfun$validateAssignment$3(liveBrokerAttributes, BoxesRunTime.unboxToInt(id)))).asJava(), CollectionConverters$.MODULE$.SeqHasAsJava((Seq)assignment.observers().map((Function1<Object, TopicPlacement.Replica> & Serializable)id -> Observer$.$anonfun$validateAssignment$5(liveBrokerAttributes, BoxesRunTime.unboxToInt(id)))).asJava()))).map((Function1<String, ApiError> & Serializable)message -> new ApiError(Errors.INVALID_REPLICA_ASSIGNMENT, (String)message))));
    }

    public Option<ApiError> validateAssignmentStructure(ReplicaAssignment.Assignment assignment) {
        Seq<Object> replicas = assignment.replicas();
        scala.collection.immutable.Set replicaSet = replicas.toSet();
        if (replicas.isEmpty() || replicas.size() != replicaSet.size()) {
            return new Some<ApiError>(new ApiError(Errors.INVALID_REPLICA_ASSIGNMENT, "Duplicate replicas not allowed in partition assignment: " + replicas.mkString(", ") + "."));
        }
        if (replicas.exists(x$14 -> x$14 < 0)) {
            return new Some<ApiError>(new ApiError(Errors.INVALID_REPLICA_ASSIGNMENT, "Invalid replica id in partition assignment: " + replicas.mkString(", ")));
        }
        if (!assignment.replicas().endsWith(assignment.observers())) {
            String observerMsg = assignment.observers().mkString(", ");
            return new Some<ApiError>(new ApiError(Errors.INVALID_REPLICA_ASSIGNMENT, "Assignment contains observers (" + observerMsg + ") and the replicas' (" + replicas.mkString(", ") + ") suffix doesn't match observers."));
        }
        return None$.MODULE$;
    }

    public Option<ApiError> validateReassignment(Optional<TopicPlacement> topicPlacement, ReplicaAssignment reassignment, Map<Object, Map<String, String>> liveBrokerAttributes) {
        return reassignment.targetAssignment().flatMap((Function1<ReplicaAssignment.Assignment, Option> & Serializable)assignment -> OptionConverters.RichOptional$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptional(topicPlacement)).flatMap((Function1<TopicPlacement, Option> & Serializable)placementConstraint -> OptionConverters.RichOptional$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptional(TopicPlacement.validateAssignment(placementConstraint, CollectionConverters$.MODULE$.SeqHasAsJava((Seq)assignment.syncReplicas().map((Function1<Object, TopicPlacement.Replica> & Serializable)id -> Observer$.$anonfun$validateReassignment$3(liveBrokerAttributes, BoxesRunTime.unboxToInt(id)))).asJava(), CollectionConverters$.MODULE$.SeqHasAsJava((Seq)assignment.observers().map((Function1<Object, TopicPlacement.Replica> & Serializable)id -> Observer$.$anonfun$validateReassignment$5(liveBrokerAttributes, reassignment, BoxesRunTime.unboxToInt(id)))).asJava()))).map((Function1<String, ApiError> & Serializable)message -> new ApiError(Errors.INVALID_REPLICA_ASSIGNMENT, (String)message))));
    }

    public static final /* synthetic */ boolean $anonfun$buildRequiredReplicaCountsAndEligibleBrokers$5(RackAndRequiredReplicaCountsAndEligibleBrokers x) {
        return x.countsAndEligibleBrokers().eligibleBrokers().size() < x.countsAndEligibleBrokers().syncReplicas() + x.countsAndEligibleBrokers().observers();
    }

    public static final /* synthetic */ boolean $anonfun$assignReplicasToPartitionsWithRackMixingSupport$7(Tuple2 x) {
        return ((RackIndexAndAssignment)x._2()).assignment().length() > 0;
    }

    public static final /* synthetic */ boolean $anonfun$assignReplicasToPartitionsWithRackMixingSupport$14(Tuple2 x) {
        return ((RackIndexAndAssignment)x._2()).assignment().length() > 0;
    }

    public static final /* synthetic */ TopicPlacement.Replica $anonfun$validateAssignment$3(Map liveBrokerAttributes$1, int id) {
        return TopicPlacement.Replica.of(id, Optional.of(CollectionConverters$.MODULE$.MapHasAsJava((Map)liveBrokerAttributes$1.getOrElse(BoxesRunTime.boxToInteger(id), (Function0<Map> & Serializable)() -> (Map)scala.collection.Map$.MODULE$.empty())).asJava()));
    }

    public static final /* synthetic */ TopicPlacement.Replica $anonfun$validateAssignment$5(Map liveBrokerAttributes$1, int id) {
        return TopicPlacement.Replica.of(id, Optional.of(CollectionConverters$.MODULE$.MapHasAsJava((Map)liveBrokerAttributes$1.getOrElse(BoxesRunTime.boxToInteger(id), (Function0<Map> & Serializable)() -> (Map)scala.collection.Map$.MODULE$.empty())).asJava()));
    }

    public static final /* synthetic */ TopicPlacement.Replica $anonfun$validateReassignment$3(Map liveBrokerAttributes$2, int id) {
        return TopicPlacement.Replica.of(id, Optional.of(CollectionConverters$.MODULE$.MapHasAsJava((Map)liveBrokerAttributes$2.getOrElse(BoxesRunTime.boxToInteger(id), (Function0<Map> & Serializable)() -> (Map)scala.collection.Map$.MODULE$.empty())).asJava()));
    }

    public static final /* synthetic */ TopicPlacement.Replica $anonfun$validateReassignment$5(Map liveBrokerAttributes$2, ReplicaAssignment reassignment$1, int id) {
        Option attributes = liveBrokerAttributes$2.get(BoxesRunTime.boxToInteger(id));
        Option attributes2 = reassignment$1.originAssignment().replicas().contains(BoxesRunTime.boxToInteger(id)) ? attributes : attributes.orElse((Function0<Some> & Serializable)() -> new Some(scala.collection.Map$.MODULE$.empty()));
        return TopicPlacement.Replica.of(id, OptionConverters.RichOption$.MODULE$.toJava$extension(OptionConverters$.MODULE$.RichOption(attributes2.map((Function1<Map, java.util.Map> & Serializable)x$15 -> CollectionConverters$.MODULE$.MapHasAsJava(x$15).asJava()))));
    }

    private Observer$() {
    }
}

