/*
 * Decompiled with CFR 0.152.
 */
package kafka.controller.rest;

import io.confluent.rest.BeginShutdownControllerHandle;
import io.confluent.rest.BeginShutdownControllerStatus;
import io.confluent.rest.CheckReadyControllerHandle;
import io.confluent.rest.CheckReadyControllerStatus;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.QuorumInfo;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.metadata.client.CannotCreateClientWithCurrentMetadataException;
import org.slf4j.Logger;

public class ControllerServerRestHandler
implements BeginShutdownControllerHandle,
CheckReadyControllerHandle {
    static final long MAX_ALLOWED_CAUGHT_UP_TIME_LAG_MS = 30000L;
    private final Logger log;
    private final Time time;
    private final int nodeId;
    private final Function<String, Admin> adminClientSupplier;
    private Admin adminClient;

    public ControllerServerRestHandler(LogContext logContext, Time time, int nodeId, Function<String, Admin> adminClientSupplier) {
        this.log = logContext.logger(ControllerServerRestHandler.class);
        this.time = time;
        this.nodeId = nodeId;
        this.adminClientSupplier = adminClientSupplier;
        this.adminClient = null;
    }

    void maybeCreateAdminClient() {
        if (this.adminClient != null) {
            this.log.trace("maybeCreateAdminClient: AdminClient does not need to be created because it already exists.");
            return;
        }
        try {
            this.adminClient = this.adminClientSupplier.apply("kcontroller-rest-handler");
        }
        catch (Exception e) {
            this.log.error("maybeCreateAdminClient: error creating adminClient.", (Throwable)e);
            throw e;
        }
        this.log.trace("maybeCreateAdminClient: created new admin client.");
    }

    QuorumInfo describeMetadataQuorum() {
        try {
            return this.adminClient.describeMetadataQuorum().quorumInfo().get(2L, TimeUnit.MINUTES);
        }
        catch (ExecutionException e) {
            this.log.error("Error checking rollable status: describeMetadataQuorum failed.", e.getCause());
            this.closeAdminClientAndSetItToNull();
            throw new RuntimeException(e.getCause().getClass().getSimpleName());
        }
        catch (Exception e) {
            this.log.error("Error checking rollable status: sending describeMetadataQuorum failed.", (Throwable)e);
            this.closeAdminClientAndSetItToNull();
            throw new RuntimeException(e.getClass().getSimpleName());
        }
    }

    @Override
    public BeginShutdownControllerStatus generateRollableStatus() {
        QuorumInfo info;
        try {
            this.maybeCreateAdminClient();
        }
        catch (CannotCreateClientWithCurrentMetadataException e) {
            return new BeginShutdownControllerStatus(false, "Error checking rollable status: failed to create AdminClient from current metadata.");
        }
        catch (Exception e) {
            return new BeginShutdownControllerStatus(false, "Error checking rollable status: failed to create AdminClient.");
        }
        try {
            info = this.describeMetadataQuorum();
        }
        catch (Exception e) {
            return new BeginShutdownControllerStatus(false, "Error checking rollable status: describeMetadataQuorum call failed: " + e.getMessage());
        }
        BeginShutdownControllerStatus status = ControllerServerRestHandler.translateRollableInfo(info.voters(), this.time.milliseconds());
        this.log.info("Checking rollable status: {}.{}", (Object)(status.rollable() ? "TRUE" : "FALSE"), status.rollable() ? "" : " " + status.reason());
        return status;
    }

    static BeginShutdownControllerStatus translateRollableInfo(Collection<QuorumInfo.ReplicaState> voters, long nowMs) {
        TreeMap<Integer, Object> voterIdToVoterString = new TreeMap<Integer, Object>();
        for (QuorumInfo.ReplicaState voter : voters) {
            if (voter.logEndOffset() < 0L) {
                voterIdToVoterString.put(voter.replicaId(), "unreachable");
                continue;
            }
            if (!voter.lastCaughtUpTimestamp().isPresent()) {
                voterIdToVoterString.put(voter.replicaId(), "not caught up");
                continue;
            }
            long lagMs = nowMs - voter.lastCaughtUpTimestamp().getAsLong();
            if (lagMs > 30000L) {
                voterIdToVoterString.put(voter.replicaId(), "lagging by " + lagMs + " ms");
                continue;
            }
            voterIdToVoterString.put(voter.replicaId(), "");
        }
        String prefix = "Some controller quorum nodes had problems: ";
        StringBuilder problemStringBuilder = new StringBuilder();
        for (Map.Entry entry : voterIdToVoterString.entrySet()) {
            if (((String)entry.getValue()).isEmpty()) continue;
            problemStringBuilder.append(prefix).append(entry.getKey()).append(" was ").append((String)entry.getValue());
            prefix = ", ";
        }
        String problemString = problemStringBuilder.toString();
        return new BeginShutdownControllerStatus(problemString.isEmpty(), problemString);
    }

    @Override
    public CheckReadyControllerStatus generateReadinessStatus() {
        QuorumInfo info;
        try {
            this.maybeCreateAdminClient();
        }
        catch (CannotCreateClientWithCurrentMetadataException e) {
            return new CheckReadyControllerStatus(false, "Error checking readiness status: failed to create AdminClient from current metadata.");
        }
        catch (Exception e) {
            return new CheckReadyControllerStatus(false, "Error checking readiness status: failed to create AdminClient.");
        }
        try {
            info = this.describeMetadataQuorum();
        }
        catch (Exception e) {
            return new CheckReadyControllerStatus(false, "Error checking readiness status: describeMetadataQuorum call failed: " + e.getMessage());
        }
        CheckReadyControllerStatus status = ControllerServerRestHandler.translateReadinessInfo(info.voters(), this.nodeId, this.time.milliseconds());
        this.log.info("Checking readiness status: {}.{}", (Object)(status.ready() ? "TRUE" : "FALSE"), status.ready() ? "" : " " + status.reason());
        return status;
    }

    static CheckReadyControllerStatus translateReadinessInfo(Collection<QuorumInfo.ReplicaState> voters, int nodeId, long nowMs) {
        QuorumInfo.ReplicaState voter = ControllerServerRestHandler.getVoterById(voters, nodeId);
        if (voter == null) {
            return new CheckReadyControllerStatus(false, "Can't find node " + nodeId + " in QuorumInfo.");
        }
        if (voter.logEndOffset() < 0L) {
            return new CheckReadyControllerStatus(false, "Node " + nodeId + " is unreachable.");
        }
        if (!voter.lastCaughtUpTimestamp().isPresent()) {
            return new CheckReadyControllerStatus(false, "Node " + nodeId + " is not caught up.");
        }
        long lagMs = nowMs - voter.lastCaughtUpTimestamp().getAsLong();
        if (lagMs > 30000L) {
            return new CheckReadyControllerStatus(false, "Node " + nodeId + " is lagging by " + lagMs + " ms.");
        }
        return new CheckReadyControllerStatus(true, "");
    }

    static QuorumInfo.ReplicaState getVoterById(Collection<QuorumInfo.ReplicaState> voters, int nodeId) {
        for (QuorumInfo.ReplicaState voter : voters) {
            if (voter.replicaId() != nodeId) continue;
            return voter;
        }
        return null;
    }

    void closeAdminClientAndSetItToNull() {
        if (this.adminClient != null) {
            try {
                this.adminClient.close();
            }
            catch (Exception e) {
                this.log.warn("Error closing adminClient", (Throwable)e);
            }
            this.adminClient = null;
        }
    }

    @Override
    public void close() throws IOException {
        this.closeAdminClientAndSetItToNull();
    }
}

