/*
 * Decompiled with CFR 0.152.
 */
package kafka.durability.materialization.validation;

import java.io.Serializable;
import kafka.durability.DurabilityAuditMirrorState;
import kafka.durability.Utils$;
import kafka.durability.audit.AuditReporter;
import kafka.durability.db.PartitionState;
import kafka.durability.events.broker.DestLogEpochChangeEvent;
import kafka.durability.events.broker.EpochChangeEvent;
import kafka.durability.events.broker.RetentionType$;
import kafka.durability.events.broker.StartOffsetChangeEvent;
import kafka.durability.materialization.DurabilityLapseType$;
import kafka.durability.materialization.validation.AbstractValidator;
import kafka.durability.materialization.validation.BrokerValidator$;
import kafka.log.AbstractLog;
import kafka.server.ReplicaManager;
import kafka.tier.state.SegmentState;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.utils.Time;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Set;
import scala.collection.mutable.HashMap;
import scala.jdk.OptionConverters;
import scala.jdk.OptionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.NonLocalReturnControl$mcV$sp;
import scala.runtime.ObjectRef;

@ScalaSignature(bytes="\u0006\u0005\tMe\u0001\u0002\u0016,\u0001QB\u0001\"\u000f\u0001\u0003\u0006\u0004%\tA\u000f\u0005\t\u0003\u0002\u0011\t\u0011)A\u0005w!A!\t\u0001BC\u0002\u0013\u00053\tC\u0005K\u0001\t\u0005\t\u0015!\u0003E\u0017\"AA\n\u0001B\u0001B\u0003%Q\nC\u0003[\u0001\u0011\u00051\f\u0003\u0005a\u0001\t\u0007I\u0011A\u0017b\u0011\u0019A\u0007\u0001)A\u0005E\"9\u0011\u000e\u0001b\u0001\n\u0013\t\u0007B\u00026\u0001A\u0003%!\rC\u0004l\u0001\t\u0007I\u0011B1\t\r1\u0004\u0001\u0015!\u0003c\u0011\u001di\u0007A1A\u0005\n\u0005DaA\u001c\u0001!\u0002\u0013\u0011\u0007\"B8\u0001\t\u0003\u0002\b\"\u0002?\u0001\t\u0003i\b\"CA\"\u0001E\u0005I\u0011AA#\u0011%\tY\u0006AI\u0001\n\u0003\ti\u0006C\u0005\u0002b\u0001\t\n\u0011\"\u0001\u0002^!I\u00111\r\u0001\u0012\u0002\u0013\u0005\u0011Q\t\u0005\b\u0003K\u0002A\u0011AA4\u0011%\ti\bAI\u0001\n\u0003\t)\u0005C\u0004\u0002\u0000\u0001!I!!!\t\u000f\u0005]\u0006\u0001\"\u0001\u0002:\"I\u00111\u001a\u0001\u0012\u0002\u0013\u0005\u0011Q\t\u0005\b\u0003\u001b\u0004A\u0011BAh\u0011\u001d\t\t\u0010\u0001C\u0005\u0003gDq!a@\u0001\t\u0003\u0011\t\u0001C\u0004\u0003\u001a\u0001!\tAa\u0007\t\u000f\t%\u0002\u0001\"\u0001\u0003,!9!1\u0007\u0001\u0005\u0002\tU\u0002b\u0002B\"\u0001\u0011\u0005!Q\t\u0005\b\u0005\u001b\u0002A\u0011\u0002B(\u0011\u001d\u0011I\u0006\u0001C\u0005\u00057B\u0001B!\u001a\u0001\t\u0003i#q\r\u0005\t\u0005W\u0002A\u0011A\u0017\u0003n!9!\u0011\u000f\u0001\u0005\n\tMt!\u0003B@W\u0005\u0005\t\u0012\u0001BA\r!Q3&!A\t\u0002\t\r\u0005B\u0002.(\t\u0003\u0011Y\tC\u0005\u0003\u000e\u001e\n\n\u0011\"\u0001\u0003\u0010\ny!I]8lKJ4\u0016\r\\5eCR|'O\u0003\u0002-[\u0005Qa/\u00197jI\u0006$\u0018n\u001c8\u000b\u00059z\u0013aD7bi\u0016\u0014\u0018.\u00197ju\u0006$\u0018n\u001c8\u000b\u0005A\n\u0014A\u00033ve\u0006\u0014\u0017\u000e\\5us*\t!'A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001)\u0004C\u0001\u001c8\u001b\u0005Y\u0013B\u0001\u001d,\u0005E\t%m\u001d;sC\u000e$h+\u00197jI\u0006$xN]\u0001\u000fe\u0016\u0004H.[2b\u001b\u0006t\u0017mZ3s+\u0005Y\u0004C\u0001\u001f@\u001b\u0005i$B\u0001 2\u0003\u0019\u0019XM\u001d<fe&\u0011\u0001)\u0010\u0002\u000f%\u0016\u0004H.[2b\u001b\u0006t\u0017mZ3s\u0003=\u0011X\r\u001d7jG\u0006l\u0015M\\1hKJ\u0004\u0013\u0001\u0003:fa>\u0014H/\u001a:\u0016\u0003\u0011\u0003\"!\u0012%\u000e\u0003\u0019S!aR\u0018\u0002\u000b\u0005,H-\u001b;\n\u0005%3%!D!vI&$(+\u001a9peR,'/A\u0005sKB|'\u000f^3sA%\u0011!iN\u0001\u0005i&lW\r\u0005\u0002O16\tqJ\u0003\u0002Q#\u0006)Q\u000f^5mg*\u0011!kU\u0001\u0007G>lWn\u001c8\u000b\u0005I\"&BA+W\u0003\u0019\t\u0007/Y2iK*\tq+A\u0002pe\u001eL!!W(\u0003\tQKW.Z\u0001\u0007y%t\u0017\u000e\u001e \u0015\tqkfl\u0018\t\u0003m\u0001AQ!\u000f\u0004A\u0002mBQA\u0011\u0004A\u0002\u0011Cq\u0001\u0014\u0004\u0011\u0002\u0003\u0007Q*\u0001\u000fSKR,g\u000e^5p]RKW.Z'be\u001eLgn\u00144FeJ|'/T:\u0016\u0003\t\u0004\"a\u00194\u000e\u0003\u0011T\u0011!Z\u0001\u0006g\u000e\fG.Y\u0005\u0003O\u0012\u00141!\u00138u\u0003u\u0011V\r^3oi&|g\u000eV5nK6\u000b'oZ5o\u001f\u001a,%O]8s\u001bN\u0004\u0013A\u0007*fi\u0016tG/[8o'&TX-T1sO&twJZ#se>\u0014\u0018a\u0007*fi\u0016tG/[8o'&TX-T1sO&twJZ#se>\u0014\b%A\u000eNCb|eMZ:fi\u001e\u000b\u0007\u000fV8mKJ\fgnY3US6,Wj]\u0001\u001d\u001b\u0006DxJ\u001a4tKR<\u0015\r\u001d+pY\u0016\u0014\u0018M\\2f)&lW-T:!\u00031j\u0015\r\u001f%jO\"<\u0016\r^3s[\u0006\u00148\u000eV8mKJ\fgnY3G_Jl\u0015N\u001d:peB\u000b'\u000f^5uS>t7/A\u0017NCbD\u0015n\u001a5XCR,'/\\1sWR{G.\u001a:b]\u000e,gi\u001c:NSJ\u0014xN\u001d)beRLG/[8og\u0002\n!\u0002\\8hO\u0016\u0014h*Y7f+\u0005\t\bC\u0001:z\u001d\t\u0019x\u000f\u0005\u0002uI6\tQO\u0003\u0002wg\u00051AH]8pizJ!\u0001\u001f3\u0002\rA\u0013X\rZ3g\u0013\tQ8P\u0001\u0004TiJLgn\u001a\u0006\u0003q\u0012\fqC^1mS\u0012\fG/\u001a#C\u0011&<\u0007nV1uKJl\u0017M]6\u0015#y\f\u0019!a\u0004\u0002\u0014\u0005u\u0011QFA\u0019\u0003w\ty\u0004\u0005\u0002d\u007f&\u0019\u0011\u0011\u00013\u0003\tUs\u0017\u000e\u001e\u0005\b\u0003\u000b\u0001\u0002\u0019AA\u0004\u00039!x\u000e]5d!\u0006\u0014H/\u001b;j_:\u0004B!!\u0003\u0002\f5\t\u0011+C\u0002\u0002\u000eE\u0013a\u0002V8qS\u000e\u0004\u0016M\u001d;ji&|g\u000e\u0003\u0004\u0002\u0012A\u0001\rAY\u0001\u0006KB|7\r\u001b\u0005\b\u0003+\u0001\u0002\u0019AA\f\u0003\rAw/\u001c\t\u0004G\u0006e\u0011bAA\u000eI\n!Aj\u001c8h\u0011\u001d\ty\u0002\u0005a\u0001\u0003C\tQa\u001d;bi\u0016\u0004B!a\t\u0002*5\u0011\u0011Q\u0005\u0006\u0004\u0003Oy\u0013A\u00013c\u0013\u0011\tY#!\n\u0003\u001dA\u000b'\u000f^5uS>t7\u000b^1uK\"A\u0011q\u0006\t\u0011\u0002\u0003\u0007\u0011/\u0001\u0005nKR\fG-\u0019;b\u0011%\t\u0019\u0004\u0005I\u0001\u0002\u0004\t)$A\u0007jg\u0016\u0003xn\u00195DQ\u0006tw-\u001a\t\u0004G\u0006]\u0012bAA\u001dI\n9!i\\8mK\u0006t\u0007\"CA\u001f!A\u0005\t\u0019AA\u001b\u0003q!(/[4hKJ,GMQ=NSJ\u0014xN]*uCR,7\t[1oO\u0016D\u0001\"!\u0011\u0011!\u0003\u0005\r!]\u0001\u0015[&\u0014(o\u001c:Ti\u0006$XM\u0012:p[\u00163XM\u001c;\u0002CY\fG.\u001b3bi\u0016$%\tS5hQ^\u000bG/\u001a:nCJ\\G\u0005Z3gCVdG\u000fJ\u001b\u0016\u0005\u0005\u001d#fA9\u0002J-\u0012\u00111\n\t\u0005\u0003\u001b\n9&\u0004\u0002\u0002P)!\u0011\u0011KA*\u0003%)hn\u00195fG.,GMC\u0002\u0002V\u0011\f!\"\u00198o_R\fG/[8o\u0013\u0011\tI&a\u0014\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-A\u0011wC2LG-\u0019;f\t\nC\u0015n\u001a5XCR,'/\\1sW\u0012\"WMZ1vYR$c'\u0006\u0002\u0002`)\"\u0011QGA%\u0003\u00052\u0018\r\\5eCR,GI\u0011%jO\"<\u0016\r^3s[\u0006\u00148\u000e\n3fM\u0006,H\u000e\u001e\u00138\u0003\u00052\u0018\r\\5eCR,GI\u0011%jO\"<\u0016\r^3s[\u0006\u00148\u000e\n3fM\u0006,H\u000e\u001e\u00139\u0003e1\u0018\r\\5eCR,Gj\\2bY2{w-\u00128e\u001f\u001a47/\u001a;\u0015\u001by\fI'a\u001b\u0002n\u0005=\u0014\u0011PA>\u0011\u001d\t)!\u0006a\u0001\u0003\u000fAa!!\u0005\u0016\u0001\u0004\u0011\u0007bBA\u000b+\u0001\u0007\u0011q\u0003\u0005\b\u0003c*\u0002\u0019AA:\u0003\rI7O\u001d\t\u0005e\u0006U$-C\u0002\u0002xm\u00141aU3u\u0011\u001d\ty\"\u0006a\u0001\u0003CA\u0001\"a\f\u0016!\u0003\u0005\r!]\u0001$m\u0006d\u0017\u000eZ1uK2{7-\u00197M_\u001e,e\u000eZ(gMN,G\u000f\n3fM\u0006,H\u000e\u001e\u00137\u0003E9W\r\u001e*fi\u0016tG/[8o-\u0006dW/\u001a\u000b\t\u0003\u0007\u000bI)a#\u0002\u000eB)1-!\"\u0002\u0018%\u0019\u0011q\u00113\u0003\r=\u0003H/[8o\u0011\u001d\t)a\u0006a\u0001\u0003\u000fAq!a\b\u0018\u0001\u0004\t\t\u0003C\u0004\u0002\u0010^\u0001\r!!%\u0002\u001bI,G/\u001a8uS>tG+\u001f9f!\u0011\t\u0019*!-\u000f\t\u0005U\u00151\u0016\b\u0005\u0003/\u000b)K\u0004\u0003\u0002\u001a\u0006\u0005f\u0002BAN\u0003?s1\u0001^AO\u0013\u0005\u0011\u0014B\u0001\u00192\u0013\r\t\u0019kL\u0001\u0007KZ,g\u000e^:\n\t\u0005\u001d\u0016\u0011V\u0001\u0007EJ|7.\u001a:\u000b\u0007\u0005\rv&\u0003\u0003\u0002.\u0006=\u0016!\u0004*fi\u0016tG/[8o)f\u0004XM\u0003\u0003\u0002(\u0006%\u0016\u0002BAZ\u0003k\u0013QBU3uK:$\u0018n\u001c8UsB,'\u0002BAW\u0003_\u000b\u0001D^1mS\u0012\fG/\u001a#C\u0019><7\u000b^1si>3gm]3u)!\t)$a/\u0002H\u0006%\u0007bBA_1\u0001\u0007\u0011qX\u0001\u0006KZ,g\u000e\u001e\t\u0005\u0003\u0003\f\u0019-\u0004\u0002\u00020&!\u0011QYAX\u0005Y\u0019F/\u0019:u\u001f\u001a47/\u001a;DQ\u0006tw-Z#wK:$\bbBA\u00101\u0001\u0007\u0011\u0011\u0005\u0005\t\u0003_A\u0002\u0013!a\u0001c\u0006\u0011c/\u00197jI\u0006$X\r\u0012\"M_\u001e\u001cF/\u0019:u\u001f\u001a47/\u001a;%I\u00164\u0017-\u001e7uIM\nAc]5{K2\u000b\u0007o]3DC2\u001cW\u000f\\1uS>tG\u0003DA\u001b\u0003#\f\u0019.!6\u0002Z\u0006m\u0007bBA_5\u0001\u0007\u0011q\u0018\u0005\b\u0003?Q\u0002\u0019AA\u0011\u0011\u001d\t9N\u0007a\u0001\u0003/\taB]3uK:$\u0018n\u001c8WC2,X\r\u0003\u0004\u00020i\u0001\r!\u001d\u0005\b\u0003;T\u0002\u0019AAp\u0003%a\u0017\r]:f)f\u0004X\r\u0005\u0003\u0002b\u0006-h\u0002BAr\u0003OtA!!'\u0002f&\u0011afL\u0005\u0004\u0003Sl\u0013a\u0005#ve\u0006\u0014\u0017\u000e\\5us2\u000b\u0007o]3UsB,\u0017\u0002BAw\u0003_\u00141\u0003R;sC\nLG.\u001b;z\u0019\u0006\u00048/\u001a+za\u0016T1!!;.\u0003Q!\u0018.\\3MCB\u001cXmQ1mGVd\u0017\r^5p]Ra\u0011QGA{\u0003o\fI0a?\u0002~\"9\u0011QX\u000eA\u0002\u0005}\u0006bBA\u00107\u0001\u0007\u0011\u0011\u0005\u0005\b\u0003/\\\u0002\u0019AA\f\u0011\u0019\tyc\u0007a\u0001c\"9\u0011Q\\\u000eA\u0002\u0005}\u0017a\u0007<bY&$\u0017\r^3M_\u000e\fG\u000eT8h'R\f'\u000f^(gMN,G\u000fF\u0005\u007f\u0005\u0007\u0011iAa\u0005\u0003\u0018!9!Q\u0001\u000fA\u0002\t\u001d\u0011\u0001\u0005;pa&\u001c\u0017\n\u001a)beRLG/[8o!\u0011\tIA!\u0003\n\u0007\t-\u0011K\u0001\tU_BL7-\u00133QCJ$\u0018\u000e^5p]\"9!q\u0002\u000fA\u0002\tE\u0011aC7jeJ|'o\u0015;bi\u0016\u0004BaYACc\"9!Q\u0003\u000fA\u0002\u0005]\u0011\u0001\u00047fC\u0012,'o\u00144gg\u0016$\bBBA\u00189\u0001\u0007\u0011/A\u000bwC2LG-\u0019;f\t\n+\u0005o\\2i\u0007\"\fgnZ3\u0015\u000fy\u0014iB!\n\u0003(!9\u0011QX\u000fA\u0002\t}\u0001\u0003BAa\u0005CIAAa\t\u00020\n\u0001R\t]8dQ\u000eC\u0017M\\4f\u000bZ,g\u000e\u001e\u0005\b\u0003?i\u0002\u0019AA\u0011\u0011\u0019\ty#\ba\u0001c\u0006ab/\u00197jI\u0006$X-\u00129pG\"\u001c\u0005.\u00198hK^KG\u000f\u001b'pG\u0006dGc\u0002@\u0003.\t=\"\u0011\u0007\u0005\b\u0003{s\u0002\u0019\u0001B\u0010\u0011\u001d\u0011yA\ba\u0001\u0005#Aa!a\f\u001f\u0001\u0004\t\u0018a\t<bY&$\u0017\r^3EKN$Hj\\4Fa>\u001c\u0007n\u00115b]\u001e,w+\u001b;i\u0019>\u001c\u0017\r\u001c\u000b\b}\n]\"q\bB!\u0011\u001d\til\ba\u0001\u0005s\u0001B!!1\u0003<%!!QHAX\u0005]!Um\u001d;M_\u001e,\u0005o\\2i\u0007\"\fgnZ3Fm\u0016tG\u000fC\u0004\u0002 }\u0001\r!!\t\t\r\u0005=r\u00041\u0001r\u0003m1\u0018\r\\5eCR,W\t]8dQ\u000eC\u0017-\u001b8XSRDGj\\2bYR9aPa\u0012\u0003J\t-\u0003bBA\u0003A\u0001\u0007\u0011q\u0001\u0005\b\u0003?\u0001\u0003\u0019AA\u0011\u0011\u0019\ty\u0003\ta\u0001c\u0006)s/\u001b;iS:l\u0015M]4j]>3WI\u001d:pe\u001a{'\u000fV5nK6\u001b(+\u001a;f]RLwN\u001c\u000b\u0007\u0003k\u0011\tF!\u0016\t\u000f\tM\u0013\u00051\u0001\u0002\u0018\u00051A/[7f\u001bNDqAa\u0016\"\u0001\u0004\t9\"A\u0006sKR,g\u000e^5p]6\u001b\u0018aI<ji\"Lg.T1sO&twJZ#se>\u0014hi\u001c:TSj,'+\u001a;f]RLwN\u001c\u000b\u0007\u0003k\u0011iF!\u0019\t\u000f\t}#\u00051\u0001\u0002\u0018\u0005!1/\u001b>f\u0011\u001d\u0011\u0019G\ta\u0001\u0003/\tQB]3uK:$\u0018n\u001c8TSj,\u0017\u0001C5t\u0013:\u001c\u0016P\\2\u0015\t\u0005U\"\u0011\u000e\u0005\b\u0003c\u001a\u0003\u0019AA:\u0003\u001dI7/\u00138J'J#B!!\u000e\u0003p!9\u0011Q\u0001\u0013A\u0002\u0005\u001d\u0011\u0001D4fi2\u000b\u0007o]3UsB,G\u0003CAp\u0005k\u00129Ha\u001f\t\u000f\t=Q\u00051\u0001\u0003\u0012!9!\u0011P\u0013A\u0002\u0005}\u0017!\u00027baN,\u0007b\u0002B?K\u0001\u0007\u0011QG\u0001\tSNdU-\u00193fe\u0006y!I]8lKJ4\u0016\r\\5eCR|'\u000f\u0005\u00027OM\u0019qE!\"\u0011\u0007\r\u00149)C\u0002\u0003\n\u0012\u0014a!\u00118z%\u00164GC\u0001BA\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%gU\u0011!\u0011\u0013\u0016\u0004\u001b\u0006%\u0003")
public class BrokerValidator
extends AbstractValidator {
    private final ReplicaManager replicaManager;
    private final Time time;
    private final int RetentionTimeMarginOfErrorMs;
    private final int RetentionSizeMarginOfError;
    private final int MaxOffsetGapToleranceTimeMs;
    private final int MaxHighWatermarkToleranceForMirrorPartitions;

    public static Time $lessinit$greater$default$3() {
        return BrokerValidator$.MODULE$.$lessinit$greater$default$3();
    }

    public ReplicaManager replicaManager() {
        return this.replicaManager;
    }

    @Override
    public AuditReporter reporter() {
        return super.reporter();
    }

    public int RetentionTimeMarginOfErrorMs() {
        return this.RetentionTimeMarginOfErrorMs;
    }

    private int RetentionSizeMarginOfError() {
        return this.RetentionSizeMarginOfError;
    }

    private int MaxOffsetGapToleranceTimeMs() {
        return this.MaxOffsetGapToleranceTimeMs;
    }

    private int MaxHighWatermarkToleranceForMirrorPartitions() {
        return this.MaxHighWatermarkToleranceForMirrorPartitions;
    }

    @Override
    public String loggerName() {
        return BrokerValidator.class.getName();
    }

    public void validateDBHighWatermark(TopicPartition topicPartition, int epoch, long hwm, PartitionState state, String metadata, boolean isEpochChange, boolean triggeredByMirrorStateChange, String mirrorStateFromEvent) {
        Enumeration.Value lapseType = this.getLapseType(Option$.MODULE$.apply(mirrorStateFromEvent).filter((Function1<String, Object> & Serializable)x$1 -> BoxesRunTime.boxToBoolean(StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(x$1)))).orElse((Function0<Option> & Serializable)() -> state.mirrorState()), DurabilityLapseType$.MODULE$.HighWatermark(), state.isLeader());
        if (isEpochChange) {
            return;
        }
        if (state.mirrorState().contains(DurabilityAuditMirrorState.PENDING_RESTORE.getName())) {
            return;
        }
        if (!triggeredByMirrorStateChange && state.highWatermark() != 0L && hwm > state.highWatermark() + (long)this.MaxHighWatermarkToleranceForMirrorPartitions() && state.mirrorState().exists((Function1<String, Object> & Serializable)mirrorState -> BoxesRunTime.boxToBoolean(BrokerValidator.$anonfun$validateDBHighWatermark$3(mirrorState)))) {
            String msg = "durability lapse on validation with hwm stored in database, should not append records in the mirror states where mirror partitions are not allowed to fetch data from the source topics\nnew hwm: " + hwm + ", db hwm: " + state.highWatermark() + ", event epoch: " + epoch + "\npartition: " + topicPartition + "\ndb state: " + state + "\nmetadata: " + metadata;
            this.reporter().reportDurabilityLapse(topicPartition, hwm, 1L, lapseType, msg, true, this.reporter().reportDurabilityLapse$default$7(), this.reporter().reportDurabilityLapse$default$8());
            return;
        }
        if (hwm < state.highWatermark()) {
            String msg = "durability lapse on validation with hwm stored in database, hwm decreased from a previous committed value.\nnew hwm: " + hwm + ", db hwm: " + state.highWatermark() + ", event epoch: " + epoch + "\npartition: " + topicPartition + "\ndb state: " + state + "\nmetadata: " + metadata;
            this.reporter().reportDurabilityLapse(topicPartition, hwm, state.highWatermark() - hwm, lapseType, msg, true, this.reporter().reportDurabilityLapse$default$7(), this.reporter().reportDurabilityLapse$default$8());
            return;
        }
    }

    public String validateDBHighWatermark$default$5() {
        return "";
    }

    public boolean validateDBHighWatermark$default$6() {
        return false;
    }

    public boolean validateDBHighWatermark$default$7() {
        return false;
    }

    public String validateDBHighWatermark$default$8() {
        return "";
    }

    public void validateLocalLogEndOffset(TopicPartition topicPartition, int epoch, long hwm, Set<Object> isr, PartitionState state, String metadata) {
        Option<Object> option = Utils$.MODULE$.getLogEndOffset(this.replicaManager(), topicPartition);
        if (option instanceof Some) {
            Some some = (Some)option;
            long localEndOffset = BoxesRunTime.unboxToLong(some.value());
            if (true) {
                long l = localEndOffset;
                if (l < hwm) {
                    String msg = "durability lapse on validation with local log end offset, log end offset is found to be less than hwm.\nlocal end offset: " + l + ", hwm: " + hwm + ", event epoch: " + epoch + ", local replica epoch: " + state.latestLocalEpoch() + ", isr: " + isr + "\npartition: " + topicPartition + "\ndb state: " + state + "\nmetadata: " + metadata;
                    this.reporter().reportDurabilityLapse(topicPartition, l, 1L, DurabilityLapseType$.MODULE$.NonCustomerFacing(), msg, false, this.reporter().reportDurabilityLapse$default$7(), this.reporter().reportDurabilityLapse$default$8());
                    return;
                }
                return;
            }
        }
    }

    public String validateLocalLogEndOffset$default$6() {
        return "";
    }

    private Option<Object> getRetentionValue(TopicPartition topicPartition, PartitionState state, Enumeration.Value retentionType) {
        Enumeration.Value value = retentionType;
        Enumeration.Value value2 = RetentionType$.MODULE$.TimeBasedRetention();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !((Object)value2).equals(value3) : value3 != null)) {
            if (state.retentionMs() != -1L) {
                return new Some<Object>(BoxesRunTime.boxToLong(state.retentionMs()));
            }
            return Utils$.MODULE$.getLocalLogRetentionMs(this.replicaManager(), topicPartition);
        }
        Enumeration.Value value4 = RetentionType$.MODULE$.SizeBasedRetention();
        Enumeration.Value value5 = value;
        if (!(value4 != null ? !((Object)value4).equals(value5) : value5 != null)) {
            if (state.retentionSz() != -1L) {
                return new Some<Object>(BoxesRunTime.boxToLong(state.retentionSz()));
            }
            return Utils$.MODULE$.getLocalLogRetentionSize(this.replicaManager(), topicPartition);
        }
        return None$.MODULE$;
    }

    public boolean validateDBLogStartOffset(StartOffsetChangeEvent event, PartitionState state, String metadata) {
        this.debug((Function0<String> & Serializable)() -> "Validating db log startOffset " + event + " " + state);
        Enumeration.Value value = RetentionType$.MODULE$.apply(event.retentionType());
        Enumeration.Value value2 = RetentionType$.MODULE$.ClusterLinkReplication();
        if (!(value != null ? !((Object)value).equals(value2) : value2 != null)) {
            state.committedStartOffset_$eq(event.logStartOffset());
            state.lapseWatchStartTime_$eq(0L);
            return false;
        }
        Enumeration.Value lapseType = this.getLapseType(state.mirrorState(), DurabilityLapseType$.MODULE$.StartOffset(), state.isLeader());
        Enumeration.Value value3 = RetentionType$.MODULE$.apply(event.retentionType());
        Enumeration.Value value4 = RetentionType$.MODULE$.SizeBasedRetention();
        if (!(value3 != null ? !((Object)value3).equals(value4) : value4 != null)) {
            return this.sizeLapseCalculation(event, state, event.retentionValue(), metadata, lapseType);
        }
        Enumeration.Value value5 = RetentionType$.MODULE$.apply(event.retentionType());
        Enumeration.Value value6 = RetentionType$.MODULE$.TimeBasedRetention();
        if (!(value5 != null ? !((Object)value5).equals(value6) : value6 != null)) {
            return this.timeLapseCalculation(event, state, event.retentionValue(), metadata, lapseType);
        }
        Enumeration.Value value7 = RetentionType$.MODULE$.apply(event.retentionType());
        Enumeration.Value value8 = RetentionType$.MODULE$.Other();
        if (!(value7 != null ? !((Object)value7).equals(value8) : value8 != null)) {
            Tuple2<Option<Object>, Option<Object>> tuple2 = new Tuple2<Option<Object>, Option<Object>>(this.getRetentionValue(event.topicIdPartition().topicPartition(), state, RetentionType$.MODULE$.SizeBasedRetention()), this.getRetentionValue(event.topicIdPartition().topicPartition(), state, RetentionType$.MODULE$.TimeBasedRetention()));
            if (tuple2 != null) {
                Option<Object> option = tuple2._1();
                Option<Object> option2 = tuple2._2();
                if (option instanceof Some) {
                    Some some = (Some)option;
                    long retentionSz = BoxesRunTime.unboxToLong(some.value());
                    if (option2 instanceof Some) {
                        Some some2 = (Some)option2;
                        long retentionMs = BoxesRunTime.unboxToLong(some2.value());
                        this.debug((Function0<String> & Serializable)() -> "Validating for db log start offset lapse for " + event + " " + state + " with retentions (" + retentionSz + ", " + retentionMs + ")");
                        Option<Object> estimatedSize = Utils$.MODULE$.getEstimatedLogRangeSize(this.replicaManager(), event.topicIdPartition(), event.logStartOffset());
                        Option<SegmentState> prevSegInfo = Utils$.MODULE$.getPreviousTierSegmentInfo(this.replicaManager(), event.topicIdPartition(), event.logStartOffset());
                        Tuple2<Option<Object>, Option<SegmentState>> tuple22 = new Tuple2<Option<Object>, Option<SegmentState>>(estimatedSize, prevSegInfo);
                        if (tuple22 != null) {
                            Option<Object> option3 = tuple22._1();
                            Option<SegmentState> option4 = tuple22._2();
                            if (option3 instanceof Some) {
                                Some some3 = (Some)option3;
                                long estimatedSize2 = BoxesRunTime.unboxToLong(some3.value());
                                if (option4 instanceof Some) {
                                    Some some4 = (Some)option4;
                                    SegmentState prevSegInfo2 = (SegmentState)some4.value();
                                    if (!this.withinMarginOfErrorForSizeRetention(estimatedSize2, retentionSz) && !this.withinMarginOfErrorForTimeMsRetention(prevSegInfo2.maxTimestamp(), retentionMs)) {
                                        String msg = "durability lapse on validation with db log start offset, the start offset is more than expected retention window.\nTime based lapse info - maxTimestamp in previous deleted segment: " + prevSegInfo2.maxTimestamp() + ", retentionMs: " + retentionMs + ", current time: " + this.time.milliseconds() + ", RetentionTimeMarginOfErrorMs: " + this.RetentionTimeMarginOfErrorMs() + "\nSize based lapse info - estimatedSize including previous segment: " + estimatedSize2 + ", retentionSz: " + retentionSz + ", RetentionSizeMarginOfError: " + this.RetentionSizeMarginOfError() + "\npartition: " + event.topicIdPartition() + "\nevent: " + event + "\ndb state: " + state + "\nmetadata: " + metadata;
                                        this.debug((Function0<String> & Serializable)() -> "Lapse with " + estimatedSize2 + " " + prevSegInfo2 + ".size " + msg);
                                        if (state.retentionMs() == -1L && state.retentionSz() == -1L && (state.lapseWatchStartTime() == 0L || this.time.milliseconds() - state.lapseWatchStartTime() < (long)this.MaxOffsetGapToleranceTimeMs())) {
                                            this.info((Function0<String> & Serializable)() -> "Postponing start offset lapse with details: " + msg);
                                            if (state.lapseWatchStartTime() == 0L) {
                                                state.lapseWatchStartTime_$eq(this.time.milliseconds());
                                            }
                                            return false;
                                        }
                                        this.reporter().reportDurabilityLapse(event.topicIdPartition().topicPartition(), state.startOffset(), Math.max(event.logStartOffset() - state.startOffset(), 1L), DurabilityLapseType$.MODULE$.NonCustomerFacing(), msg, false, this.reporter().reportDurabilityLapse$default$7(), this.reporter().reportDurabilityLapse$default$8());
                                        return true;
                                    }
                                    this.debug((Function0<String> & Serializable)() -> "Validation against db log start offset went fine  " + estimatedSize2 + ", " + prevSegInfo2);
                                    return true;
                                }
                            }
                        }
                        return true;
                    }
                }
            }
            return true;
        }
        this.debug((Function0<String> & Serializable)() -> "validateDBLogStartOffset exits as not able to fetch comparing value " + event + " " + state);
        return true;
    }

    public String validateDBLogStartOffset$default$3() {
        return "";
    }

    private boolean sizeLapseCalculation(StartOffsetChangeEvent event, PartitionState state, long retentionValue, String metadata, Enumeration.Value lapseType) {
        this.debug((Function0<String> & Serializable)() -> "sizeLapseCalculation " + event + " " + state + " " + retentionValue);
        Option<Object> option = Utils$.MODULE$.getEstimatedLogRangeSize(this.replicaManager(), event.topicIdPartition(), event.logStartOffset());
        if (option instanceof Some) {
            Some some = (Some)option;
            long estimatedSize = BoxesRunTime.unboxToLong(some.value());
            if (!this.withinMarginOfErrorForSizeRetention(estimatedSize, retentionValue)) {
                String msg = "durability lapse on validation with db log start offset based on size, the start offset is more than expected retention window size.\nSize based lapse info - estimatedSize including previous segment: " + estimatedSize + ", retentionValue: " + retentionValue + ", RetentionSizeMarginOfError: " + this.RetentionSizeMarginOfError() + "\npartition: " + event.topicIdPartition() + "\nevent: " + event + "\ndb state: " + state + "\nmetadata: " + metadata;
                this.reporter().reportDurabilityLapse(event.topicIdPartition().topicPartition(), state.startOffset(), Math.max(event.logStartOffset() - state.startOffset(), 1L), lapseType, msg, true, this.reporter().reportDurabilityLapse$default$7(), this.reporter().reportDurabilityLapse$default$8());
                return true;
            }
            return true;
        }
        return true;
    }

    private boolean timeLapseCalculation(StartOffsetChangeEvent event, PartitionState state, long retentionValue, String metadata, Enumeration.Value lapseType) {
        Option<SegmentState> previousTierSegmentInfo;
        this.debug((Function0<String> & Serializable)() -> "timeLapseCalculation " + event + " " + state + " " + retentionValue);
        Option<SegmentState> option = previousTierSegmentInfo = Utils$.MODULE$.getPreviousTierSegmentInfo(this.replicaManager(), event.topicIdPartition(), event.logStartOffset());
        if (option instanceof Some) {
            Some some = (Some)option;
            SegmentState prevSegmentState = (SegmentState)some.value();
            if (!this.withinMarginOfErrorForTimeMsRetention(prevSegmentState.maxTimestamp(), retentionValue)) {
                String msg = "durability lapse on validation with db log start offset based on time, the start offset is more than expected retention window time.\nTime based lapse info - maxTimestamp in previous deleted segment: " + prevSegmentState.maxTimestamp() + ", retentionValue: " + retentionValue + ", current time: " + this.time.milliseconds() + ", RetentionTimeMarginOfErrorMs: " + this.RetentionTimeMarginOfErrorMs() + "\nPrevious deleted tiered segment info - objectId: " + prevSegmentState.objectId() + ", baseOffset: " + prevSegmentState.baseOffset() + ", size: " + prevSegmentState.size() + ", endOffset: " + prevSegmentState.endOffset() + ", tierEpoch: " + prevSegmentState.tierEpoch() + "\npartition: " + event.topicIdPartition() + "\nevent: " + event + "\ndb state: " + state + "\nmetadata: " + metadata;
                this.reporter().reportDurabilityLapse(event.topicIdPartition().topicPartition(), state.startOffset(), Math.max(event.logStartOffset() - state.startOffset(), 1L), lapseType, msg, true, this.reporter().reportDurabilityLapse$default$7(), this.reporter().reportDurabilityLapse$default$8());
                return true;
            }
            return true;
        }
        return true;
    }

    public void validateLocalLogStartOffset(TopicIdPartition topicIdPartition, Option<String> mirrorState, long leaderOffset, String metadata) {
        AbstractLog abstractLog;
        Some some;
        AbstractLog log;
        Option<AbstractLog> option = this.replicaManager().logManager().getLog(topicIdPartition.topicPartition(), this.replicaManager().logManager().getLog$default$2());
        if (option instanceof Some && (log = (AbstractLog)(some = (Some)option).value()) != null && (abstractLog = log).logStartOffset() > leaderOffset) {
            Option<SegmentState> option2 = Utils$.MODULE$.getPreviousTierSegmentInfo(this.replicaManager(), topicIdPartition, abstractLog.logStartOffset());
            if (option2 instanceof Some) {
                Some some2 = (Some)option2;
                SegmentState prevSegmentState = (SegmentState)some2.value();
                if (!this.withinMarginOfErrorForTimeMsRetention(prevSegmentState.maxTimestamp(), abstractLog.config().retentionMs) && !this.withinMarginOfErrorForSizeRetention(abstractLog.size() + (long)prevSegmentState.size(), abstractLog.config().retentionSize)) {
                    String msg = "durability lapse on validation with local log start offset.\nTime based lapse info - maxTimestamp in previous deleted segment: " + prevSegmentState.maxTimestamp() + ", retentionMs: " + abstractLog.config().retentionMs + "\nSize based lapse info - prevSegmentSize: " + prevSegmentState.size() + ", logSize: " + abstractLog.size() + ", retentionSz: " + abstractLog.config().retentionSize + "\nbroker: " + Utils$.MODULE$.getBrokerId(this.replicaManager()) + "\npartition: " + topicIdPartition + "\nmetadata: " + metadata;
                    this.reporter().reportDurabilityLapse(topicIdPartition.topicPartition(), abstractLog.logStartOffset(), Math.max(abstractLog.logStartOffset() - leaderOffset, 1L), DurabilityLapseType$.MODULE$.NonCustomerFacing(), msg, false, this.reporter().reportDurabilityLapse$default$7(), this.reporter().reportDurabilityLapse$default$8());
                }
            }
            return;
        }
    }

    public void validateDBEpochChange(EpochChangeEvent event, PartitionState state, String metadata) {
        Enumeration.Value lapseType = this.getLapseType(state.mirrorState(), DurabilityLapseType$.MODULE$.EpochChange(), state.isLeader());
        if (event.firstOffset() < state.highWatermark() || event.epoch() < state.latestEpoch()) {
            String msg = "durability lapse on epoch change event with db, first offset for new epoch is less than previous recorded db state hwm\nevent first offset: " + event.firstOffset() + ", new epoch: " + event.epoch() + "\ndb state hwm: " + state.highWatermark() + "\npartition: " + event.topicIdPartition() + "\nevent: " + event + "\ndb state: " + state + "\nmetadata: " + metadata;
            this.reporter().reportDurabilityLapse(event.topicIdPartition().topicPartition(), event.firstOffset(), Math.max(state.highWatermark() - event.firstOffset(), 1L), lapseType, msg, true, this.reporter().reportDurabilityLapse$default$7(), this.reporter().reportDurabilityLapse$default$8());
            return;
        }
    }

    public void validateEpochChangeWithLocal(EpochChangeEvent event, Option<String> mirrorState, String metadata) {
        Option<AbstractLog> log;
        if (mirrorState.isDefined()) {
            return;
        }
        if (!this.isInSync(event.isr())) {
            return;
        }
        if (this.isInISR(event.topicIdPartition().topicPartition())) {
            Tuple2<Option<Object>, Option<Object>> tuple2 = new Tuple2<Option<Object>, Option<Object>>(Utils$.MODULE$.getLatestEpoch(this.replicaManager(), event.topicIdPartition().topicPartition()), Utils$.MODULE$.getLogEndOffset(this.replicaManager(), event.topicIdPartition().topicPartition()));
            if (tuple2 != null) {
                Option<Object> option = tuple2._1();
                Option<Object> option2 = tuple2._2();
                if (option instanceof Some) {
                    Some some = (Some)option;
                    int epoch = BoxesRunTime.unboxToInt(some.value());
                    if (true) {
                        int n = epoch;
                        if (option2 instanceof Some) {
                            Some some2 = (Some)option2;
                            long localEndOffset = BoxesRunTime.unboxToLong(some2.value());
                            if (true) {
                                long l = localEndOffset;
                                if (n >= event.epoch() && l < event.firstOffset()) {
                                    String msg = "durability lapse on validation of epoch change with local, local end offset is less than first offset of new event\nin-sync partition " + event.topicIdPartition() + "\nlocal end offset: " + l + ", local epoch " + n + "\nfirst offset: " + event.firstOffset() + " of the new epoch\nevent: " + event + "\nmetadata: " + metadata;
                                    this.reporter().reportDurabilityLapse(event.topicIdPartition().topicPartition(), l, 1L, DurabilityLapseType$.MODULE$.NonCustomerFacing(), msg, false, this.reporter().reportDurabilityLapse$default$7(), this.reporter().reportDurabilityLapse$default$8());
                                } else if (l < event.highWatermark()) {
                                    String msg = "durability lapse on validation of epoch change with local, local end offset is less than hwm of new event\nFor in-sync partition: " + event.topicIdPartition() + "\nlocal end offset " + l + ",local epoch " + n + "\nhwm: " + event.highWatermark() + ", isrSet " + Utils$.MODULE$.getIsrPartition(this.replicaManager(), event.topicIdPartition().topicPartition()) + "\nevent: " + event + "\nmetadata: " + metadata;
                                    this.reporter().reportDurabilityLapse(event.topicIdPartition().topicPartition(), l, 1L, DurabilityLapseType$.MODULE$.NonCustomerFacing(), msg, false, this.reporter().reportDurabilityLapse$default$7(), this.reporter().reportDurabilityLapse$default$8());
                                }
                            }
                        }
                    }
                }
            }
        } else {
            this.debug((Function0<String> & Serializable)() -> "Follower is lagging " + Utils$.MODULE$.getIsrPartition(this.replicaManager(), event.topicIdPartition().topicPartition()) + ", processing older event " + event.topicIdPartition() + " ");
        }
        if (Utils$.MODULE$.isCompacted(this.replicaManager(), event.topicIdPartition().topicPartition())) {
            return;
        }
        Option<Object> localOffset = Utils$.MODULE$.getLocalStartOffsetForEpoch(this.replicaManager(), event.topicIdPartition().topicPartition(), event.epoch());
        Tuple2<Option<Object>, Option<AbstractLog>> tuple2 = new Tuple2<Option<Object>, Option<AbstractLog>>(localOffset, log = this.replicaManager().logManager().getLog(event.topicIdPartition().topicPartition(), this.replicaManager().logManager().getLog$default$2()));
        if (tuple2 != null) {
            Option<Object> option = tuple2._1();
            Option<AbstractLog> option3 = tuple2._2();
            if (option instanceof Some) {
                Some some = (Some)option;
                long firstOffset = BoxesRunTime.unboxToLong(some.value());
                if (option3 instanceof Some) {
                    Some some3 = (Some)option3;
                    AbstractLog localLog = (AbstractLog)some3.value();
                    if (firstOffset != -1L) {
                        if (firstOffset != event.firstOffset() && (firstOffset < event.firstOffset() || firstOffset > localLog.logStartOffset())) {
                            String msg = "durability lapse on validation of epoch change with local, local first offset is not equal to first offset of new event\nin-sync partition: " + event.topicIdPartition() + "\nlocal first offset: " + localOffset + "\nfirst offset: " + event.firstOffset() + "\nevent: " + event + "\nmetadata: " + metadata;
                            this.reporter().reportDurabilityLapse(event.topicIdPartition().topicPartition(), firstOffset, 1L, DurabilityLapseType$.MODULE$.NonCustomerFacing(), msg, false, this.reporter().reportDurabilityLapse$default$7(), this.reporter().reportDurabilityLapse$default$8());
                            return;
                        }
                        return;
                    }
                }
            }
        }
    }

    public void validateDestLogEpochChangeWithLocal(DestLogEpochChangeEvent event, PartitionState state, String metadata) {
        Option<AbstractLog> log;
        if (!this.isInSync(event.isr())) {
            return;
        }
        if (this.isInISR(event.topicIdPartition().topicPartition())) {
            Tuple2<Option<Object>, Option<Object>> tuple2 = new Tuple2<Option<Object>, Option<Object>>(Utils$.MODULE$.getLatestEpoch(this.replicaManager(), event.topicIdPartition().topicPartition()), Utils$.MODULE$.getLogEndOffset(this.replicaManager(), event.topicIdPartition().topicPartition()));
            if (tuple2 != null) {
                Option<Object> option = tuple2._1();
                Option<Object> option2 = tuple2._2();
                if (option instanceof Some) {
                    Some some = (Some)option;
                    int epoch = BoxesRunTime.unboxToInt(some.value());
                    if (true) {
                        int n = epoch;
                        if (option2 instanceof Some) {
                            Some some2 = (Some)option2;
                            long localEndOffset = BoxesRunTime.unboxToLong(some2.value());
                            if (true) {
                                long l = localEndOffset;
                                if (n >= event.destLogEpoch() && l < event.firstOffset()) {
                                    String msg = "durability lapse on validation of epoch change with local, local end offset is less than first offset of new event\nin-sync partition " + event.topicIdPartition() + "\nlocal end offset: " + l + ", local epoch " + n + "\nfirst offset: " + event.firstOffset() + " of the new epoch\nevent: " + event + "\nmetadata: " + metadata;
                                    this.reporter().reportDurabilityLapse(event.topicIdPartition().topicPartition(), l, 1L, DurabilityLapseType$.MODULE$.NonCustomerFacing(), msg, false, this.reporter().reportDurabilityLapse$default$7(), this.reporter().reportDurabilityLapse$default$8());
                                } else if (l < event.highWatermark()) {
                                    String msg = "durability lapse on validation of epoch change with local, local end offset is less than hwm of new event\nFor in-sync partition: " + event.topicIdPartition() + "\nlocal end offset " + l + ",local epoch " + n + "\nhwm: " + event.highWatermark() + ", isrSet " + Utils$.MODULE$.getIsrPartition(this.replicaManager(), event.topicIdPartition().topicPartition()) + "\nevent: " + event + "\nmetadata: " + metadata;
                                    this.reporter().reportDurabilityLapse(event.topicIdPartition().topicPartition(), l, 1L, DurabilityLapseType$.MODULE$.NonCustomerFacing(), msg, false, this.reporter().reportDurabilityLapse$default$7(), this.reporter().reportDurabilityLapse$default$8());
                                }
                            }
                        }
                    }
                }
            }
        } else {
            this.debug((Function0<String> & Serializable)() -> "Follower is lagging " + Utils$.MODULE$.getIsrPartition(this.replicaManager(), event.topicIdPartition().topicPartition()) + ", processing older event " + event.topicIdPartition() + " ");
        }
        if (Utils$.MODULE$.isCompacted(this.replicaManager(), event.topicIdPartition().topicPartition())) {
            return;
        }
        Option<Object> localOffset = Utils$.MODULE$.getLocalStartOffsetForEpoch(this.replicaManager(), event.topicIdPartition().topicPartition(), event.destLogEpoch());
        Tuple2<Option<Object>, Option<AbstractLog>> tuple2 = new Tuple2<Option<Object>, Option<AbstractLog>>(localOffset, log = this.replicaManager().logManager().getLog(event.topicIdPartition().topicPartition(), this.replicaManager().logManager().getLog$default$2()));
        if (tuple2 != null) {
            Option<Object> option = tuple2._1();
            Option<AbstractLog> option3 = tuple2._2();
            if (option instanceof Some) {
                Some some = (Some)option;
                long firstOffset = BoxesRunTime.unboxToLong(some.value());
                if (option3 instanceof Some) {
                    Some some3 = (Some)option3;
                    AbstractLog localLog = (AbstractLog)some3.value();
                    if (firstOffset != -1L) {
                        if (firstOffset != event.firstOffset() && (firstOffset < event.firstOffset() || firstOffset > localLog.logStartOffset())) {
                            String msg = "durability lapse on validation of epoch change with local, local first offset is not equal to first offset of new event\nin-sync partition: " + event.topicIdPartition() + "\nlocal first offset: " + localOffset + "\nfirst offset: " + event.firstOffset() + "\nevent: " + event + "\nmetadata: " + metadata;
                            this.reporter().reportDurabilityLapse(event.topicIdPartition().topicPartition(), firstOffset, 1L, DurabilityLapseType$.MODULE$.NonCustomerFacing(), msg, false, this.reporter().reportDurabilityLapse$default$7(), this.reporter().reportDurabilityLapse$default$8());
                            return;
                        }
                        return;
                    }
                }
            }
        }
    }

    public void validateEpochChainWithLocal(TopicPartition topicPartition, PartitionState state, String metadata) {
        Object object = new Object();
        try {
            if (Utils$.MODULE$.isCompacted(this.replicaManager(), topicPartition)) {
                return;
            }
            LongRef prevLocalEpochFirstOffset = LongRef.create(-1L);
            IntRef prevEpoch = IntRef.create(-1);
            HashMap<Object, Object> dbEpochChain = state.mirrorState().isEmpty() ? state.epochChain() : state.mirrorCacheEpochChain();
            ((List)dbEpochChain.toList().sortWith((Function2<Tuple2, Tuple2, Object> & Serializable)(x, y) -> BoxesRunTime.boxToBoolean(BrokerValidator.$anonfun$validateEpochChainWithLocal$1(x, y)))).foreach((Function1<Tuple2, Object> & Serializable)x0$1 -> {
                BrokerValidator.$anonfun$validateEpochChainWithLocal$2(this, topicPartition, prevLocalEpochFirstOffset, prevEpoch, state, metadata, object, x0$1);
                return BoxedUnit.UNIT;
            });
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                ex.value$mcV$sp();
            }
            throw ex;
        }
    }

    private boolean withinMarginOfErrorForTimeMsRetention(long timeMs, long retentionMs) {
        this.debug((Function0<String> & Serializable)() -> "validating " + timeMs + " against " + retentionMs);
        if (timeMs == -1L) {
            return true;
        }
        if (retentionMs == -1L) {
            return false;
        }
        long diff = this.time.milliseconds() - timeMs;
        return retentionMs - diff <= (long)this.RetentionTimeMarginOfErrorMs();
    }

    private boolean withinMarginOfErrorForSizeRetention(long size, long retentionSize) {
        this.debug((Function0<String> & Serializable)() -> "Validating " + size + " against " + retentionSize);
        if (size == -1L) {
            return true;
        }
        if (retentionSize == -1L) {
            return false;
        }
        return retentionSize - size <= (long)this.RetentionSizeMarginOfError();
    }

    public boolean isInSync(Set<Object> isr) {
        return isr.contains(BoxesRunTime.boxToInteger(Utils$.MODULE$.getBrokerId(this.replicaManager())));
    }

    public boolean isInISR(TopicPartition topicPartition) {
        Option<Set<Object>> isrSet = Utils$.MODULE$.getIsrPartition(this.replicaManager(), topicPartition);
        return isrSet.contains(BoxesRunTime.boxToInteger(Utils$.MODULE$.getBrokerId(this.replicaManager())));
    }

    private Enumeration.Value getLapseType(Option<String> mirrorState, Enumeration.Value lapse, boolean isLeader) {
        Enumeration.Value value;
        Object object = new Object();
        try {
            ObjectRef<Enumeration.Value> newLapse = ObjectRef.create(lapse);
            mirrorState.foreach((Function1<String, Object> & Serializable)mirror -> {
                BrokerValidator.$anonfun$getLapseType$1(isLeader, object, lapse, newLapse, mirror);
                return BoxedUnit.UNIT;
            });
            value = (Enumeration.Value)newLapse.elem;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                value = (Enumeration.Value)ex.value();
            }
            throw ex;
        }
        return value;
    }

    public static final /* synthetic */ boolean $anonfun$validateDBHighWatermark$3(String mirrorState) {
        return !DurabilityAuditMirrorState.fromString(OptionConverters.RichOption$.MODULE$.toJava$extension(OptionConverters$.MODULE$.RichOption(Option$.MODULE$.apply(mirrorState)))).get().isAppendRecordsAllowed();
    }

    public static final /* synthetic */ boolean $anonfun$validateEpochChainWithLocal$1(Tuple2 x, Tuple2 y) {
        return x._1$mcI$sp() < y._1$mcI$sp();
    }

    public static final /* synthetic */ void $anonfun$validateEpochChainWithLocal$2(BrokerValidator $this, TopicPartition topicPartition$1, LongRef prevLocalEpochFirstOffset$1, IntRef prevEpoch$1, PartitionState state$5, String metadata$1, Object nonLocalReturnKey1$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            Some some;
            long localEpochFirstOffset;
            int dbEpoch = tuple2._1$mcI$sp();
            long dbEpochFirstOffset = tuple2._2$mcJ$sp();
            Option<Object> option = Utils$.MODULE$.getLocalStartOffsetForEpoch($this.replicaManager(), topicPartition$1, dbEpoch);
            if (option instanceof Some && (localEpochFirstOffset = BoxesRunTime.unboxToLong((some = (Some)option).value())) != -1L) {
                if (dbEpochFirstOffset < prevLocalEpochFirstOffset$1.elem) {
                    String msg = "durability lapse on epoch chain validation with db, local first offset is greater than or equal to next epoch's first offset\npartition " + topicPartition$1 + "\nprevEpoch: " + prevEpoch$1.elem + ", prevLocalFirstOffset: " + prevLocalEpochFirstOffset$1.elem + "\ndbEpoch: " + dbEpoch + ", db first offset " + dbEpochFirstOffset + "\nstate: " + state$5 + "\nmetadata: " + metadata$1;
                    $this.reporter().reportDurabilityLapse(topicPartition$1, dbEpochFirstOffset, 1L, DurabilityLapseType$.MODULE$.NonCustomerFacing(), msg, false, $this.reporter().reportDurabilityLapse$default$7(), $this.reporter().reportDurabilityLapse$default$8());
                    throw new NonLocalReturnControl$mcV$sp(nonLocalReturnKey1$1, BoxedUnit.UNIT);
                }
                if (localEpochFirstOffset != dbEpochFirstOffset) {
                    Option<AbstractLog> option2 = $this.replicaManager().logManager().getLog(topicPartition$1, $this.replicaManager().logManager().getLog$default$2());
                    if (option2 instanceof Some) {
                        Some some2 = (Some)option2;
                        AbstractLog log = (AbstractLog)some2.value();
                        if (log.logStartOffset() < localEpochFirstOffset || dbEpochFirstOffset > localEpochFirstOffset) {
                            String msg = "durability lapse on epoch chain validation, db first offset is greater than local first offset\npartition: " + topicPartition$1 + "\ndbEpoch: " + dbEpoch + ", the local first offset: " + localEpochFirstOffset + "\ndb first offset: " + dbEpochFirstOffset + ", log start offset: " + log.logStartOffset() + "\nstate: " + state$5 + "\nmetadata: " + metadata$1;
                            $this.reporter().reportDurabilityLapse(topicPartition$1, dbEpochFirstOffset, 1L, DurabilityLapseType$.MODULE$.NonCustomerFacing(), msg, false, $this.reporter().reportDurabilityLapse$default$7(), $this.reporter().reportDurabilityLapse$default$8());
                            throw new NonLocalReturnControl$mcV$sp(nonLocalReturnKey1$1, BoxedUnit.UNIT);
                        }
                    }
                }
                prevLocalEpochFirstOffset$1.elem = localEpochFirstOffset;
                prevEpoch$1.elem = dbEpoch;
            }
            return;
        }
        throw new MatchError(tuple2);
    }

    public static final /* synthetic */ void $anonfun$getLapseType$1(boolean isLeader$1, Object nonLocalReturnKey2$1, Enumeration.Value lapse$1, ObjectRef newLapse$1, String mirror) {
        if (!isLeader$1) {
            throw new NonLocalReturnControl<Enumeration.Value>(nonLocalReturnKey2$1, DurabilityLapseType$.MODULE$.NonCustomerFacing());
        }
        if (mirror.equals(DurabilityAuditMirrorState.STOPPED.getName())) {
            Enumeration.Value value = lapse$1;
            Enumeration.Value value2 = DurabilityLapseType$.MODULE$.HighWatermark();
            Enumeration.Value value3 = value;
            if (!(value2 != null ? !((Object)value2).equals(value3) : value3 != null)) {
                newLapse$1.elem = DurabilityLapseType$.MODULE$.StoppedMirrorPartitionHighWatermark();
                return;
            }
            Enumeration.Value value4 = DurabilityLapseType$.MODULE$.StartOffset();
            Enumeration.Value value5 = value;
            if (!(value4 != null ? !((Object)value4).equals(value5) : value5 != null)) {
                newLapse$1.elem = DurabilityLapseType$.MODULE$.StoppedMirrorPartitionStartOffset();
                return;
            }
            Enumeration.Value value6 = DurabilityLapseType$.MODULE$.EpochChange();
            Enumeration.Value value7 = value;
            if (!(value6 != null ? !((Object)value6).equals(value7) : value7 != null)) {
                newLapse$1.elem = DurabilityLapseType$.MODULE$.StoppedMirrorPartitionEpochChange();
                return;
            }
            return;
        }
        Enumeration.Value value = lapse$1;
        Enumeration.Value value8 = DurabilityLapseType$.MODULE$.HighWatermark();
        Enumeration.Value value9 = value;
        if (!(value8 != null ? !((Object)value8).equals(value9) : value9 != null)) {
            newLapse$1.elem = DurabilityLapseType$.MODULE$.MirrorPartitionHighWatermark();
            return;
        }
        Enumeration.Value value10 = DurabilityLapseType$.MODULE$.StartOffset();
        Enumeration.Value value11 = value;
        if (!(value10 != null ? !((Object)value10).equals(value11) : value11 != null)) {
            newLapse$1.elem = DurabilityLapseType$.MODULE$.MirrorPartitionStartOffset();
            return;
        }
        Enumeration.Value value12 = DurabilityLapseType$.MODULE$.EpochChange();
        Enumeration.Value value13 = value;
        if (!(value12 != null ? !((Object)value12).equals(value13) : value13 != null)) {
            newLapse$1.elem = DurabilityLapseType$.MODULE$.MirrorPartitionEpochChange();
            return;
        }
    }

    public BrokerValidator(ReplicaManager replicaManager, AuditReporter reporter, Time time) {
        this.replicaManager = replicaManager;
        this.time = time;
        super(reporter, time);
        this.RetentionTimeMarginOfErrorMs = 3600000;
        this.RetentionSizeMarginOfError = 0x100000;
        this.MaxOffsetGapToleranceTimeMs = 900000;
        this.MaxHighWatermarkToleranceForMirrorPartitions = 10000;
    }
}

