/*
 * Decompiled with CFR 0.152.
 */
package kafka.durability.ondemand;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.Gson;
import com.google.gson.stream.JsonReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import kafka.durability.audit.DurabilityAuditConstants;
import kafka.durability.ondemand.GetAuditJobStatusDetail;
import kafka.durability.ondemand.GetAuditJobStatusRequest;
import kafka.durability.ondemand.GetAuditJobStatusResponseSummary;
import kafka.durability.ondemand.StartAuditJobRequest;
import kafka.durability.ondemand.StartAuditJobResponse;
import kafka.durability.ondemand.StopAuditJobRequest;
import kafka.durability.ondemand.StopAuditJobResponse;
import kafka.durability.ondemand.TopicPartitionConfig;
import kafka.tier.common.RestServerUtil;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.DescribeClusterResult;
import org.apache.kafka.clients.admin.TopicDescription;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartitionInfo;
import org.apache.kafka.common.utils.Exit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OnDemandAuditJobOrchestrator {
    private static final Logger LOGGER = LoggerFactory.getLogger(OnDemandAuditJobOrchestrator.class);
    private final Gson gson;
    private final Boolean forceStart;
    private final Boolean compactionCheckNeeded;
    private final AdminClient adminClient;
    private final CloseableHttpClient httpClient;
    private static final int KAFKA_INTERNAL_REST_SERVER_PORT = 9080;
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static final String HTTP_PREFIX = "http://";

    public OnDemandAuditJobOrchestrator(String bootstrapServers, Boolean forceStart, Boolean compactionCheckNeeded) {
        this(forceStart, compactionCheckNeeded, OnDemandAuditJobOrchestrator.getAdminClient(bootstrapServers), RestServerUtil.buildHttpClient());
    }

    public OnDemandAuditJobOrchestrator(Boolean forceStart, Boolean compactionCheckNeeded, AdminClient adminClient, CloseableHttpClient httpClient) {
        this.forceStart = forceStart;
        this.compactionCheckNeeded = compactionCheckNeeded;
        this.adminClient = adminClient;
        this.gson = new Gson();
        this.httpClient = httpClient;
    }

    public void startOnDemandAuditJobBasedOnConfig(String topicPartitionConfigFile) throws ExecutionException, InterruptedException, JsonProcessingException {
        int currentJobId = this.getRandomAuditJobId();
        LOGGER.debug("Parsing topicPartitionConfigFile at: {}", (Object)topicPartitionConfigFile);
        Map<String, Set<Integer>> topicPartitionConfigMap = this.parseTopicPartitionConfigFile(topicPartitionConfigFile);
        LOGGER.debug("Generating brokerTopicPartitionConfig");
        Map<String, Map<String, Set<Integer>>> brokerTopicPartitionConfig = this.generateBrokerPartitionMapping(topicPartitionConfigMap, Optional.empty());
        LOGGER.debug("Generated brokerTopicPartitionConfig. Will start audit jobs on {} brokers", (Object)brokerTopicPartitionConfig.size());
        StartAuditJobResponse startAuditJobResponse = new StartAuditJobResponse();
        for (String brokerUrl : brokerTopicPartitionConfig.keySet()) {
            String response = this.startOnDemandAuditJob(new StartAuditJobRequest(brokerUrl, brokerTopicPartitionConfig.get(brokerUrl), currentJobId, this.forceStart, this.compactionCheckNeeded));
            this.parseStartAuditJobResponse(startAuditJobResponse, response, brokerUrl.split("\\.")[0].substring(HTTP_PREFIX.length()));
        }
        System.out.println(OBJECT_MAPPER.writerWithDefaultPrettyPrinter().writeValueAsString(startAuditJobResponse));
    }

    public void startOnDemandAuditJobForCluster() throws ExecutionException, InterruptedException, JsonProcessingException {
        int currentJobId = this.getRandomAuditJobId();
        DescribeClusterResult describeClusterResult = this.adminClient.describeCluster();
        StartAuditJobResponse startAuditJobResponse = new StartAuditJobResponse();
        for (Node node : describeClusterResult.nodes().get()) {
            String response = this.startOnDemandAuditJob(new StartAuditJobRequest(this.getBrokerUrl(node.host()), Collections.emptyMap(), currentJobId, this.forceStart, this.compactionCheckNeeded));
            this.parseStartAuditJobResponse(startAuditJobResponse, response, node.host());
        }
        System.out.println(OBJECT_MAPPER.writerWithDefaultPrettyPrinter().writeValueAsString(startAuditJobResponse));
    }

    public void startOnDemandAuditJobForBroker(int brokerId) throws ExecutionException, InterruptedException, JsonProcessingException {
        int currentJobId = this.getRandomAuditJobId();
        DescribeClusterResult describeClusterResult = this.adminClient.describeCluster();
        boolean brokerIdFound = false;
        StartAuditJobResponse startAuditJobResponse = new StartAuditJobResponse();
        for (Node node : describeClusterResult.nodes().get()) {
            if (brokerId != node.id()) continue;
            brokerIdFound = true;
            String response = this.startOnDemandAuditJob(new StartAuditJobRequest(this.getBrokerUrl(node.host()), Collections.emptyMap(), currentJobId, this.forceStart, this.compactionCheckNeeded));
            this.parseStartAuditJobResponse(startAuditJobResponse, response, node.host());
            System.out.println(OBJECT_MAPPER.writerWithDefaultPrettyPrinter().writeValueAsString(startAuditJobResponse));
            break;
        }
        if (!brokerIdFound) {
            String message = String.format("Broker %d not found.", brokerId);
            System.out.println(message);
            Exit.exit(0);
        }
    }

    public void startOnDemandAuditJobForTopic(String topicName) throws ExecutionException, InterruptedException, JsonProcessingException {
        this.startOnDemandJobForTopicPartition(topicName, new HashSet<Integer>());
    }

    public void startOnDemandJobForTopicPartition(String topicName, Set<Integer> partitionsToAudit) throws ExecutionException, InterruptedException, JsonProcessingException {
        int currentJobId = this.getRandomAuditJobId();
        HashMap<String, Set<Integer>> topicPartitionMap = new HashMap<String, Set<Integer>>();
        topicPartitionMap.put(topicName, partitionsToAudit);
        Map<String, Map<String, Set<Integer>>> brokerTopicPartitionConfig = this.generateBrokerPartitionMapping(topicPartitionMap, Optional.empty());
        StartAuditJobResponse startAuditJobResponse = new StartAuditJobResponse();
        for (String brokerUrl : brokerTopicPartitionConfig.keySet()) {
            String response = this.startOnDemandAuditJob(new StartAuditJobRequest(brokerUrl, brokerTopicPartitionConfig.get(brokerUrl), currentJobId, this.forceStart, this.compactionCheckNeeded));
            this.parseStartAuditJobResponse(startAuditJobResponse, response, brokerUrl.split("\\.")[0].substring(HTTP_PREFIX.length()));
        }
        System.out.println(OBJECT_MAPPER.writerWithDefaultPrettyPrinter().writeValueAsString(startAuditJobResponse));
    }

    public void startOnDemandJobForTopicPartitionOnBroker(String topicName, Set<Integer> partitionsToAudit, int brokerId) throws ExecutionException, InterruptedException, JsonProcessingException {
        int currentJobId = this.getRandomAuditJobId();
        HashMap<String, Set<Integer>> topicPartitionMap = new HashMap<String, Set<Integer>>();
        topicPartitionMap.put(topicName, partitionsToAudit);
        Map<String, Map<String, Set<Integer>>> brokerTopicPartitionConfig = this.generateBrokerPartitionMapping(topicPartitionMap, Optional.of(brokerId));
        if (brokerTopicPartitionConfig.isEmpty()) {
            String message = String.format("Invalid combination for broker %d, topicName %s and partition %s", brokerId, topicName, partitionsToAudit);
            System.out.println(message);
            Exit.exit(0);
        } else {
            StartAuditJobResponse startAuditJobResponse = new StartAuditJobResponse();
            for (String brokerUrl : brokerTopicPartitionConfig.keySet()) {
                String response = this.startOnDemandAuditJob(new StartAuditJobRequest(brokerUrl, brokerTopicPartitionConfig.get(brokerUrl), currentJobId, this.forceStart, this.compactionCheckNeeded));
                this.parseStartAuditJobResponse(startAuditJobResponse, response, brokerUrl.split("\\.")[0].substring(HTTP_PREFIX.length()));
            }
            System.out.println(OBJECT_MAPPER.writerWithDefaultPrettyPrinter().writeValueAsString(startAuditJobResponse));
        }
    }

    public void getAuditJobStatus(Optional<Integer> brokerId, boolean detail, int auditJobId) throws ExecutionException, InterruptedException, IOException {
        DescribeClusterResult describeClusterResult = this.adminClient.describeCluster();
        if (!brokerId.isPresent()) {
            GetAuditJobStatusResponseSummary summary = new GetAuditJobStatusResponseSummary(auditJobId, DurabilityAuditConstants.AUDIT_JOB_STATUS_COMPLETED());
            GetAuditJobStatusDetail getAuditJobStatusDetail = new GetAuditJobStatusDetail();
            for (Node node : describeClusterResult.nodes().get()) {
                String response = this.getAuditJobStatus(new GetAuditJobStatusRequest(this.getBrokerUrl(node.host()), detail, node.host()));
                if (detail) {
                    this.parseGetAuditJobStatusDetail(getAuditJobStatusDetail, response, node.host(), auditJobId);
                    continue;
                }
                this.updateAuditJobStatusSummary(node.host(), response, summary, auditJobId);
            }
            if (!detail) {
                System.out.println(OBJECT_MAPPER.writerWithDefaultPrettyPrinter().writeValueAsString(summary));
            } else {
                System.out.println(OBJECT_MAPPER.writerWithDefaultPrettyPrinter().writeValueAsString(getAuditJobStatusDetail));
            }
        } else {
            boolean brokerFound = false;
            GetAuditJobStatusDetail getAuditJobStatusDetail = new GetAuditJobStatusDetail();
            for (Node node : describeClusterResult.nodes().get()) {
                if (node.id() != brokerId.get().intValue()) continue;
                brokerFound = true;
                String response = this.getAuditJobStatus(new GetAuditJobStatusRequest(this.getBrokerUrl(node.host()), detail, node.host()));
                if (detail) {
                    this.parseGetAuditJobStatusDetail(getAuditJobStatusDetail, response, node.host(), auditJobId);
                    System.out.println(OBJECT_MAPPER.writerWithDefaultPrettyPrinter().writeValueAsString(getAuditJobStatusDetail));
                    break;
                }
                if (response != null) {
                    JsonNode rootNode = OBJECT_MAPPER.readTree(response).get("data").get("attributes");
                    if (rootNode.get(DurabilityAuditConstants.JOB_ID()).asInt() == auditJobId) {
                        System.out.println("Status: " + rootNode.toPrettyString());
                        break;
                    }
                    System.out.printf("Audit job %d not found.%n", auditJobId);
                    break;
                }
                System.out.printf("Unable to get audit job status for: %d. Please try after some time", brokerId.get());
                break;
            }
            if (!brokerFound) {
                LOGGER.error("broker {} not found", brokerId);
                Exit.exit(0);
            }
        }
    }

    public void stopAuditJobs() throws ExecutionException, InterruptedException, JsonProcessingException {
        DescribeClusterResult describeClusterResult = this.adminClient.describeCluster();
        ArrayList<String> success = new ArrayList<String>();
        ArrayList<String> failed = new ArrayList<String>();
        for (Node node : describeClusterResult.nodes().get()) {
            String response = this.stopAuditJob(new StopAuditJobRequest(this.getBrokerUrl(node.host())));
            if (response != null) {
                JsonNode rootNode = OBJECT_MAPPER.readTree(response).get("data").get("attributes");
                int status = rootNode.get(DurabilityAuditConstants.STATUS()).asInt();
                if (status > 0) {
                    success.add(node.host());
                    continue;
                }
                failed.add(node.host());
                continue;
            }
            String message = String.format("%s : Unable to stop audit job. Please try after some time", node.host());
            LOGGER.debug(message);
            failed.add(node.host());
        }
        StopAuditJobResponse stopAuditJobResponse = new StopAuditJobResponse(success, failed);
        System.out.println(OBJECT_MAPPER.writerWithDefaultPrettyPrinter().writeValueAsString(stopAuditJobResponse));
    }

    private String getAuditJobStatus(GetAuditJobStatusRequest getAuditJobStatusRequest) {
        LOGGER.debug("{}: Getting audit job status", (Object)getAuditJobStatusRequest.brokerUrl());
        return RestServerUtil.sendRequestTryHttps(getAuditJobStatusRequest, this.httpClient);
    }

    private String stopAuditJob(StopAuditJobRequest stopAuditJobRequest) {
        LOGGER.debug("{}: Attempting to stop audit job for ", (Object)stopAuditJobRequest.brokerUrl());
        return RestServerUtil.sendRequestTryHttps(stopAuditJobRequest, this.httpClient);
    }

    private String startOnDemandAuditJob(StartAuditJobRequest startAuditJobRequest) {
        LOGGER.debug("{}: Starting audit job with id {}", (Object)startAuditJobRequest.brokerUrl(), (Object)startAuditJobRequest.jobId());
        return RestServerUtil.sendRequestTryHttps(startAuditJobRequest, this.httpClient);
    }

    private Map<String, Set<Integer>> parseTopicPartitionConfigFile(String topicPartitionConfigFile) {
        HashMap<String, Set<Integer>> topicPartitionConfigMap = new HashMap<String, Set<Integer>>();
        try {
            TopicPartitionConfig[] topicPartitionConfigs;
            JsonReader reader = new JsonReader(new FileReader(topicPartitionConfigFile));
            for (TopicPartitionConfig topicPartitionConfig : topicPartitionConfigs = (TopicPartitionConfig[])this.gson.fromJson(reader, (Type)((Object)TopicPartitionConfig[].class))) {
                topicPartitionConfigMap.put(topicPartitionConfig.getTopicName(), new HashSet<Integer>(topicPartitionConfig.getPartitions()));
            }
        }
        catch (FileNotFoundException fnfe) {
            LOGGER.error("File {} does not exist", (Object)topicPartitionConfigFile, (Object)fnfe);
            Exit.exit(0);
        }
        return topicPartitionConfigMap;
    }

    private Map<String, Map<String, Set<Integer>>> generateBrokerPartitionMapping(Map<String, Set<Integer>> topicPartitionsConfig, Optional<Integer> brokerId) throws ExecutionException, InterruptedException {
        HashMap<String, Map<String, Set<Integer>>> brokerPartitionConfig = new HashMap<String, Map<String, Set<Integer>>>();
        Map<String, TopicDescription> topicDescriptions = this.adminClient.describeTopics(topicPartitionsConfig.keySet()).allTopicNames().get();
        for (String topicName : topicDescriptions.keySet()) {
            Set<Integer> partitionsToAudit = topicPartitionsConfig.get(topicName);
            for (TopicPartitionInfo tpi : topicDescriptions.get(topicName).partitions()) {
                int partition = tpi.partition();
                boolean needsAudit = partitionsToAudit.isEmpty() || partitionsToAudit.contains(partition);
                if (!needsAudit) continue;
                if (!brokerId.isPresent() || tpi.leader().id() == brokerId.get().intValue()) {
                    brokerPartitionConfig.putIfAbsent(this.getBrokerUrl(tpi.leader().host()), new HashMap());
                    ((Map)brokerPartitionConfig.get(this.getBrokerUrl(tpi.leader().host()))).putIfAbsent(topicName, new HashSet());
                    ((Set)((Map)brokerPartitionConfig.get(this.getBrokerUrl(tpi.leader().host()))).get(topicName)).add(partition);
                }
                for (Node replica : tpi.replicas()) {
                    if (brokerId.isPresent() && replica.id() != brokerId.get().intValue()) continue;
                    brokerPartitionConfig.putIfAbsent(this.getBrokerUrl(replica.host()), new HashMap());
                    ((Map)brokerPartitionConfig.get(this.getBrokerUrl(replica.host()))).putIfAbsent(topicName, new HashSet());
                    ((Set)((Map)brokerPartitionConfig.get(this.getBrokerUrl(replica.host()))).get(topicName)).add(partition);
                }
            }
        }
        return brokerPartitionConfig;
    }

    private String getBrokerUrl(String host) {
        return HTTP_PREFIX + host + ":9080";
    }

    private static AdminClient getAdminClient(String bootstrapServers) {
        Properties properties = new Properties();
        properties.put("bootstrap.servers", bootstrapServers);
        properties.put("connections.max.idle.ms", (Object)10000);
        properties.put("request.timeout.ms", (Object)5000);
        return AdminClient.create(properties);
    }

    private int getRandomAuditJobId() {
        int min = 1000;
        Random r = new Random();
        return r.nextInt(min) + min;
    }

    private void parseGetAuditJobStatusDetail(GetAuditJobStatusDetail getAuditJobStatusDetail, String response, String broker, int auditJobId) throws IOException {
        if (response != null) {
            JsonNode rootNode = OBJECT_MAPPER.readTree(response).get("data").get("attributes");
            if (rootNode.get(DurabilityAuditConstants.JOB_ID()).asInt() == auditJobId) {
                List partitionStatusDetails = (List)OBJECT_MAPPER.readerFor(new TypeReference<List<GetAuditJobStatusDetail.PartitionStatusDetail>>(){}).readValue(rootNode.get("partitionStatusList"));
                for (GetAuditJobStatusDetail.PartitionStatusDetail partitionStatusDetail : partitionStatusDetails) {
                    partitionStatusDetail.setBroker(broker);
                    getAuditJobStatusDetail.getSuccess().add(partitionStatusDetail);
                }
            } else {
                String message = String.format("Audit job : %d not found on broker", auditJobId);
                GetAuditJobStatusDetail.PartitionStatusDetailFailed partitionStatusDetailFailed = new GetAuditJobStatusDetail.PartitionStatusDetailFailed(broker, message);
                getAuditJobStatusDetail.getFailed().add(partitionStatusDetailFailed);
            }
        } else {
            getAuditJobStatusDetail.getFailed().add(new GetAuditJobStatusDetail.PartitionStatusDetailFailed(broker, "Unable to get audit job status. Please try after some time"));
        }
    }

    private void parseStartAuditJobResponse(StartAuditJobResponse startAuditJobResponse, String response, String broker) throws JsonProcessingException {
        if (response != null) {
            JsonNode rootNode = OBJECT_MAPPER.readTree(response).get("data").get("attributes");
            int status = rootNode.get(DurabilityAuditConstants.STATUS()).asInt();
            if (status > 0) {
                boolean newJobStarted = rootNode.get("newJob").asBoolean();
                int jobId = rootNode.get(DurabilityAuditConstants.JOB_ID()).asInt();
                if (newJobStarted) {
                    startAuditJobResponse.getSuccess().add(new StartAuditJobResponse.SuccessBrokerDetail(broker, jobId));
                } else {
                    String message = String.format("Already existing job %d. Please wait for job to complete or use --force to start a new job", jobId);
                    startAuditJobResponse.getFailed().add(new StartAuditJobResponse.FailedBrokerDetail(broker, message));
                }
            } else {
                startAuditJobResponse.getFailed().add(new StartAuditJobResponse.FailedBrokerDetail(broker, "Unable to start audit job. Please try after some time"));
            }
        } else {
            startAuditJobResponse.getFailed().add(new StartAuditJobResponse.FailedBrokerDetail(broker, "Unable to start audit job. Please try after some time"));
        }
    }

    private String mergeAuditJobStatus(int auditJobId, String previousStatus, String newStatus) {
        if (previousStatus.equals(DurabilityAuditConstants.AUDIT_JOB_STATUS_COMPLETED())) {
            return newStatus;
        }
        if (previousStatus.equals(DurabilityAuditConstants.AUDIT_JOB_STATUS_ABORTED())) {
            return DurabilityAuditConstants.AUDIT_JOB_STATUS_ABORTED();
        }
        if (previousStatus.equals(DurabilityAuditConstants.AUDIT_JOB_STATUS_IN_PROGRESS())) {
            return newStatus.equals(DurabilityAuditConstants.AUDIT_JOB_STATUS_ABORTED()) ? DurabilityAuditConstants.AUDIT_JOB_STATUS_ABORTED() : DurabilityAuditConstants.AUDIT_JOB_STATUS_IN_PROGRESS();
        }
        throw new IllegalArgumentException(String.format("[auditJobId:%d] Unrecognized audit job status '%s'", auditJobId, previousStatus));
    }

    private void updateAuditJobStatusSummary(String broker, String brokerSummaryString, GetAuditJobStatusResponseSummary summary, int requestedJobId) throws JsonProcessingException {
        if (brokerSummaryString != null) {
            JsonNode rootNode = OBJECT_MAPPER.readTree(brokerSummaryString).get("data").get("attributes");
            if (rootNode.get(DurabilityAuditConstants.JOB_ID()).asInt() == requestedJobId) {
                summary.setStatus(this.mergeAuditJobStatus(requestedJobId, summary.getStatus(), rootNode.get(DurabilityAuditConstants.STATUS()).asText()));
                summary.getBrokersSuccess().add(broker);
                summary.setTopicPartitionScanned(summary.getTopicPartitionScanned() + rootNode.get(DurabilityAuditConstants.TOPIC_PARTITIONS_SCANNED()).asInt());
                summary.setTopicPartitionScannedSuccess(summary.getTopicPartitionScannedSuccess() + rootNode.get(DurabilityAuditConstants.TOPIC_PARTITIONS_SCANNED_SUCCESS()).asInt());
                summary.setTopicPartitionSkipped(summary.getTopicPartitionSkipped() + rootNode.get(DurabilityAuditConstants.TOPIC_PARTITIONS_SKIPPED()).asInt());
                summary.setTotalTierCompactedPartitionsRequested(summary.getTotalTierCompactedPartitionsRequested() + rootNode.get(DurabilityAuditConstants.TOTAL_TIER_COMPACTED_PARTITIONS_REQUESTED()).asInt());
                summary.setTopicPartitionsRequested(summary.getTopicPartitionsRequested() + rootNode.get(DurabilityAuditConstants.TOPIC_PARTITIONS_REQUESTED()).asInt());
                summary.setTotalGapCountAcrossPartitions(summary.getTotalGapCountAcrossPartitions() + rootNode.get(DurabilityAuditConstants.TOTAL_GAP_COUNT_ACROSS_PARTITIONS()).asInt());
                summary.setTotalOffsetCountAcrossPartitions(summary.getTotalOffsetCountAcrossPartitions() + rootNode.get(DurabilityAuditConstants.TOTAL_OFFSET_COUNT_ACROSS_PARTITIONS()).asInt());
            }
        } else {
            summary.getBrokersFailed().add(broker);
        }
    }
}

