/*
 * Decompiled with CFR 0.152.
 */
package kafka.durability.utils;

import com.typesafe.scalalogging.Logger;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.security.MessageDigest;
import kafka.durability.exception.MemoryLimitExceededException;
import kafka.durability.utils.OffsetInfo;
import kafka.durability.utils.OffsetMapEntry;
import kafka.durability.utils.OffsetMapEntryRecord;
import kafka.durability.utils.OffsetMapFile;
import kafka.log.CleanedTransactionMetadata;
import kafka.tier.TopicIdPartition;
import kafka.utils.Logging;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.MutableRecordBatch;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.utils.BufferSupplier;
import org.apache.kafka.common.utils.CloseableIterator;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.storage.internals.utils.Throttler;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.SortedMap;
import scala.collection.mutable.SortedMap$;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.util.control.Breaks$;

public final class DurabilityOffsetMapUtils$
implements Logging {
    public static final DurabilityOffsetMapUtils$ MODULE$ = new DurabilityOffsetMapUtils$();
    private static final BufferSupplier decompressionBufferSupplier;
    private static final MessageDigest digest;
    private static final int hashSize;
    private static final byte[] hashBuffer;
    private static final int OFFSET_MAP_MEMORY_USAGE_PER_ENTRY;
    private static final long OFFSET_MAP_ENTRY_COUNT_LIMIT;
    private static Logger logger;
    private static String logIdent;
    private static volatile boolean bitmap$0;

    static {
        Logging.$init$(MODULE$);
        decompressionBufferSupplier = BufferSupplier.create();
        digest = MessageDigest.getInstance("MD5");
        hashSize = MODULE$.digest().getDigestLength();
        hashBuffer = new byte[MODULE$.hashSize()];
        OFFSET_MAP_MEMORY_USAGE_PER_ENTRY = 152;
        OFFSET_MAP_ENTRY_COUNT_LIMIT = 0x100000L;
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        DurabilityOffsetMapUtils$ durabilityOffsetMapUtils$ = this;
        synchronized (durabilityOffsetMapUtils$) {
            if (!bitmap$0) {
                logger = Logging.logger$(this);
                bitmap$0 = true;
            }
        }
        return logger;
    }

    @Override
    public Logger logger() {
        if (!bitmap$0) {
            return this.logger$lzycompute();
        }
        return logger;
    }

    @Override
    public String logIdent() {
        return logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        logIdent = x$1;
    }

    private BufferSupplier decompressionBufferSupplier() {
        return decompressionBufferSupplier;
    }

    private MessageDigest digest() {
        return digest;
    }

    private int hashSize() {
        return hashSize;
    }

    private byte[] hashBuffer() {
        return hashBuffer;
    }

    public ByteBuffer getHashedBuffer(ByteBuffer key) {
        key.mark();
        this.digest().reset();
        this.digest().update(key);
        int len = this.digest().digest(this.hashBuffer(), 0, this.hashSize());
        byte[] hashedKey = new byte[len];
        Array$.MODULE$.copy(this.hashBuffer(), 0, hashedKey, 0, len);
        return ByteBuffer.wrap(hashedKey);
    }

    private int OFFSET_MAP_MEMORY_USAGE_PER_ENTRY() {
        return OFFSET_MAP_MEMORY_USAGE_PER_ENTRY;
    }

    private long OFFSET_MAP_ENTRY_COUNT_LIMIT() {
        return OFFSET_MAP_ENTRY_COUNT_LIMIT;
    }

    private void mayThrowMemoryLimitExceededException(long limit, long actual) {
        if (actual > limit) {
            throw new MemoryLimitExceededException("DA for compaction offset map generator", limit * (long)this.OFFSET_MAP_MEMORY_USAGE_PER_ENTRY(), actual * (long)this.OFFSET_MAP_MEMORY_USAGE_PER_ENTRY());
        }
    }

    public SortedMap<ByteBuffer, OffsetInfo> filterKeysAndOffset(Throttler throttler, InputStream inputStream, ByteBuffer readByteBuffer, CleanedTransactionMetadata transactionMetadata, long firstCleanOffset, long lastCleanOffset, long offsetMapEntryCountLimit) {
        SortedMap offsetMap = (SortedMap)SortedMap$.MODULE$.apply(Nil$.MODULE$, Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms()));
        IntRef totalBytesRead = IntRef.create(0);
        readByteBuffer.clear();
        try {
            Utils.readFully(inputStream, readByteBuffer, false);
            while (readByteBuffer.position() != 0) {
                readByteBuffer.flip();
                MemoryRecords records = MemoryRecords.readableRecords(readByteBuffer);
                this.debug((Function0<String> & Serializable)() -> "Throttling with records size: " + records.sizeInBytes());
                throttler.maybeThrottle(records.sizeInBytes());
                for (MutableRecordBatch batch : records.batches()) {
                    Serializable serializable;
                    if (batch.isControlBatch()) {
                        serializable = BoxesRunTime.boxToBoolean(transactionMetadata.onControlBatchRead(batch));
                        continue;
                    }
                    boolean isAborted = transactionMetadata.onBatchRead(batch);
                    if (!isAborted) {
                        try (CloseableIterator<Record> recordsIterator = batch.streamingIterator(this.decompressionBufferSupplier());){
                            CollectionConverters$.MODULE$.IteratorHasAsScala(recordsIterator).asScala().foreach((Function1<Record, Object> & Serializable)record -> {
                                DurabilityOffsetMapUtils$.$anonfun$filterKeysAndOffset$2(lastCleanOffset, firstCleanOffset, offsetMap, offsetMapEntryCountLimit, record);
                                return BoxedUnit.UNIT;
                            });
                        }
                    }
                    serializable = BoxedUnit.UNIT;
                }
                int bytesRead = records.validBytes();
                totalBytesRead.elem += bytesRead;
                readByteBuffer.position(bytesRead);
                readByteBuffer.compact();
                Utils.readFully(inputStream, readByteBuffer, false);
            }
        }
        catch (MemoryLimitExceededException e) {
            throw e;
        }
        catch (Exception e) {
            this.error((Function0<String> & Serializable)() -> "Ran into the exception while reading the data " + e);
            throw new IOException("Error reading input stream");
        }
        this.debug((Function0<String> & Serializable)() -> "Total bytes read: " + totalBytesRead$1.elem);
        return offsetMap;
    }

    public long filterKeysAndOffset$default$7() {
        return this.OFFSET_MAP_ENTRY_COUNT_LIMIT();
    }

    public void storeOffsetMapInFile(scala.collection.SortedMap<ByteBuffer, OffsetInfo> offsetMap, File path, boolean exists) {
        this.debug((Function0<String> & Serializable)() -> "Creating offsetMapFile in " + path);
        OffsetMapFile offsetMapFile = new OffsetMapFile(path, exists);
        offsetMap.foreach((Function1<Tuple2, Object> & Serializable)x0$1 -> {
            DurabilityOffsetMapUtils$.$anonfun$storeOffsetMapInFile$2(offsetMapFile, x0$1);
            return BoxedUnit.UNIT;
        });
        offsetMapFile.flush();
        offsetMapFile.close();
    }

    public void storeInputStreamOffsetMapInFile(InputStream inputStream, ByteBuffer readByteBuffer, File path) {
        this.debug((Function0<String> & Serializable)() -> "Creating offsetMapFile in " + path);
        path.createNewFile();
        FileChannel destChannel = FileChannel.open(Paths.get(path.getPath(), new String[0]), StandardOpenOption.APPEND);
        readByteBuffer.clear();
        Utils.readFully(inputStream, readByteBuffer, false);
        while (readByteBuffer.position() != 0) {
            readByteBuffer.flip();
            Utils.writeFully(destChannel, readByteBuffer);
            readByteBuffer.compact();
            Utils.readFully(inputStream, readByteBuffer, false);
        }
        destChannel.close();
    }

    public scala.collection.SortedMap<ByteBuffer, OffsetInfo> retrieveOffsetMapInFile(File path, String name) {
        SortedMap offsetMap = (SortedMap)SortedMap$.MODULE$.apply(Nil$.MODULE$, Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms()));
        OffsetMapFile offsetMapFile = new OffsetMapFile(new File(path, name), true);
        Iterator<Option<OffsetMapEntryRecord>> fileIterate = offsetMapFile.iterator();
        Option<OffsetMapEntryRecord> fileEntry = fileIterate.next();
        while (fileEntry.nonEmpty()) {
            offsetMap.put(ByteBuffer.wrap(fileEntry.get().entry().hashedKey()), new OffsetInfo(fileEntry.get().entry().offsetValue(), fileEntry.get().entry().isTombStone()));
            fileEntry = fileIterate.next();
        }
        return offsetMap;
    }

    public void truncateOffsetMapFile(File olderFile, File newerFile, long firstCleanOffset, long lastCleanOffset) {
        OffsetMapFile olderFileOffsetMap = new OffsetMapFile(olderFile, true);
        OffsetMapFile newerFileOffsetMap = new OffsetMapFile(newerFile, true);
        try {
            try {
                Iterator<Option<OffsetMapEntryRecord>> olderFileIterate = olderFileOffsetMap.iterator();
                Option<OffsetMapEntryRecord> olderFileEntry = olderFileIterate.next();
                while (olderFileEntry.nonEmpty()) {
                    if (olderFileEntry.get().entry().offsetValue() >= firstCleanOffset && olderFileEntry.get().entry().offsetValue() <= lastCleanOffset) {
                        newerFileOffsetMap.append(olderFileEntry.get().entry());
                    }
                    olderFileEntry = olderFileIterate.next();
                }
                newerFileOffsetMap.flush();
            }
            catch (Exception e) {
                this.info((Function0<String> & Serializable)() -> "Ran into exception to while truncating the file. " + e);
                throw e;
            }
        }
        finally {
            olderFileOffsetMap.close();
            newerFileOffsetMap.close();
        }
    }

    public void mergeOffsetMapFile(File newerFile, File olderFile, File destination, long firstCleanOffset, long lastCleanOffset) {
        OffsetMapFile newerFileOffsetMap = new OffsetMapFile(newerFile, true);
        OffsetMapFile olderFileOffsetMap = new OffsetMapFile(olderFile, true);
        OffsetMapFile destinationOffsetMap = new OffsetMapFile(destination, false);
        try {
            try {
                Iterator<Option<OffsetMapEntryRecord>> newerFileIterate = newerFileOffsetMap.iterator();
                Iterator<Option<OffsetMapEntryRecord>> olderFileIterate = olderFileOffsetMap.iterator();
                Option<OffsetMapEntryRecord> newerFileEntry = newerFileIterate.next();
                Option<OffsetMapEntryRecord> olderFileEntry = olderFileIterate.next();
                while (newerFileEntry.nonEmpty() || olderFileEntry.nonEmpty()) {
                    while (newerFileEntry.nonEmpty() && (newerFileEntry.get().entry().offsetValue() < firstCleanOffset || newerFileEntry.get().entry().offsetValue() > lastCleanOffset)) {
                        newerFileEntry = newerFileIterate.next();
                    }
                    if (newerFileEntry.nonEmpty() && olderFileEntry.nonEmpty()) {
                        int value = ByteBuffer.wrap(newerFileEntry.get().entry().hashedKey()).compareTo(ByteBuffer.wrap(olderFileEntry.get().entry().hashedKey()));
                        if (value == 0) {
                            if (newerFileEntry.get().entry().offsetValue() > olderFileEntry.get().entry().offsetValue()) {
                                destinationOffsetMap.append(newerFileEntry.get().entry());
                            } else {
                                destinationOffsetMap.append(olderFileEntry.get().entry());
                            }
                            newerFileEntry = newerFileIterate.next();
                            olderFileEntry = olderFileIterate.next();
                        }
                        if (value < 0) {
                            destinationOffsetMap.append(newerFileEntry.get().entry());
                            newerFileEntry = newerFileIterate.next();
                        }
                        if (value <= 0) continue;
                        destinationOffsetMap.append(olderFileEntry.get().entry());
                        olderFileEntry = olderFileIterate.next();
                        continue;
                    }
                    if (newerFileEntry.nonEmpty()) {
                        destinationOffsetMap.append(newerFileEntry.get().entry());
                        newerFileEntry = newerFileIterate.next();
                    }
                    if (!olderFileEntry.nonEmpty()) continue;
                    destinationOffsetMap.append(olderFileEntry.get().entry());
                    olderFileEntry = olderFileIterate.next();
                }
                destinationOffsetMap.flush();
            }
            catch (Exception e) {
                this.info((Function0<String> & Serializable)() -> "Ran into exception to while merging the files. " + e);
                throw e;
            }
        }
        finally {
            destinationOffsetMap.close();
            newerFileOffsetMap.close();
            olderFileOffsetMap.close();
        }
    }

    public int checkCongruentOffsetMapFile(TopicIdPartition topicIdPartition, File sourceFile, File destinationFile) {
        OffsetMapFile sourceFileOffsetMap = new OffsetMapFile(sourceFile, true);
        OffsetMapFile destinationFileOffsetMap = new OffsetMapFile(destinationFile, true);
        IntRef mismatches = IntRef.create(0);
        try {
            Iterator<Option<OffsetMapEntryRecord>> sourceFileIterate = sourceFileOffsetMap.iterator();
            Iterator<Option<OffsetMapEntryRecord>> destinationFileIterate = destinationFileOffsetMap.iterator();
            ObjectRef<Option<OffsetMapEntryRecord>> sourceMessageEntry = ObjectRef.create(sourceFileIterate.next());
            ObjectRef<Option<OffsetMapEntryRecord>> destinationMessageEntry = ObjectRef.create(destinationFileIterate.next());
            while (((Option)sourceMessageEntry.elem).nonEmpty() || ((Option)destinationMessageEntry.elem).nonEmpty()) {
                Breaks$.MODULE$.breakable(() -> {
                    if (MODULE$.isTombStone((Option)sourceMessageEntry$1.elem)) {
                        if (MODULE$.isTombStone((Option)destinationMessageEntry$1.elem) && MODULE$.isHashedKeyEqual((Option)sourceMessageEntry$1.elem, (Option)destinationMessageEntry$1.elem)) {
                            destinationMessageEntry$1.elem = (Option)destinationFileIterate.next();
                        }
                        sourceMessageEntry$1.elem = (Option)sourceFileIterate.next();
                        throw Breaks$.MODULE$.break();
                    }
                    if (((Option)sourceMessageEntry$1.elem).nonEmpty() && ((Option)destinationMessageEntry$1.elem).nonEmpty()) {
                        boolean isKeyEqual = MODULE$.isHashedKeyEqual((Option)sourceMessageEntry$1.elem, (Option)destinationMessageEntry$1.elem);
                        if (!isKeyEqual || ((OffsetMapEntryRecord)((Option)sourceMessageEntry$1.elem).get()).entry().offsetValue() != ((OffsetMapEntryRecord)((Option)destinationMessageEntry$1.elem).get()).entry().offsetValue()) {
                            MODULE$.error((Function0<String> & Serializable)() -> "KeyPair Mismatch, " + topicIdPartition + " source key: " + ((Option)sourceMessageEntry$1.elem).get() + "  destination key: " + ((Option)destinationMessageEntry$1.elem).get());
                            ++mismatches$1.elem;
                        }
                        if (!isKeyEqual) {
                            int compareVal = ByteBuffer.wrap(((OffsetMapEntryRecord)((Option)sourceMessageEntry$1.elem).get()).entry().hashedKey()).compareTo(ByteBuffer.wrap(((OffsetMapEntryRecord)((Option)destinationMessageEntry$1.elem).get()).entry().hashedKey()));
                            if (compareVal < 0) {
                                sourceMessageEntry$1.elem = (Option)sourceFileIterate.next();
                                return;
                            }
                            destinationMessageEntry$1.elem = (Option)destinationFileIterate.next();
                            return;
                        }
                        sourceMessageEntry$1.elem = (Option)sourceFileIterate.next();
                        destinationMessageEntry$1.elem = (Option)destinationFileIterate.next();
                        return;
                    }
                    if (((Option)sourceMessageEntry$1.elem).nonEmpty()) {
                        MODULE$.error((Function0<String> & Serializable)() -> "Key missing in destination offset map for " + topicIdPartition + " for source key " + ((Option)sourceMessageEntry$1.elem).get());
                        sourceMessageEntry$1.elem = (Option)sourceFileIterate.next();
                        ++mismatches$1.elem;
                    }
                    if (((Option)destinationMessageEntry$1.elem).nonEmpty()) {
                        MODULE$.error((Function0<String> & Serializable)() -> "Key missing in source offset map for " + topicIdPartition + " for destination key " + ((Option)destinationMessageEntry$1.elem).get());
                        destinationMessageEntry$1.elem = (Option)destinationFileIterate.next();
                        ++mismatches$1.elem;
                        return;
                    }
                });
            }
        }
        catch (Exception e) {
            this.info((Function0<String> & Serializable)() -> "Ran into exception to while merging the files for " + topicIdPartition + " " + e);
            throw e;
        }
        return mismatches.elem;
    }

    private boolean isTombStone(Option<OffsetMapEntryRecord> messageEntry) {
        return messageEntry.nonEmpty() && messageEntry.get().entry().isTombStone();
    }

    private boolean isHashedKeyEqual(Option<OffsetMapEntryRecord> sourceMessageEntry, Option<OffsetMapEntryRecord> destinationMessageEntry) {
        return Predef$.MODULE$.wrapByteArray(sourceMessageEntry.get().entry().hashedKey()).sameElements(Predef$.MODULE$.wrapByteArray(destinationMessageEntry.get().entry().hashedKey()));
    }

    public static final /* synthetic */ void $anonfun$filterKeysAndOffset$2(long lastCleanOffset$1, long firstCleanOffset$1, SortedMap offsetMap$1, long offsetMapEntryCountLimit$1, Record record) {
        Serializable serializable = record.hasKey() && record.offset() <= lastCleanOffset$1 && record.offset() >= firstCleanOffset$1 ? offsetMap$1.put(MODULE$.getHashedBuffer(record.key()), new OffsetInfo(record.offset(), !record.hasValue())) : BoxedUnit.UNIT;
        MODULE$.mayThrowMemoryLimitExceededException(offsetMapEntryCountLimit$1, offsetMap$1.size());
    }

    public static final /* synthetic */ void $anonfun$storeOffsetMapInFile$2(OffsetMapFile offsetMapFile$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            ByteBuffer k = (ByteBuffer)tuple2._1();
            OffsetInfo v = (OffsetInfo)tuple2._2();
            offsetMapFile$1.append(new OffsetMapEntry(v.isTombstone(), v.offset(), k.array()));
            return;
        }
        throw new MatchError(tuple2);
    }

    private DurabilityOffsetMapUtils$() {
    }
}

