/*
 * Decompiled with CFR 0.152.
 */
package kafka.internals.generated;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.protocol.MessageSizeAccumulator;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.CompactArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.ByteUtils;

public class ComputedQuotaValue
implements ApiMessage {
    List<ComputedBrokerQuota> computedBrokerQuotas;
    long lastUpdatedTimestamp;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0 = new Schema(new Field("computed_broker_quotas", new CompactArrayOf(ComputedBrokerQuota.SCHEMA_0), "The computed quotas on each broker for a quota entity"), new Field("last_updated_timestamp", Type.INT64, "The timestamp of the last update for the quota entity"), Field.TaggedFieldsSection.of(new Object[0]));
    public static final Schema SCHEMA_1 = new Schema(new Field("computed_broker_quotas", new CompactArrayOf(ComputedBrokerQuota.SCHEMA_1), "The computed quotas on each broker for a quota entity"), new Field("last_updated_timestamp", Type.INT64, "The timestamp of the last update for the quota entity"), Field.TaggedFieldsSection.of(new Object[0]));
    public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1};
    public static final short LOWEST_SUPPORTED_VERSION = 0;
    public static final short HIGHEST_SUPPORTED_VERSION = 1;

    public ComputedQuotaValue(Readable _readable, short _version) {
        this.read(_readable, _version, MessageContext.IDENTITY);
    }

    public ComputedQuotaValue(Readable _readable, short _version, MessageContext _context) {
        this.read(_readable, _version, _context);
    }

    public ComputedQuotaValue() {
        this.computedBrokerQuotas = new ArrayList<ComputedBrokerQuota>(0);
        this.lastUpdatedTimestamp = 0L;
    }

    @Override
    public short apiKey() {
        return -1;
    }

    @Override
    public short lowestSupportedVersion() {
        return 0;
    }

    @Override
    public short highestSupportedVersion() {
        return 1;
    }

    @Override
    public final void read(Readable _readable, short _version, MessageContext _context) {
        int arrayLength = _readable.readUnsignedVarint() - 1;
        if (arrayLength < 0) {
            throw new RuntimeException("non-nullable field computedBrokerQuotas was serialized as null");
        }
        if (arrayLength > _readable.remaining()) {
            throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
        }
        ArrayList<ComputedBrokerQuota> newCollection = new ArrayList<ComputedBrokerQuota>(arrayLength);
        for (int i = 0; i < arrayLength; ++i) {
            newCollection.add(new ComputedBrokerQuota(_readable, _version, _context));
        }
        this.computedBrokerQuotas = newCollection;
        this.lastUpdatedTimestamp = _readable.readLong();
        this._unknownTaggedFields = null;
        int _numTaggedFields = _readable.readUnsignedVarint();
        for (int _i = 0; _i < _numTaggedFields; ++_i) {
            int _tag = _readable.readUnsignedVarint();
            int _size = _readable.readUnsignedVarint();
            switch (_tag) {
                default: 
            }
            this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
        }
    }

    @Override
    public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
        int _numTaggedFields = 0;
        _writable.writeUnsignedVarint(this.computedBrokerQuotas.size() + 1);
        for (ComputedBrokerQuota computedBrokerQuotasElement : this.computedBrokerQuotas) {
            computedBrokerQuotasElement.write(_writable, _cache, _version, _context);
        }
        _writable.writeLong(this.lastUpdatedTimestamp);
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
        _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
    }

    @Override
    public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
        int _numTaggedFields = 0;
        _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.computedBrokerQuotas.size() + 1));
        for (ComputedBrokerQuota computedBrokerQuotasElement : this.computedBrokerQuotas) {
            computedBrokerQuotasElement.addSize(_size, _cache, _version, _context);
        }
        _size.addBytes(8);
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                _size.addBytes(_field.size());
            }
        }
        _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ComputedQuotaValue)) {
            return false;
        }
        ComputedQuotaValue other = (ComputedQuotaValue)obj;
        if (this.computedBrokerQuotas == null ? other.computedBrokerQuotas != null : !this.computedBrokerQuotas.equals(other.computedBrokerQuotas)) {
            return false;
        }
        if (this.lastUpdatedTimestamp != other.lastUpdatedTimestamp) {
            return false;
        }
        return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + (this.computedBrokerQuotas == null ? 0 : this.computedBrokerQuotas.hashCode());
        hashCode = 31 * hashCode + ((int)(this.lastUpdatedTimestamp >> 32) ^ (int)this.lastUpdatedTimestamp);
        return hashCode;
    }

    @Override
    public ComputedQuotaValue duplicate() {
        ComputedQuotaValue _duplicate = new ComputedQuotaValue();
        ArrayList<ComputedBrokerQuota> newComputedBrokerQuotas = new ArrayList<ComputedBrokerQuota>(this.computedBrokerQuotas.size());
        for (ComputedBrokerQuota _element : this.computedBrokerQuotas) {
            newComputedBrokerQuotas.add(_element.duplicate());
        }
        _duplicate.computedBrokerQuotas = newComputedBrokerQuotas;
        _duplicate.lastUpdatedTimestamp = this.lastUpdatedTimestamp;
        return _duplicate;
    }

    public String toString() {
        return "ComputedQuotaValue(computedBrokerQuotas=" + MessageUtil.deepToString(this.computedBrokerQuotas.iterator()) + ", lastUpdatedTimestamp=" + this.lastUpdatedTimestamp + ")";
    }

    public List<ComputedBrokerQuota> computedBrokerQuotas() {
        return this.computedBrokerQuotas;
    }

    public long lastUpdatedTimestamp() {
        return this.lastUpdatedTimestamp;
    }

    @Override
    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public ComputedQuotaValue setComputedBrokerQuotas(List<ComputedBrokerQuota> v) {
        this.computedBrokerQuotas = v;
        return this;
    }

    public ComputedQuotaValue setLastUpdatedTimestamp(long v) {
        this.lastUpdatedTimestamp = v;
        return this;
    }

    public static class ComputedBrokerQuota
    implements Message {
        int brokerId;
        List<ComputedQuota> computedQuotas;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0 = new Schema(new Field("broker_id", Type.INT32, "The broker ID"), new Field("computed_quotas", new CompactArrayOf(ComputedQuota.SCHEMA_0), "The computed quota for a quota type"), Field.TaggedFieldsSection.of(new Object[0]));
        public static final Schema SCHEMA_1 = new Schema(new Field("broker_id", Type.INT32, "The broker ID"), new Field("computed_quotas", new CompactArrayOf(ComputedQuota.SCHEMA_1), "The computed quota for a quota type"), Field.TaggedFieldsSection.of(new Object[0]));
        public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1};
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 1;

        public ComputedBrokerQuota(Readable _readable, short _version, MessageContext _context) {
            this.read(_readable, _version, _context);
        }

        public ComputedBrokerQuota() {
            this.brokerId = 0;
            this.computedQuotas = new ArrayList<ComputedQuota>(0);
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 1;
        }

        @Override
        public final void read(Readable _readable, short _version, MessageContext _context) {
            if (_version > 1) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of ComputedBrokerQuota");
            }
            this.brokerId = _readable.readInt();
            int arrayLength = _readable.readUnsignedVarint() - 1;
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field computedQuotas was serialized as null");
            }
            if (arrayLength > _readable.remaining()) {
                throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
            }
            ArrayList<ComputedQuota> newCollection = new ArrayList<ComputedQuota>(arrayLength);
            for (int i = 0; i < arrayLength; ++i) {
                newCollection.add(new ComputedQuota(_readable, _version, _context));
            }
            this.computedQuotas = newCollection;
            this._unknownTaggedFields = null;
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            _writable.writeInt(this.brokerId);
            _writable.writeUnsignedVarint(this.computedQuotas.size() + 1);
            for (ComputedQuota computedQuotasElement : this.computedQuotas) {
                computedQuotasElement.write(_writable, _cache, _version, _context);
            }
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        }

        @Override
        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            if (_version > 1) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of ComputedBrokerQuota");
            }
            _size.addBytes(4);
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.computedQuotas.size() + 1));
            for (ComputedQuota computedQuotasElement : this.computedQuotas) {
                computedQuotasElement.addSize(_size, _cache, _version, _context);
            }
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ComputedBrokerQuota)) {
                return false;
            }
            ComputedBrokerQuota other = (ComputedBrokerQuota)obj;
            if (this.brokerId != other.brokerId) {
                return false;
            }
            if (this.computedQuotas == null ? other.computedQuotas != null : !this.computedQuotas.equals(other.computedQuotas)) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + this.brokerId;
            hashCode = 31 * hashCode + (this.computedQuotas == null ? 0 : this.computedQuotas.hashCode());
            return hashCode;
        }

        @Override
        public ComputedBrokerQuota duplicate() {
            ComputedBrokerQuota _duplicate = new ComputedBrokerQuota();
            _duplicate.brokerId = this.brokerId;
            ArrayList<ComputedQuota> newComputedQuotas = new ArrayList<ComputedQuota>(this.computedQuotas.size());
            for (ComputedQuota _element : this.computedQuotas) {
                newComputedQuotas.add(_element.duplicate());
            }
            _duplicate.computedQuotas = newComputedQuotas;
            return _duplicate;
        }

        public String toString() {
            return "ComputedBrokerQuota(brokerId=" + this.brokerId + ", computedQuotas=" + MessageUtil.deepToString(this.computedQuotas.iterator()) + ")";
        }

        public int brokerId() {
            return this.brokerId;
        }

        public List<ComputedQuota> computedQuotas() {
            return this.computedQuotas;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public ComputedBrokerQuota setBrokerId(int v) {
            this.brokerId = v;
            return this;
        }

        public ComputedBrokerQuota setComputedQuotas(List<ComputedQuota> v) {
            this.computedQuotas = v;
            return this;
        }
    }

    public static class ComputedQuota
    implements Message {
        String quotaType;
        double quota;
        double usage;
        boolean throttled;
        double throttledTimeMs;
        long lastUsageReportTimestamp;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0 = new Schema(new Field("quota_type", Type.COMPACT_STRING, "The quota type"), new Field("quota", Type.FLOAT64, "The computed quota for this type"), new Field("usage", Type.FLOAT64, "The reported usage for this quota type"), new Field("throttled", Type.BOOLEAN, "Whether the quota entity is being throttled by this quota"), new Field("last_usage_report_timestamp", Type.INT64, "The timestamp of the last consumption report for this quota on this broker"), Field.TaggedFieldsSection.of(new Object[0]));
        public static final Schema SCHEMA_1 = new Schema(new Field("quota_type", Type.COMPACT_STRING, "The quota type"), new Field("quota", Type.FLOAT64, "The computed quota for this type"), new Field("usage", Type.FLOAT64, "The reported usage for this quota type"), new Field("throttled_time_ms", Type.FLOAT64, "How long the quota entity is being throttled for"), new Field("last_usage_report_timestamp", Type.INT64, "The timestamp of the last consumption report for this quota on this broker"), Field.TaggedFieldsSection.of(new Object[0]));
        public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1};
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 1;

        public ComputedQuota(Readable _readable, short _version, MessageContext _context) {
            this.read(_readable, _version, _context);
        }

        public ComputedQuota() {
            this.quotaType = "";
            this.quota = 0.0;
            this.usage = 0.0;
            this.throttled = false;
            this.throttledTimeMs = 0.0;
            this.lastUsageReportTimestamp = 0L;
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 1;
        }

        @Override
        public final void read(Readable _readable, short _version, MessageContext _context) {
            if (_version > 1) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of ComputedQuota");
            }
            int length = _readable.readUnsignedVarint() - 1;
            if (length < 0) {
                throw new RuntimeException("non-nullable field quotaType was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field quotaType had invalid length " + length);
            }
            this.quotaType = _readable.readString(length);
            this.quota = _readable.readDouble();
            this.usage = _readable.readDouble();
            this.throttled = _version <= 0 ? _readable.readByte() != 0 : false;
            this.throttledTimeMs = _version >= 1 ? _readable.readDouble() : 0.0;
            this.lastUsageReportTimestamp = _readable.readLong();
            this._unknownTaggedFields = null;
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            byte[] _stringBytes = _cache.getSerializedValue(this.quotaType);
            _writable.writeUnsignedVarint(_stringBytes.length + 1);
            _writable.writeByteArray(_stringBytes);
            _writable.writeDouble(this.quota);
            _writable.writeDouble(this.usage);
            if (_version <= 0) {
                _writable.writeByte(this.throttled ? (byte)1 : 0);
            } else if (this.throttled) {
                throw new UnsupportedVersionException("Attempted to write a non-default throttled at version " + _version);
            }
            if (_version >= 1) {
                _writable.writeDouble(this.throttledTimeMs);
            } else if (this.throttledTimeMs != 0.0) {
                throw new UnsupportedVersionException("Attempted to write a non-default throttledTimeMs at version " + _version);
            }
            _writable.writeLong(this.lastUsageReportTimestamp);
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        }

        @Override
        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            if (_version > 1) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of ComputedQuota");
            }
            byte[] _stringBytes = this.quotaType.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'quotaType' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.quotaType, _stringBytes);
            _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
            _size.addBytes(8);
            _size.addBytes(8);
            if (_version <= 0) {
                _size.addBytes(1);
            }
            if (_version >= 1) {
                _size.addBytes(8);
            }
            _size.addBytes(8);
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ComputedQuota)) {
                return false;
            }
            ComputedQuota other = (ComputedQuota)obj;
            if (this.quotaType == null ? other.quotaType != null : !this.quotaType.equals(other.quotaType)) {
                return false;
            }
            if (this.quota != other.quota) {
                return false;
            }
            if (this.usage != other.usage) {
                return false;
            }
            if (this.throttled != other.throttled) {
                return false;
            }
            if (this.throttledTimeMs != other.throttledTimeMs) {
                return false;
            }
            if (this.lastUsageReportTimestamp != other.lastUsageReportTimestamp) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.quotaType == null ? 0 : this.quotaType.hashCode());
            hashCode = 31 * hashCode + Double.hashCode(this.quota);
            hashCode = 31 * hashCode + Double.hashCode(this.usage);
            hashCode = 31 * hashCode + (this.throttled ? 1231 : 1237);
            hashCode = 31 * hashCode + Double.hashCode(this.throttledTimeMs);
            hashCode = 31 * hashCode + ((int)(this.lastUsageReportTimestamp >> 32) ^ (int)this.lastUsageReportTimestamp);
            return hashCode;
        }

        @Override
        public ComputedQuota duplicate() {
            ComputedQuota _duplicate = new ComputedQuota();
            _duplicate.quotaType = this.quotaType;
            _duplicate.quota = this.quota;
            _duplicate.usage = this.usage;
            _duplicate.throttled = this.throttled;
            _duplicate.throttledTimeMs = this.throttledTimeMs;
            _duplicate.lastUsageReportTimestamp = this.lastUsageReportTimestamp;
            return _duplicate;
        }

        public String toString() {
            return "ComputedQuota(quotaType=" + (String)(this.quotaType == null ? "null" : "'" + this.quotaType.toString() + "'") + ", quota=" + this.quota + ", usage=" + this.usage + ", throttled=" + (this.throttled ? "true" : "false") + ", throttledTimeMs=" + this.throttledTimeMs + ", lastUsageReportTimestamp=" + this.lastUsageReportTimestamp + ")";
        }

        public String quotaType() {
            return this.quotaType;
        }

        public double quota() {
            return this.quota;
        }

        public double usage() {
            return this.usage;
        }

        public boolean throttled() {
            return this.throttled;
        }

        public double throttledTimeMs() {
            return this.throttledTimeMs;
        }

        public long lastUsageReportTimestamp() {
            return this.lastUsageReportTimestamp;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public ComputedQuota setQuotaType(String v) {
            this.quotaType = v;
            return this;
        }

        public ComputedQuota setQuota(double v) {
            this.quota = v;
            return this;
        }

        public ComputedQuota setUsage(double v) {
            this.usage = v;
            return this;
        }

        public ComputedQuota setThrottled(boolean v) {
            this.throttled = v;
            return this;
        }

        public ComputedQuota setThrottledTimeMs(double v) {
            this.throttledTimeMs = v;
            return this;
        }

        public ComputedQuota setLastUsageReportTimestamp(long v) {
            this.lastUsageReportTimestamp = v;
            return this;
        }
    }
}

