/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import com.yammer.metrics.core.Meter;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.server.BucketStorageProbe$;
import kafka.server.KafkaConfig;
import kafka.tier.store.BucketHealthResult;
import kafka.tier.store.TierObjectStore;
import kafka.utils.Logging;
import org.apache.kafka.common.utils.KafkaThread;
import org.apache.kafka.server.metrics.KafkaMetricsGroup;
import scala.Function0;
import scala.MatchError;
import scala.Predef$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u0005Mf\u0001B\u0016-\u0001EB\u0001b\u0011\u0001\u0003\u0006\u0004%I\u0001\u0012\u0005\t\u0013\u0002\u0011\t\u0011)A\u0005\u000b\"A!\n\u0001BC\u0002\u0013%1\n\u0003\u0005U\u0001\t\u0005\t\u0015!\u0003M\u0011!)\u0006A!b\u0001\n\u00131\u0006\u0002C/\u0001\u0005\u0003\u0005\u000b\u0011B,\t\u000by\u0003A\u0011A0\t\u000f\u0011\u0004!\u0019!C\u0005K\"1\u0001\u000f\u0001Q\u0001\n\u0019Dq!\u001d\u0001C\u0002\u0013%!\u000f\u0003\u0004w\u0001\u0001\u0006Ia\u001d\u0005\bo\u0002\u0011\r\u0011\"\u0003s\u0011\u0019A\b\u0001)A\u0005g\"9\u0011\u0010\u0001b\u0001\n\u0013\u0011\bB\u0002>\u0001A\u0003%1\u000fC\u0004|\u0001\t\u0007I\u0011\u0002:\t\rq\u0004\u0001\u0015!\u0003t\u0011%i\b\u00011AA\u0002\u0013%a\u0010C\u0006\u0002\u0018\u0001\u0001\r\u00111A\u0005\n\u0005e\u0001BCA\u0013\u0001\u0001\u0007\t\u0011)Q\u0005\u007f\"Y\u0011q\u0005\u0001A\u0002\u0003\u0007I\u0011BA\u0015\u0011-\t\u0019\u0005\u0001a\u0001\u0002\u0004%I!!\u0012\t\u0017\u0005%\u0003\u00011A\u0001B\u0003&\u00111\u0006\u0005\f\u0003\u0017\u0002\u0001\u0019!a\u0001\n\u0013\tI\u0003C\u0006\u0002N\u0001\u0001\r\u00111A\u0005\n\u0005=\u0003bCA*\u0001\u0001\u0007\t\u0011)Q\u0005\u0003WA1\"!\u0016\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002*!Y\u0011q\u000b\u0001A\u0002\u0003\u0007I\u0011BA-\u0011-\ti\u0006\u0001a\u0001\u0002\u0003\u0006K!a\u000b\t\u0017\u0005}\u0003\u00011AA\u0002\u0013%\u0011\u0011\u0006\u0005\f\u0003C\u0002\u0001\u0019!a\u0001\n\u0013\t\u0019\u0007C\u0006\u0002h\u0001\u0001\r\u0011!Q!\n\u0005-\u0002\"CA5\u0001\t\u0007I\u0011BA6\u0011!\tI\b\u0001Q\u0001\n\u00055\u0004bBA>\u0001\u0011\u0005\u0011Q\u0010\u0005\b\u0003\u007f\u0002A\u0011AA?\u0011\u001d\t\t\t\u0001C\u0001\u0003{Bq!a!\u0001\t\u0003\tihB\u0005\u0002\u000e2\n\t\u0011#\u0001\u0002\u0010\u001aA1\u0006LA\u0001\u0012\u0003\t\t\n\u0003\u0004_Q\u0011\u0005\u0011\u0011\u0014\u0005\n\u00037C\u0013\u0013!C\u0001\u0003;\u0013!CQ;dW\u0016$8\u000b^8sC\u001e,\u0007K]8cK*\u0011QFL\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003=\nQa[1gW\u0006\u001c\u0001a\u0005\u0003\u0001eij\u0004CA\u001a9\u001b\u0005!$BA\u001b7\u0003\u0011a\u0017M\\4\u000b\u0003]\nAA[1wC&\u0011\u0011\b\u000e\u0002\u0007\u001f\nTWm\u0019;\u0011\u0005MZ\u0014B\u0001\u001f5\u0005!\u0011VO\u001c8bE2,\u0007C\u0001 B\u001b\u0005y$B\u0001!/\u0003\u0015)H/\u001b7t\u0013\t\u0011uHA\u0004M_\u001e<\u0017N\\4\u0002\r\r|gNZ5h+\u0005)\u0005C\u0001$H\u001b\u0005a\u0013B\u0001%-\u0005-Y\u0015MZ6b\u0007>tg-[4\u0002\u000f\r|gNZ5hA\u0005yA/[3s\u001f\nTWm\u0019;Ti>\u0014X-F\u0001M!\ti%+D\u0001O\u0015\ty\u0005+A\u0003ti>\u0014XM\u0003\u0002R]\u0005!A/[3s\u0013\t\u0019fJA\bUS\u0016\u0014xJ\u00196fGR\u001cFo\u001c:f\u0003A!\u0018.\u001a:PE*,7\r^*u_J,\u0007%A\u0006ti\u0006\u0014H\u000f\u00165sK\u0006$W#A,\u0011\u0005a[V\"A-\u000b\u0003i\u000bQa]2bY\u0006L!\u0001X-\u0003\u000f\t{w\u000e\\3b]\u0006a1\u000f^1siRC'/Z1eA\u00051A(\u001b8jiz\"B\u0001Y1cGB\u0011a\t\u0001\u0005\u0006\u0007\u001e\u0001\r!\u0012\u0005\u0006\u0015\u001e\u0001\r\u0001\u0014\u0005\b+\u001e\u0001\n\u00111\u0001X\u00031\u0019\b.\u001e;e_^tg\t\\1h+\u00051\u0007CA4o\u001b\u0005A'BA5k\u0003\u0019\tGo\\7jG*\u00111\u000e\\\u0001\u000bG>t7-\u001e:sK:$(BA77\u0003\u0011)H/\u001b7\n\u0005=D'!D!u_6L7MQ8pY\u0016\fg.A\u0007tQV$Hm\\<o\r2\fw\rI\u0001\u0012Ef|7.\u0012:s_J\u0014\u0016\r^3OC6,W#A:\u0011\u0005M\"\u0018BA;5\u0005\u0019\u0019FO]5oO\u0006\u0011\"-_8l\u000bJ\u0014xN\u001d*bi\u0016t\u0015-\\3!\u0003]\u0001XM]7jgNLwN\\#se>\u0014(+\u0019;f\u001d\u0006lW-\u0001\rqKJl\u0017n]:j_:,%O]8s%\u0006$XMT1nK\u0002\nQ#\u001e8dY\u0006\u001c8/\u001b4jK\u0012,%O]8s%\u0006$X-\u0001\fv]\u000ed\u0017m]:jM&,G-\u0012:s_J\u0014\u0016\r^3!\u0003=AW-\u00197uQf\u0014\u0016\r^3OC6,\u0017\u0001\u00055fC2$\b.\u001f*bi\u0016t\u0015-\\3!\u0003\u0019!\bN]3bIV\tq\u0010\u0005\u0003\u0002\u0002\u0005MQBAA\u0002\u0015\r\u0001\u0015Q\u0001\u0006\u0005\u0003\u000f\tI!\u0001\u0004d_6lwN\u001c\u0006\u0004_\u0005-!\u0002BA\u0007\u0003\u001f\ta!\u00199bG\",'BAA\t\u0003\ry'oZ\u0005\u0005\u0003+\t\u0019AA\u0006LC\u001a\\\u0017\r\u00165sK\u0006$\u0017A\u0003;ie\u0016\fGm\u0018\u0013fcR!\u00111DA\u0011!\rA\u0016QD\u0005\u0004\u0003?I&\u0001B+oSRD\u0001\"a\t\u0014\u0003\u0003\u0005\ra`\u0001\u0004q\u0012\n\u0014a\u0002;ie\u0016\fG\rI\u0001\u000bEf|7.\u0012:s_J\u001cXCAA\u0016!\u0011\ti#a\u0010\u000e\u0005\u0005=\"\u0002BA\u0019\u0003g\tAaY8sK*!\u0011QGA\u001c\u0003\u001diW\r\u001e:jGNTA!!\u000f\u0002<\u00051\u00110Y7nKJT!!!\u0010\u0002\u0007\r|W.\u0003\u0003\u0002B\u0005=\"!B'fi\u0016\u0014\u0018A\u00042z_.,%O]8sg~#S-\u001d\u000b\u0005\u00037\t9\u0005C\u0005\u0002$Y\t\t\u00111\u0001\u0002,\u0005Y!-_8l\u000bJ\u0014xN]:!\u0003A\u0001XM]7jgNLwN\\#se>\u00148/\u0001\u000bqKJl\u0017n]:j_:,%O]8sg~#S-\u001d\u000b\u0005\u00037\t\t\u0006C\u0005\u0002$e\t\t\u00111\u0001\u0002,\u0005\t\u0002/\u001a:nSN\u001c\u0018n\u001c8FeJ|'o\u001d\u0011\u0002%Ut7\r\\1tg&4\u0017.\u001a3FeJ|'o]\u0001\u0017k:\u001cG.Y:tS\u001aLW\rZ#se>\u00148o\u0018\u0013fcR!\u00111DA.\u0011%\t\u0019\u0003HA\u0001\u0002\u0004\tY#A\nv]\u000ed\u0017m]:jM&,G-\u0012:s_J\u001c\b%A\u0004iK\u0006dG\u000f[=\u0002\u0017!,\u0017\r\u001c;is~#S-\u001d\u000b\u0005\u00037\t)\u0007C\u0005\u0002$}\t\t\u00111\u0001\u0002,\u0005A\u0001.Z1mi\"L\b%\u0001\u0007nKR\u0014\u0018nY:He>,\b/\u0006\u0002\u0002nA!\u0011qNA;\u001b\t\t\tH\u0003\u0003\u00026\u0005M$bA\u0017\u0002\n%!\u0011qOA9\u0005EY\u0015MZ6b\u001b\u0016$(/[2t\u000fJ|W\u000f]\u0001\u000e[\u0016$(/[2t\u000fJ|W\u000f\u001d\u0011\u0002\u000fM$\u0018M\u001d;vaR\u0011\u00111D\u0001\tg\",H\u000fZ8x]\u0006)\u0001O]8cK\u0006\u0019!/\u001e8)\u0007\u0019\n9\tE\u00024\u0003\u0013K1!a#5\u0005!ye/\u001a:sS\u0012,\u0017A\u0005\"vG.,Go\u0015;pe\u0006<W\r\u0015:pE\u0016\u0004\"A\u0012\u0015\u0014\u0007!\n\u0019\nE\u0002Y\u0003+K1!a&Z\u0005\u0019\te.\u001f*fMR\u0011\u0011qR\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\u0005}%fA,\u0002\".\u0012\u00111\u0015\t\u0005\u0003K\u000by+\u0004\u0002\u0002(*!\u0011\u0011VAV\u0003%)hn\u00195fG.,GMC\u0002\u0002.f\u000b!\"\u00198o_R\fG/[8o\u0013\u0011\t\t,a*\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\r")
public class BucketStorageProbe
implements Runnable,
Logging {
    private final KafkaConfig config;
    private final TierObjectStore tierObjectStore;
    private final boolean startThread;
    private final AtomicBoolean shutdownFlag;
    private final String byokErrorRateName;
    private final String permissionErrorRateName;
    private final String unclassifiedErrorRate;
    private final String healthyRateName;
    private KafkaThread thread;
    private Meter byokErrors;
    private Meter permissionErrors;
    private Meter unclassifiedErrors;
    private Meter healthy;
    private final KafkaMetricsGroup metricsGroup;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static boolean $lessinit$greater$default$3() {
        return BucketStorageProbe$.MODULE$.$lessinit$greater$default$3();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        BucketStorageProbe bucketStorageProbe = this;
        synchronized (bucketStorageProbe) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private KafkaConfig config() {
        return this.config;
    }

    private TierObjectStore tierObjectStore() {
        return this.tierObjectStore;
    }

    private boolean startThread() {
        return this.startThread;
    }

    private AtomicBoolean shutdownFlag() {
        return this.shutdownFlag;
    }

    private String byokErrorRateName() {
        return this.byokErrorRateName;
    }

    private String permissionErrorRateName() {
        return this.permissionErrorRateName;
    }

    private String unclassifiedErrorRate() {
        return this.unclassifiedErrorRate;
    }

    private String healthyRateName() {
        return this.healthyRateName;
    }

    private KafkaThread thread() {
        return this.thread;
    }

    private void thread_$eq(KafkaThread x$1) {
        this.thread = x$1;
    }

    private Meter byokErrors() {
        return this.byokErrors;
    }

    private void byokErrors_$eq(Meter x$1) {
        this.byokErrors = x$1;
    }

    private Meter permissionErrors() {
        return this.permissionErrors;
    }

    private void permissionErrors_$eq(Meter x$1) {
        this.permissionErrors = x$1;
    }

    private Meter unclassifiedErrors() {
        return this.unclassifiedErrors;
    }

    private void unclassifiedErrors_$eq(Meter x$1) {
        this.unclassifiedErrors = x$1;
    }

    private Meter healthy() {
        return this.healthy;
    }

    private void healthy_$eq(Meter x$1) {
        this.healthy = x$1;
    }

    private KafkaMetricsGroup metricsGroup() {
        return this.metricsGroup;
    }

    public void startup() {
        this.byokErrors_$eq(this.metricsGroup().newMeter(this.byokErrorRateName(), "error", TimeUnit.SECONDS));
        this.permissionErrors_$eq(this.metricsGroup().newMeter(this.permissionErrorRateName(), "error", TimeUnit.SECONDS));
        this.healthy_$eq(this.metricsGroup().newMeter(this.healthyRateName(), "error", TimeUnit.SECONDS));
        this.unclassifiedErrors_$eq(this.metricsGroup().newMeter(this.unclassifiedErrorRate(), "error", TimeUnit.SECONDS));
        if (Predef$.MODULE$.Long2long(this.config().confluentConfig().tierBucketProbePeriodMs()) > 0L) {
            this.thread_$eq(KafkaThread.nonDaemon("BucketStorageProbe", this));
            if (this.startThread()) {
                this.thread().start();
                return;
            }
            return;
        }
    }

    public void shutdown() {
        this.metricsGroup().removeMetric(this.byokErrorRateName());
        this.metricsGroup().removeMetric(this.permissionErrorRateName());
        this.metricsGroup().removeMetric(this.healthyRateName());
        this.metricsGroup().removeMetric(this.unclassifiedErrorRate());
        this.shutdownFlag().set(true);
    }

    public void probe() {
        block6: {
            try {
                BucketHealthResult bucketHealthResult = this.tierObjectStore().checkBucketHealth();
                if (((Object)((Object)BucketHealthResult.BYOK)).equals((Object)bucketHealthResult)) {
                    this.byokErrors().mark();
                    break block6;
                }
                if (((Object)((Object)BucketHealthResult.HEALTHY)).equals((Object)bucketHealthResult)) {
                    this.healthy().mark();
                    break block6;
                }
                if (((Object)((Object)BucketHealthResult.PERMISSION)).equals((Object)bucketHealthResult)) {
                    this.permissionErrors().mark();
                    break block6;
                }
                if (((Object)((Object)BucketHealthResult.UNCLASSIFIED)).equals((Object)bucketHealthResult)) {
                    this.unclassifiedErrors().mark();
                    break block6;
                }
                throw new MatchError((Object)bucketHealthResult);
            }
            catch (Throwable t) {
                this.error((Function0<String> & Serializable)() -> "Failed checking bucket.", (Function0<Throwable> & Serializable)() -> t);
            }
        }
    }

    @Override
    public void run() {
        do {
            this.probe();
            Thread.sleep(Predef$.MODULE$.Long2long(this.config().confluentConfig().tierBucketProbePeriodMs()));
        } while (!this.shutdownFlag().get());
    }

    public BucketStorageProbe(KafkaConfig config, TierObjectStore tierObjectStore, boolean startThread) {
        this.config = config;
        this.tierObjectStore = tierObjectStore;
        this.startThread = startThread;
        Logging.$init$(this);
        this.shutdownFlag = new AtomicBoolean(false);
        this.byokErrorRateName = "ByokErrorRate";
        this.permissionErrorRateName = "PermissionErrorRate";
        this.unclassifiedErrorRate = "UnclassifiedErrorRate";
        this.healthyRateName = "HealthyRate";
        this.metricsGroup = new KafkaMetricsGroup(this.getClass());
    }
}

