/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import kafka.network.RequestChannel;
import kafka.server.ClientQuotaManager;
import kafka.server.ClientQuotaManager$;
import kafka.server.ClientSensors;
import kafka.server.ProducerIdQuotaManagerConfig;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.MetricConfig;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.QuotaViolationException;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.CumulativeSum;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.network.Session;
import org.apache.kafka.server.config.ClientQuotaManagerConfig;
import org.apache.kafka.server.quota.ClientQuotaCallback;
import org.apache.kafka.server.quota.QuotaType;
import org.apache.kafka.storage.internals.log.ProducerIdQuotaRecorder;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Option;
import scala.collection.immutable.Map;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0015f\u0001B\r\u001b\u0001}A\u0001b\r\u0001\u0003\u0006\u0004%I\u0001\u000e\u0005\tq\u0001\u0011\t\u0011)A\u0005k!A\u0011\b\u0001BC\u0002\u0013%!\b\u0003\u0005B\u0001\t\u0005\t\u0015!\u0003<\u0011!\u0011\u0005A!b\u0001\n\u0013\u0019\u0005\u0002C&\u0001\u0005\u0003\u0005\u000b\u0011\u0002#\t\u00111\u0003!Q1A\u0005R5C\u0011\u0002\u0016\u0001\u0003\u0002\u0003\u0006IAT+\t\u0011Y\u0003!Q1A\u0005\n]C\u0001\"\u001a\u0001\u0003\u0002\u0003\u0006I\u0001\u0017\u0005\tM\u0002\u0011)\u0019!C\u0005O\"A!\u000f\u0001B\u0001B\u0003%\u0001\u000eC\u0003t\u0001\u0011\u0005A\u000fC\u0004}\u0001\t\u0007I\u0011B?\t\u000f\u0005\r\u0001\u0001)A\u0005}\"9\u0011Q\u0001\u0001\u0005B\u0005\u001d\u0001bBA\b\u0001\u0011\u0005\u0013\u0011\u0003\u0005\b\u0003c\u0001A\u0011IA\u001a\u0011\u001d\t9\u0005\u0001C!\u0003\u0013Bq!!\u0019\u0001\t\u0003\t\u0019\u0007C\u0004\u0002\u0000\u0001!I!!!\t\u000f\u0005\u001d\u0005\u0001\"\u0001\u0002\n\"9\u00111\u0013\u0001\u0005\n\u0005U\u0005bBAP\u0001\u0011%\u0011\u0011\u0015\u0002\u0017!J|G-^2fe&#\u0017+^8uC6\u000bg.Y4fe*\u00111\u0004H\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003u\tQa[1gW\u0006\u001c\u0001aE\u0002\u0001A\u0011\u0002\"!\t\u0012\u000e\u0003iI!a\t\u000e\u0003%\rc\u0017.\u001a8u#V|G/Y'b]\u0006<WM\u001d\t\u0003KEj\u0011A\n\u0006\u0003O!\n1\u0001\\8h\u0015\tI#&A\u0005j]R,'O\\1mg*\u00111\u0006L\u0001\bgR|'/Y4f\u0015\tiRF\u0003\u0002/_\u00051\u0011\r]1dQ\u0016T\u0011\u0001M\u0001\u0004_J<\u0017B\u0001\u001a'\u0005]\u0001&o\u001c3vG\u0016\u0014\u0018\nZ)v_R\f'+Z2pe\u0012,'/\u0001\u0004d_:4\u0017nZ\u000b\u0002kA\u0011\u0011EN\u0005\u0003oi\u0011A\u0004\u0015:pIV\u001cWM]%e#V|G/Y'b]\u0006<WM]\"p]\u001aLw-A\u0004d_:4\u0017n\u001a\u0011\u0002\u0019\rd\u0017.\u001a8u\u0007>tg-[4\u0016\u0003m\u0002\"\u0001P \u000e\u0003uR!a\r \u000b\u0005ma\u0013B\u0001!>\u0005a\u0019E.[3oiF+x\u000e^1NC:\fw-\u001a:D_:4\u0017nZ\u0001\u000eG2LWM\u001c;D_:4\u0017n\u001a\u0011\u0002\u000f5,GO]5dgV\tA\t\u0005\u0002F\u00136\taI\u0003\u0002C\u000f*\u0011\u0001\nL\u0001\u0007G>lWn\u001c8\n\u0005)3%aB'fiJL7m]\u0001\t[\u0016$(/[2tA\u0005!A/[7f+\u0005q\u0005CA(S\u001b\u0005\u0001&BA)H\u0003\u0015)H/\u001b7t\u0013\t\u0019\u0006K\u0001\u0003US6,\u0017!\u0002;j[\u0016\u0004\u0013B\u0001'#\u0003A!\bN]3bI:\u000bW.\u001a)sK\u001aL\u00070F\u0001Y!\tI&M\u0004\u0002[AB\u00111LX\u0007\u00029*\u0011QLH\u0001\u0007yI|w\u000e\u001e \u000b\u0003}\u000bQa]2bY\u0006L!!\u00190\u0002\rA\u0013X\rZ3g\u0013\t\u0019GM\u0001\u0004TiJLgn\u001a\u0006\u0003Cz\u000b\u0011\u0003\u001e5sK\u0006$g*Y7f!J,g-\u001b=!\u0003M\u0019G.[3oiF+x\u000e^1DC2d'-Y2l+\u0005A\u0007cA5kY6\ta,\u0003\u0002l=\n1q\n\u001d;j_:\u0004\"!\u001c9\u000e\u00039T!a\u001c \u0002\u000bE,x\u000e^1\n\u0005Et'aE\"mS\u0016tG/U;pi\u0006\u001c\u0015\r\u001c7cC\u000e\\\u0017\u0001F2mS\u0016tG/U;pi\u0006\u001c\u0015\r\u001c7cC\u000e\\\u0007%\u0001\u0004=S:LGO\u0010\u000b\bkZ<\b0\u001f>|!\t\t\u0003\u0001C\u00034\u001b\u0001\u0007Q\u0007C\u0003:\u001b\u0001\u00071\bC\u0003C\u001b\u0001\u0007A\tC\u0003M\u001b\u0001\u0007a\nC\u0003W\u001b\u0001\u0007\u0001\fC\u0003g\u001b\u0001\u0007\u0001.A\tuQJ|G\u000f\u001e7f)\"\u0014Xm\u001d5pY\u0012,\u0012A \t\u0003S~L1!!\u0001_\u0005\u0019!u.\u001e2mK\u0006\u0011B\u000f\u001b:piRdW\r\u00165sKNDw\u000e\u001c3!\u0003M\u0011\u0017mY6qe\u0016\u001c8/\u001e:f\u000b:\f'\r\\3e+\t\tI\u0001E\u0002j\u0003\u0017I1!!\u0004_\u0005\u001d\u0011un\u001c7fC:\f!D]3d_J$\u0017I\u001c3HKR$\u0006N]8ui2,G+[7f\u001bN$\u0002\"a\u0005\u0002\u001a\u0005\r\u0012q\u0005\t\u0004S\u0006U\u0011bAA\f=\n\u0019\u0011J\u001c;\t\u000f\u0005m\u0011\u00031\u0001\u0002\u001e\u0005i1\r\\5f]R\u001cVM\\:peN\u00042!IA\u0010\u0013\r\t\tC\u0007\u0002\u000e\u00072LWM\u001c;TK:\u001cxN]:\t\r\u0005\u0015\u0012\u00031\u0001\u007f\u0003\u00151\u0018\r\\;f\u0011\u001d\tI#\u0005a\u0001\u0003W\ta\u0001^5nK6\u001b\bcA5\u0002.%\u0019\u0011q\u00060\u0003\t1{gnZ\u0001\u0015G2LWM\u001c;SCR,W*\u001a;sS\u000et\u0015-\\3\u0015\t\u0005U\u0012Q\b\t\u0005\u0003o\tI$D\u0001H\u0013\r\tYd\u0012\u0002\u000b\u001b\u0016$(/[2OC6,\u0007bBA %\u0001\u0007\u0011\u0011I\u0001\u0010cV|G/Y'fiJL7\rV1hgB)\u0011,a\u0011Y1&\u0019\u0011Q\t3\u0003\u00075\u000b\u0007/\u0001\u000bsK\u001eL7\u000f^3s#V|G/Y'fiJL7m\u001d\u000b\u0005\u0003\u0017\ni\u0006\u0006\u0003\u0002N\u0005M\u0003cA5\u0002P%\u0019\u0011\u0011\u000b0\u0003\tUs\u0017\u000e\u001e\u0005\b\u0003+\u001a\u0002\u0019AA,\u0003\u0019\u0019XM\\:peB\u0019Q)!\u0017\n\u0007\u0005mcI\u0001\u0004TK:\u001cxN\u001d\u0005\b\u0003?\u001a\u0002\u0019AA!\u0003)iW\r\u001e:jGR\u000bwm]\u0001\u0017[\u0006L(-Z$fiRC'o\u001c;uY\u0016$\u0016.\\3NgR1\u00111CA3\u0003{Bq!a\u001a\u0015\u0001\u0004\tI'A\u0004sKF,Xm\u001d;\u0011\t\u0005-\u0014q\u000f\b\u0005\u0003[\n\u0019(\u0004\u0002\u0002p)\u0019\u0011\u0011\u000f\u000f\u0002\u000f9,Go^8sW&!\u0011QOA8\u00039\u0011V-];fgR\u001c\u0005.\u00198oK2LA!!\u001f\u0002|\t9!+Z9vKN$(\u0002BA;\u0003_Bq!!\u000b\u0015\u0001\u0004\tY#A\thKR$\u0006N]8ui2,G+[7f\u001bN$b!a\u0005\u0002\u0004\u0006\u0015\u0005bBA\u000e+\u0001\u0007\u0011Q\u0004\u0005\b\u0003S)\u0002\u0019AA\u0016\u0003-i\u0017-\u001f2f%\u0016\u001cwN\u001d3\u0015\u0011\u00055\u00131RAH\u0003#Ca!!$\u0017\u0001\u0004A\u0016!\u0003;pa&\u001cg*Y7f\u0011\u0019\t)C\u0006a\u0001}\"9\u0011\u0011\u0006\fA\u0002\u0005-\u0012A\u0002:fG>\u0014H\r\u0006\u0005\u0002N\u0005]\u00151TAO\u0011\u001d\tIj\u0006a\u0001\u0003/\n1\"];pi\u0006\u001cVM\\:pe\"1\u0011QE\fA\u0002yDq!!\u000b\u0018\u0001\u0004\tY#A\u000bdY&,g\u000e^\"pk:$X*\u001a;sS\u000et\u0015-\\3\u0015\t\u0005U\u00121\u0015\u0005\b\u0003\u007fA\u0002\u0019AA!\u0001")
public class ProducerIdQuotaManager
extends ClientQuotaManager
implements ProducerIdQuotaRecorder {
    private final ProducerIdQuotaManagerConfig config;
    private final ClientQuotaManagerConfig clientConfig;
    private final Metrics metrics;
    private final String threadNamePrefix;
    private final Option<ClientQuotaCallback> clientQuotaCallback;
    private final double throttleThreshold;

    private ProducerIdQuotaManagerConfig config() {
        return this.config;
    }

    private ClientQuotaManagerConfig clientConfig() {
        return this.clientConfig;
    }

    private Metrics metrics() {
        return this.metrics;
    }

    @Override
    public Time time() {
        return super.time();
    }

    private String threadNamePrefix() {
        return this.threadNamePrefix;
    }

    private Option<ClientQuotaCallback> clientQuotaCallback() {
        return this.clientQuotaCallback;
    }

    private double throttleThreshold() {
        return this.throttleThreshold;
    }

    @Override
    public boolean backpressureEnabled() {
        return false;
    }

    @Override
    public int recordAndGetThrottleTimeMs(ClientSensors clientSensors, double value, long timeMs) {
        int throttleTimeMs;
        block0: {
            throttleTimeMs = this.getThrottleTimeMs(clientSensors, timeMs);
            if (throttleTimeMs > 0) break block0;
            this.record(clientSensors.quotaSensor(), value, timeMs);
        }
        return throttleTimeMs;
    }

    @Override
    public MetricName clientRateMetricName(Map<String, String> quotaMetricTags) {
        return this.metrics().metricName("usage-rate", this.quotaType().toString(), "Tracking usage-rate per tenant", CollectionConverters$.MODULE$.MapHasAsJava(quotaMetricTags).asJava());
    }

    @Override
    public void registerQuotaMetrics(Map<String, String> metricTags, Sensor sensor) {
        super.registerQuotaMetrics(metricTags, sensor);
        sensor.add(this.clientCountMetricName(metricTags), new CumulativeSum(), new MetricConfig());
    }

    public int maybeGetThrottleTimeMs(RequestChannel.Request request, long timeMs) {
        if (this.quotasEnabled()) {
            Session session = request.session();
            String clientId = request.header().clientId();
            ClientSensors clientSensors = this.getOrCreateQuotaSensors(session, clientId);
            return this.getThrottleTimeMs(clientSensors, timeMs);
        }
        return 0;
    }

    private int getThrottleTimeMs(ClientSensors clientSensors, long timeMs) {
        int n;
        Sensor quotaSensor = clientSensors.quotaSensor();
        try {
            KafkaMetric countMetric = this.metrics().metrics().get(this.clientCountMetricName(clientSensors.metricTags()));
            if (countMetric != null && countMetric.measurableValue(timeMs) > this.throttleThreshold()) {
                quotaSensor.checkQuotas(timeMs);
            }
            n = 0;
        }
        catch (QuotaViolationException e) {
            int throttleTimeMs = (int)this.throttleTime(e, this.quotaMaxThrottleTimeMs());
            this.debug((Function0<String> & Serializable)() -> "Quota violated for sensor (" + quotaSensor.name() + "). Delay time: (" + throttleTimeMs + ")");
            n = throttleTimeMs;
        }
        return n;
    }

    @Override
    public void maybeRecord(String topicName, double value, long timeMs) {
        if (this.quotasEnabled()) {
            Map<String, String> metricTags = CollectionConverters$.MODULE$.MapHasAsScala(this.quotaCallback().quotaMetricTagsFromTopic(this.clientQuotaType(), topicName)).asScala().toMap($less$colon$less$.MODULE$.refl());
            ClientSensors clientSensors = this.getOrCreateQuotaSensors(metricTags, this.getOrCreateQuotaSensors$default$2(), this.getOrCreateQuotaSensors$default$3());
            this.record(clientSensors.quotaSensor(), value, timeMs);
            return;
        }
    }

    private void record(Sensor quotaSensor, double value, long timeMs) {
        quotaSensor.record(value, timeMs, false);
    }

    private MetricName clientCountMetricName(Map<String, String> quotaMetricTags) {
        return this.metrics().metricName("count", this.quotaType().toString(), "Tracking total count per tenant/user", CollectionConverters$.MODULE$.MapHasAsJava(quotaMetricTags).asJava());
    }

    public ProducerIdQuotaManager(ProducerIdQuotaManagerConfig config, ClientQuotaManagerConfig clientConfig, Metrics metrics, Time time, String threadNamePrefix, Option<ClientQuotaCallback> clientQuotaCallback) {
        this.config = config;
        this.clientConfig = clientConfig;
        this.metrics = metrics;
        this.threadNamePrefix = threadNamePrefix;
        this.clientQuotaCallback = clientQuotaCallback;
        super(clientConfig, metrics, QuotaType.PRODUCER_ID, time, threadNamePrefix, clientQuotaCallback, ClientQuotaManager$.MODULE$.$lessinit$greater$default$7());
        this.throttleThreshold = (double)config.cacheLimit() * ((double)config.cachePerTenantPercent() / 100.0);
    }
}

