/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import kafka.cluster.EndPoint;
import kafka.metrics.BrokerLoad;
import kafka.server.AbstractQuotaChannelManager;
import kafka.server.ActiveTenantsManager;
import kafka.server.ClientQuotaManager;
import kafka.server.ClientQuotaMetricsReporter;
import kafka.server.ClientQuotaMetricsReporterConfig;
import kafka.server.ClientRequestQuotaManager;
import kafka.server.ClusterLinkQuotas;
import kafka.server.ClusterLinkReplicationConfig;
import kafka.server.ClusterLinkReplicationQuotaManager;
import kafka.server.ClusterLinkRequestQuotaManager;
import kafka.server.ClusterLinkRequestQuotaManagerConfig;
import kafka.server.ControllerMutationQuotaManager;
import kafka.server.DiskUsageBasedThrottler$;
import kafka.server.KafkaConfig;
import kafka.server.ProducerIdQuotaManager;
import kafka.server.ProducerIdQuotaManagerConfig;
import kafka.server.ReplicaQuota;
import kafka.server.ReplicationQuotaManager;
import kafka.server.RequestQueueSizePercentiles;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.config.internals.ConfluentConfigs;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.config.BrokerBackpressureConfig;
import org.apache.kafka.server.config.ClientQuotaManagerConfig;
import org.apache.kafka.server.config.DiskUsageBasedThrottlingConfig;
import org.apache.kafka.server.config.ReplicationQuotaManagerConfig;
import org.apache.kafka.server.quota.ClientQuotaCallback;
import org.apache.kafka.server.quota.ClientQuotaType;
import org.apache.kafka.server.quota.QuotaType;
import org.apache.kafka.server.util.Csv;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Option;
import scala.jdk.CollectionConverters;
import scala.jdk.javaapi.OptionConverters;

public class QuotaFactory {
    private static final Logger log = LoggerFactory.getLogger(QuotaFactory.class);
    static volatile boolean quotaConsumptionReportingEnabled = false;
    static volatile boolean brokerLoadConsumptionReportingEnabled = false;
    public static final ReplicaQuota UNBOUNDED_QUOTA = new ReplicaQuota(){

        @Override
        public boolean isThrottled(TopicPartition topicPartition) {
            return false;
        }

        @Override
        public boolean isQuotaExceeded() {
            return false;
        }

        @Override
        public void record(long value) {
        }
    };

    public static void updateQuotaConsumptionReportingEnabled(boolean consumptionReportingEnabled) {
        quotaConsumptionReportingEnabled = consumptionReportingEnabled;
    }

    public static QuotaManagers instantiate(KafkaConfig cfg, Metrics metrics, Time time, String threadNamePrefix, Option<AbstractQuotaChannelManager> dynamicQuotaChannelManagerOpt, Option<BrokerLoad> brokerLoadOpt) {
        Option<ClientQuotaCallback> clientQuotaCallback = Option.apply(cfg.getConfiguredInstance("client.quota.callback.class", ClientQuotaCallback.class));
        Long consumptionReportingIntervalMs = cfg.getLong("confluent.quota.dynamic.reporting.interval.ms");
        quotaConsumptionReportingEnabled = dynamicQuotaChannelManagerOpt.isDefined() && consumptionReportingIntervalMs > 0L;
        brokerLoadConsumptionReportingEnabled = brokerLoadOpt.isDefined() && consumptionReportingIntervalMs > 0L;
        Option<ActiveTenantsManager> activeTenantsManager = Option.empty();
        if (QuotaFactory.isMultiTenant(cfg)) {
            activeTenantsManager = Option.apply(new ActiveTenantsManager(metrics, time, BrokerBackpressureConfig.DEFAULT_ACTIVE_WINDOW_MS));
        }
        if (clientQuotaCallback.isDefined()) {
            clientQuotaCallback.get().enableDynamicQuota(cfg.getBoolean(KafkaConfig.DynamicQuotaEnabledProp()));
        }
        ClientQuotaManagerConfig fetchClientConfig = QuotaFactory.clientConfig(cfg, QuotaType.FETCH);
        ClientQuotaManager fetchQuotaManager = new ClientQuotaManager(fetchClientConfig, metrics, QuotaType.FETCH, time, threadNamePrefix, clientQuotaCallback, activeTenantsManager);
        QuotaManagers.setBrokerQuotaLimitByType(QuotaType.toClientQuotaType(QuotaType.FETCH), fetchClientConfig.brokerQuotaLimit);
        ClientQuotaManagerConfig produceClientConfig = QuotaFactory.clientConfig(cfg, QuotaType.PRODUCE);
        ClientQuotaManager produceQuotaManager = new ClientQuotaManager(produceClientConfig, metrics, QuotaType.PRODUCE, time, threadNamePrefix, clientQuotaCallback, activeTenantsManager);
        QuotaManagers.setBrokerQuotaLimitByType(QuotaType.toClientQuotaType(QuotaType.PRODUCE), produceClientConfig.brokerQuotaLimit);
        ClientRequestQuotaManager requestQuotaManager = new ClientRequestQuotaManager(QuotaFactory.clientConfig(cfg, QuotaType.REQUEST), metrics, time, threadNamePrefix, OptionConverters.toJava(clientQuotaCallback), OptionConverters.toJava(activeTenantsManager), OptionConverters.toJava(brokerLoadOpt));
        Optional<ProducerIdQuotaManager> producerIdQuotaManager = Optional.empty();
        if (cfg.producerIdQuotaManagerEnable().booleanValue()) {
            producerIdQuotaManager = Optional.of(new ProducerIdQuotaManager(QuotaFactory.producerIdQuotaConfig(cfg), QuotaFactory.clientProducerIdQuotaConfig(cfg), metrics, time, threadNamePrefix, clientQuotaCallback));
        }
        List<EndPoint> listeners = CollectionConverters.SeqHasAsJava(cfg.listeners()).asJava();
        listeners.forEach(listener -> requestQuotaManager.addListenerMetrics(listener.listenerName().value()));
        ReplicationQuotaManager followerQuotaManager = new ReplicationQuotaManager(QuotaFactory.replicationConfig(cfg, QuotaType.FOLLOWER_REPLICATION), metrics, QuotaType.FOLLOWER_REPLICATION, time);
        ClusterLinkReplicationQuotaManager clusterLinkReplicationQuotaManager = new ClusterLinkReplicationQuotaManager(QuotaFactory.clusterLinkReplicationConfig(cfg), produceQuotaManager, metrics, time);
        ClusterLinkRequestQuotaManager clusterLinkRequestQuotaManager = new ClusterLinkRequestQuotaManager(QuotaFactory.clusterLinkRequestQuotaManagerConfig(cfg), metrics, time, threadNamePrefix, clientQuotaCallback, activeTenantsManager);
        DiskUsageBasedThrottler$.MODULE$.registerListener(produceQuotaManager);
        DiskUsageBasedThrottler$.MODULE$.registerListener(followerQuotaManager);
        if (cfg.clusterLinkEnable().booleanValue()) {
            DiskUsageBasedThrottler$.MODULE$.registerListener(clusterLinkReplicationQuotaManager);
        }
        produceQuotaManager.initThrottler();
        ClientQuotaMetricsReporter clientQuotaMetricsReporter = new ClientQuotaMetricsReporter(QuotaFactory.clientQuotaMetricsReporterConfig(cfg), metrics, fetchQuotaManager, produceQuotaManager, activeTenantsManager, dynamicQuotaChannelManagerOpt.map(AbstractQuotaChannelManager::getReportRequestThread), brokerLoadOpt);
        clientQuotaMetricsReporter.init();
        return new QuotaManagers(fetchQuotaManager, produceQuotaManager, requestQuotaManager, new ControllerMutationQuotaManager(QuotaFactory.clientControllerMutationConfig(cfg), metrics, time, threadNamePrefix, clientQuotaCallback), producerIdQuotaManager, new ReplicationQuotaManager(QuotaFactory.replicationConfig(cfg, QuotaType.LEADER_REPLICATION), metrics, QuotaType.LEADER_REPLICATION, time), followerQuotaManager, new ReplicationQuotaManager(QuotaFactory.alterLogDirsReplicationConfig(cfg), metrics, QuotaType.ALTER_LOG_DIRS_REPLICATION, time), clusterLinkReplicationQuotaManager, clusterLinkRequestQuotaManager, OptionConverters.toJava(clientQuotaCallback));
    }

    static DiskUsageBasedThrottlingConfig diskThrottleConfig(KafkaConfig cfg) {
        long freeDiskThresholdBytes = cfg.backPressureDiskThresholdBytes();
        long throttledProduceThroughput = cfg.getLong("confluent.backpressure.disk.produce.bytes.per.second");
        boolean enableDiskThrottling = cfg.getBoolean("confluent.backpressure.disk.enable");
        double recoveryFactor = cfg.getDouble("confluent.backpressure.disk.threshold.recovery.factor");
        return new DiskUsageBasedThrottlingConfig(freeDiskThresholdBytes, throttledProduceThroughput, CollectionConverters.SeqHasAsJava(cfg.logDirs()).asJava(), enableDiskThrottling, recoveryFactor, cfg.clusterLinkEnable());
    }

    protected static ClientQuotaManagerConfig clientConfig(KafkaConfig cfg, QuotaType quotaType) {
        if (!Arrays.asList(QuotaType.PRODUCE, QuotaType.FETCH, QuotaType.REQUEST, QuotaType.CLUSTER_LINK_REQUEST).contains((Object)quotaType)) {
            throw new IllegalArgumentException("Unexpected quota type: " + String.valueOf((Object)quotaType));
        }
        DiskUsageBasedThrottlingConfig diskThrottlingConfig = new DiskUsageBasedThrottlingConfig();
        if (quotaType == QuotaType.PRODUCE) {
            diskThrottlingConfig = QuotaFactory.diskThrottleConfig(cfg);
        }
        double brokerQuotaLimit = 9.223372036854776E18;
        if (quotaType == QuotaType.PRODUCE) {
            brokerQuotaLimit = cfg.confluentConfig().brokerLimitProducerConfig().longValue();
        } else if (quotaType == QuotaType.FETCH) {
            brokerQuotaLimit = cfg.confluentConfig().brokerLimitConsumerConfig().longValue();
        }
        int quotaSamples = cfg.numQuotaSamples();
        if (quotaType == QuotaType.PRODUCE || quotaType == QuotaType.FETCH) {
            quotaSamples = cfg.numThroughputQuotaSamples();
        }
        return new ClientQuotaManagerConfig(quotaSamples, cfg.quotaWindowSizeSeconds(), QuotaFactory.brokerBackpressureConfig(cfg, quotaType), diskThrottlingConfig, brokerQuotaLimit, cfg.getLong("confluent.quota.dynamic.reporting.interval.ms"), cfg.clientQuotaMaxThrottleTimeMs(), cfg.clientQuotaMaxThrottleTimeInResponseMs());
    }

    protected static ReplicationQuotaManagerConfig replicationConfig(KafkaConfig cfg, QuotaType quotaType) {
        long throttleRate = Long.MAX_VALUE;
        boolean replicasAreThrottled = false;
        if (quotaType == QuotaType.LEADER_REPLICATION) {
            throttleRate = cfg.ReplicationLeaderThrottleRate();
            replicasAreThrottled = cfg.ReplicationLeaderReplicasAreThrottled();
        } else if (quotaType == QuotaType.FOLLOWER_REPLICATION) {
            throttleRate = cfg.ReplicationFollowerThrottleRate();
            replicasAreThrottled = cfg.ReplicationFollowerReplicasAreThrottled();
        }
        return new ReplicationQuotaManagerConfig(throttleRate, cfg.numReplicationQuotaSamples(), cfg.replicationQuotaWindowSizeSeconds(), replicasAreThrottled);
    }

    private static ClientQuotaManagerConfig clientControllerMutationConfig(KafkaConfig cfg) {
        return new ClientQuotaManagerConfig((int)cfg.numControllerQuotaSamples(), cfg.controllerQuotaWindowSizeSeconds(), (long)cfg.clientQuotaMaxThrottleTimeMs());
    }

    private static ReplicationQuotaManagerConfig replicationConfig(KafkaConfig cfg) {
        return new ReplicationQuotaManagerConfig(cfg.numReplicationQuotaSamples(), cfg.replicationQuotaWindowSizeSeconds());
    }

    private static ReplicationQuotaManagerConfig alterLogDirsReplicationConfig(KafkaConfig cfg) {
        return new ReplicationQuotaManagerConfig(cfg.numAlterLogDirsReplicationQuotaSamples(), cfg.alterLogDirsReplicationQuotaWindowSizeSeconds());
    }

    private static ClusterLinkRequestQuotaManagerConfig clusterLinkRequestQuotaManagerConfig(KafkaConfig cfg) {
        return new ClusterLinkRequestQuotaManagerConfig(QuotaFactory.clientConfig(cfg, QuotaType.CLUSTER_LINK_REQUEST), cfg::clusterLinkEnable, cfg::clusterLinkTenantRequestQuotaEnable, cfg::clusterLinkRequestQuotaCapacity);
    }

    static ClusterLinkReplicationConfig clusterLinkReplicationConfig(KafkaConfig cfg) {
        long bytesPerSecond = cfg.getLong(KafkaConfig.ClusterLinkIoMaxBytesPerSecondProp());
        ReplicationQuotaManagerConfig replicationQuotaManagerConfig = new ReplicationQuotaManagerConfig(bytesPerSecond, cfg.numClusterLinkReplicationQuotaSamples(), cfg.clusterLinkReplicationQuotaWindowSizeSeconds(), bytesPerSecond != Long.MAX_VALUE);
        return new ClusterLinkReplicationConfig(replicationQuotaManagerConfig, cfg::clusterLinkEnable, cfg::clusterLinkTenantReplicationQuotaEnable, cfg::clusterLinkQuotaMode, cfg::clusterLinkQuotaModePerTenantOverrides);
    }

    static ClientQuotaManagerConfig clientProducerIdQuotaConfig(KafkaConfig cfg) {
        return new ClientQuotaManagerConfig((int)cfg.numProducerIdQuotaSamples(), cfg.producerIdQuotaWindowSizeSeconds(), (long)cfg.clientQuotaMaxThrottleTimeMs());
    }

    static ProducerIdQuotaManagerConfig producerIdQuotaConfig(KafkaConfig cfg) {
        return new ProducerIdQuotaManagerConfig(cfg.producerIdCacheLimit(), cfg.producerIdThrottleEnableThresholdPercentage());
    }

    static ClientQuotaMetricsReporterConfig clientQuotaMetricsReporterConfig(KafkaConfig cfg) {
        return new ClientQuotaMetricsReporterConfig(cfg.getLong("confluent.quota.dynamic.reporting.interval.ms"), cfg.confluentConfig().elasticCkuEnabled(), cfg.getBoolean("confluent.enable.broker.reporting.min.usage.mode"));
    }

    static boolean isMultiTenant(KafkaConfig cfg) {
        String quotaCallbackStr = "";
        if (cfg.originalsStrings().containsKey("client.quota.callback.class")) {
            quotaCallbackStr = cfg.originalsStrings().get("client.quota.callback.class");
        }
        return quotaCallbackStr.contains("io.confluent.kafka.multitenant.quota.TenantQuotaCallback");
    }

    static boolean backpressureEnabledInConfig(KafkaConfig cfg, QuotaType quotaType) {
        if (QuotaFactory.isMultiTenant(cfg)) {
            String backpressureTypeProp = cfg.getString("confluent.backpressure.types");
            List<String> backpressureTypesList = Csv.parseCsvList(backpressureTypeProp);
            return backpressureTypesList.contains(quotaType.toString().toLowerCase(Locale.ROOT));
        }
        return false;
    }

    static BrokerBackpressureConfig brokerBackpressureConfig(KafkaConfig cfg, QuotaType quotaType) {
        String queueSizePercentile;
        String percentileStr;
        boolean backpressureEnabled = QuotaFactory.backpressureEnabledInConfig(cfg, quotaType);
        ArrayList<String> tenantListenerNames = new ArrayList<String>();
        if (quotaType == QuotaType.REQUEST) {
            List<String> multitenantListeners = ConfluentConfigs.multitenantListenerNames(cfg, cfg.interBrokerListenerName());
            List<EndPoint> effectiveAdvertisedBrokerListeners = CollectionConverters.SeqHasAsJava(cfg.effectiveAdvertisedBrokerListeners()).asJava();
            ArrayList listeners = new ArrayList();
            effectiveAdvertisedBrokerListeners.forEach(listener -> {
                if (multitenantListeners.contains(listener.listenerName().value())) {
                    listeners.add(listener.listenerName().value());
                }
            });
            if (listeners.isEmpty() && backpressureEnabled) {
                log.warn("Invalid multitenant listener names provided in config. Request backpressure will be disabled");
            }
            tenantListenerNames = listeners;
        }
        if (RequestQueueSizePercentiles.valid(percentileStr = cfg.getString("confluent.backpressure.request.queue.size.percentile"))) {
            queueSizePercentile = percentileStr;
        } else {
            log.warn("Invalid {}=`{}`. Using default `{}`.", new Object[]{"confluent.backpressure.request.queue.size.percentile", percentileStr, "p95"});
            queueSizePercentile = "p95";
        }
        return new BrokerBackpressureConfig(backpressureEnabled, tenantListenerNames, cfg.queuedMaxRequests().intValue(), Math.max((double)cfg.getLong("confluent.backpressure.request.min.broker.limit").longValue(), 10.0), queueSizePercentile, cfg.maxBrokerLoad());
    }

    public static class QuotaManagers {
        private final ClientQuotaManager fetch;
        private final ClientQuotaManager produce;
        private final ClientRequestQuotaManager request;
        private final ControllerMutationQuotaManager controllerMutation;
        private final Optional<ProducerIdQuotaManager> producerId;
        private final ReplicationQuotaManager leader;
        private final ReplicationQuotaManager follower;
        private final ReplicationQuotaManager alterLogDirs;
        private final ClusterLinkReplicationQuotaManager clusterLinkProduce;
        private final ClusterLinkRequestQuotaManager clusterLinkRequest;
        private final Optional<ClientQuotaCallback> clientQuotaCallback;
        private static final Map<ClientQuotaType, Double> BROKER_QUOTA_LIMIT_BY_TYPE = new ConcurrentHashMap<ClientQuotaType, Double>();

        public QuotaManagers(ClientQuotaManager fetch, ClientQuotaManager produce, ClientRequestQuotaManager request, ControllerMutationQuotaManager controllerMutation, Optional<ProducerIdQuotaManager> producerId, ReplicationQuotaManager leader, ReplicationQuotaManager follower, ReplicationQuotaManager alterLogDirs, ClusterLinkReplicationQuotaManager clusterLinkProduce, ClusterLinkRequestQuotaManager clusterLinkRequest, Optional<ClientQuotaCallback> clientQuotaCallback) {
            this.fetch = fetch;
            this.produce = produce;
            this.request = request;
            this.controllerMutation = controllerMutation;
            this.producerId = producerId;
            this.leader = leader;
            this.follower = follower;
            this.alterLogDirs = alterLogDirs;
            this.clusterLinkProduce = clusterLinkProduce;
            this.clusterLinkRequest = clusterLinkRequest;
            this.clientQuotaCallback = clientQuotaCallback;
        }

        static void setBrokerQuotaLimitByType(ClientQuotaType quotaType, double brokerQuotaLimit) {
            BROKER_QUOTA_LIMIT_BY_TYPE.put(quotaType, brokerQuotaLimit);
        }

        public static double getBrokerQuotaLimitByTypeOrElse(ClientQuotaType quotaType, double defaultValue) {
            return BROKER_QUOTA_LIMIT_BY_TYPE.getOrDefault((Object)quotaType, defaultValue);
        }

        public ClientQuotaManager fetch() {
            return this.fetch;
        }

        public ClientQuotaManager produce() {
            return this.produce;
        }

        public ClientRequestQuotaManager request() {
            return this.request;
        }

        public ControllerMutationQuotaManager controllerMutation() {
            return this.controllerMutation;
        }

        public ReplicationQuotaManager leader() {
            return this.leader;
        }

        public ReplicationQuotaManager follower() {
            return this.follower;
        }

        public ReplicationQuotaManager alterLogDirs() {
            return this.alterLogDirs;
        }

        public Optional<ClientQuotaCallback> clientQuotaCallback() {
            return this.clientQuotaCallback;
        }

        public ClusterLinkRequestQuotaManager clusterLinkRequest() {
            return this.clusterLinkRequest;
        }

        public ClusterLinkQuotas clusterLinkQuotas() {
            return new ClusterLinkQuotas(this.clusterLinkProduce, this.clusterLinkRequest);
        }

        public Optional<ProducerIdQuotaManager> producerId() {
            return this.producerId;
        }

        public ClusterLinkReplicationQuotaManager clusterLinkProduce() {
            return this.clusterLinkProduce;
        }

        public void shutdown() {
            this.fetch.shutdown();
            this.produce.shutdown();
            this.request.shutdown();
            this.clusterLinkRequest.shutdown();
            this.controllerMutation.shutdown();
            this.producerId.ifPresent(ClientQuotaManager::shutdown);
            this.clientQuotaCallback.ifPresent(ClientQuotaCallback::close);
            DiskUsageBasedThrottler$.MODULE$.deRegisterListener(this.produce);
            DiskUsageBasedThrottler$.MODULE$.deRegisterListener(this.follower);
            DiskUsageBasedThrottler$.MODULE$.deRegisterListener(this.clusterLinkProduce);
        }
    }
}

