/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import kafka.server.AllRequests$;
import kafka.server.IoThread$;
import kafka.server.NetworkThread$;
import kafka.server.NonExemptRequest$;
import kafka.server.RequestType;
import kafka.server.ThreadType;
import kafka.server.ThreadUsageMetrics$;
import kafka.utils.Pool;
import kafka.utils.Pool$;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.Rate;
import scala.Function0;
import scala.Function1;
import scala.Option$;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0005\u0005Ua\u0001\u0002\u000b\u0016\u0001iA\u0001\"\t\u0001\u0003\u0006\u0004%IA\t\u0005\t_\u0001\u0011\t\u0011)A\u0005G!)\u0001\u0007\u0001C\u0001c!9Q\u0007\u0001b\u0001\n\u00131\u0004B\u0002\u001e\u0001A\u0003%q\u0007C\u0004<\u0001\t\u0007I\u0011\u0002\u001c\t\rq\u0002\u0001\u0015!\u00038\u0011\u001di\u0004A1A\u0005\nyBa\u0001\u0015\u0001!\u0002\u0013y\u0004bB)\u0001\u0005\u0004%IA\u0010\u0005\u0007%\u0002\u0001\u000b\u0011B \t\u000bM\u0003A\u0011\u0001+\t\u000b\u001d\u0004A\u0011\u00015\t\u000b9\u0004A\u0011A8\t\u000bE\u0004A\u0011\u0001:\t\u000bQ\u0004A\u0011A;\t\u000bY\u0004A\u0011B<\t\u000f\u0005\u001d\u0001\u0001\"\u0003\u0002\n!9\u0011q\u0002\u0001\u0005\n\u0005E!A\u0005+ie\u0016\fG-V:bO\u0016\u001cVM\\:peNT!AF\f\u0002\rM,'O^3s\u0015\u0005A\u0012!B6bM.\f7\u0001A\n\u0003\u0001m\u0001\"\u0001H\u0010\u000e\u0003uQ\u0011AH\u0001\u0006g\u000e\fG.Y\u0005\u0003Au\u0011a!\u00118z%\u00164\u0017aB7fiJL7m]\u000b\u0002GA\u0011A%L\u0007\u0002K)\u0011\u0011E\n\u0006\u0003O!\naaY8n[>t'B\u0001\r*\u0015\tQ3&\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002Y\u0005\u0019qN]4\n\u00059*#aB'fiJL7m]\u0001\t[\u0016$(/[2tA\u00051A(\u001b8jiz\"\"A\r\u001b\u0011\u0005M\u0002Q\"A\u000b\t\u000b\u0005\u001a\u0001\u0019A\u0012\u00029%|G\u000b\u001b:fC\u0012tuN\\#yK6\u0004H/V:bO\u0016\u001cVM\\:peV\tq\u0007\u0005\u0002%q%\u0011\u0011(\n\u0002\u0007'\u0016t7o\u001c:\u0002;%|G\u000b\u001b:fC\u0012tuN\\#yK6\u0004H/V:bO\u0016\u001cVM\\:pe\u0002\n\u0001$[8UQJ,\u0017\r\u001a+pi\u0006dWk]1hKN+gn]8s\u0003eIw\u000e\u00165sK\u0006$Gk\u001c;bYV\u001b\u0018mZ3TK:\u001cxN\u001d\u0011\u0002E9,Go^8sWRC'/Z1e\u001d>tW\t_3naR,6/Y4f'\u0016t7o\u001c:t+\u0005y\u0004\u0003\u0002!D\u000b^j\u0011!\u0011\u0006\u0003\u0005^\tQ!\u001e;jYNL!\u0001R!\u0003\tA{w\u000e\u001c\t\u0003\r6s!aR&\u0011\u0005!kR\"A%\u000b\u0005)K\u0012A\u0002\u001fs_>$h(\u0003\u0002M;\u00051\u0001K]3eK\u001aL!AT(\u0003\rM#(/\u001b8h\u0015\taU$A\u0012oKR<xN]6UQJ,\u0017\r\u001a(p]\u0016CX-\u001c9u+N\fw-Z*f]N|'o\u001d\u0011\u0002=9,Go^8sWRC'/Z1e)>$\u0018\r\\+tC\u001e,7+\u001a8t_J\u001c\u0018a\b8fi^|'o\u001b+ie\u0016\fG\rV8uC2,6/Y4f'\u0016t7o\u001c:tA\u0005\u0019\"/Z2pe\u0012Lu\u000e\u00165sK\u0006$Wk]1hKR!Q\u000bW/c!\tab+\u0003\u0002X;\t!QK\\5u\u0011\u0015IF\u00021\u0001[\u0003\u00151\u0018\r\\;f!\ta2,\u0003\u0002];\t1Ai\\;cY\u0016DQA\u0018\u0007A\u0002}\u000ba\u0001^5nK6\u001b\bC\u0001\u000fa\u0013\t\tWD\u0001\u0003M_:<\u0007\"B2\r\u0001\u0004!\u0017a\u0003:fcV,7\u000f\u001e+za\u0016\u0004\"aM3\n\u0005\u0019,\"a\u0003*fcV,7\u000f\u001e+za\u0016\f\u0001D]3d_J$g*\u001a;x_J\\G\u000b\u001b:fC\u0012,6/Y4f)\u0015)\u0016N[6n\u0011\u0015IV\u00021\u0001[\u0011\u0015qV\u00021\u0001`\u0011\u0015aW\u00021\u0001F\u00031a\u0017n\u001d;f]\u0016\u0014h*Y7f\u0011\u0015\u0019W\u00021\u0001e\u0003I\tG\r\u001a'jgR,g.\u001a:NKR\u0014\u0018nY:\u0015\u0005U\u0003\b\"\u00027\u000f\u0001\u0004)\u0015!\u0006:f[>4X\rT5ti\u0016tWM]'fiJL7m\u001d\u000b\u0003+NDQ\u0001\\\bA\u0002\u0015\u000bQa\u00197pg\u0016$\u0012!V\u0001\u0016i\"\u0014X-\u00193Vg\u0006<WmU3og>\u0014h*Y7f)\u0015)\u00050`A\u0003\u0011\u0015I\u0018\u00031\u0001{\u0003)!\bN]3bIRK\b/\u001a\t\u0003gmL!\u0001`\u000b\u0003\u0015QC'/Z1e)f\u0004X\rC\u0003\u007f#\u0001\u0007q0\u0001\u0006nKR\u0014\u0018n\u0019+bON\u0004RARA\u0001\u000b\u0016K1!a\u0001P\u0005\ri\u0015\r\u001d\u0005\u0006GF\u0001\r\u0001Z\u0001\u001fGJ,\u0017\r^3OKR<xN]6UQJ,\u0017\rZ+tC\u001e,7+\u001a8t_J$RaNA\u0006\u0003\u001bAQ\u0001\u001c\nA\u0002\u0015CQa\u0019\nA\u0002\u0011\f\u0011d\u0019:fCR,\u0017j\u001c+ie\u0016\fG-V:bO\u0016\u001cVM\\:peR\u0019q'a\u0005\t\u000b\r\u001c\u0002\u0019\u00013")
public class ThreadUsageSensors {
    private final Metrics metrics;
    private final Sensor ioThreadNonExemptUsageSensor;
    private final Sensor ioThreadTotalUsageSensor;
    private final Pool<String, Sensor> networkThreadNonExemptUsageSensors;
    private final Pool<String, Sensor> networkThreadTotalUsageSensors;

    private Metrics metrics() {
        return this.metrics;
    }

    private Sensor ioThreadNonExemptUsageSensor() {
        return this.ioThreadNonExemptUsageSensor;
    }

    private Sensor ioThreadTotalUsageSensor() {
        return this.ioThreadTotalUsageSensor;
    }

    private Pool<String, Sensor> networkThreadNonExemptUsageSensors() {
        return this.networkThreadNonExemptUsageSensors;
    }

    private Pool<String, Sensor> networkThreadTotalUsageSensors() {
        return this.networkThreadTotalUsageSensors;
    }

    public void recordIoThreadUsage(double value, long timeMs, RequestType requestType) {
        this.ioThreadTotalUsageSensor().record(value, timeMs, false);
        RequestType requestType2 = requestType;
        if (NonExemptRequest$.MODULE$.equals(requestType2)) {
            this.ioThreadNonExemptUsageSensor().record(value, timeMs, false);
            return;
        }
    }

    public void recordNetworkThreadUsage(double value, long timeMs, String listenerName, RequestType requestType) {
        Option$.MODULE$.apply(this.networkThreadTotalUsageSensors().get(listenerName)).foreach((Function1<Sensor, Object> & Serializable)x$1 -> {
            x$1.record(value, timeMs, false);
            return BoxedUnit.UNIT;
        });
        RequestType requestType2 = requestType;
        if (NonExemptRequest$.MODULE$.equals(requestType2)) {
            Option$.MODULE$.apply(this.networkThreadNonExemptUsageSensors().get(listenerName)).foreach((Function1<Sensor, Object> & Serializable)x$2 -> {
                x$2.record(value, timeMs, false);
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    public void addListenerMetrics(String listenerName) {
        ThreadUsageSensors threadUsageSensors = this;
        synchronized (threadUsageSensors) {
            this.networkThreadNonExemptUsageSensors().getAndMaybePut(listenerName, (Function0<Sensor> & Serializable)() -> this.createNetworkThreadUsageSensor(listenerName, NonExemptRequest$.MODULE$));
            this.networkThreadTotalUsageSensors().getAndMaybePut(listenerName, (Function0<Sensor> & Serializable)() -> this.createNetworkThreadUsageSensor(listenerName, AllRequests$.MODULE$));
        }
    }

    public void removeListenerMetrics(String listenerName) {
        ThreadUsageSensors threadUsageSensors = this;
        synchronized (threadUsageSensors) {
            Option$.MODULE$.apply(this.networkThreadNonExemptUsageSensors().get(listenerName)).foreach((Function1<Sensor, Object> & Serializable)sensor -> {
                ThreadUsageSensors.$anonfun$removeListenerMetrics$1(this, sensor);
                return BoxedUnit.UNIT;
            });
            this.networkThreadNonExemptUsageSensors().remove(listenerName);
            Option$.MODULE$.apply(this.networkThreadTotalUsageSensors().get(listenerName)).foreach((Function1<Sensor, Object> & Serializable)sensor -> {
                ThreadUsageSensors.$anonfun$removeListenerMetrics$2(this, sensor);
                return BoxedUnit.UNIT;
            });
            this.networkThreadTotalUsageSensors().remove(listenerName);
        }
    }

    public void close() {
        this.metrics().removeSensor(this.ioThreadTotalUsageSensor().name());
        this.metrics().removeSensor(this.ioThreadNonExemptUsageSensor().name());
        this.networkThreadNonExemptUsageSensors().values().foreach((Function1<Sensor, Object> & Serializable)sensor -> {
            ThreadUsageSensors.$anonfun$close$1(this, sensor);
            return BoxedUnit.UNIT;
        });
        this.networkThreadNonExemptUsageSensors().clear();
        this.networkThreadTotalUsageSensors().values().foreach((Function1<Sensor, Object> & Serializable)sensor -> {
            ThreadUsageSensors.$anonfun$close$2(this, sensor);
            return BoxedUnit.UNIT;
        });
        this.networkThreadTotalUsageSensors().clear();
    }

    private String threadUsageSensorName(ThreadType threadType, Map<String, String> metricTags, RequestType requestType) {
        String suffix = metricTags.isEmpty() ? "" : "-" + metricTags.values().mkString(":");
        String prefix = requestType.name();
        return prefix + "-" + threadType.name() + "-thread-usage-" + suffix;
    }

    private Sensor createNetworkThreadUsageSensor(String listenerName, RequestType requestType) {
        Map<String, String> metricTags = ThreadUsageMetrics$.MODULE$.listenerNetworkThreadUsageMetricTags(listenerName);
        String sensorName = this.threadUsageSensorName(NetworkThread$.MODULE$, metricTags, requestType);
        Sensor sensor = this.metrics().sensor(sensorName);
        sensor.add(ThreadUsageMetrics$.MODULE$.threadUsageMetricName(this.metrics(), NetworkThread$.MODULE$, metricTags, requestType), new Rate());
        return sensor;
    }

    private Sensor createIoThreadUsageSensor(RequestType requestType) {
        Map<String, String> metricTags = ThreadUsageMetrics$.MODULE$.ioThreadUsageMetricTags();
        String sensorName = this.threadUsageSensorName(IoThread$.MODULE$, metricTags, requestType);
        Sensor sensor = this.metrics().sensor(sensorName);
        sensor.add(ThreadUsageMetrics$.MODULE$.threadUsageMetricName(this.metrics(), IoThread$.MODULE$, metricTags, requestType), new Rate());
        return sensor;
    }

    public static final /* synthetic */ void $anonfun$removeListenerMetrics$1(ThreadUsageSensors $this, Sensor sensor) {
        $this.metrics().removeSensor(sensor.name());
    }

    public static final /* synthetic */ void $anonfun$removeListenerMetrics$2(ThreadUsageSensors $this, Sensor sensor) {
        $this.metrics().removeSensor(sensor.name());
    }

    public static final /* synthetic */ void $anonfun$close$1(ThreadUsageSensors $this, Sensor sensor) {
        $this.metrics().removeSensor(sensor.name());
    }

    public static final /* synthetic */ void $anonfun$close$2(ThreadUsageSensors $this, Sensor sensor) {
        $this.metrics().removeSensor(sensor.name());
    }

    public ThreadUsageSensors(Metrics metrics) {
        this.metrics = metrics;
        this.ioThreadNonExemptUsageSensor = this.createIoThreadUsageSensor(NonExemptRequest$.MODULE$);
        this.ioThreadTotalUsageSensor = this.createIoThreadUsageSensor(AllRequests$.MODULE$);
        this.networkThreadNonExemptUsageSensors = new Pool(Pool$.MODULE$.$lessinit$greater$default$1());
        this.networkThreadTotalUsageSensors = new Pool(Pool$.MODULE$.$lessinit$greater$default$1());
    }
}

