/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import kafka.server.BrokerBlockingSender;
import kafka.server.ClusterLinkQuotas;
import kafka.server.ClusterLinkReplicaQuotaAdapter;
import kafka.server.FailedPartitions;
import kafka.server.FetcherPool;
import kafka.server.FetcherPool$InSync$;
import kafka.server.KafkaConfig;
import kafka.server.PausedPartitions;
import kafka.server.ReplicaManager;
import kafka.server.ReplicaQuota;
import kafka.server.link.ClusterLinkAsyncLeaderEndPoint;
import kafka.server.link.ClusterLinkAsyncSender;
import kafka.server.link.ClusterLinkClientType$Fetcher$;
import kafka.server.link.ClusterLinkConfig;
import kafka.server.link.ClusterLinkConnectionManager;
import kafka.server.link.ClusterLinkFactory$;
import kafka.server.link.ClusterLinkFetchResponseAllocator;
import kafka.server.link.ClusterLinkFetcherManager;
import kafka.server.link.ClusterLinkFetcherThread;
import kafka.server.link.ClusterLinkFetcherWithSharedThread;
import kafka.server.link.ClusterLinkLeaderEndPoint;
import kafka.server.link.ClusterLinkLeaderEndPoint$;
import kafka.server.link.ClusterLinkMetadata;
import kafka.server.link.ClusterLinkMetrics;
import kafka.server.link.ClusterLinkMetrics$;
import kafka.server.link.ClusterLinkNetworkClient;
import kafka.server.link.ClusterLinkSelectorMetricsRegistry;
import kafka.server.link.ClusterLinkSharedFetcherThread;
import org.apache.kafka.clients.ManualMetadataUpdater;
import org.apache.kafka.clients.MetadataUpdater;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.common.MetadataVersion;
import org.apache.kafka.server.network.BrokerEndPoint;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.mutable.Map$;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;

public final class ClusterLinkFetcherThread$ {
    public static final ClusterLinkFetcherThread$ MODULE$ = new ClusterLinkFetcherThread$();
    private static final String mirrorTopicMessageRateMetricName = "mirror-topic-message-rate-per-second";
    private static final String mirrorTopicMessageRateMetricDescription = "Rate of messages being written to the mirror topic per second";
    private static final String mirrorTopicRpoMetricName = "mirror-topic-rpo-seconds";
    private static final String mirrorTopicRpoMetricDescription = "RPO for mirror topic in seconds";

    public Option<LogContext> $lessinit$greater$default$18() {
        return None$.MODULE$;
    }

    public String mirrorTopicMessageRateMetricName() {
        return mirrorTopicMessageRateMetricName;
    }

    public String mirrorTopicMessageRateMetricDescription() {
        return mirrorTopicMessageRateMetricDescription;
    }

    public String mirrorTopicRpoMetricName() {
        return mirrorTopicRpoMetricName;
    }

    public String mirrorTopicRpoMetricDescription() {
        return mirrorTopicRpoMetricDescription;
    }

    public ClusterLinkFetcherThread apply(String name, int fetcherId, FetcherPool fetcherPool, KafkaConfig brokerConfig, ClusterLinkConfig clusterLinkConfig, ClusterLinkMetadata clusterLinkMetadata, ClusterLinkFetcherManager fetcherManager, ClusterLinkConnectionManager connectionManager, BrokerEndPoint sourceBroker, FailedPartitions failedPartitions, PausedPartitions pausedPartitions, ReplicaManager replicaMgr, ReplicaQuota quota, ClusterLinkMetrics clusterLinkMetrics, ClusterLinkSelectorMetricsRegistry selectorMetricsRegistry, Time time, Option<String> tenant, ClusterLinkFetchResponseAllocator fetchResponseAllocator, Function0<MetadataVersion> metadataVersionSupplier) {
        int brokerId = brokerConfig.brokerId();
        LogContext logContext = new LogContext("[ClusterLinkFetcher brokerId=" + brokerId + " fetcherId=" + fetcherId + " fetcherPool=" + fetcherPool.name() + " source(link=" + clusterLinkMetadata.linkName() + ", leaderId=" + sourceBroker.id() + ")] ", connectionManager.maxLogLevel());
        scala.collection.mutable.Map extraMetricTags = (scala.collection.mutable.Map)Map$.MODULE$.apply(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("broker-id"), Integer.toString(sourceBroker.id())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("fetcher-id"), Integer.toString(fetcherId))}));
        FetcherPool fetcherPool2 = fetcherPool;
        FetcherPool$InSync$ fetcherPool$InSync$ = FetcherPool$InSync$.MODULE$;
        Object object = !(fetcherPool2 != null ? !fetcherPool2.equals(fetcherPool$InSync$) : fetcherPool$InSync$ != null) ? extraMetricTags.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("fetcher-pool"), fetcherPool.name())) : BoxedUnit.UNIT;
        ClusterLinkNetworkClient clusterLinkClient = new ClusterLinkNetworkClient(brokerConfig, clusterLinkConfig, ClusterLinkMetrics$.MODULE$.throttleTimeSensorName(clusterLinkMetadata.linkName()), None$.MODULE$, new Some<MetadataUpdater>(new ManualMetadataUpdater()), clusterLinkMetrics.metrics(), selectorMetricsRegistry, (Map)ClusterLinkFactory$.MODULE$.linkMetricTags(clusterLinkMetadata.linkName()).$plus$plus(extraMetricTags), time, "link-" + clusterLinkMetadata.linkName() + "-broker-" + brokerId + "-fetcher-" + fetcherId + "-pool-" + fetcherPool.name(), ClusterLinkClientType$Fetcher$.MODULE$, fetcherManager.clusterLinkChannelContext(), logContext, connectionManager.maxLogLevel());
        connectionManager.enableClusterLink(clusterLinkClient, None$.MODULE$);
        BrokerBlockingSender blockingSender = new BrokerBlockingSender(sourceBroker, brokerConfig, Predef$.MODULE$.Integer2int(clusterLinkConfig.replicaSocketTimeoutMs()), time, fetcherId, clusterLinkClient.networkClient(), None$.MODULE$);
        ClusterLinkLeaderEndPoint leader = ClusterLinkLeaderEndPoint$.MODULE$.apply(logContext, time, blockingSender, clusterLinkClient, brokerConfig, clusterLinkConfig, fetcherManager, replicaMgr, quota, clusterLinkMetrics);
        return new ClusterLinkFetcherThread(name, fetcherId, fetcherPool, leader, brokerConfig, clusterLinkConfig, clusterLinkMetadata, fetcherManager, failedPartitions, pausedPartitions, clusterLinkConfig.replicaFetchBackoff(), replicaMgr, quota, clusterLinkMetrics, time, fetchResponseAllocator, clusterLinkClient, new Some<LogContext>(logContext), tenant, metadataVersionSupplier);
    }

    public ClusterLinkFetcherWithSharedThread createFetcherWithSharedThread(String name, int fetcherId, FetcherPool fetcherPool, Uuid linkId, ClusterLinkSharedFetcherThread sharedThread, KafkaConfig brokerConfig, ClusterLinkConfig clusterLinkConfig, ClusterLinkMetadata clusterLinkMetadata, ClusterLinkFetcherManager fetcherManager, ClusterLinkConnectionManager connectionManager, BrokerEndPoint sourceBroker, FailedPartitions failedPartitions, PausedPartitions pausedPartitions, ReplicaManager replicaMgr, ClusterLinkQuotas quotas, ClusterLinkMetrics clusterLinkMetrics, Time time, Option<String> tenant, ClusterLinkFetchResponseAllocator fetchResponseAllocator, Function0<MetadataVersion> metadataVersionSupplier) {
        int brokerId = brokerConfig.brokerId();
        LogContext logContext = new LogContext("[ClusterLinkFetcher brokerId=" + brokerId + " fetcherId=" + fetcherId + " fetcherPool=" + fetcherPool.name() + " source(link=" + clusterLinkMetadata.linkName() + ", leaderId=" + sourceBroker.id() + ")] ", connectionManager.maxLogLevel());
        ClusterLinkNetworkClient clusterLinkClient = sharedThread.clusterLinkClient();
        ClusterLinkAsyncSender sender = new ClusterLinkAsyncSender(sourceBroker, brokerConfig, Predef$.MODULE$.Integer2int(clusterLinkConfig.replicaSocketTimeoutMs()), Predef$.MODULE$.Integer2int(clusterLinkConfig.requestTimeoutMs()), time, quotas.requestQuotaAdapter(clusterLinkMetadata.linkName(), tenant), fetcherId, fetcherPool, clusterLinkClient.networkClient());
        ClusterLinkReplicaQuotaAdapter quota = new ClusterLinkReplicaQuotaAdapter(quotas, clusterLinkMetrics, tenant, clusterLinkMetadata.linkName());
        ClusterLinkAsyncLeaderEndPoint leader = ClusterLinkLeaderEndPoint$.MODULE$.createAsyncLeaderEndpoint(logContext, time, sender, clusterLinkClient, brokerConfig, clusterLinkConfig, fetcherManager, replicaMgr, quota, clusterLinkMetrics);
        ClusterLinkFetcherWithSharedThread fetcher = new ClusterLinkFetcherWithSharedThread(name, linkId, fetcherId, fetcherPool, name, sourceBroker, sharedThread, sender, leader, brokerConfig, clusterLinkConfig, clusterLinkMetadata, fetcherManager, failedPartitions, pausedPartitions, clusterLinkConfig.replicaFetchBackoff(), replicaMgr, quota, clusterLinkMetrics, time, fetchResponseAllocator, clusterLinkClient, logContext, tenant, metadataVersionSupplier);
        sharedThread.addFetcher(sourceBroker.id(), fetcher);
        return fetcher;
    }

    private ClusterLinkFetcherThread$() {
    }
}

