/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.metadata;

import com.typesafe.scalalogging.Logger;
import io.confluent.k2.kafka.K2Stack;
import io.confluent.k2.kafka.affinity.AffinitySelector;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import kafka.server.CachedControllerId;
import kafka.server.link.ClusterLinkTopicState;
import kafka.server.metadata.ConfigRepository;
import kafka.server.metadata.K2MetadataCache;
import kafka.server.metadata.K2MetadataCache$;
import kafka.server.metadata.KRaftImageMetadataCache;
import kafka.server.metadata.KRaftMetadataCache;
import kafka.utils.Logging;
import org.apache.kafka.admin.BrokerMetadata;
import org.apache.kafka.clients.admin.BrokerComponent;
import org.apache.kafka.common.Cluster;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.TopicType;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.message.DescribeClientQuotasRequestData;
import org.apache.kafka.common.message.DescribeClientQuotasResponseData;
import org.apache.kafka.common.message.DescribeTopicPartitionsResponseData;
import org.apache.kafka.common.message.DescribeUserScramCredentialsRequestData;
import org.apache.kafka.common.message.DescribeUserScramCredentialsResponseData;
import org.apache.kafka.common.message.MetadataResponseData;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.requests.RequestContext;
import org.apache.kafka.image.MetadataImage;
import org.apache.kafka.metadata.LeaderAndIsr;
import org.apache.kafka.server.common.FinalizedFeatures;
import org.apache.kafka.server.common.MetadataVersion;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Set;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\rme\u0001\u0002\u001b6\u0001qB\u0001b\u0012\u0001\u0003\u0006\u0004%\t\u0001\u0013\u0005\t\u0019\u0002\u0011\t\u0011)A\u0005\u0013\"AQ\n\u0001BC\u0002\u0013\u0005a\n\u0003\u0005S\u0001\t\u0005\t\u0015!\u0003P\u0011\u0015\u0019\u0006\u0001\"\u0001U\u0011\u001dA\u0006A1A\u0005\u0002eCa!\u0018\u0001!\u0002\u0013Q\u0006\"\u00020\u0001\t\u0003z\u0006\"B2\u0001\t\u0003\"\u0007\"\u00029\u0001\t\u0003\n\b\"CA*\u0001E\u0005I\u0011AA+\u0011%\tY\u0007AI\u0001\n\u0003\t)\u0006C\u0004\u0002n\u0001!\t%a\u001c\t\u000f\u0005m\u0004\u0001\"\u0011\u0002~!9\u0011Q\u0012\u0001\u0005B\u0005=\u0005bBAM\u0001\u0011\u0005\u00131\u0014\u0005\b\u0003C\u0003A\u0011IAR\u0011\u001d\ty\u000b\u0001C!\u0003cCq!!.\u0001\t\u0003\n9\fC\u0004\u0002X\u0002!\t%!7\t\u000f\u0005\u001d\b\u0001\"\u0011\u0002j\"9\u0011Q\u001e\u0001\u0005B\u0005=\bbBA{\u0001\u0011\u0005\u0013q\u001f\u0005\b\u0003w\u0004A\u0011IA\u007f\u0011\u001d\u0011\t\u0002\u0001C!\u0005'AqA!\u0007\u0001\t\u0003\u0012Y\u0002C\u0004\u0003.\u0001!\tEa\f\t\u000f\tM\u0002\u0001\"\u0011\u00036!9!Q\b\u0001\u0005\u0002\t}\u0002b\u0002B\u001f\u0001\u0011\u0005!1\t\u0005\b\u0005\u000f\u0002A\u0011\u0001B%\u0011\u001d\u00119\u0005\u0001C\u0001\u0005\u001bBqA!\u0015\u0001\t\u0003\u0012\u0019\u0006C\u0004\u0003\\\u0001!\tE!\u0018\t\u000f\t%\u0004\u0001\"\u0011\u0003l!9!q\u000f\u0001\u0005B\te\u0004b\u0002B>\u0001\u0011\u0005#Q\u0010\u0005\b\u0005\u0017\u0003A\u0011\tBG\u0011\u001d\u0011Y\t\u0001C!\u0005#CqA!&\u0001\t\u0003\u00129\nC\u0004\u0003$\u0002!\tE!*\t\u000f\tm\u0006\u0001\"\u0011\u0003>\"9!1\u001a\u0001\u0005B\t5\u0007b\u0002Bk\u0001\u0011\u0005#q\u001b\u0005\b\u00057\u0004A\u0011\tBo\u0011\u001d\u0011\u0019\u0010\u0001C!\u0005kDqa!\u0003\u0001\t\u0003\u0019Y\u0001\u0003\u0004\u0004N\u0001!\t%\u0017\u0005\b\u0007\u001f\u0002A\u0011IB)\u0011\u001d\u0019\u0019\u0007\u0001C!\u0007KBqa!\u001e\u0001\t\u0003\u001a9H\u0001\u000bLe-\u0013\u0016M\u001a;NKR\fG-\u0019;b\u0007\u0006\u001c\u0007.\u001a\u0006\u0003m]\n\u0001\"\\3uC\u0012\fG/\u0019\u0006\u0003qe\naa]3sm\u0016\u0014(\"\u0001\u001e\u0002\u000b-\fgm[1\u0004\u0001M\u0019\u0001!P\"\u0011\u0005y\nU\"A \u000b\u0003\u0001\u000bQa]2bY\u0006L!AQ \u0003\r\u0005s\u0017PU3g!\t!U)D\u00016\u0013\t1UGA\fL%\u00064G/S7bO\u0016lU\r^1eCR\f7)Y2iK\u0006Q1N]1gi\u000e\u000b7\r[3\u0016\u0003%\u0003\"\u0001\u0012&\n\u0005-+$AE&SC\u001a$X*\u001a;bI\u0006$\u0018mQ1dQ\u0016\f1b\u001b:bMR\u001c\u0015m\u00195fA\u000591NM\"bG\",W#A(\u0011\u0005\u0011\u0003\u0016BA)6\u0005=Y%'T3uC\u0012\fG/Y\"bG\",\u0017\u0001C63\u0007\u0006\u001c\u0007.\u001a\u0011\u0002\rqJg.\u001b;?)\r)fk\u0016\t\u0003\t\u0002AQaR\u0003A\u0002%CQ!T\u0003A\u0002=\u000bqD^1mS\u0012\fG/Z#yG2,8/\u001b<jif\f5M]8tg\u000e\u000b7\r[3t+\u0005Q\u0006C\u0001 \\\u0013\tavHA\u0004C_>dW-\u00198\u0002AY\fG.\u001b3bi\u0016,\u0005p\u00197vg&4\u0018\u000e^=BGJ|7o]\"bG\",7\u000fI\u0001\tEJ|7.\u001a:JIV\t\u0001\r\u0005\u0002?C&\u0011!m\u0010\u0002\u0004\u0013:$\u0018\u0001D2veJ,g\u000e^%nC\u001e,G#A3\u0011\u0005\u0019tW\"A4\u000b\u0005!L\u0017!B5nC\u001e,'B\u0001\u001ek\u0015\tYG.\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002[\u0006\u0019qN]4\n\u0005=<'!D'fi\u0006$\u0017\r^1J[\u0006<W-\u0001\thKR$v\u000e]5d\u001b\u0016$\u0018\rZ1uCRI!/!\t\u0002<\u0005-\u0013q\n\t\u0004gZDX\"\u0001;\u000b\u0005U|\u0014AC2pY2,7\r^5p]&\u0011q\u000f\u001e\u0002\u0004'\u0016\f\bcA=\u0002\u001c9\u0019!0!\u0006\u000f\u0007m\fyAD\u0002}\u0003\u0017q1!`A\u0005\u001d\rq\u0018q\u0001\b\u0004\u007f\u0006\u0015QBAA\u0001\u0015\r\t\u0019aO\u0001\u0007yI|w\u000e\u001e \n\u00035L!a\u001b7\n\u0005iR\u0017bAA\u0007S\u000611m\\7n_:LA!!\u0005\u0002\u0014\u00059Q.Z:tC\u001e,'bAA\u0007S&!\u0011qCA\r\u0003QiU\r^1eCR\f'+Z:q_:\u001cX\rR1uC*!\u0011\u0011CA\n\u0013\u0011\ti\"a\b\u0003+5+G/\u00193bi\u0006\u0014Vm\u001d9p]N,Gk\u001c9jG*!\u0011qCA\r\u0011\u001d\t\u0019C\u0003a\u0001\u0003K\ta\u0001^8qS\u000e\u001c\b#B:\u0002(\u0005-\u0012bAA\u0015i\n\u00191+\u001a;\u0011\t\u00055\u0012Q\u0007\b\u0005\u0003_\t\t\u0004\u0005\u0002\u0000\u007f%\u0019\u00111G \u0002\rA\u0013X\rZ3g\u0013\u0011\t9$!\u000f\u0003\rM#(/\u001b8h\u0015\r\t\u0019d\u0010\u0005\b\u0003{Q\u0001\u0019AA \u00031a\u0017n\u001d;f]\u0016\u0014h*Y7f!\u0011\t\t%a\u0012\u000e\u0005\u0005\r#\u0002BA#\u0003'\tqA\\3uo>\u00148.\u0003\u0003\u0002J\u0005\r#\u0001\u0004'jgR,g.\u001a:OC6,\u0007\u0002CA'\u0015A\u0005\t\u0019\u0001.\u00023\u0015\u0014(o\u001c:V]\u00064\u0018-\u001b7bE2,WI\u001c3q_&tGo\u001d\u0005\t\u0003#R\u0001\u0013!a\u00015\u0006IRM\u001d:peVs\u0017M^1jY\u0006\u0014G.\u001a'jgR,g.\u001a:t\u0003i9W\r\u001e+pa&\u001cW*\u001a;bI\u0006$\u0018\r\n3fM\u0006,H\u000e\u001e\u00134+\t\t9FK\u0002[\u00033Z#!a\u0017\u0011\t\u0005u\u0013qM\u0007\u0003\u0003?RA!!\u0019\u0002d\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003Kz\u0014AC1o]>$\u0018\r^5p]&!\u0011\u0011NA0\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u001bO\u0016$Hk\u001c9jG6+G/\u00193bi\u0006$C-\u001a4bk2$H\u0005N\u0001\rO\u0016$\u0018\t\u001c7U_BL7m\u001d\u000b\u0005\u0003K\t\t\bC\u0004\u0002t5\u0001\r!!\u001e\u0002\u001fQ,g.\u00198u!J,g-\u001b=PaR\u0004RAPA<\u0003WI1!!\u001f@\u0005\u0019y\u0005\u000f^5p]\u0006\u0011r-\u001a;U_BL7\rU1si&$\u0018n\u001c8t)\u0011\ty(!#\u0011\u000bM\f9#!!\u0011\t\u0005\r\u0015QQ\u0007\u0003\u0003'IA!a\"\u0002\u0014\tqAk\u001c9jGB\u000b'\u000f^5uS>t\u0007bBAF\u001d\u0001\u0007\u00111F\u0001\ni>\u0004\u0018n\u0019(b[\u0016\f!bZ3u)>\u0004\u0018nY%e)\u0011\t\t*a&\u0011\t\u0005\r\u00151S\u0005\u0005\u0003+\u000b\u0019B\u0001\u0003Vk&$\u0007bBAF\u001f\u0001\u0007\u00111F\u0001\rO\u0016$Hk\u001c9jG:\u000bW.\u001a\u000b\u0005\u0003k\ni\nC\u0004\u0002 B\u0001\r!!%\u0002\u000fQ|\u0007/[2JI\u0006aq-\u001a;U_BL7\rV=qKR!\u0011QUAW!\u0015q\u0014qOAT!\u0011\t\u0019)!+\n\t\u0005-\u00161\u0003\u0002\n)>\u0004\u0018n\u0019+za\u0016Dq!a#\u0012\u0001\u0004\tY#\u0001\biCN\fE.\u001b<f\u0005J|7.\u001a:\u0015\u0007i\u000b\u0019\fC\u0003_%\u0001\u0007\u0001-A\bhKR\fE.\u001b<f\u0005J|7.\u001a:t)\t\tI\f\u0005\u0004\u0002<\u0006\u0015\u00171\u001a\b\u0005\u0003{\u000b\tMD\u0002\u0000\u0003\u007fK\u0011\u0001Q\u0005\u0004\u0003\u0007|\u0014a\u00029bG.\fw-Z\u0005\u0005\u0003\u000f\fIM\u0001\u0005Ji\u0016\u0014\u0018M\u00197f\u0015\r\t\u0019m\u0010\t\u0005\u0003\u001b\f\u0019.\u0004\u0002\u0002P*\u0019\u0011\u0011[5\u0002\u000b\u0005$W.\u001b8\n\t\u0005U\u0017q\u001a\u0002\u000f\u0005J|7.\u001a:NKR\fG-\u0019;b\u0003I9W\r^!mSZ,'I]8lKJtu\u000eZ3\u0015\r\u0005m\u00171]As!\u0015q\u0014qOAo!\u0011\t\u0019)a8\n\t\u0005\u0005\u00181\u0003\u0002\u0005\u001d>$W\rC\u0003_)\u0001\u0007\u0001\rC\u0004\u0002>Q\u0001\r!a\u0010\u0002\u001f\u001d,GO\u0011:pW\u0016\u00148)\u001a7m\u0013\u0012$2\u0001YAv\u0011\u0015qV\u00031\u0001a\u0003M9W\r^!mSZ,'I]8lKJtu\u000eZ3t)\u0011\t\t0a=\u0011\tM4\u0018Q\u001c\u0005\b\u0003{1\u0002\u0019AA \u000399W\r\u001e\"s_.,'OT8eKN$B!!=\u0002z\"9\u0011QH\fA\u0002\u0005}\u0012aD4fi2+\u0017\rZ3s\u0003:$\u0017j\u001d:\u0015\r\u0005}(1\u0002B\u0007!\u0015q\u0014q\u000fB\u0001!\u0011\u0011\u0019Aa\u0002\u000e\u0005\t\u0015!B\u0001\u001cj\u0013\u0011\u0011IA!\u0002\u0003\u00191+\u0017\rZ3s\u0003:$\u0017j\u001d:\t\u000f\u0005-\u0005\u00041\u0001\u0002,!1!q\u0002\rA\u0002\u0001\f1\u0002]1si&$\u0018n\u001c8JI\u0006ia.^7QCJ$\u0018\u000e^5p]N$BA!\u0006\u0003\u0018A!a(a\u001ea\u0011\u001d\tY)\u0007a\u0001\u0003W\tq\u0002^8qS\u000et\u0015-\\3t)>LEm\u001d\u000b\u0003\u0005;\u0001\u0002Ba\b\u0003*\u0005-\u0012\u0011S\u0007\u0003\u0005CQAAa\t\u0003&\u0005!Q\u000f^5m\u0015\t\u00119#\u0001\u0003kCZ\f\u0017\u0002\u0002B\u0016\u0005C\u00111!T1q\u0003=!x\u000e]5d\u0013\u0012\u001cHk\u001c(b[\u0016\u001cHC\u0001B\u0019!!\u0011yB!\u000b\u0002\u0012\u0006-\u0012a\u0003;pa&\u001c\u0017\nZ%oM>$\"Aa\u000e\u0011\u000fy\u0012ID!\b\u00032%\u0019!1H \u0003\rQ+\b\u000f\\33\u0003%I7o\u0013\u001aU_BL7\rF\u0002[\u0005\u0003Bq!a#\u001e\u0001\u0004\tY\u0003F\u0002[\u0005\u000bBq!a(\u001f\u0001\u0004\t\t*\u0001\u0007jg.\u0013\u0016M\u001a;U_BL7\rF\u0002[\u0005\u0017Bq!a( \u0001\u0004\t\t\nF\u0002[\u0005\u001fBq!a#!\u0001\u0004\tY#\u0001\u000ehKR\u0004\u0016M\u001d;ji&|g\u000eT3bI\u0016\u0014XI\u001c3q_&tG\u000f\u0006\u0005\u0002\\\nU#q\u000bB-\u0011\u001d\tY)\ta\u0001\u0003WAaAa\u0004\"\u0001\u0004\u0001\u0007bBA\u001fC\u0001\u0007\u0011qH\u0001\u001dO\u0016$\b+\u0019:uSRLwN\u001c*fa2L7-Y#oIB|\u0017N\u001c;t)\u0019\u0011yFa\u0019\u0003hA11O!\u0019a\u0003;L1Aa\u000bu\u0011\u001d\u0011)G\ta\u0001\u0003\u0003\u000b!\u0001\u001e9\t\u000f\u0005u\"\u00051\u0001\u0002@\u0005yq-\u001a;D_:$(o\u001c7mKJLE-\u0006\u0002\u0003nA)a(a\u001e\u0003pA!!\u0011\u000fB:\u001b\u00059\u0014b\u0001B;o\t\u00112)Y2iK\u0012\u001cuN\u001c;s_2dWM]%e\u0003Y9W\r\u001e*b]\u0012|W.\u00117jm\u0016\u0014%o\\6fe&#WC\u0001B\u000b\u0003I9W\r^\"mkN$XM]'fi\u0006$\u0017\r^1\u0015\r\t}$Q\u0011BE!\u0011\t\u0019I!!\n\t\t\r\u00151\u0003\u0002\b\u00072,8\u000f^3s\u0011\u001d\u00119)\na\u0001\u0003W\t\u0011b\u00197vgR,'/\u00133\t\u000f\u0005uR\u00051\u0001\u0002@\u0005A1m\u001c8uC&t7\u000fF\u0002[\u0005\u001fCq!a#'\u0001\u0004\tY\u0003F\u0002[\u0005'CqA!\u001a(\u0001\u0004\t\t)\u0001\u0005tKRLU.Y4f)\u0011\u0011IJa(\u0011\u0007y\u0012Y*C\u0002\u0003\u001e~\u0012A!\u00168ji\"1!\u0011\u0015\u0015A\u0002\u0015\f\u0001B\\3x\u00136\fw-Z\u0001\u0007G>tg-[4\u0015\t\t\u001d&Q\u0016\t\u0005\u0005?\u0011I+\u0003\u0003\u0003,\n\u0005\"A\u0003)s_B,'\u000f^5fg\"9!qV\u0015A\u0002\tE\u0016AD2p]\u001aLwMU3t_V\u00148-\u001a\t\u0005\u0005g\u00139,\u0004\u0002\u00036*!!1UA\n\u0013\u0011\u0011IL!.\u0003\u001d\r{gNZ5h%\u0016\u001cx.\u001e:dK\u0006yQ.\u001a;bI\u0006$\u0018MV3sg&|g\u000e\u0006\u0002\u0003@B!!\u0011\u0019Bd\u001b\t\u0011\u0019M\u0003\u0003\u0002\u000e\t\u0015'B\u0001\u001dj\u0013\u0011\u0011IMa1\u0003\u001f5+G/\u00193bi\u00064VM]:j_:\f\u0001BZ3biV\u0014Xm\u001d\u000b\u0003\u0005\u001f\u0004BA!1\u0003R&!!1\u001bBb\u0005E1\u0015N\\1mSj,GMR3biV\u0014Xm]\u0001\u0011SN\u0014%o\\6fe\u0012+wM]1eK\u0012$2A\u0017Bm\u0011\u0015qF\u00061\u0001a\u0003eI7O\u0011:pW\u0016\u00148i\\7q_:,g\u000e\u001e#fOJ\fG-\u001a3\u0015\u000bi\u0013yN!9\t\u000byk\u0003\u0019\u00011\t\u000f\t\rX\u00061\u0001\u0003f\u0006I1m\\7q_:,g\u000e\u001e\t\u0005\u0005O\u0014y/\u0004\u0002\u0003j*!\u0011\u0011\u001bBv\u0015\r\u0011i/[\u0001\bG2LWM\u001c;t\u0013\u0011\u0011\tP!;\u0003\u001f\t\u0013xn[3s\u0007>l\u0007o\u001c8f]R\f\u0001#\\5se>\u0014Hk\u001c9jGN#\u0018\r^3\u0015\t\t]8Q\u0001\t\u0006}\u0005]$\u0011 \t\u0005\u0005w\u001c\t!\u0004\u0002\u0003~*\u0019!q`\u001c\u0002\t1Lgn[\u0005\u0005\u0007\u0007\u0011iPA\u000bDYV\u001cH/\u001a:MS:\\Gk\u001c9jGN#\u0018\r^3\t\u000f\r\u001da\u00061\u0001\u0002,\u0005)Ao\u001c9jG\u0006q\u0012\r\u001a6vgR$v\u000e]5d\u001b\u0016$\u0018\rZ1uC\u001a{'/\u00114gS:LG/\u001f\u000b\t\u0007\u001b\u0019yb!\u000f\u0004JA11qBB\u000b\u00073i!a!\u0005\u000b\t\rM!\u0011E\u0001\u000bG>t7-\u001e:sK:$\u0018\u0002BB\f\u0007#\u0011\u0011cQ8na2,G/\u00192mK\u001a+H/\u001e:f!\u0011\u0019Y\"a\u0007\u000f\t\ru\u0011QC\u0007\u0003\u00033Aqa!\t0\u0001\u0004\u0019\u0019#A\u0004leM#\u0018mY6\u0011\t\r\u00152QG\u0007\u0003\u0007OQ1AOB\u0015\u0015\u0011\u0019Yc!\f\u0002\u0005-\u0014$\u0002BB\u0018\u0007c\t\u0011bY8oM2,XM\u001c;\u000b\u0005\rM\u0012AA5p\u0013\u0011\u00199da\n\u0003\u000f-\u00134\u000b^1dW\"911H\u0018A\u0002\ru\u0012A\u0004:fcV,7\u000f^\"p]R,\u0007\u0010\u001e\t\u0005\u0007\u007f\u0019)%\u0004\u0002\u0004B)!11IA\n\u0003!\u0011X-];fgR\u001c\u0018\u0002BB$\u0007\u0003\u0012aBU3rk\u0016\u001cHoQ8oi\u0016DH\u000fC\u0004\u0004L=\u0002\ra!\u0007\u0002\u001bQ|\u0007/[2NKR\fG-\u0019;b\u0003Ya\u0017N\\6D_>\u0014H-\u001b8bi>\u0014XI\\1cY\u0016$\u0017\u0001\u00063fg\u000e\u0014\u0018NY3DY&,g\u000e^)v_R\f7\u000f\u0006\u0003\u0004T\re\u0003\u0003BB\u000f\u0007+JAaa\u0016\u0002\u001a\t\u0001C)Z:de&\u0014Wm\u00117jK:$\u0018+^8uCN\u0014Vm\u001d9p]N,G)\u0019;b\u0011\u001d\u0019Y&\ra\u0001\u0007;\nqA]3rk\u0016\u001cH\u000f\u0005\u0003\u0004\u001e\r}\u0013\u0002BB1\u00033\u0011q\u0004R3tGJL'-Z\"mS\u0016tG/U;pi\u0006\u001c(+Z9vKN$H)\u0019;b\u0003a!Wm]2sS\n,7k\u0019:b[\u000e\u0013X\rZ3oi&\fGn\u001d\u000b\u0005\u0007O\u001ai\u0007\u0005\u0003\u0004\u001e\r%\u0014\u0002BB6\u00033\u0011\u0001\u0006R3tGJL'-Z+tKJ\u001c6M]1n\u0007J,G-\u001a8uS\u0006d7OU3ta>t7/\u001a#bi\u0006Dqaa\u00173\u0001\u0004\u0019y\u0007\u0005\u0003\u0004\u001e\rE\u0014\u0002BB:\u00033\u0011q\u0005R3tGJL'-Z+tKJ\u001c6M]1n\u0007J,G-\u001a8uS\u0006d7OU3rk\u0016\u001cH\u000fR1uC\u0006As-\u001a;U_BL7-T3uC\u0012\fG/\u0019$pe\u0012+7o\u0019:jE\u0016$v\u000e]5d%\u0016\u001c\bo\u001c8tKRa1\u0011PB@\u0007\u000f\u001bIia%\u0004\u0018B!1QDB>\u0013\u0011\u0019i(!\u0007\u0003G\u0011+7o\u0019:jE\u0016$v\u000e]5d!\u0006\u0014H/\u001b;j_:\u001c(+Z:q_:\u001cX\rR1uC\"9\u00111E\u001aA\u0002\r\u0005\u0005CBA^\u0007\u0007\u000bY#\u0003\u0003\u0004\u0006\u0006%'\u0001C%uKJ\fGo\u001c:\t\u000f\u0005u2\u00071\u0001\u0002@!911R\u001aA\u0002\r5\u0015\u0001\u0007;pa&\u001c\u0007+\u0019:uSRLwN\\*uCJ$\u0018J\u001c3fqB1aha$\u0002,\u0001L1a!%@\u0005%1UO\\2uS>t\u0017\u0007\u0003\u0004\u0004\u0016N\u0002\r\u0001Y\u0001\u001a[\u0006D\u0018.\\;n\u001dVl'-\u001a:PMB\u000b'\u000f^5uS>t7\u000f\u0003\u0004\u0004\u001aN\u0002\rAW\u0001\u001bS\u001etwN]3U_BL7m],ji\",\u0005pY3qi&|gn\u001d")
public class K2KRaftMetadataCache
implements KRaftImageMetadataCache {
    private final KRaftMetadataCache kraftCache;
    private final K2MetadataCache k2Cache;
    private final boolean validateExclusivityAcrossCaches;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public Properties topicConfig(String topicName) {
        return ConfigRepository.topicConfig$(this, topicName);
    }

    @Override
    public Properties brokerConfig(int brokerId) {
        return ConfigRepository.brokerConfig$(this, brokerId);
    }

    @Override
    public Properties groupConfig(String groupName) {
        return ConfigRepository.groupConfig$(this, groupName);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        K2KRaftMetadataCache k2KRaftMetadataCache = this;
        synchronized (k2KRaftMetadataCache) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public KRaftMetadataCache kraftCache() {
        return this.kraftCache;
    }

    public K2MetadataCache k2Cache() {
        return this.k2Cache;
    }

    public boolean validateExclusivityAcrossCaches() {
        return this.validateExclusivityAcrossCaches;
    }

    @Override
    public int brokerId() {
        return this.kraftCache().brokerId();
    }

    @Override
    public MetadataImage currentImage() {
        return this.kraftCache().currentImage();
    }

    @Override
    public Seq<MetadataResponseData.MetadataResponseTopic> getTopicMetadata(Set<String> topics, ListenerName listenerName, boolean errorUnavailableEndpoints, boolean errorUnavailableListeners) {
        return (Seq)this.kraftCache().getTopicMetadata(topics, listenerName, errorUnavailableEndpoints, errorUnavailableListeners).$plus$plus(this.k2Cache().getTopicMetadata(topics, listenerName, errorUnavailableEndpoints, errorUnavailableListeners));
    }

    @Override
    public boolean getTopicMetadata$default$3() {
        return false;
    }

    @Override
    public boolean getTopicMetadata$default$4() {
        return false;
    }

    @Override
    public Set<String> getAllTopics(Option<String> tenantPrefixOpt) {
        return (Set)this.kraftCache().getAllTopics(tenantPrefixOpt).$plus$plus(this.k2Cache().getAllTopics(tenantPrefixOpt));
    }

    @Override
    public Set<TopicPartition> getTopicPartitions(String topicName) {
        return (Set)this.kraftCache().getTopicPartitions(topicName).$plus$plus(this.k2Cache().getTopicPartitions(topicName));
    }

    @Override
    public Uuid getTopicId(String topicName) {
        Uuid id = this.k2Cache().getTopicId(topicName);
        if (id.equals(Uuid.ZERO_UUID)) {
            return this.kraftCache().getTopicId(topicName);
        }
        return id;
    }

    @Override
    public Option<String> getTopicName(Uuid topicId) {
        return this.kraftCache().getTopicName(topicId).orElse((Function0<Option> & Serializable)() -> this.k2Cache().getTopicName(topicId));
    }

    @Override
    public Option<TopicType> getTopicType(String topicName) {
        return this.kraftCache().getTopicType(topicName).orElse((Function0<Option> & Serializable)() -> this.k2Cache().getTopicType(topicName));
    }

    @Override
    public boolean hasAliveBroker(int brokerId) {
        return this.kraftCache().hasAliveBroker(brokerId);
    }

    @Override
    public Iterable<BrokerMetadata> getAliveBrokers() {
        return this.kraftCache().getAliveBrokers();
    }

    @Override
    public Option<Node> getAliveBrokerNode(int brokerId, ListenerName listenerName) {
        return this.kraftCache().getAliveBrokerNode(brokerId, listenerName);
    }

    @Override
    public int getBrokerCellId(int brokerId) {
        return this.kraftCache().getBrokerCellId(brokerId);
    }

    public Seq<Node> getAliveBrokerNodes(ListenerName listenerName) {
        return this.kraftCache().getAliveBrokerNodes(listenerName);
    }

    public Seq<Node> getBrokerNodes(ListenerName listenerName) {
        return this.kraftCache().getBrokerNodes(listenerName);
    }

    @Override
    public Option<LeaderAndIsr> getLeaderAndIsr(String topicName, int partitionId) {
        return this.kraftCache().getLeaderAndIsr(topicName, partitionId).orElse((Function0<Option> & Serializable)() -> this.k2Cache().getLeaderAndIsr(topicName, partitionId));
    }

    @Override
    public Option<Object> numPartitions(String topicName) {
        return this.kraftCache().numPartitions(topicName).orElse((Function0<Option> & Serializable)() -> this.k2Cache().numPartitions(topicName));
    }

    @Override
    public java.util.Map<String, Uuid> topicNamesToIds() {
        int combinedSize = this.kraftCache().topicNamesToIds().size() + this.k2Cache().topicNamesToIds().size();
        HashMap<String, Uuid> cache = new HashMap<String, Uuid>(combinedSize);
        cache.putAll(this.kraftCache().topicNamesToIds());
        cache.putAll(this.k2Cache().topicNamesToIds());
        return cache;
    }

    @Override
    public java.util.Map<Uuid, String> topicIdsToNames() {
        int combinedSize = this.kraftCache().topicIdsToNames().size() + this.k2Cache().topicIdsToNames().size();
        HashMap<Uuid, String> cache = new HashMap<Uuid, String>(combinedSize);
        cache.putAll(this.kraftCache().topicIdsToNames());
        cache.putAll(this.k2Cache().topicIdsToNames());
        return cache;
    }

    @Override
    public Tuple2<java.util.Map<String, Uuid>, java.util.Map<Uuid, String>> topicIdInfo() {
        return new Tuple2<java.util.Map<String, Uuid>, java.util.Map<Uuid, String>>(this.topicNamesToIds(), this.topicIdsToNames());
    }

    public boolean isK2Topic(String topicName) {
        boolean found = this.k2Cache().topicNamesToIds().containsKey(topicName);
        if (this.validateExclusivityAcrossCaches() && found && this.kraftCache().topicNamesToIds().containsKey(topicName)) {
            throw new IllegalStateException("Topic " + topicName + " found in both kraft and k2 metadata caches.");
        }
        return found;
    }

    public boolean isK2Topic(Uuid topicId) {
        boolean found = this.k2Cache().topicIdsToNames().containsKey(topicId);
        if (this.validateExclusivityAcrossCaches() && found && this.kraftCache().topicIdsToNames().containsKey(topicId)) {
            throw new IllegalStateException("Topic " + topicId + " found in both kraft and k2 metadata caches.");
        }
        return found;
    }

    public boolean isKRaftTopic(Uuid topicId) {
        return this.kraftCache().topicIdsToNames().containsKey(topicId);
    }

    public boolean isKRaftTopic(String topicName) {
        return this.kraftCache().topicNamesToIds().containsKey(topicName);
    }

    @Override
    public Option<Node> getPartitionLeaderEndpoint(String topicName, int partitionId, ListenerName listenerName) {
        return this.kraftCache().getPartitionLeaderEndpoint(topicName, partitionId, listenerName).orElse((Function0<Option> & Serializable)() -> this.getLeaderAndIsr(topicName, partitionId).flatMap((Function1<LeaderAndIsr, Option> & Serializable)state -> this.kraftCache().getAliveBrokerNode(state.leader(), listenerName)));
    }

    @Override
    public Map<Object, Node> getPartitionReplicaEndpoints(TopicPartition tp, ListenerName listenerName) {
        Map<Object, Node> replicaEndpoints = this.kraftCache().getPartitionReplicaEndpoints(tp, listenerName);
        if (replicaEndpoints.nonEmpty()) {
            return replicaEndpoints;
        }
        Option<K2MetadataCache.ReplicaSetMetadata> option = this.k2Cache().getPartitionInfo(tp, AffinitySelector.noAffinity(), K2MetadataCache$.MODULE$.EMPTY_CLIENT_CONTEXT());
        if (None$.MODULE$.equals(option)) {
            return (Map)Map$.MODULE$.empty();
        }
        if (option instanceof Some) {
            Some some = (Some)option;
            K2MetadataCache.ReplicaSetMetadata replicaSetMetadata = (K2MetadataCache.ReplicaSetMetadata)some.value();
            return ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(replicaSetMetadata.availableReplicas()).asScala().flatMap((Function1<Integer, Option> & Serializable)r -> this.kraftCache().getAliveBrokerNode(Predef$.MODULE$.Integer2int((Integer)r), listenerName).map((Function1<Node, Tuple2> & Serializable)n -> new Tuple2<Integer, Node>(BoxesRunTime.boxToInteger(Predef$.MODULE$.Integer2int((Integer)r)), (Node)n)))).toMap($less$colon$less$.MODULE$.refl());
        }
        throw new MatchError(option);
    }

    @Override
    public Option<CachedControllerId> getControllerId() {
        return this.k2Cache().getControllerId();
    }

    @Override
    public Option<Object> getRandomAliveBrokerId() {
        return this.kraftCache().getRandomAliveBrokerId();
    }

    @Override
    public Cluster getClusterMetadata(String clusterId, ListenerName listenerName) {
        return this.kraftCache().getClusterMetadata(clusterId, listenerName);
    }

    @Override
    public boolean contains(String topicName) {
        return this.kraftCache().contains(topicName) || this.k2Cache().contains(topicName);
    }

    @Override
    public boolean contains(TopicPartition tp) {
        return this.kraftCache().contains(tp) || this.k2Cache().contains(tp);
    }

    @Override
    public void setImage(MetadataImage newImage) {
        this.kraftCache().setImage(newImage);
        this.k2Cache().setImage(newImage);
    }

    @Override
    public Properties config(ConfigResource configResource) {
        ConfigResource.Type type = configResource.type();
        ConfigResource.Type type2 = ConfigResource.Type.TOPIC;
        if (!(type != null ? !((Object)((Object)type)).equals((Object)type2) : type2 != null)) {
            Object b = this.getTopicType(configResource.name()).getOrElse((Function0<TopicType> & Serializable)() -> TopicType.UNKNOWN);
            TopicType topicType = TopicType.FREIGHT;
            if (!(b != null ? !b.equals((Object)topicType) : topicType != null)) {
                return this.k2Cache().topicConfig(configResource.name());
            }
        }
        return this.kraftCache().config(configResource);
    }

    @Override
    public MetadataVersion metadataVersion() {
        return this.kraftCache().metadataVersion();
    }

    @Override
    public FinalizedFeatures features() {
        return this.kraftCache().features();
    }

    @Override
    public boolean isBrokerDegraded(int brokerId) {
        return this.kraftCache().isBrokerDegraded(brokerId);
    }

    @Override
    public boolean isBrokerComponentDegraded(int brokerId, BrokerComponent component) {
        return this.kraftCache().isBrokerComponentDegraded(brokerId, component);
    }

    @Override
    public Option<ClusterLinkTopicState> mirrorTopicState(String topic) {
        if (this.isK2Topic(topic)) {
            throw new UnsupportedOperationException("K2 topics are not supported for mirroring yet.");
        }
        return this.kraftCache().mirrorTopicState(topic);
    }

    public CompletableFuture<MetadataResponseData.MetadataResponseTopic> adjustTopicMetadataForAffinity(K2Stack k2Stack, RequestContext requestContext, MetadataResponseData.MetadataResponseTopic topicMetadata) {
        return (CompletableFuture)this.getTopicType(topicMetadata.name()).filter((Function1<TopicType, Object> & Serializable)x$1 -> BoxesRunTime.boxToBoolean(K2KRaftMetadataCache.$anonfun$adjustTopicMetadataForAffinity$1(x$1))).map((Function1<TopicType, CompletableFuture> & Serializable)x$2 -> this.k2Cache().adjustTopicMetadataForAffinity(k2Stack, requestContext, topicMetadata)).getOrElse((Function0<CompletableFuture> & Serializable)() -> CompletableFuture.completedFuture(topicMetadata));
    }

    @Override
    public boolean linkCoordinatorEnabled() {
        return true;
    }

    @Override
    public DescribeClientQuotasResponseData describeClientQuotas(DescribeClientQuotasRequestData request) {
        return this.kraftCache().describeClientQuotas(request);
    }

    @Override
    public DescribeUserScramCredentialsResponseData describeScramCredentials(DescribeUserScramCredentialsRequestData request) {
        return this.kraftCache().describeScramCredentials(request);
    }

    @Override
    public DescribeTopicPartitionsResponseData getTopicMetadataForDescribeTopicResponse(Iterator<String> topics, ListenerName listenerName, Function1<String, Object> topicPartitionStartIndex, int maximumNumberOfPartitions, boolean ignoreTopicsWithExceptions) {
        throw new UnsupportedOperationException("DescribeTopicPartitionsResponse is not currently implemented for K2 as no clients currently implement it yet.");
    }

    public static final /* synthetic */ boolean $anonfun$adjustTopicMetadataForAffinity$1(TopicType x$1) {
        TopicType topicType = x$1;
        TopicType topicType2 = TopicType.FREIGHT;
        return !(topicType != null ? !((Object)((Object)topicType)).equals((Object)topicType2) : topicType2 != null);
    }

    public K2KRaftMetadataCache(KRaftMetadataCache kraftCache, K2MetadataCache k2Cache) {
        this.kraftCache = kraftCache;
        this.k2Cache = k2Cache;
        Logging.$init$(this);
        ConfigRepository.$init$(this);
        this.validateExclusivityAcrossCaches = true;
        if (kraftCache.brokerId() != k2Cache.brokerId()) {
            throw new IllegalStateException("Mismatch in kraftCache.brokerId=" + kraftCache.brokerId() + " and k2Cache.brokerId=" + k2Cache.brokerId());
        }
        this.logIdent_$eq("[K2KRaftMetadataCache brokerId=" + kraftCache + ".brokerId] ");
    }
}

