/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.common;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import java.util.concurrent.TimeUnit;
import kafka.restore.schedulers.RetryableException;
import kafka.tier.common.RestServerRequest;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.TrustAllStrategy;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestServerUtil {
    public static final int HTTP_MAX_RETRIES = 2;
    public static final long HTTP_RETRY_INTERVAL_IN_MS = TimeUnit.SECONDS.toMillis(3L);
    private static final Logger LOGGER = LoggerFactory.getLogger(RestServerUtil.class);
    private static final String HTTP_PREFIX = "http://";
    private static final String HTTPS_PREFIX = "https://";

    public static HttpPost buildKafkaHttpPostRequest(RestServerRequest request, URI uri) throws JsonProcessingException {
        if (request.requestType() != RestServerRequest.RestRequestType.POST) {
            throw new IllegalArgumentException("Received unsupported request of type: " + String.valueOf((Object)request.requestType()));
        }
        String body = request.requestBodyAsJson();
        HttpPost post = new HttpPost(uri);
        LOGGER.info("build http request with uri: " + uri.toString() + ", body: " + body);
        StringEntity params = new StringEntity(body, ContentType.APPLICATION_FORM_URLENCODED);
        post.setEntity(params);
        return post;
    }

    public static HttpGet buildKafkaHttpGetRequest(RestServerRequest request, URI uri) {
        if (request.requestType() != RestServerRequest.RestRequestType.GET) {
            throw new IllegalArgumentException("Received unsupported request of type: " + String.valueOf((Object)request.requestType()));
        }
        HttpGet get = new HttpGet(uri);
        LOGGER.info("build http request with uri: " + uri.toString());
        return get;
    }

    public static CloseableHttpClient buildHttpClient() {
        try {
            return HttpClients.custom().addInterceptorLast((response, context) -> {
                int statusCode = response.getStatusLine().getStatusCode();
                if (statusCode != 200) {
                    Object errorMessage = String.format("Received a failure status code %s in response.", statusCode);
                    if (statusCode == 500 || statusCode == 400) {
                        LOGGER.warn("Skipping retries for failures due to internal server error or bad request...");
                        LOGGER.error((String)errorMessage + ". Can't retry the request.");
                    } else {
                        errorMessage = (String)errorMessage + ". Throwing IOException to trigger a retry.";
                        LOGGER.error((String)errorMessage);
                        throw new IOException((String)errorMessage);
                    }
                }
            }).setRetryHandler((exception, executionCount, context) -> {
                if (executionCount < 2) {
                    long delayMs = HTTP_RETRY_INTERVAL_IN_MS * (long)executionCount;
                    try {
                        LOGGER.info(String.format("httpclient retry #%s, sleeping for %s ms before retry.", executionCount, delayMs), (Throwable)exception);
                        Thread.sleep(delayMs);
                        return true;
                    }
                    catch (InterruptedException interruptedException) {
                        LOGGER.error("Interrupted while waiting to retry HTTP request. Giving up on retrying request.", (Throwable)interruptedException);
                        return false;
                    }
                }
                LOGGER.error(String.format("exhaust max http retries: %d", 2));
                return false;
            }).setSSLContext(SSLContextBuilder.create().loadTrustMaterial(new TrustAllStrategy()).build()).setSSLHostnameVerifier(NoopHostnameVerifier.INSTANCE).build();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Loose catch block
     */
    private static String sendRequest(RestServerRequest request, CloseableHttpClient httpClient) {
        Object post;
        Closeable httpResponse;
        block18: {
            block16: {
                block17: {
                    httpResponse = null;
                    URI uri = request.uri();
                    switch (request.requestType()) {
                        case POST: {
                            post = RestServerUtil.buildKafkaHttpPostRequest(request, uri);
                            httpResponse = httpClient.execute((HttpUriRequest)post);
                            break;
                        }
                        case GET: {
                            HttpGet get = RestServerUtil.buildKafkaHttpGetRequest(request, uri);
                            httpResponse = httpClient.execute(get);
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("Received unsupported request of type: " + String.valueOf((Object)request.requestType()));
                        }
                    }
                    if (httpResponse.getStatusLine().getStatusCode() != 200) break block16;
                    LOGGER.debug("{}: Successfully received request response on broker", (Object)request.brokerUrl());
                    post = EntityUtils.toString(httpResponse.getEntity());
                    if (httpResponse == null) break block17;
                    try {
                        httpResponse.close();
                    }
                    catch (IOException e) {
                        LOGGER.error(String.format("[%s]: Received IOException while closing HTTP client after replying to request %s", request.brokerUrl(), request.requestName()), (Throwable)e);
                    }
                }
                return post;
            }
            LOGGER.error(String.format("[%s]: Received non-retryable failure status code, http response error status: %s, http response body: %s.", request.brokerUrl(), httpResponse.getStatusLine().getStatusCode(), httpResponse.getEntity().toString()));
            post = null;
            if (httpResponse == null) break block18;
            try {
                httpResponse.close();
            }
            catch (IOException e) {
                LOGGER.error(String.format("[%s]: Received IOException while closing HTTP client after replying to request %s", request.brokerUrl(), request.requestName()), (Throwable)e);
            }
        }
        return post;
        catch (Exception e) {
            try {
                String errorMessage = String.format("[%s]: Exception while executing request %s, throw retryable exception", request.brokerUrl(), request.requestName());
                LOGGER.error(errorMessage, (Throwable)e);
                throw new RetryableException(errorMessage, e);
            }
            catch (Throwable throwable) {
                if (httpResponse != null) {
                    try {
                        httpResponse.close();
                    }
                    catch (IOException e2) {
                        LOGGER.error(String.format("[%s]: Received IOException while closing HTTP client after replying to request %s", request.brokerUrl(), request.requestName()), (Throwable)e2);
                    }
                }
                throw throwable;
            }
        }
    }

    /*
     * Exception decompiling
     */
    public static String sendRequestTryHttps(RestServerRequest request, CloseableHttpClient httpClient) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [13[CATCHBLOCK]], but top level block is 4[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

