/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.domain;

import com.google.flatbuffers.FlatBufferBuilder;
import io.confluent.kafka.storage.tier.serdes.OffsetAndEpoch;
import io.confluent.kafka.storage.tier.serdes.SegmentDeleteInitiate;
import java.nio.ByteBuffer;
import java.util.Optional;
import java.util.UUID;
import kafka.tier.TopicIdPartition;
import kafka.tier.domain.AbstractTierSegmentMetadata;
import kafka.tier.domain.TierObjectMetadata;
import kafka.tier.domain.TierRecordType;

public class TierSegmentDeleteInitiate
extends AbstractTierSegmentMetadata {
    private static final byte VERSION_V1 = 1;
    private static final byte CURRENT_VERSION = 1;
    private static final int INITIAL_BUFFER_SIZE = 64;
    private final TopicIdPartition topicIdPartition;
    private final SegmentDeleteInitiate metadata;

    public TierSegmentDeleteInitiate(TopicIdPartition topicIdPartition, int tierEpoch, UUID objectId, Optional<kafka.tier.state.OffsetAndEpoch> stateOffset) {
        FlatBufferBuilder builder = new FlatBufferBuilder(64).forceDefaults(true);
        SegmentDeleteInitiate.startSegmentDeleteInitiate(builder);
        SegmentDeleteInitiate.addVersion(builder, (byte)1);
        SegmentDeleteInitiate.addTierEpoch(builder, tierEpoch);
        stateOffset.ifPresent(offsetAndEpoch -> {
            int offsetAndEpochId = OffsetAndEpoch.createOffsetAndEpoch(builder, offsetAndEpoch.offset(), offsetAndEpoch.epoch().orElse(-1));
            SegmentDeleteInitiate.addStateOffsetAndEpoch(builder, offsetAndEpochId);
        });
        int objectIdOffset = io.confluent.kafka.storage.tier.serdes.UUID.createUUID(builder, objectId.getMostSignificantBits(), objectId.getLeastSignificantBits());
        SegmentDeleteInitiate.addObjectId(builder, objectIdOffset);
        int entryId = SegmentDeleteInitiate.endSegmentDeleteInitiate(builder);
        builder.finish(entryId);
        this.topicIdPartition = topicIdPartition;
        this.metadata = SegmentDeleteInitiate.getRootAsSegmentDeleteInitiate(builder.dataBuffer());
    }

    public TierSegmentDeleteInitiate(TopicIdPartition topicIdPartition, int tierEpoch, UUID objectId, kafka.tier.state.OffsetAndEpoch stateOffset) {
        this(topicIdPartition, tierEpoch, objectId, Optional.of(stateOffset));
    }

    public TierSegmentDeleteInitiate(TopicIdPartition topicIdPartition, SegmentDeleteInitiate metadata) {
        this.topicIdPartition = topicIdPartition;
        this.metadata = metadata;
    }

    public static int initialBufferSize() {
        return 64;
    }

    @Override
    public TierRecordType type() {
        return TierRecordType.SegmentDeleteInitiate;
    }

    @Override
    public TopicIdPartition topicIdPartition() {
        return this.topicIdPartition;
    }

    @Override
    public int tierEpoch() {
        return this.metadata.tierEpoch();
    }

    @Override
    public kafka.tier.state.OffsetAndEpoch stateOffsetAndEpoch() {
        return this.metadata.stateOffsetAndEpoch() == null ? kafka.tier.state.OffsetAndEpoch.EMPTY : new kafka.tier.state.OffsetAndEpoch(this.metadata.stateOffsetAndEpoch());
    }

    @Override
    public ByteBuffer payloadBuffer() {
        return this.metadata.getByteBuffer().duplicate();
    }

    @Override
    public UUID messageId() {
        io.confluent.kafka.storage.tier.serdes.UUID objectId = this.metadata.objectId();
        return new UUID(objectId.mostSignificantBits(), objectId.leastSignificantBits());
    }

    @Override
    public TierObjectMetadata.State state() {
        return TierObjectMetadata.State.SEGMENT_DELETE_INITIATE;
    }

    public String toString() {
        return "TierSegmentDeleteInitiate(version=" + this.metadata.version() + ", topicIdPartition=" + String.valueOf(this.topicIdPartition()) + ", tierEpoch=" + this.tierEpoch() + ", objectIdAsBase64=" + this.objectIdAsBase64() + ", stateOffsetAndEpoch=" + String.valueOf(this.stateOffsetAndEpoch()) + ")";
    }
}

