/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.fetcher;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import kafka.tier.TierUnfetchedTimestampAndOffset;
import kafka.tier.fetcher.CancellationContext;
import kafka.tier.fetcher.TierFetcherMetrics;
import kafka.tier.fetcher.TierSegmentReader;
import kafka.tier.store.TierObjectStore;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.KafkaStorageException;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.purgatory.DelayedOperationKey;
import org.apache.kafka.server.purgatory.TierOffsetForTimestampOperationKey;
import org.apache.kafka.storage.internals.log.FetchedTimestampAndOffset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PendingOffsetForTimestamp
implements Runnable {
    protected static final Logger log = LoggerFactory.getLogger(PendingOffsetForTimestamp.class);
    protected final CancellationContext cancellationContext;
    protected final TierObjectStore tierObjectStore;
    protected final Map<TopicPartition, TierUnfetchedTimestampAndOffset> timestamps;
    protected final Optional<TierFetcherMetrics> tierFetcherMetrics;
    private final Consumer<DelayedOperationKey> fetchCompletionCallback;
    private final Consumer<Runnable> fetchCancellationCallback;
    protected final ConcurrentHashMap<TopicPartition, Optional<FetchedTimestampAndOffset>> results = new ConcurrentHashMap();
    protected final Uuid requestId;
    protected final TierSegmentReader reader;
    protected final String logPrefix;
    protected final Time time;
    protected final long creationTimeMs;
    private final AtomicBoolean isComplete;

    PendingOffsetForTimestamp(CancellationContext cancellationContext, TierObjectStore tierObjectStore, Map<TopicPartition, TierUnfetchedTimestampAndOffset> timestamps, Optional<TierFetcherMetrics> tierFetcherMetrics, Consumer<DelayedOperationKey> fetchCompletionCallback, Time time, Uuid requestId, String logPrefixFormat, Consumer<Runnable> fetchCancellationCallback) {
        this.cancellationContext = cancellationContext;
        this.tierObjectStore = tierObjectStore;
        this.timestamps = Collections.unmodifiableMap(timestamps);
        this.tierFetcherMetrics = tierFetcherMetrics;
        this.fetchCompletionCallback = fetchCompletionCallback;
        this.requestId = requestId;
        this.logPrefix = String.format(logPrefixFormat, requestId);
        this.reader = new TierSegmentReader(this.logPrefix);
        this.time = time;
        this.creationTimeMs = time.hiResClockMs();
        this.fetchCancellationCallback = fetchCancellationCallback;
        this.isComplete = new AtomicBoolean(false);
    }

    public boolean isDone() {
        return this.cancellationContext.isCancelled() || this.isComplete();
    }

    public boolean isComplete() {
        return this.results.size() == this.timestamps.size();
    }

    public Map<TopicPartition, Optional<FetchedTimestampAndOffset>> results() {
        return Collections.unmodifiableMap(this.results);
    }

    public void completeExceptionally(TopicPartition topicPartition, Exception exception) {
        TierUnfetchedTimestampAndOffset timestampAndOffset = this.timestamps.get(topicPartition);
        if (timestampAndOffset != null) {
            this.results.put(topicPartition, Optional.of(new FetchedTimestampAndOffset(exception)));
        }
    }

    public List<DelayedOperationKey> delayedOperationKeys() {
        return Collections.singletonList(new TierOffsetForTimestampOperationKey(this.requestId));
    }

    protected boolean complete() {
        if (this.isComplete.compareAndSet(false, true)) {
            if (this.fetchCompletionCallback != null) {
                for (DelayedOperationKey key : this.delayedOperationKeys()) {
                    this.fetchCompletionCallback.accept(key);
                }
            }
            return true;
        }
        return false;
    }

    public Map<TopicPartition, TierUnfetchedTimestampAndOffset> tierTimestampAndOffsets() {
        return this.timestamps;
    }

    protected boolean fetchable(TopicPartition topicPartition) {
        return !this.cancellationContext.isCancelled() && !this.results.containsKey(topicPartition);
    }

    public void cancel() {
        this.cancellationContext.cancel();
        if (this.complete()) {
            this.tierFetcherMetrics.ifPresent(metrics -> metrics.fetchOffsetForTimestampCancelled().record());
            if (this.fetchCancellationCallback != null) {
                this.fetchCancellationCallback.accept(this);
            }
        }
    }

    protected void putOffsetResult(TopicPartition topicPartition, Optional<Long> offsetOpt, long targetTimestamp) {
        this.results.putIfAbsent(topicPartition, offsetOpt.map(offset -> new FetchedTimestampAndOffset(targetTimestamp, (long)offset, Optional.empty())));
    }

    protected void handlePartitionError(TopicPartition topicPartition, TierUnfetchedTimestampAndOffset tierTimestampAndOffset, Throwable e) {
        log.error("{} tier offset for timestamp lookup failed to fetch TierTimestampAndOffset {} from tiered storage", new Object[]{this.logPrefix, tierTimestampAndOffset, e});
        this.tierFetcherMetrics.ifPresent(metrics -> metrics.fetchOffsetForTimestampException().record());
        this.results.putIfAbsent(topicPartition, Optional.of(new FetchedTimestampAndOffset(new KafkaStorageException(e))));
    }
}

