/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.store;

import com.google.crypto.tink.Aead;
import com.google.crypto.tink.KeyTemplate;
import com.google.crypto.tink.KeyTemplates;
import com.google.crypto.tink.KeysetHandle;
import com.google.crypto.tink.aead.AeadConfig;
import io.confluent.kafka.storage.checksum.ChecksumInfo;
import io.confluent.kafka.storage.checksum.E2EChecksumStore;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.OpenOption;
import java.security.GeneralSecurityException;
import java.time.Duration;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import kafka.server.ReplicaManager;
import kafka.tier.TopicIdPartition;
import kafka.tier.exceptions.E2EChecksumInvalidException;
import kafka.tier.exceptions.TierObjectStoreFatalException;
import kafka.tier.exceptions.TierObjectStoreRetriableException;
import kafka.tier.store.BucketHealthResult;
import kafka.tier.store.CombinedObjectStream;
import kafka.tier.store.MockInMemoryTierObjectStoreConfig;
import kafka.tier.store.OpaqueData;
import kafka.tier.store.TierObjectAttribute;
import kafka.tier.store.TierObjectStore;
import kafka.tier.store.TierObjectStoreResponse;
import kafka.tier.store.TierObjectStoreUtils;
import kafka.tier.store.VersionInformation;
import kafka.tier.store.encryption.CleartextDataKey;
import kafka.tier.store.encryption.EncryptionKeyManager;
import kafka.tier.store.encryption.KeyContext;
import kafka.tier.store.encryption.KeySha;
import kafka.tier.store.objects.CompactedSegmentUpload;
import kafka.tier.store.objects.FragmentType;
import kafka.tier.store.objects.ObjectType;
import kafka.tier.store.objects.ThrottledSegmentUpload;
import kafka.tier.store.objects.TierSegmentUpload;
import kafka.tier.store.objects.metadata.ObjectMetadata;
import kafka.tier.store.objects.metadata.ObjectStoreMetadata;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.utils.ByteBufferInputStream;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.multitenant.MultiTenantMetadata;
import org.apache.kafka.server.util.KafkaScheduler;
import scala.Function3;

public class MockInMemoryTierObjectStore
extends TierObjectStore
implements AutoCloseable {
    public static UploadedObject deleteMarker = new UploadedObject(new HashMap<String, String>(), null, null, new VersionInformation("delete-marker"), System.currentTimeMillis());
    public Function<FragmentType, Boolean> throwOnFragmentFetchCondition = fragmentType -> false;
    public Function3<String, ObjectStoreMetadata, ObjectType, Boolean> throwOnCondition = null;
    public Supplier<Boolean> throwOnListCondition = () -> false;
    private static final ConcurrentHashMap<String, ConcurrentLinkedDeque<UploadedObject>> KEY_TO_BLOB = new ConcurrentHashMap();
    private static final Aead MASTER_KEY;
    private static Map<String, String> wellKnownKeyPathMetadata;
    private final ConcurrentHashMap<FragmentType, Integer> fragmentCounts = new ConcurrentHashMap();
    private final MockInMemoryTierObjectStoreConfig config;
    private final String keyPrefix;
    private final EncryptionKeyManager encryptionKeyManager;
    private final Optional<E2EChecksumStore> checksumStoreOpt;
    private final ConcurrentHashMap<FragmentType, ChecksumInfo> checksums = new ConcurrentHashMap();

    @Override
    public String keyPrefix() {
        return this.keyPrefix;
    }

    public MockInMemoryTierObjectStore(Time time, MockInMemoryTierObjectStoreConfig config) {
        this(time, null, config, Optional.empty());
    }

    public MockInMemoryTierObjectStore(Time time, MockInMemoryTierObjectStoreConfig config, Optional<E2EChecksumStore> checksumStoreOpt) {
        this(time, null, config, checksumStoreOpt);
    }

    public MockInMemoryTierObjectStore(Time time, Metrics metrics, MockInMemoryTierObjectStoreConfig config) {
        this(time, metrics, config, Optional.empty());
    }

    public MockInMemoryTierObjectStore(Time time, Metrics metrics, MockInMemoryTierObjectStoreConfig config, Optional<E2EChecksumStore> checksumStoreOpt) {
        this.config = config;
        this.keyPrefix = config.prefix;
        this.encryptionKeyManager = new EncryptionKeyManager(time, metrics, MASTER_KEY, Duration.ofSeconds(1L));
        this.encryptionKeyManager.bindHook(new EncryptionKeyManager.WellKnownKeypathHook(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void writeWellKnownPathMetadata(Map<String, String> metadata) {
                Aead aead = MASTER_KEY;
                synchronized (aead) {
                    wellKnownKeyPathMetadata = metadata;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Map<String, String> fetchWellKnownPathMetadata() {
                Aead aead = MASTER_KEY;
                synchronized (aead) {
                    return wellKnownKeyPathMetadata;
                }
            }
        });
        this.checksumStoreOpt = checksumStoreOpt;
    }

    public List<String> getStoredKeys() {
        return this.getStored().keySet().stream().filter(k -> k.startsWith(this.keyPrefix)).collect(Collectors.toList());
    }

    public Integer fragmentCount(FragmentType fragmentType) {
        return this.fragmentCounts.getOrDefault((Object)fragmentType, 0);
    }

    public ConcurrentHashMap<FragmentType, ChecksumInfo> getChecksums() {
        return this.checksums;
    }

    private boolean shouldThrow(String method, ObjectStoreMetadata metadata, ObjectType objectType) {
        return this.throwOnCondition != null && this.throwOnCondition.apply(method, metadata, objectType) != false;
    }

    public ConcurrentHashMap<String, byte[]> getStored() {
        ConcurrentHashMap<String, byte[]> returnMap = new ConcurrentHashMap<String, byte[]>();
        for (Map.Entry<String, ConcurrentLinkedDeque<UploadedObject>> entry : KEY_TO_BLOB.entrySet()) {
            if (entry.getValue().isEmpty() || entry.getValue().getFirst() == deleteMarker) continue;
            returnMap.put(entry.getKey(), entry.getValue().getFirst().data);
        }
        return returnMap;
    }

    private String generateVersion() {
        String letters = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";
        String digits = "0123456789";
        String lettersAndDigits = letters + digits;
        Random random = new Random();
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < 1024; ++i) {
            b.append(lettersAndDigits.charAt(random.nextInt(lettersAndDigits.length())));
        }
        return b.toString();
    }

    @Override
    public TierObjectStore.Backend getBackend() {
        return TierObjectStore.Backend.Mock;
    }

    @Override
    public Map<String, List<VersionInformation>> listObject(String keyPrefix, boolean getVersionInfo) {
        if (this.throwOnListCondition.get().booleanValue()) {
            throw new TierObjectStoreRetriableException("Mocked retriable");
        }
        HashMap<String, List<VersionInformation>> blobKeysToVersions = new HashMap<String, List<VersionInformation>>();
        for (Map.Entry<String, ConcurrentLinkedDeque<UploadedObject>> entry : KEY_TO_BLOB.entrySet()) {
            String blobKey = entry.getKey();
            if (!blobKey.startsWith(keyPrefix)) continue;
            ConcurrentLinkedDeque<UploadedObject> uploadedObjects = entry.getValue();
            LinkedList versionInformation = new LinkedList();
            if (getVersionInfo) {
                uploadedObjects.forEach(blobWithMetadata -> versionInformation.add(blobWithMetadata.versionInfo));
                blobKeysToVersions.put(blobKey, versionInformation);
                continue;
            }
            if (uploadedObjects.getFirst().getVersionId().equals("delete-marker")) continue;
            blobKeysToVersions.put(blobKey, versionInformation);
        }
        return blobKeysToVersions;
    }

    @Override
    public TierObjectStoreResponse getObjectStoreFragment(ObjectStoreMetadata objectMetadata, FragmentType fragmentType, Long relativeByteOffsetStart, Long relativeByteOffsetEndExclusive, VersionInformation versionInformation) throws IOException {
        if (this.throwOnFragmentFetchCondition != null && this.throwOnFragmentFetchCondition.apply(fragmentType).booleanValue()) {
            throw new TierObjectStoreRetriableException("Mocked retriable");
        }
        return super.getObjectStoreFragment(objectMetadata, fragmentType, relativeByteOffsetStart, relativeByteOffsetEndExclusive, versionInformation);
    }

    @Override
    public TierObjectStoreResponse getObject(ObjectStoreMetadata objectMetadata, ObjectType objectType, Long byteOffsetStart, Long byteOffsetEndExclusive, VersionInformation versionInformation) throws TierObjectStoreRetriableException {
        String key = this.keyPath(objectMetadata, objectType);
        ConcurrentLinkedDeque<UploadedObject> uploadedObjectLinkedList = KEY_TO_BLOB.get(key);
        if (uploadedObjectLinkedList == null || uploadedObjectLinkedList.isEmpty() || versionInformation == null && uploadedObjectLinkedList.getFirst() == deleteMarker) {
            throw new TierObjectStoreRetriableException(String.format("Key not found: %s", key));
        }
        UploadedObject uploadedObject = versionInformation != null ? KEY_TO_BLOB.get(key).stream().filter(obj -> Objects.equals(obj.getVersionId(), versionInformation.getVersionId())).findFirst().get() : uploadedObjectLinkedList.getFirst();
        byte[] blob = uploadedObject.data;
        if (!objectMetadata.opaqueData().equals(OpaqueData.ZEROED)) {
            KeySha keySha = KeySha.fromRawBytes(objectMetadata.opaqueData().intoByteArray());
            KeyContext keyContext = this.encryptionKeyManager.keyContext(keySha);
            if (keyContext == null) {
                KeySha registeredKeySha = this.encryptionKeyManager.registerKeyFromObjectMetadata(uploadedObject.metadata);
                if (!registeredKeySha.equals(keySha)) {
                    throw new IllegalStateException("key sha does not match");
                }
                keyContext = this.encryptionKeyManager.keyContext(registeredKeySha);
            }
            if (!keyContext.cleartextDataKey.equals(uploadedObject.cleartextDataKey)) {
                throw new IllegalStateException("decryption failed, decrypted data keys do not match");
            }
        } else if (uploadedObject.encrypted()) {
            throw new IllegalStateException("tried to download an encrypted object without OpaqueData");
        }
        int start = byteOffsetStart != null ? byteOffsetStart.intValue() : 0;
        int end = (int)Math.min(byteOffsetEndExclusive != null ? byteOffsetEndExclusive : Long.MAX_VALUE, (long)blob.length);
        int byteBufferSize = end - start;
        ByteBuffer buf = ByteBuffer.allocate(byteBufferSize);
        buf.put(blob, start, byteBufferSize);
        buf.flip();
        return new MockInMemoryTierObjectStoreResponse(new ByteBufferInputStream(buf));
    }

    @Override
    public ByteBuffer getSnapshot(ObjectStoreMetadata metadata, FragmentType fragmentType, int estimatedBufferSize) {
        ByteBuffer buffer;
        if (fragmentType != FragmentType.TIER_PARTITION_STATE_METADATA_SNAPSHOT && fragmentType != FragmentType.TIER_STATE_SNAPSHOT && fragmentType != FragmentType.PRODUCER_STATE) {
            throw new IllegalArgumentException("getSnapshot does not support the given fragmentType: " + String.valueOf((Object)fragmentType));
        }
        try (TierObjectStoreResponse response = this.getObjectStoreFragment(metadata, fragmentType);){
            buffer = ByteBuffer.wrap(Utils.readFullyToArray(response.getInputStream(), estimatedBufferSize));
        }
        catch (Exception e) {
            throw new TierObjectStoreRetriableException("Encountered an exception when fetching snapshot from object store.", e);
        }
        return buffer;
    }

    @Override
    public TierObjectStore.ByokKeyHolder prepPutSegment(TopicIdPartition topicIdPartition) throws TierObjectStoreRetriableException {
        KeySha activeKeySha = this.encryptionKeyManager.activeKeySha();
        if (activeKeySha != null) {
            return this.encryptionKeyManager.getActiveKey();
        }
        return TierObjectStore.ByokKeyHolder.defaultByokKeyHolder();
    }

    @Override
    public void initMultiTenantEncryptionSupport(MultiTenantMetadata multiTenantMetadata, ReplicaManager replicaManager, KafkaScheduler kafkaScheduler) {
    }

    private void incrementFragmentCount(FragmentType fragmentType) {
        this.fragmentCounts.compute(fragmentType, (key, integer) -> integer == null ? 1 : integer + 1);
    }

    private KeyContext getKeyCtx(ObjectMetadata objectMetadata) {
        if (objectMetadata.opaqueData().equals(OpaqueData.ZEROED)) {
            return null;
        }
        KeySha keySha = KeySha.fromRawBytes(objectMetadata.opaqueData().intoByteArray());
        KeyContext keyCtx = this.encryptionKeyManager.keyContext(keySha);
        if (keyCtx == null) {
            throw new TierObjectStoreFatalException(String.format("no key context on upload for '%s'", keySha));
        }
        return keyCtx;
    }

    private void updateChecksums(FragmentType type, File file) {
        this.checksumStoreOpt.flatMap(checksumStore -> checksumStore.store().get(file.getAbsolutePath())).ifPresent(checksumInfo -> this.checksums.put(type, (ChecksumInfo)checksumInfo));
    }

    private void putSegmentAsCombinedObject(TierSegmentUpload<?> tierSegmentUpload) throws IOException {
        KeyContext keyCtx = this.getKeyCtx(tierSegmentUpload.objectMetadata());
        String combinedObjectKeyPath = this.keyPath(tierSegmentUpload.objectMetadata(), ObjectType.SEGMENT_WITH_METADATA);
        try (CombinedObjectStream combinedObjectStream = tierSegmentUpload.makeCombinedObjectStream();){
            if (combinedObjectStream.length() > Integer.MAX_VALUE) {
                throw new IllegalArgumentException("MockInMemoryTierObjectStore does not support storing combined objects with size over Integer.MAX_VALUE");
            }
            this.writeInputStreamToArray(combinedObjectKeyPath, combinedObjectStream, (int)combinedObjectStream.length(), keyCtx);
        }
        if (tierSegmentUpload instanceof ThrottledSegmentUpload && this.shouldThrow("putSegment(ThrottledSegmentUpload)", tierSegmentUpload.objectMetadata(), ObjectType.SEGMENT_WITH_METADATA)) {
            throw new TierObjectStoreRetriableException("Mocked retriable");
        }
        if (tierSegmentUpload instanceof CompactedSegmentUpload && this.shouldThrow("putSegment(CompactedSegmentUpload)", tierSegmentUpload.objectMetadata(), ObjectType.SEGMENT_WITH_METADATA)) {
            throw new TierObjectStoreRetriableException("Mocked retriable");
        }
        if (this.shouldThrow("E2EChecksumValidation", tierSegmentUpload.objectMetadata(), ObjectType.SEGMENT_WITH_METADATA)) {
            throw new E2EChecksumInvalidException(tierSegmentUpload.objectMetadata(), (Throwable)new Exception());
        }
        for (FragmentType ft : tierSegmentUpload.orderedFragmentsForCombinedObject().keySet()) {
            this.incrementFragmentCount(ft);
        }
        this.updateChecksums(FragmentType.SEGMENT, tierSegmentUpload.segment());
        this.updateChecksums(FragmentType.OFFSET_INDEX, tierSegmentUpload.offsetIdx());
        this.updateChecksums(FragmentType.TIMESTAMP_INDEX, tierSegmentUpload.timestampIdx());
    }

    private void putSegmentAsMultiObject(TierSegmentUpload<?> tierSegmentUpload) {
        KeyContext keyCtx = this.getKeyCtx(tierSegmentUpload.objectMetadata());
        String segmentKeyPath = this.keyPath(tierSegmentUpload.objectMetadata(), ObjectType.SEGMENT);
        this.writeFileToArray(segmentKeyPath, tierSegmentUpload.segment(), keyCtx);
        if (tierSegmentUpload instanceof ThrottledSegmentUpload && this.shouldThrow("putSegment(ThrottledSegmentUpload)", tierSegmentUpload.objectMetadata(), ObjectType.SEGMENT)) {
            throw new TierObjectStoreRetriableException("Mocked retriable");
        }
        if (tierSegmentUpload instanceof CompactedSegmentUpload && this.shouldThrow("putSegment(CompactedSegmentUpload)", tierSegmentUpload.objectMetadata(), ObjectType.SEGMENT)) {
            throw new TierObjectStoreRetriableException("Mocked retriable");
        }
        if (this.shouldThrow("E2EChecksumValidation", tierSegmentUpload.objectMetadata(), ObjectType.SEGMENT)) {
            throw new E2EChecksumInvalidException(tierSegmentUpload.objectMetadata(), (Throwable)new Exception());
        }
        this.incrementFragmentCount(FragmentType.SEGMENT);
        this.updateChecksums(FragmentType.SEGMENT, tierSegmentUpload.segment());
        this.writeFileToArray(this.keyPath(tierSegmentUpload.objectMetadata(), ObjectType.OFFSET_INDEX), tierSegmentUpload.offsetIdx(), keyCtx);
        this.incrementFragmentCount(FragmentType.OFFSET_INDEX);
        this.updateChecksums(FragmentType.OFFSET_INDEX, tierSegmentUpload.offsetIdx());
        this.writeFileToArray(this.keyPath(tierSegmentUpload.objectMetadata(), ObjectType.TIMESTAMP_INDEX), tierSegmentUpload.timestampIdx(), keyCtx);
        this.incrementFragmentCount(FragmentType.TIMESTAMP_INDEX);
        this.updateChecksums(FragmentType.TIMESTAMP_INDEX, tierSegmentUpload.timestampIdx());
        if (tierSegmentUpload.producerStateSnapshotOpt().isPresent()) {
            Object producerState = tierSegmentUpload.producerStateSnapshotOpt().get();
            if (producerState instanceof File) {
                this.writeFileToArray(this.keyPath(tierSegmentUpload.objectMetadata(), ObjectType.PRODUCER_STATE), (File)producerState, keyCtx);
                this.incrementFragmentCount(FragmentType.PRODUCER_STATE);
            } else if (producerState instanceof ByteBuffer) {
                this.writeBufToArray(this.keyPath(tierSegmentUpload.objectMetadata(), ObjectType.PRODUCER_STATE), (ByteBuffer)producerState, keyCtx);
                this.incrementFragmentCount(FragmentType.PRODUCER_STATE);
            }
        }
        tierSegmentUpload.txnIdxOpt().ifPresent(data -> {
            this.writeBufToArray(this.keyPath(tierSegmentUpload.objectMetadata(), ObjectType.TRANSACTION_INDEX), (ByteBuffer)data, keyCtx);
            this.incrementFragmentCount(FragmentType.TRANSACTION_INDEX);
        });
        if (tierSegmentUpload.epochStateOpt().isPresent()) {
            this.writeBufToArray(this.keyPath(tierSegmentUpload.objectMetadata(), ObjectType.EPOCH_STATE), tierSegmentUpload.epochStateOpt().get(), keyCtx);
            this.incrementFragmentCount(FragmentType.EPOCH_STATE);
        }
    }

    @Override
    public void putSegment(TierSegmentUpload<?> tierSegmentUpload) throws IOException {
        switch (tierSegmentUpload.putMode()) {
            case LegacyMultiObject: {
                this.putSegmentAsMultiObject(tierSegmentUpload);
                break;
            }
            case CombinedObject: {
                this.putSegmentAsCombinedObject(tierSegmentUpload);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported segment PUT mode: " + String.valueOf((Object)tierSegmentUpload.putMode()));
            }
        }
    }

    @Override
    public String putObject(ObjectStoreMetadata objectMetadata, File file, ObjectType objectType) {
        if (this.shouldThrow("putObject", objectMetadata, objectType)) {
            throw new TierObjectStoreRetriableException("Mocked retriable");
        }
        String key = this.keyPath(objectMetadata, objectType);
        this.writeFileToArray(key, file, null);
        return key;
    }

    @Override
    public String putBuffer(ObjectStoreMetadata objectMetadata, ByteBuffer buffer, ObjectType objectType) {
        if (this.shouldThrow("putBuffer", objectMetadata, objectType)) {
            throw new TierObjectStoreRetriableException("Mocked retriable");
        }
        String key = this.keyPath(objectMetadata, objectType);
        this.writeBufToArray(key, buffer, null);
        return key;
    }

    @Override
    public void restoreObjectByCopy(ObjectMetadata objectMetadata, String key, VersionInformation lastLiveVersion) {
        Optional<UploadedObject> toBeRestoredOpt;
        if (KEY_TO_BLOB.containsKey(key) && (toBeRestoredOpt = KEY_TO_BLOB.get(key).stream().filter(obj -> Objects.equals(obj.getVersionId(), lastLiveVersion.getVersionId())).findFirst()).isPresent()) {
            UploadedObject toBeRestored = toBeRestoredOpt.get();
            KEY_TO_BLOB.get(key).addFirst(new UploadedObject(toBeRestored.metadata, toBeRestored.cleartextDataKey, toBeRestored.data, new VersionInformation(this.generateVersion()), System.currentTimeMillis()));
        }
    }

    private void markDelete(String keyPath) {
        KEY_TO_BLOB.get(keyPath).addFirst(deleteMarker);
    }

    @Override
    public void deleteSegment(ObjectMetadata objectMetadata) {
        if (objectMetadata.isCombinedObject(this.keyPrefix)) {
            if (KEY_TO_BLOB.containsKey(this.keyPath(objectMetadata, ObjectType.SEGMENT_WITH_METADATA))) {
                this.markDelete(this.keyPath(objectMetadata, ObjectType.SEGMENT_WITH_METADATA));
            }
        } else {
            for (ObjectType type : TierObjectStore.getObjectTypesPerSegment()) {
                if (!KEY_TO_BLOB.containsKey(this.keyPath(objectMetadata, type))) continue;
                this.markDelete(this.keyPath(objectMetadata, type));
            }
        }
    }

    @Override
    public void deleteVersions(List<TierObjectStore.KeyAndVersion> keys) {
        for (TierObjectStore.KeyAndVersion k : keys) {
            if (!KEY_TO_BLOB.containsKey(k.key())) continue;
            if (k.versionId() == null) {
                KEY_TO_BLOB.get(k.key()).removeIf(element -> element.getVersionId() == null);
                this.markDelete(k.key());
                continue;
            }
            KEY_TO_BLOB.get(k.key()).removeIf(element -> element.versionInfo.getVersionId().equals(k.versionId()));
            if (KEY_TO_BLOB.get(k.key()).size() != 1 || KEY_TO_BLOB.get(k.key()).getFirst() != deleteMarker) continue;
            KEY_TO_BLOB.remove(k.key());
        }
    }

    @Override
    public TierObjectAttribute objectExists(ObjectStoreMetadata objectMetadata, ObjectType type) {
        TierObjectAttribute result = new TierObjectAttribute(false);
        if (KEY_TO_BLOB.containsKey(this.keyPath(objectMetadata, type)) && KEY_TO_BLOB.get(this.keyPath(objectMetadata, type)).getFirst() != deleteMarker) {
            result.exist = true;
            result.size = MockInMemoryTierObjectStore.KEY_TO_BLOB.get((Object)this.keyPath((ObjectStoreMetadata)objectMetadata, (ObjectType)type)).getFirst().data.length;
        }
        return result;
    }

    @Override
    public BucketHealthResult checkBucketHealth() {
        return BucketHealthResult.HEALTHY;
    }

    public void clearForClusterId() {
        this.getStoredKeys().forEach(KEY_TO_BLOB::remove);
    }

    private String keyPath(ObjectStoreMetadata objectMetadata, ObjectType objectType) {
        return TierObjectStoreUtils.keyPath(this.keyPrefix, objectMetadata, objectType);
    }

    private void upload(String filePath, KeyContext keyCtx, byte[] buf) {
        ConcurrentLinkedDeque uploadedObjects = KEY_TO_BLOB.computeIfAbsent(filePath, k -> new ConcurrentLinkedDeque());
        HashMap<String, String> metadata = keyCtx == null ? new HashMap<String, String>() : keyCtx.metadata;
        CleartextDataKey cleartextDataKey = keyCtx == null ? null : keyCtx.cleartextDataKey;
        UploadedObject obj = new UploadedObject(metadata, cleartextDataKey, buf, new VersionInformation(this.generateVersion()), System.currentTimeMillis());
        uploadedObjects.addFirst(obj);
    }

    private void writeFileToArray(String filePath, File file, KeyContext keyCtx) {
        try (FileChannel sourceChan = FileChannel.open(file.toPath(), new OpenOption[0]);){
            ByteBuffer buf = ByteBuffer.allocate((int)sourceChan.size());
            sourceChan.read(buf);
            this.upload(filePath, keyCtx, buf.array());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private void writeInputStreamToArray(String filePath, InputStream stream, int contentLength, KeyContext keyCtx) {
        try {
            if (!stream.markSupported()) {
                stream = new BufferedInputStream(stream);
            }
            byte[] bs = new byte[contentLength];
            Utils.readFully(stream, bs, false);
            this.upload(filePath, keyCtx, bs);
        }
        catch (IOException ioe) {
            throw new UncheckedIOException(ioe);
        }
    }

    private void writeBufToArray(String filePath, ByteBuffer buf, KeyContext keyCtx) {
        ByteBufferInputStream inputStream = new ByteBufferInputStream(buf);
        this.writeInputStreamToArray(filePath, inputStream, buf.limit(), keyCtx);
    }

    static {
        wellKnownKeyPathMetadata = null;
        try {
            AeadConfig.register();
            KeyTemplate keyTemplate = KeyTemplates.get((String)"AES256_GCM_RAW");
            KeysetHandle keySetHandle = KeysetHandle.generateNew((KeyTemplate)keyTemplate);
            MASTER_KEY = (Aead)keySetHandle.getPrimitive(Aead.class);
        }
        catch (GeneralSecurityException e) {
            throw new TierObjectStoreFatalException("failed to initialize Tink", e);
        }
    }

    public static class UploadedObject {
        final HashMap<String, String> metadata;
        final CleartextDataKey cleartextDataKey;
        final byte[] data;
        VersionInformation versionInfo;
        long timestamp;

        private UploadedObject(HashMap<String, String> metadata, CleartextDataKey cleartextDataKey, byte[] data, VersionInformation versionInfo, long timestamp) {
            this.metadata = metadata;
            this.cleartextDataKey = cleartextDataKey;
            this.data = data;
            this.versionInfo = versionInfo;
            this.timestamp = timestamp;
        }

        public String getVersionId() {
            return this.versionInfo.getVersionId();
        }

        boolean encrypted() {
            return this.cleartextDataKey != null;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            UploadedObject that = (UploadedObject)o;
            return this.timestamp == that.timestamp && Objects.equals(this.cleartextDataKey, that.cleartextDataKey) && Arrays.equals(this.data, that.data) && Objects.equals(this.versionInfo, that.versionInfo);
        }

        public int hashCode() {
            int result = Objects.hash(this.cleartextDataKey, this.versionInfo, this.timestamp);
            result = 31 * result + Arrays.hashCode(this.data);
            return result;
        }
    }

    private static class MockInMemoryTierObjectStoreResponse
    implements TierObjectStoreResponse {
        private final InputStream inputStream;

        MockInMemoryTierObjectStoreResponse(InputStream inputStream) {
            this.inputStream = inputStream;
        }

        @Override
        public InputStream getInputStream() {
            return this.inputStream;
        }

        @Override
        public void close() {
            try {
                this.inputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

