/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.tasks.compaction;

import com.yammer.metrics.core.Counter;
import java.io.Serializable;
import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.Random;
import java.util.concurrent.CancellationException;
import kafka.cluster.Partition;
import kafka.common.LogCleaningAbortedException;
import kafka.log.AbstractLog;
import kafka.log.Cleaner;
import kafka.log.CleanerStats;
import kafka.log.ValidateLogResult$;
import kafka.server.ReplicaManager;
import kafka.tier.TopicIdPartition;
import kafka.tier.exceptions.E2EChecksumInvalidException;
import kafka.tier.exceptions.NotTierablePartitionException;
import kafka.tier.exceptions.TierLogCompactionFencedException;
import kafka.tier.exceptions.TierLogCompactionFencedException$;
import kafka.tier.exceptions.TierMetadataRetriableException;
import kafka.tier.exceptions.TierObjectStoreRetriableException;
import kafka.tier.fetcher.CancellationContext;
import kafka.tier.store.TierObjectStore;
import kafka.tier.store.TierObjectStoreLinearRetry;
import kafka.tier.tasks.TierTask;
import kafka.tier.tasks.compaction.CompactionTask$;
import kafka.tier.tasks.compaction.TierCleaner;
import kafka.tier.tasks.compaction.TierCompactionMetrics;
import kafka.tier.tasks.compaction.TierLogToClean;
import kafka.tier.tasks.config.CompactionTasksConfig;
import kafka.tier.tasks.config.TierTasksConfig;
import kafka.tier.topic.TierTopicAppender;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.config.SegmentMetadataLayoutPutMode;
import org.apache.kafka.storage.internals.log.ExtendedOffsetMap;
import org.apache.kafka.storage.internals.log.OffsetMap;
import org.apache.kafka.storage.internals.log.OffsetMapSupplier;
import org.apache.kafka.storage.internals.utils.Throttler;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0005\r\u0015h\u0001B#G\u0005=C\u0001\u0002\u0018\u0001\u0003\u0006\u0004%\t%\u0018\u0005\tI\u0002\u0011\t\u0011)A\u0005=\"AQ\r\u0001BC\u0002\u0013\u0005c\r\u0003\u0005l\u0001\t\u0005\t\u0015!\u0003h\u0011!a\u0007A!b\u0001\n\u0003i\u0007\u0002C?\u0001\u0005\u0003\u0005\u000b\u0011\u00028\t\u0011y\u0004!\u00111A\u0005\u0002}D!ba#\u0001\u0005\u0003\u0007I\u0011ABG\u0011)\u0019\t\n\u0001B\u0001B\u0003&\u0011\u0011\u0001\u0005\u000b\u0003_\u0004!Q1A\u0005\u0002\rM\u0005BCBK\u0001\t\u0005\t\u0015!\u0003\u0002r\"Q\u0011\u0011 \u0001\u0003\u0002\u0003\u0006I!a?\t\u000f\u00055\u0002\u0001\"\u0001\u0004\u0018\"9\u0011\u0011\u0007\u0001\u0005B\u0005M\u0002\"CBS\u0001\t\u0007I\u0011ABT\u0011!\u0019I\u000b\u0001Q\u0001\n\t5\u0006\"CBV\u0001\u0001\u0007I\u0011ABW\u0011%\u0019\t\f\u0001a\u0001\n\u0003\u0019\u0019\f\u0003\u0005\u00048\u0002\u0001\u000b\u0015BBX\u0011\u001d\u0019\t\r\u0001C\u0001\u0007\u0007Dq!!!\u0001\t\u0003\u001ay\rC\u0004\u0003<\u0002!\tea\u0013\b\u000f\u0005ma\t#\u0001\u0002\u001e\u00191QI\u0012E\u0001\u0003?Aq!!\f\u0019\t\u0003\ty\u0003C\u0004\u00022a!\t&a\r\t\u0013\u0005\u0015\u0003D1A\u0005\u0002\u0005\u001d\u0003\u0002CA(1\u0001\u0006I!!\u0013\t\u0013\u0005E\u0003D1A\u0005\u0002\u0005\u001d\u0003\u0002CA*1\u0001\u0006I!!\u0013\t\u0013\u0005U\u0003D1A\u0005\u0002\u0005]\u0003\u0002CA31\u0001\u0006I!!\u0017\u0007\u0015\u0005\u001d\u0004\u0004%A\u0012\"\u0019\u000bI\u0007C\u0004\u0002l\u00052\t!a\u0012\t\u000f\u00055\u0014E\"\u0001\u0002p!9\u0011\u0011Q\u0011\u0007\u0002\u0005\reA\u0002B\u00061\u0001\u0013i\u0001\u0003\u0006\u0002l\u0015\u0012)\u001a!C\u0001\u0003\u000fB!Ba\n&\u0005#\u0005\u000b\u0011BA%\u0011)\u0011I#\nBK\u0002\u0013\u0005!1\u0006\u0005\u000b\u0005[)#\u0011#Q\u0001\n\u0005E\u0004bBA\u0017K\u0011\u0005!q\u0006\u0005\b\u0003[*C\u0011IA8\u0011\u001d\t\t)\nC!\u0005oAqA!\u0015&\t\u0003\u0011\u0019\u0006C\u0004\u0003\u0006\u0016\"IAa\"\t\u000f\teU\u0005\"\u0001\u0003\u001c\"9!1X\u0013\u0005B\tu\u0006\"\u0003B`K\u0005\u0005I\u0011\u0001Ba\u0011%\u00119-JI\u0001\n\u0003\u0011I\rC\u0005\u0003`\u0016\n\n\u0011\"\u0001\u0003b\"I!Q]\u0013\u0002\u0002\u0013\u0005#q\u001d\u0005\n\u0005o,\u0013\u0011!C\u0001\u0003\u000fB\u0011B!?&\u0003\u0003%\tAa?\t\u0013\r\u001dQ%!A\u0005B\r%\u0001\"CB\fK\u0005\u0005I\u0011AB\r\u0011%\u0019i\"JA\u0001\n\u0003\u001ay\u0002C\u0005\u0004$\u0015\n\t\u0011\"\u0011\u0004&!I1qE\u0013\u0002\u0002\u0013\u00053\u0011F\u0004\n\u0007[A\u0012\u0011!E\u0001\u0007_1\u0011Ba\u0003\u0019\u0003\u0003E\ta!\r\t\u000f\u00055R\b\"\u0001\u0004J!I!1X\u001f\u0002\u0002\u0013\u001531\n\u0005\n\u0007\u001bj\u0014\u0011!CA\u0007\u001fB\u0011b!\u0016>\u0003\u0003%\tia\u0016\t\u0013\r\u0015T(!A\u0005\n\r\u001d\u0004bBB81\u0011\u00051\u0011\u000f\u0005\b\u0007\u0003CB\u0011BBB\u00059\u0019u.\u001c9bGRLwN\u001c+bg.T!a\u0012%\u0002\u0015\r|W\u000e]1di&|gN\u0003\u0002J\u0015\u0006)A/Y:lg*\u00111\nT\u0001\u0005i&,'OC\u0001N\u0003\u0015Y\u0017MZ6b\u0007\u0001\u00192\u0001\u0001)W!\r\t&\u000bV\u0007\u0002\u0011&\u00111\u000b\u0013\u0002\t)&,'\u000fV1tWB\u0011Q\u000bA\u0007\u0002\rB\u0011qKW\u0007\u00021*\u0011\u0011\fT\u0001\u0006kRLGn]\u0005\u00037b\u0013q\u0001T8hO&tw-A\u0002dib,\u0012A\u0018\t\u0003?\nl\u0011\u0001\u0019\u0006\u0003C*\u000bqAZ3uG\",'/\u0003\u0002dA\n\u00192)\u00198dK2d\u0017\r^5p]\u000e{g\u000e^3yi\u0006!1\r\u001e=!\u0003A!x\u000e]5d\u0013\u0012\u0004\u0016M\u001d;ji&|g.F\u0001h!\tA\u0017.D\u0001K\u0013\tQ'J\u0001\tU_BL7-\u00133QCJ$\u0018\u000e^5p]\u0006\tBo\u001c9jG&#\u0007+\u0019:uSRLwN\u001c\u0011\u0002#=4gm]3u\u001b\u0006\u00048+\u001e9qY&,'/F\u0001o!\ty70D\u0001q\u0015\t\t(/A\u0002m_\u001eT!a\u001d;\u0002\u0013%tG/\u001a:oC2\u001c(BA;w\u0003\u001d\u0019Ho\u001c:bO\u0016T!!T<\u000b\u0005aL\u0018AB1qC\u000eDWMC\u0001{\u0003\ry'oZ\u0005\u0003yB\u0014\u0011c\u00144gg\u0016$X*\u00199TkB\u0004H.[3s\u0003IygMZ:fi6\u000b\u0007oU;qa2LWM\u001d\u0011\u0002\u000bM$\u0018\r^3\u0016\u0005\u0005\u0005\u0001cAA\u0002C9\u0019\u0011QA\f\u000f\t\u0005\u001d\u0011\u0011\u0004\b\u0005\u0003\u0013\t9B\u0004\u0003\u0002\f\u0005Ua\u0002BA\u0007\u0003'i!!a\u0004\u000b\u0007\u0005Ea*\u0001\u0004=e>|GOP\u0005\u0002\u001b&\u00111\nT\u0005\u0003\u0013*K!a\u0012%\u0002\u001d\r{W\u000e]1di&|g\u000eV1tWB\u0011Q\u000bG\n\u00051\u0005\u0005b\u000b\u0005\u0003\u0002$\u0005%RBAA\u0013\u0015\t\t9#A\u0003tG\u0006d\u0017-\u0003\u0003\u0002,\u0005\u0015\"AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0003\u0003;\t!\u0002\\8hO\u0016\u0014h*Y7f+\t\t)\u0004\u0005\u0003\u00028\u0005}b\u0002BA\u001d\u0003w\u0001B!!\u0004\u0002&%!\u0011QHA\u0013\u0003\u0019\u0001&/\u001a3fM&!\u0011\u0011IA\"\u0005\u0019\u0019FO]5oO*!\u0011QHA\u0013\u0003Q!UMZ1vYRl\u0015\r\u001f*fiJL8i\\;oiV\u0011\u0011\u0011\n\t\u0005\u0003G\tY%\u0003\u0003\u0002N\u0005\u0015\"aA%oi\u0006)B)\u001a4bk2$X*\u0019=SKR\u0014\u0018pQ8v]R\u0004\u0013\u0001\u0007#fM\u0006,H\u000e\u001e*fiJL\u0018J\u001c;feZ\fG.\u00138Ng\u0006IB)\u001a4bk2$(+\u001a;ss&sG/\u001a:wC2Le.T:!\u0003I!UMZ1vYR\u0014V\r\u001e:z!>d\u0017nY=\u0016\u0005\u0005e\u0003\u0003BA.\u0003Cj!!!\u0018\u000b\u0007\u0005}#*A\u0003ti>\u0014X-\u0003\u0003\u0002d\u0005u#A\u0007+jKJ|%M[3diN#xN]3MS:,\u0017M\u001d*fiJL\u0018a\u0005#fM\u0006,H\u000e\u001e*fiJL\bk\u001c7jGf\u0004#aE\"p[B\f7\r^5p]R\u000b7o[*uCR,7cA\u0011\u0002\"\u0005YA.Z1eKJ,\u0005o\\2i\u00031\u0019G.Z1oKJ\u001cF/\u0019;t)\t\t\t\b\u0005\u0004\u0002$\u0005M\u0014qO\u0005\u0005\u0003k\n)C\u0001\u0004PaRLwN\u001c\t\u0005\u0003s\ni(\u0004\u0002\u0002|)\u0011\u0011\u000fT\u0005\u0005\u0003\u007f\nYH\u0001\u0007DY\u0016\fg.\u001a:Ti\u0006$8/\u0001\u0006ue\u0006t7/\u001b;j_:$b#!\"\u0002\"\u0006\r\u0016QUA[\u0003\u000b\fy-!8\u0002l\u00065\u0018q\u001f\u000b\u0005\u0003\u000f\u000b9\n\u0005\u0004\u0002\n\u0006=\u00151S\u0007\u0003\u0003\u0017SA!!$\u0002&\u0005Q1m\u001c8dkJ\u0014XM\u001c;\n\t\u0005E\u00151\u0012\u0002\u0007\rV$XO]3\u0011\u0007\u0005U\u0015%D\u0001\u0019\u0011\u001d\tI\n\na\u0002\u00037\u000b!!Z2\u0011\t\u0005%\u0015QT\u0005\u0005\u0003?\u000bYI\u0001\tFq\u0016\u001cW\u000f^5p]\u000e{g\u000e^3yi\")A\f\na\u0001=\")Q\r\na\u0001O\"9\u0011q\u0015\u0013A\u0002\u0005%\u0016A\u0004:fa2L7-Y'b]\u0006<WM\u001d\t\u0005\u0003W\u000b\t,\u0004\u0002\u0002.*\u0019\u0011q\u0016'\u0002\rM,'O^3s\u0013\u0011\t\u0019,!,\u0003\u001dI+\u0007\u000f\\5dC6\u000bg.Y4fe\"9\u0011q\u0017\u0013A\u0002\u0005e\u0016!\u0005;jKJ$v\u000e]5d\u0003B\u0004XM\u001c3feB!\u00111XAa\u001b\t\tiLC\u0002\u0002@*\u000bQ\u0001^8qS\u000eLA!a1\u0002>\n\tB+[3s)>\u0004\u0018nY!qa\u0016tG-\u001a:\t\u000f\u0005\u001dG\u00051\u0001\u0002J\u0006yA/[3s\u001f\nTWm\u0019;Ti>\u0014X\r\u0005\u0003\u0002\\\u0005-\u0017\u0002BAg\u0003;\u0012q\u0002V5fe>\u0013'.Z2u'R|'/\u001a\u0005\b\u0003#$\u0003\u0019AAj\u0003\u0019\u0019wN\u001c4jOB!\u0011Q[Am\u001b\t\t9NC\u0002\u0002R\"KA!a7\u0002X\nyA+[3s)\u0006\u001c8n]\"p]\u001aLw\rC\u0004\u0002`\u0012\u0002\r!!9\u0002\u0013QD'o\u001c;uY\u0016\u0014\b\u0003BAr\u0003Ol!!!:\u000b\u0005e\u0013\u0018\u0002BAu\u0003K\u0014\u0011\u0002\u00165s_R$H.\u001a:\t\u000b1$\u0003\u0019\u00018\t\u000f\u0005=H\u00051\u0001\u0002r\u0006)B/[3s\u0007>l\u0007/Y2uS>tW*\u001a;sS\u000e\u001c\bcA+\u0002t&\u0019\u0011Q\u001f$\u0003+QKWM]\"p[B\f7\r^5p]6+GO]5dg\"9\u0011\u0011 \u0013A\u0002\u0005m\u0018\u0001\u0002;j[\u0016\u0004B!!@\u0003\u00065\u0011\u0011q \u0006\u00043\n\u0005!b\u0001B\u0002m\u000611m\\7n_:LAAa\u0002\u0002\u0000\n!A+[7fS\t\tSE\u0001\u0005DY\u0016\fg\u000eT8h'%)\u0013\u0011EAJ\u0005\u001f\u0011)\u0002\u0005\u0003\u0002$\tE\u0011\u0002\u0002B\n\u0003K\u0011q\u0001\u0015:pIV\u001cG\u000f\u0005\u0003\u0003\u0018\t\u0005b\u0002\u0002B\r\u0005;qA!!\u0004\u0003\u001c%\u0011\u0011qE\u0005\u0005\u0005?\t)#A\u0004qC\u000e\\\u0017mZ3\n\t\t\r\"Q\u0005\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0006\u0005\u0005?\t)#\u0001\u0007mK\u0006$WM]#q_\u000eD\u0007%A\u0005mCN$8\u000b^1ugV\u0011\u0011\u0011O\u0001\u000bY\u0006\u001cHo\u0015;biN\u0004CC\u0002B\u0019\u0005g\u0011)\u0004E\u0002\u0002\u0016\u0016Bq!a\u001b+\u0001\u0004\tI\u0005C\u0004\u0003*)\u0002\r!!\u001d\u0015-\te\"Q\bB \u0005\u0003\u0012\u0019E!\u0012\u0003H\t%#1\nB'\u0005\u001f\"B!a\"\u0003<!9\u0011\u0011\u0014\u0017A\u0004\u0005m\u0005\"\u0002/-\u0001\u0004q\u0006\"B3-\u0001\u00049\u0007bBATY\u0001\u0007\u0011\u0011\u0016\u0005\b\u0003oc\u0003\u0019AA]\u0011\u001d\t9\r\fa\u0001\u0003\u0013Dq!!5-\u0001\u0004\t\u0019\u000eC\u0004\u0002`2\u0002\r!!9\t\u000b1d\u0003\u0019\u00018\t\u000f\u0005=H\u00061\u0001\u0002r\"9\u0011\u0011 \u0017A\u0002\u0005m\u0018A\u00033p\u00072,\u0017M\u001c'pORQ\"Q\u000bB-\u00057\u0012iFa\u0018\u0003b\t\r$Q\rB7\u0005_\u0012yH!!\u0003\u0004R!\u0011q\u0011B,\u0011\u001d\tI*\fa\u0002\u00037CQ\u0001X\u0017A\u0002yCq!a..\u0001\u0004\tI\fC\u0004\u0002l5\u0002\r!!\u0013\t\u000b\u0015l\u0003\u0019A4\t\u000f\u0005\u001dV\u00061\u0001\u0002*\")A.\fa\u0001]\"9\u0011\u0011[\u0017A\u0002\t\u001d\u0004\u0003BAk\u0005SJAAa\u001b\u0002X\n)2i\\7qC\u000e$\u0018n\u001c8UCN\\7oQ8oM&<\u0007bBAd[\u0001\u0007\u0011\u0011\u001a\u0005\b\u0005cj\u0003\u0019\u0001B:\u0003\u001d\u0001X\u000f^'pI\u0016\u0004BA!\u001e\u0003|5\u0011!q\u000f\u0006\u0005\u0003#\u0014IHC\u0002\u00020ZLAA! \u0003x\ta2+Z4nK:$X*\u001a;bI\u0006$\u0018\rT1z_V$\b+\u001e;N_\u0012,\u0007bBAx[\u0001\u0007\u0011\u0011\u001f\u0005\b\u0003?l\u0003\u0019AAq\u0011\u001d\tI0\fa\u0001\u0003w\f\u0001e\u001d5pk2$Gi\u001c#vC2\u001cu.\u001c9bGRLwN\u001c,bY&$\u0017\r^5p]R1!\u0011\u0012BH\u0005/\u0003B!a\t\u0003\f&!!QRA\u0013\u0005\u001d\u0011un\u001c7fC:Da!\u001d\u0018A\u0002\tE\u0005\u0003BA=\u0005'KAA!&\u0002|\tY\u0011IY:ue\u0006\u001cG\u000fT8h\u0011\u001d\t\tN\fa\u0001\u0005O\n1B]3d_J$7\u000b^1ugRa!Q\u0014BR\u0005O\u0013IKa-\u00038B!\u00111\u0005BP\u0013\u0011\u0011\t+!\n\u0003\tUs\u0017\u000e\u001e\u0005\b\u0005K{\u0003\u0019AA\u001b\u0003\u0011!\u0018m]6\t\u000b\u0015|\u0003\u0019A4\t\u000f\t-v\u00061\u0001\u0003.\u0006!aM]8n!\u0011\t\u0019Ca,\n\t\tE\u0016Q\u0005\u0002\u0005\u0019>tw\rC\u0004\u00036>\u0002\rA!,\u0002\u0005Q|\u0007b\u0002B]_\u0001\u0007\u0011qO\u0001\u0006gR\fGo]\u0001\ti>\u001cFO]5oOR\u0011\u0011QG\u0001\u0005G>\u0004\u0018\u0010\u0006\u0004\u00032\t\r'Q\u0019\u0005\n\u0003W\n\u0004\u0013!a\u0001\u0003\u0013B\u0011B!\u000b2!\u0003\u0005\r!!\u001d\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011!1\u001a\u0016\u0005\u0003\u0013\u0012im\u000b\u0002\u0003PB!!\u0011\u001bBn\u001b\t\u0011\u0019N\u0003\u0003\u0003V\n]\u0017!C;oG\",7m[3e\u0015\u0011\u0011I.!\n\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0003^\nM'!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012TC\u0001BrU\u0011\t\tH!4\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\u0011I\u000f\u0005\u0003\u0003l\nUXB\u0001Bw\u0015\u0011\u0011yO!=\u0002\t1\fgn\u001a\u0006\u0003\u0005g\fAA[1wC&!\u0011\u0011\tBw\u00031\u0001(o\u001c3vGR\f%/\u001b;z\u00039\u0001(o\u001c3vGR,E.Z7f]R$BA!@\u0004\u0004A!\u00111\u0005B\u0000\u0013\u0011\u0019\t!!\n\u0003\u0007\u0005s\u0017\u0010C\u0005\u0004\u0006Y\n\t\u00111\u0001\u0002J\u0005\u0019\u0001\u0010J\u0019\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"aa\u0003\u0011\r\r511\u0003B\u007f\u001b\t\u0019yA\u0003\u0003\u0004\u0012\u0005\u0015\u0012AC2pY2,7\r^5p]&!1QCB\b\u0005!IE/\u001a:bi>\u0014\u0018\u0001C2b]\u0016\u000bX/\u00197\u0015\t\t%51\u0004\u0005\n\u0007\u000bA\u0014\u0011!a\u0001\u0005{\f!\u0003\u001d:pIV\u001cG/\u00127f[\u0016tGOT1nKR!!\u0011^B\u0011\u0011%\u0019)!OA\u0001\u0002\u0004\tI%\u0001\u0005iCND7i\u001c3f)\t\tI%\u0001\u0004fcV\fGn\u001d\u000b\u0005\u0005\u0013\u001bY\u0003C\u0005\u0004\u0006m\n\t\u00111\u0001\u0003~\u0006A1\t\\3b]2{w\rE\u0002\u0002\u0016v\u001aR!PB\u001a\u0007\u007f\u0001\"b!\u000e\u0004<\u0005%\u0013\u0011\u000fB\u0019\u001b\t\u00199D\u0003\u0003\u0004:\u0005\u0015\u0012a\u0002:v]RLW.Z\u0005\u0005\u0007{\u00199DA\tBEN$(/Y2u\rVt7\r^5p]J\u0002Ba!\u0011\u0004H5\u001111\t\u0006\u0005\u0007\u000b\u0012\t0\u0001\u0002j_&!!1EB\")\t\u0019y\u0003\u0006\u0002\u0003j\u0006)\u0011\r\u001d9msR1!\u0011GB)\u0007'Bq!a\u001bA\u0001\u0004\tI\u0005C\u0004\u0003*\u0001\u0003\r!!\u001d\u0002\u000fUt\u0017\r\u001d9msR!1\u0011LB1!\u0019\t\u0019#a\u001d\u0004\\AA\u00111EB/\u0003\u0013\n\t(\u0003\u0003\u0004`\u0005\u0015\"A\u0002+va2,'\u0007C\u0005\u0004d\u0005\u000b\t\u00111\u0001\u00032\u0005\u0019\u0001\u0010\n\u0019\u0002\u0019]\u0014\u0018\u000e^3SKBd\u0017mY3\u0015\u0005\r%\u0004\u0003\u0002Bv\u0007WJAa!\u001c\u0003n\n1qJ\u00196fGR\f\u0011cZ3u)&,'\u000fT8h)>\u001cE.Z1o)!\u0019\u0019h!\u001f\u0004|\ru\u0004cA+\u0004v%\u00191q\u000f$\u0003\u001dQKWM\u001d'pOR{7\t\\3b]\"1\u0011o\u0011a\u0001\u0005#Cq!!?D\u0001\u0004\tY\u0010C\u0004\u0004\u0000\r\u0003\rA!,\u0002\u00079|w/\u0001\u0006eSJ$\u0018PU1oO\u0016$ba!\"\u0004\b\u000e%\u0005\u0003CA\u0012\u0007;\u0012iK!,\t\rE$\u0005\u0019\u0001BI\u0011\u001d\u0019y\b\u0012a\u0001\u0005[\u000b\u0011b\u001d;bi\u0016|F%Z9\u0015\t\tu5q\u0012\u0005\n\u0007\u000bA\u0011\u0011!a\u0001\u0003\u0003\taa\u001d;bi\u0016\u0004SCAAy\u0003Y!\u0018.\u001a:D_6\u0004\u0018m\u0019;j_:lU\r\u001e:jGN\u0004C#\u0004+\u0004\u001a\u000em5QTBP\u0007C\u001b\u0019\u000bC\u0003]\u001b\u0001\u0007a\fC\u0003f\u001b\u0001\u0007q\rC\u0003m\u001b\u0001\u0007a\u000e\u0003\u0004\u007f\u001b\u0001\u0007\u0011\u0011\u0001\u0005\b\u0003_l\u0001\u0019AAy\u0011\u001d\tI0\u0004a\u0001\u0003w\f\u0001\u0003^1tW\u000e\u0013X-\u0019;j_:$\u0016.\\3\u0016\u0005\t5\u0016!\u0005;bg.\u001c%/Z1uS>tG+[7fA\u0005QAn\\4U_\u000ecW-\u00198\u0016\u0005\r=\u0006CBA\u0012\u0003g\u001a\u0019(\u0001\bm_\u001e$vn\u00117fC:|F%Z9\u0015\t\tu5Q\u0017\u0005\n\u0007\u000b\u0011\u0012\u0011!a\u0001\u0007_\u000b1\u0002\\8h)>\u001cE.Z1oA!\u001a1ca/\u0011\t\u0005\r2QX\u0005\u0005\u0007\u007f\u000b)C\u0001\u0005w_2\fG/\u001b7f\u0003Ui\u0017-\u001f2f+B$\u0017\r^3M_\u001e$vn\u00117fC:$\u0002ba,\u0004F\u000e\u001d71\u001a\u0005\b\u0003O#\u0002\u0019AAU\u0011\u001d\u0019I\r\u0006a\u0001\u0005[\u000b\u0011B\\8x\u001b&dG.[:\t\u000f\r5G\u00031\u0001\u0003.\u0006qQ\u000f\u001d3bi\u0016Le\u000e^3sm\u0006dGCDBi\u0007/\u001cIna7\u0004^\u000e}7\u0011\u001d\u000b\u0005\u0007'\u001c)\u000eE\u0003\u0002\n\u0006=E\u000bC\u0004\u0002\u001aV\u0001\u001d!a'\t\u000f\u0005eX\u00031\u0001\u0002|\"9\u0011qW\u000bA\u0002\u0005e\u0006bBAd+\u0001\u0007\u0011\u0011\u001a\u0005\b\u0003O+\u0002\u0019AAU\u0011\u001d\t\t.\u0006a\u0001\u0003'Dq!a8\u0016\u0001\u0004\u0019\u0019\u000f\u0005\u0004\u0002$\u0005M\u0014\u0011\u001d")
public final class CompactionTask
extends TierTask<CompactionTask> {
    private final CancellationContext ctx;
    private final TopicIdPartition topicIdPartition;
    private final OffsetMapSupplier offsetMapSupplier;
    private CompactionTaskState state;
    private final TierCompactionMetrics tierCompactionMetrics;
    private final Time time;
    private final long taskCreationTime;
    private volatile Option<TierLogToClean> logToClean;

    public static TierLogToClean getTierLogToClean(AbstractLog log, Time time, long now) {
        return CompactionTask$.MODULE$.getTierLogToClean(log, time, now);
    }

    public static TierObjectStoreLinearRetry DefaultRetryPolicy() {
        return CompactionTask$.MODULE$.DefaultRetryPolicy();
    }

    public static int DefaultRetryIntervalInMs() {
        return CompactionTask$.MODULE$.DefaultRetryIntervalInMs();
    }

    public static int DefaultMaxRetryCount() {
        return CompactionTask$.MODULE$.DefaultMaxRetryCount();
    }

    @Override
    public CancellationContext ctx() {
        return this.ctx;
    }

    @Override
    public TopicIdPartition topicIdPartition() {
        return this.topicIdPartition;
    }

    public OffsetMapSupplier offsetMapSupplier() {
        return this.offsetMapSupplier;
    }

    public CompactionTaskState state() {
        return this.state;
    }

    public void state_$eq(CompactionTaskState x$1) {
        this.state = x$1;
    }

    public TierCompactionMetrics tierCompactionMetrics() {
        return this.tierCompactionMetrics;
    }

    @Override
    public String loggerName() {
        return CompactionTask.class.getName();
    }

    public long taskCreationTime() {
        return this.taskCreationTime;
    }

    public Option<TierLogToClean> logToClean() {
        return this.logToClean;
    }

    public void logToClean_$eq(Option<TierLogToClean> x$1) {
        this.logToClean = x$1;
    }

    public Option<TierLogToClean> maybeUpdateLogToClean(ReplicaManager replicaManager, long nowMillis, long updateInterval) {
        CompactionTaskState compactionTaskState = this.state();
        None$ optLog = compactionTaskState instanceof CleanLog ? replicaManager.getLog(this.topicPartition()).filter((Function1<AbstractLog, Object> & Serializable)x$1 -> BoxesRunTime.boxToBoolean(x$1.isTierCompactable())) : None$.MODULE$;
        Option<TierLogToClean> updatedNextLogToClean = optLog.flatMap((Function1<AbstractLog, Option> & Serializable)log -> {
            if (this.logToClean().isEmpty() || this.logToClean().exists((Function1<TierLogToClean, Object> & Serializable)x$2 -> BoxesRunTime.boxToBoolean(x$2.stale(log.tierPartitionState().lastLocalMaterializedSrcOffsetAndEpoch(), updateInterval)))) {
                return new Some<TierLogToClean>(CompactionTask$.MODULE$.getTierLogToClean((AbstractLog)log, $this.time, nowMillis));
            }
            return this.logToClean();
        });
        this.logToClean_$eq(updatedNextLogToClean);
        return updatedNextLogToClean;
    }

    @Override
    public Future<CompactionTask> transition(Time time, TierTopicAppender tierTopicAppender, TierObjectStore tierObjectStore, ReplicaManager replicaManager, TierTasksConfig config, Option<Throttler> throttler, ExecutionContext ec) {
        Future<CompactionTaskState> newState = this.ctx().isCancelled() ? Future$.MODULE$.successful(this.state()) : this.state().transition(this.ctx(), this.topicIdPartition(), replicaManager, tierTopicAppender, tierObjectStore, config, throttler.get(), this.offsetMapSupplier(), this.tierCompactionMetrics(), time, ec);
        return newState.map((Function1<CompactionTaskState, CompactionTask> & Serializable)result -> {
            this.onSuccessfulTransition();
            this.debug((Function0<String> & Serializable)() -> "Transitioned " + this.topicIdPartition() + " from " + this.state() + " to " + result);
            this.state_$eq((CompactionTaskState)result);
            return this;
        }, ec).recover(new Serializable(this, config, time){
            private static final long serialVersionUID = 0L;
            private final /* synthetic */ CompactionTask $outer;
            private final TierTasksConfig config$1;
            private final Time time$1;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof TierMetadataRetriableException) {
                    TierMetadataRetriableException tierMetadataRetriableException = (TierMetadataRetriableException)A1;
                    this.$outer.retryTaskLater(this.config$1.maxRetryBackoffMs(), this.time$1.hiResClockMs(), tierMetadataRetriableException);
                    return (B1)this.$outer;
                }
                if (A1 instanceof TierObjectStoreRetriableException) {
                    TierObjectStoreRetriableException tierObjectStoreRetriableException = (TierObjectStoreRetriableException)A1;
                    this.$outer.retryTaskLater(this.config$1.maxRetryBackoffMs(), this.time$1.hiResClockMs(), tierObjectStoreRetriableException);
                    return (B1)this.$outer;
                }
                if (A1 instanceof LogCleaningAbortedException) {
                    LogCleaningAbortedException logCleaningAbortedException = (LogCleaningAbortedException)A1;
                    this.$outer.info((Function0<String> & Serializable)() -> $this.$outer.topicIdPartition() + ": compaction operation was aborted.", (Function0<Throwable>)(Function0<LogCleaningAbortedException> & Serializable)() -> logCleaningAbortedException);
                    return (B1)this.$outer;
                }
                if (A1 instanceof E2EChecksumInvalidException) {
                    E2EChecksumInvalidException e2EChecksumInvalidException = (E2EChecksumInvalidException)A1;
                    this.$outer.tierCompactionMetrics().e2eChecksumInvalidCount().foreach((Function1<Counter, Object> & Serializable)x$3 -> {
                        $anonfun$transition$3.$anonfun$applyOrElse$3(x$3);
                        return BoxedUnit.UNIT;
                    });
                    this.$outer.info((Function0<String> & Serializable)() -> $this.$outer.topicIdPartition() + ": checksum mismatch while uploading new segment.", (Function0<Throwable>)(Function0<E2EChecksumInvalidException> & Serializable)() -> e2EChecksumInvalidException);
                    this.$outer.retryTaskLater(this.config$1.maxRetryBackoffMs(), this.time$1.hiResClockMs(), e2EChecksumInvalidException);
                    return (B1)this.$outer;
                }
                if (A1 instanceof TierLogCompactionFencedException) {
                    TierLogCompactionFencedException tierLogCompactionFencedException = (TierLogCompactionFencedException)A1;
                    this.$outer.info((Function0<String> & Serializable)() -> $this.$outer.topicIdPartition() + " was fenced, stopping compaction process", (Function0<Throwable>)(Function0<TierLogCompactionFencedException> & Serializable)() -> tierLogCompactionFencedException);
                    this.$outer.ctx().cancel();
                    return (B1)this.$outer;
                }
                if (A1 instanceof CancellationException) {
                    CancellationException cancellationException = (CancellationException)A1;
                    this.$outer.info((Function0<String> & Serializable)() -> $this.$outer.topicIdPartition() + " was fenced by cancellation context, stopping compaction process", (Function0<Throwable>)(Function0<CancellationException> & Serializable)() -> cancellationException);
                    this.$outer.ctx().cancel();
                    return (B1)this.$outer;
                }
                if (A1 instanceof NotTierablePartitionException) {
                    NotTierablePartitionException notTierablePartitionException = (NotTierablePartitionException)A1;
                    this.$outer.info((Function0<String> & Serializable)() -> $this.$outer.topicIdPartition() + " is not tierable and cannot use tier compaction", (Function0<Throwable>)(Function0<NotTierablePartitionException> & Serializable)() -> notTierablePartitionException);
                    this.$outer.ctx().cancel();
                    return (B1)this.$outer;
                }
                if (A1 != null) {
                    A1 A12 = A1;
                    this.$outer.error((Function0<String> & Serializable)() -> $this.$outer.topicIdPartition() + ": unhandled exception in CompactionTask. Moving task to error state", (Function0<Throwable> & Serializable)() -> A12);
                    this.$outer.cancelAndSetErrorState(A12);
                    return (B1)this.$outer;
                }
                return function1.apply(x1);
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                if (throwable instanceof TierMetadataRetriableException) {
                    return true;
                }
                if (throwable instanceof TierObjectStoreRetriableException) {
                    return true;
                }
                if (throwable instanceof LogCleaningAbortedException) {
                    return true;
                }
                if (throwable instanceof E2EChecksumInvalidException) {
                    return true;
                }
                if (throwable instanceof TierLogCompactionFencedException) {
                    return true;
                }
                if (throwable instanceof CancellationException) {
                    return true;
                }
                if (throwable instanceof NotTierablePartitionException) {
                    return true;
                }
                return throwable != null;
            }

            public static final /* synthetic */ void $anonfun$applyOrElse$3(Counter x$3) {
                x$3.inc();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.config$1 = config$1;
                this.time$1 = time$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1(kafka.tier.tasks.compaction.CompactionTask$$anonfun$transition$3 ), $anonfun$applyOrElse$10(kafka.tier.tasks.compaction.CompactionTask$$anonfun$transition$3 ), $anonfun$applyOrElse$11(kafka.tier.exceptions.NotTierablePartitionException ), $anonfun$applyOrElse$12(kafka.tier.tasks.compaction.CompactionTask$$anonfun$transition$3 ), $anonfun$applyOrElse$13(java.lang.Throwable ), $anonfun$applyOrElse$2(kafka.common.LogCleaningAbortedException ), $anonfun$applyOrElse$3$adapted(com.yammer.metrics.core.Counter ), $anonfun$applyOrElse$4(kafka.tier.tasks.compaction.CompactionTask$$anonfun$transition$3 ), $anonfun$applyOrElse$5(kafka.tier.exceptions.E2EChecksumInvalidException ), $anonfun$applyOrElse$6(kafka.tier.tasks.compaction.CompactionTask$$anonfun$transition$3 ), $anonfun$applyOrElse$7(kafka.tier.exceptions.TierLogCompactionFencedException ), $anonfun$applyOrElse$8(kafka.tier.tasks.compaction.CompactionTask$$anonfun$transition$3 ), $anonfun$applyOrElse$9(java.util.concurrent.CancellationException )}, serializedLambda);
            }
        }, ec);
    }

    public String toString() {
        return "CompactionTask(" + this.topicIdPartition() + ", state=" + this.state().getClass().getName() + ", cancelled=" + this.ctx().isCancelled() + ")";
    }

    public CompactionTask(CancellationContext ctx, TopicIdPartition topicIdPartition, OffsetMapSupplier offsetMapSupplier, CompactionTaskState state, TierCompactionMetrics tierCompactionMetrics, Time time) {
        this.ctx = ctx;
        this.topicIdPartition = topicIdPartition;
        this.offsetMapSupplier = offsetMapSupplier;
        this.state = state;
        this.tierCompactionMetrics = tierCompactionMetrics;
        this.time = time;
        super(tierCompactionMetrics.retryRateOpt());
        this.taskCreationTime = time.milliseconds();
        this.logToClean = None$.MODULE$;
    }

    public static class CleanLog
    implements CompactionTaskState,
    Product,
    Serializable {
        private final int leaderEpoch;
        private final Option<CleanerStats> lastStats;

        @Override
        public Iterator<String> productElementNames() {
            return Product.productElementNames$(this);
        }

        @Override
        public int leaderEpoch() {
            return this.leaderEpoch;
        }

        public Option<CleanerStats> lastStats() {
            return this.lastStats;
        }

        @Override
        public Option<CleanerStats> cleanerStats() {
            return this.lastStats();
        }

        @Override
        public Future<CompactionTaskState> transition(CancellationContext ctx, TopicIdPartition topicIdPartition, ReplicaManager replicaManager, TierTopicAppender tierTopicAppender, TierObjectStore tierObjectStore, TierTasksConfig config, Throttler throttler, OffsetMapSupplier offsetMapSupplier, TierCompactionMetrics tierCompactionMetrics, Time time, ExecutionContext ec) {
            CompactionTask$.MODULE$.info((Function0<String> & Serializable)() -> "Starting tier log compaction for " + topicIdPartition);
            if (config.compactionTaskConfig().isEmpty()) {
                throw new IllegalArgumentException("Compaction task config was unexpectedly empty");
            }
            return this.doCleanLog(ctx, tierTopicAppender, this.leaderEpoch(), topicIdPartition, replicaManager, offsetMapSupplier, config.compactionTaskConfig().get(), tierObjectStore, config.segmentMetadataLayoutPutMode(), tierCompactionMetrics, throttler, time, ec).map((Function1<CompactionTaskState, CompactionTaskState> & Serializable)state -> {
                CompactionTask$.MODULE$.info((Function0<String> & Serializable)() -> "Completed tier log compaction for " + topicIdPartition);
                return state;
            }, ec);
        }

        public Future<CompactionTaskState> doCleanLog(CancellationContext ctx, TierTopicAppender tierTopicAppender, int leaderEpoch, TopicIdPartition topicIdPartition, ReplicaManager replicaManager, OffsetMapSupplier offsetMapSupplier, CompactionTasksConfig config, TierObjectStore tierObjectStore, SegmentMetadataLayoutPutMode putMode, TierCompactionMetrics tierCompactionMetrics, Throttler throttler, Time time, ExecutionContext ec) {
            return Future$.MODULE$.apply((Function0<CompactionTaskState> & Serializable)() -> {
                Either<Errors, Partition> either = replicaManager.getPartitionOrError(topicIdPartition.topicPartition());
                if (either instanceof Left) {
                    Left left = (Left)either;
                    Errors error = (Errors)((Object)((Object)left.value()));
                    throw new TierLogCompactionFencedException(topicIdPartition, (Throwable)error.exception());
                }
                if (either instanceof Right) {
                    Right right = (Right)either;
                    Partition partition = (Partition)right.value();
                    return (CompactionTaskState)partition.log().map((Function1<AbstractLog, CleanLog> & Serializable)log -> {
                        Option<CleanerStats> stats;
                        block32: {
                            OffsetMap offsetMap;
                            int tierEpoch = log.tierPartitionState().tierEpoch();
                            if (tierEpoch > leaderEpoch) {
                                throw new TierLogCompactionFencedException(topicIdPartition, TierLogCompactionFencedException$.MODULE$.$lessinit$greater$default$2());
                            }
                            if (tierEpoch < leaderEpoch) {
                                throw new TierMetadataRetriableException("Leadership not established for " + topicIdPartition + ". Backing off.");
                            }
                            if (partition.isUncleanLeader()) {
                                throw new TierMetadataRetriableException(topicIdPartition + " undergoing unclean leader recovery. Backing off.");
                            }
                            if (log.isTierMetadataStateRecovering()) {
                                throw new TierMetadataRetriableException(topicIdPartition + " undergoing tier metadata recovery. Backing off.");
                            }
                            if (log.isFrozenLogStartOffsetState()) {
                                throw new TierMetadataRetriableException(topicIdPartition + " undergoing tiered data recovery. Backing off.");
                            }
                            try {
                                offsetMap = offsetMapSupplier.getOffsetMap();
                            }
                            catch (Exception e) {
                                throw new TierMetadataRetriableException(topicIdPartition + " unable to borrow offset map from object pool. Backing off.", e);
                            }
                            OffsetMap offsetMap2 = offsetMap;
                            stats = this.lastStats();
                            try {
                                Tuple2<Object, CleanerStats> tuple2;
                                if (!log.isTierCompactable()) {
                                    CompactionTask$.MODULE$.warn((Function0<String> & Serializable)() -> "Log for " + topicIdPartition + " is not tier compact enabled, but is attempting to clean tiered segments");
                                    break block32;
                                }
                                if (log.tieredLogSegments().isEmpty()) {
                                    CompactionTask$.MODULE$.warn((Function0<String> & Serializable)() -> "Log for " + topicIdPartition + " was scheduled in tier CompactionTask but has no eligible tiered segments for compaction");
                                    throw new TierMetadataRetriableException("Log for " + topicIdPartition + " has no eligible tiered segments for tier compaction");
                                }
                                TierLogToClean cleanable = CompactionTask$.MODULE$.getTierLogToClean((AbstractLog)log, time, time.milliseconds());
                                Function1<TopicPartition, Object> & Serializable checkDone = (Function1<TopicPartition, Object> & Serializable)x$4 -> {
                                    CleanLog.$anonfun$doCleanLog$5(ctx, x$4);
                                    return BoxedUnit.UNIT;
                                };
                                TierObjectStoreLinearRetry retryPolicy = CompactionTask$.MODULE$.DefaultRetryPolicy();
                                TierCleaner cleaner = new TierCleaner(offsetMap2, config.ioBufferSize(), config.maxIoBufferSize(), config.skimpyOffsetMapLoadFactor(), throttler, tierCompactionMetrics, time, tierObjectStore, putMode, tierTopicAppender, leaderEpoch, ctx, (Function1<TopicPartition, BoxedUnit>)checkDone, retryPolicy);
                                Option<Object> lockedOffset = log.lockOffsetFromDeletion();
                                if (lockedOffset.isEmpty()) {
                                    CompactionTask$.MODULE$.warn((Function0<String> & Serializable)() -> "Log for " + topicIdPartition + " is still locked by previous compaction round. Abort current operation and will be retried.");
                                    throw new LogCleaningAbortedException();
                                }
                                cleanable.firstCleanableOffset_$eq(BoxesRunTime.unboxToLong(lockedOffset.get()));
                                try {
                                    long tierEndOffset = log.tierPartitionState().endOffset();
                                    if (this.shouldDoDualCompactionValidation((AbstractLog)log, config) && cleanable.firstCleanableOffset() >= log.localLogStartOffset() && cleanable.firstCleanableOffset() <= tierEndOffset && log.tierableLogSegments().isEmpty()) {
                                        OffsetMap localOffsetMap = CleanLog.liftedTree1$1(offsetMapSupplier, topicIdPartition);
                                        try {
                                            CompactionTask$.MODULE$.info((Function0<String> & Serializable)() -> "Starting dual compaction validation for " + topicIdPartition + " for offset range [" + cleanable.firstCleanableOffset() + ", end offset=" + tierEndOffset + "]");
                                            ExtendedOffsetMap baseOffsetMap = new ExtendedOffsetMap(localOffsetMap);
                                            Cleaner localCleaner = new Cleaner(-1, localOffsetMap, config.ioBufferSize(), config.maxIoBufferSize(), config.skimpyOffsetMapLoadFactor(), throttler, time, (Function1<TopicPartition, BoxedUnit>)checkDone, tierCompactionMetrics.cleanerMetrics());
                                            CleanerStats stats2 = new CleanerStats(time, tierCompactionMetrics.cleanerMetrics());
                                            Tuple2 tuple22 = CleanLog.liftedTree2$1(localCleaner, log, cleanable, tierEndOffset, baseOffsetMap, stats2, localOffsetMap);
                                            if (tuple22 == null) {
                                                throw new MatchError(tuple22);
                                            }
                                            boolean offsetMapSuccess = tuple22._1$mcZ$sp();
                                            String failReason = (String)tuple22._2();
                                            Tuple2<Boolean, String> tuple23 = new Tuple2<Boolean, String>(BoxesRunTime.boxToBoolean(offsetMapSuccess), failReason);
                                            boolean offsetMapSuccess2 = tuple23._1$mcZ$sp();
                                            String failReason2 = tuple23._2();
                                            if (!offsetMapSuccess2) {
                                                CompactionTask$.MODULE$.warn((Function0<String> & Serializable)() -> "Abort dual compaction validation for " + log + ". " + failReason2);
                                                stats2.validationAborted();
                                            } else if (log.tierPartitionState().endOffset() != tierEndOffset) {
                                                CompactionTask$.MODULE$.warn((Function0<String> & Serializable)() -> "Abort dual compaction validation for " + log + " because tierEndOffset changed. old tierEndOffset: " + tierEndOffset + ", new tierEndOffset: " + log.tierPartitionState().endOffset() + ".");
                                                stats2.validationAborted();
                                            } else {
                                                Enumeration.Value value = cleaner.validateLog((AbstractLog)log, cleanable.firstCleanableOffset(), tierEndOffset + 1L, baseOffsetMap, stats2);
                                                Enumeration.Value value2 = ValidateLogResult$.MODULE$.Passed();
                                                Enumeration.Value value3 = value;
                                                if (!(value2 != null ? !((Object)value2).equals(value3) : value3 != null)) {
                                                    CompactionTask$.MODULE$.info((Function0<String> & Serializable)() -> "Dual compaction validation for " + topicIdPartition + " passed");
                                                    stats2.validationPassed();
                                                } else {
                                                    Enumeration.Value value4 = ValidateLogResult$.MODULE$.Failed();
                                                    Enumeration.Value value5 = value;
                                                    if (!(value4 != null ? !((Object)value4).equals(value5) : value5 != null)) {
                                                        CompactionTask$.MODULE$.warn((Function0<String> & Serializable)() -> "Dual compaction validation for " + log + " failed");
                                                        stats2.validationFailed();
                                                    } else {
                                                        Enumeration.Value value6 = ValidateLogResult$.MODULE$.Aborted();
                                                        Enumeration.Value value7 = value;
                                                        if (!(value6 != null ? !((Object)value6).equals(value7) : value7 != null)) {
                                                            CompactionTask$.MODULE$.warn((Function0<String> & Serializable)() -> "Dual compaction validation is not able to complete for " + log + ".");
                                                            stats2.validationAborted();
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                        finally {
                                            offsetMapSupplier.reclaimOffsetMap(localOffsetMap);
                                        }
                                    }
                                    tuple2 = cleaner.clean(cleanable);
                                }
                                finally {
                                    log.unlockOffsetFromDeletion(cleanable.firstCleanableOffset());
                                }
                                Tuple2<Object, CleanerStats> tuple24 = tuple2;
                                if (tuple24 == null) {
                                    throw new MatchError(tuple24);
                                }
                                long nextDirtyOffset = tuple24._1$mcJ$sp();
                                CleanerStats cleanerStats = tuple24._2();
                                Tuple2<Long, CleanerStats> tuple25 = new Tuple2<Long, CleanerStats>(BoxesRunTime.boxToLong(nextDirtyOffset), cleanerStats);
                                long nextDirtyOffset2 = tuple25._1$mcJ$sp();
                                CleanerStats cleanerStats2 = tuple25._2();
                                if (nextDirtyOffset2 != -1L) {
                                    this.recordStats(this.toString(), topicIdPartition, cleanable.firstDirtyOffset(), nextDirtyOffset2, cleanerStats2);
                                }
                                stats = new Some<CleanerStats>(cleanerStats2);
                            }
                            finally {
                                offsetMapSupplier.reclaimOffsetMap(offsetMap2);
                            }
                        }
                        return new CleanLog(leaderEpoch, stats);
                    }).getOrElse((Function0<CleanLog> & Serializable)() -> this);
                }
                throw new MatchError(either);
            }, ec);
        }

        private boolean shouldDoDualCompactionValidation(AbstractLog log, CompactionTasksConfig config) {
            return log.config().confluentLogConfig().tierCleanerDualCompaction && config.dualCompactionValidationPercent() > 0 && log.tierPartitionState().totalSize() <= config.dualCompactionValidationMaxBytes() && new Random().nextInt(100) < config.dualCompactionValidationPercent();
        }

        public void recordStats(String task, TopicIdPartition topicIdPartition, long from, long to, CleanerStats stats) {
            String message = StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Tier Compaction Task: %s cleaned log %s (dirty section = [%d, %d))%n"), ScalaRunTime$.MODULE$.genericWrapArray(new Object[]{task, topicIdPartition.toString(), BoxesRunTime.boxToLong(from), BoxesRunTime.boxToLong(to)})) + StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("\t%,.1f MB of log processed in %,.1f seconds (%,.1f MB/sec).%n"), ScalaRunTime$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToDouble(CleanLog.mb$1(stats.bytesRead())), BoxesRunTime.boxToDouble(stats.elapsedSecs()), BoxesRunTime.boxToDouble(CleanLog.mb$1((double)stats.bytesRead() / stats.elapsedSecs()))})) + StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("\tAverage key size for records observed during this compaction run is %.2f bytes%n"), ScalaRunTime$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToDouble((double)stats.keyBytesRead() / (double)stats.messagesRead())})) + StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("\tIndexed %,.1f MB in %.1f seconds (%,.1f Mb/sec, %.1f%% of total time)%n"), ScalaRunTime$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToDouble(CleanLog.mb$1(stats.mapBytesRead())), BoxesRunTime.boxToDouble(stats.elapsedIndexSecs()), BoxesRunTime.boxToDouble(CleanLog.mb$1(stats.mapBytesRead()) / stats.elapsedIndexSecs()), BoxesRunTime.boxToDouble((double)100 * stats.elapsedIndexSecs() / stats.elapsedSecs())})) + StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("\tBuffer utilization: %.1f%%%n"), ScalaRunTime$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToDouble((double)100 * stats.bufferUtilization())})) + StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("\tCleaned %,.1f MB in %.1f seconds (%,.1f Mb/sec, %.1f%% of total time)%n"), ScalaRunTime$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToDouble(CleanLog.mb$1(stats.bytesRead())), BoxesRunTime.boxToDouble(stats.elapsedSecs() - stats.elapsedIndexSecs()), BoxesRunTime.boxToDouble(CleanLog.mb$1(stats.bytesRead()) / (stats.elapsedSecs() - stats.elapsedIndexSecs())), BoxesRunTime.boxToDouble((double)100 * (stats.elapsedSecs() - stats.elapsedIndexSecs()) / stats.elapsedSecs())})) + StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("\tThrottled time: %,.1f seconds (%.1f%% of total time)%n"), ScalaRunTime$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToDouble(stats.throttledSecs()), BoxesRunTime.boxToDouble((double)100 * stats.throttledSecs() / stats.elapsedSecs())})) + StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("\tStart size: %,.1f MB (%,d messages)%n"), ScalaRunTime$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToDouble(CleanLog.mb$1(stats.bytesRead())), BoxesRunTime.boxToLong(stats.messagesRead())})) + StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("\tEnd size: %,.1f MB (%,d messages)%n"), ScalaRunTime$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToDouble(CleanLog.mb$1(stats.bytesWritten())), BoxesRunTime.boxToLong(stats.messagesWritten())})) + StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("\t%.1f%% size reduction (%.1f%% fewer messages)%n"), ScalaRunTime$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToDouble(100.0 * (1.0 - (double)stats.bytesWritten() / (double)stats.bytesRead())), BoxesRunTime.boxToDouble(100.0 * (1.0 - (double)stats.messagesWritten() / (double)stats.messagesRead()))}));
            CompactionTask$.MODULE$.info((Function0<String> & Serializable)() -> message);
            if (stats.invalidMessagesRead() > 0L) {
                CompactionTask$.MODULE$.warn((Function0<String> & Serializable)() -> StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("\tFound %d invalid messages during compaction."), ScalaRunTime$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToLong(stats.invalidMessagesRead())})));
                return;
            }
        }

        public String toString() {
            return "CleanLog(leaderEpoch=" + this.leaderEpoch() + ")";
        }

        public CleanLog copy(int leaderEpoch, Option<CleanerStats> lastStats) {
            return new CleanLog(leaderEpoch, lastStats);
        }

        public int copy$default$1() {
            return this.leaderEpoch();
        }

        public Option<CleanerStats> copy$default$2() {
            return this.lastStats();
        }

        @Override
        public String productPrefix() {
            return "CleanLog";
        }

        @Override
        public int productArity() {
            return 2;
        }

        @Override
        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return BoxesRunTime.boxToInteger(this.leaderEpoch());
                }
                case 1: {
                    return this.lastStats();
                }
            }
            return Statics.ioobe(x$1);
        }

        @Override
        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator(this);
        }

        @Override
        public boolean canEqual(Object x$1) {
            return x$1 instanceof CleanLog;
        }

        @Override
        public String productElementName(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return "leaderEpoch";
                }
                case 1: {
                    return "lastStats";
                }
            }
            return (String)Statics.ioobe(x$1);
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix(n, this.productPrefix().hashCode());
            n = Statics.mix(n, this.leaderEpoch());
            n = Statics.mix(n, Statics.anyHash(this.lastStats()));
            return Statics.finalizeHash(n, 2);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof CleanLog)) return false;
            boolean bl = true;
            if (!bl) return false;
            CleanLog cleanLog = (CleanLog)x$1;
            if (this.leaderEpoch() != cleanLog.leaderEpoch()) return false;
            Option<CleanerStats> option = this.lastStats();
            Option<CleanerStats> option2 = cleanLog.lastStats();
            if (option == null) {
                if (option2 != null) {
                    return false;
                }
            } else if (!option.equals(option2)) return false;
            if (!cleanLog.canEqual(this)) return false;
            return true;
        }

        public static final /* synthetic */ void $anonfun$doCleanLog$5(CancellationContext ctx$1, TopicPartition x$4) {
            if (ctx$1.isCancelled()) {
                throw new CancellationException("Operation cancelled");
            }
        }

        private static final /* synthetic */ OffsetMap liftedTree1$1(OffsetMapSupplier offsetMapSupplier$1, TopicIdPartition topicIdPartition$2) {
            OffsetMap offsetMap;
            try {
                offsetMap = offsetMapSupplier$1.getOffsetMap();
            }
            catch (Exception e) {
                throw new TierMetadataRetriableException(topicIdPartition$2 + " unable to borrow offset map from object pool for dual compaction validation. Backing off.", e);
            }
            return offsetMap;
        }

        private static final /* synthetic */ Tuple2 liftedTree2$1(Cleaner localCleaner$1, AbstractLog log$2, TierLogToClean cleanable$1, long tierEndOffset$1, ExtendedOffsetMap baseOffsetMap$1, CleanerStats stats$1, OffsetMap localOffsetMap$1) {
            Tuple2<Boolean, CallSite> tuple2;
            block3: {
                try {
                    if (localCleaner$1.buildOffsetMap(log$2, cleanable$1.firstCleanableOffset(), tierEndOffset$1 + 1L, baseOffsetMap$1, stats$1)) {
                        tuple2 = new Tuple2<Boolean, CallSite>(BoxesRunTime.boxToBoolean(false), (CallSite)((Object)("offset map is too small for storing all keys in offset range [" + cleanable$1.firstCleanableOffset() + ", " + tierEndOffset$1 + "]. Offset map memory: " + localOffsetMap$1.memory() + ", slots: " + localOffsetMap$1.slots() + ".")));
                        break block3;
                    }
                    tuple2 = new Tuple2<Boolean, String>(BoxesRunTime.boxToBoolean(true), "");
                }
                catch (Throwable e) {
                    tuple2 = new Tuple2<Boolean, CallSite>(BoxesRunTime.boxToBoolean(false), (CallSite)((Object)("exception encountered when building offset map for local data in offset range [" + cleanable$1.firstCleanableOffset() + ", " + tierEndOffset$1 + "]. " + e)));
                }
            }
            return tuple2;
        }

        private static final double mb$1(double bytes) {
            return bytes / (double)0x100000;
        }

        public CleanLog(int leaderEpoch, Option<CleanerStats> lastStats) {
            this.leaderEpoch = leaderEpoch;
            this.lastStats = lastStats;
            Product.$init$(this);
        }
    }

    public static interface CompactionTaskState {
        public int leaderEpoch();

        public Option<CleanerStats> cleanerStats();

        public Future<CompactionTaskState> transition(CancellationContext var1, TopicIdPartition var2, ReplicaManager var3, TierTopicAppender var4, TierObjectStore var5, TierTasksConfig var6, Throttler var7, OffsetMapSupplier var8, TierCompactionMetrics var9, Time var10, ExecutionContext var11);
    }
}

