/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.tasks.compaction;

import java.io.Serializable;
import kafka.tier.TopicIdPartition;
import kafka.tier.fetcher.CancellationContext;
import kafka.tier.tasks.ChangeMetadata;
import kafka.tier.tasks.LeadershipChange;
import kafka.tier.tasks.StartChangeMetadata;
import kafka.tier.tasks.StartLeadership;
import kafka.tier.tasks.TierTaskQueue;
import kafka.tier.tasks.compaction.CompactionTask;
import kafka.tier.tasks.compaction.TierCompactionMetrics;
import kafka.tier.tasks.compaction.TierLogToClean;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.storage.internals.log.OffsetMapSupplier;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.AbstractSeq;
import scala.collection.immutable.List;
import scala.math.Ordering$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005%a\u0001B\u0006\r\u0001UA\u0001B\b\u0001\u0003\u0002\u0003\u0006Ia\b\u0005\tK\u0001\u0011\t\u0011)A\u0005M!AA\u0006\u0001B\u0001B\u0003%Q\u0006\u0003\u0005;\u0001\t\u0005\t\u0015!\u0003<\u0011!9\u0005A!A!\u0002\u0013A\u0005\u0002\u0003*\u0001\u0005\u0003\u0005\u000b\u0011B*\t\u000bY\u0003A\u0011A,\t\r}\u0003A\u0011\u000b\ba\u0011\u0019q\u0007\u0001\"\u0015\u000f_\"11\u0010\u0001C)\u001dq\u00141cQ8na\u0006\u001cG/[8o)\u0006\u001c8.U;fk\u0016T!!\u0004\b\u0002\u0015\r|W\u000e]1di&|gN\u0003\u0002\u0010!\u0005)A/Y:lg*\u0011\u0011CE\u0001\u0005i&,'OC\u0001\u0014\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001\u0001\f\u0011\u0007]A\"$D\u0001\u000f\u0013\tIbBA\u0007US\u0016\u0014H+Y:l#V,W/\u001a\t\u00037qi\u0011\u0001D\u0005\u0003;1\u0011abQ8na\u0006\u001cG/[8o)\u0006\u001c8.A\u0002dib\u0004\"\u0001I\u0012\u000e\u0003\u0005R!A\t\t\u0002\u000f\u0019,Go\u00195fe&\u0011A%\t\u0002\u0014\u0007\u0006t7-\u001a7mCRLwN\\\"p]R,\u0007\u0010^\u0001\t[\u0006DH+Y:lgB\u0011qEK\u0007\u0002Q)\t\u0011&A\u0003tG\u0006d\u0017-\u0003\u0002,Q\t\u0019\u0011J\u001c;\u0002\tQLW.\u001a\t\u0003]aj\u0011a\f\u0006\u0003aE\nQ!\u001e;jYNT!AM\u001a\u0002\r\r|W.\\8o\u0015\t\u0019BG\u0003\u00026m\u00051\u0011\r]1dQ\u0016T\u0011aN\u0001\u0004_J<\u0017BA\u001d0\u0005\u0011!\u0016.\\3\u0002\u00151|w\rV8DY\u0016\fg\u000eE\u0003(yiq\u0014)\u0003\u0002>Q\tIa)\u001e8di&|gN\r\t\u0003O}J!\u0001\u0011\u0015\u0003\t1{gn\u001a\t\u0004O\t#\u0015BA\")\u0005\u0019y\u0005\u000f^5p]B\u00111$R\u0005\u0003\r2\u0011a\u0002V5fe2{w\rV8DY\u0016\fg.A\tpM\u001a\u001cX\r^'baN+\b\u000f\u001d7jKJ\u0004\"!\u0013)\u000e\u0003)S!a\u0013'\u0002\u00071|wM\u0003\u0002N\u001d\u0006I\u0011N\u001c;fe:\fGn\u001d\u0006\u0003\u001fN\nqa\u001d;pe\u0006<W-\u0003\u0002R\u0015\n\trJ\u001a4tKRl\u0015\r]*vaBd\u0017.\u001a:\u0002+QLWM]\"p[B\f7\r^5p]6+GO]5dgB\u00111\u0004V\u0005\u0003+2\u0011Q\u0003V5fe\u000e{W\u000e]1di&|g.T3ue&\u001c7/\u0001\u0004=S:LGO\u0010\u000b\b1fS6\fX/_!\tY\u0002\u0001C\u0003\u001f\u000f\u0001\u0007q\u0004C\u0003&\u000f\u0001\u0007a\u0005C\u0003-\u000f\u0001\u0007Q\u0006C\u0003;\u000f\u0001\u00071\bC\u0003H\u000f\u0001\u0007\u0001\nC\u0003S\u000f\u0001\u00071+A\u0005t_J$H+Y:lgR\u0011\u0011-\u001c\t\u0004E*TbBA2i\u001d\t!w-D\u0001f\u0015\t1G#\u0001\u0004=e>|GOP\u0005\u0002S%\u0011\u0011\u000eK\u0001\ba\u0006\u001c7.Y4f\u0013\tYGN\u0001\u0003MSN$(BA5)\u0011\u0015y\u0001\u00021\u0001b\u0003\u001dqWm\u001e+bg.$2A\u00079w\u0011\u0015\t\u0018\u00021\u0001s\u0003A!x\u000e]5d\u0013\u0012\u0004\u0016M\u001d;ji&|g\u000e\u0005\u0002ti6\t\u0001#\u0003\u0002v!\t\u0001Bk\u001c9jG&#\u0007+\u0019:uSRLwN\u001c\u0005\u0006o&\u0001\r\u0001_\u0001\t[\u0016$\u0018\rZ1uCB\u0011q#_\u0005\u0003u:\u00111c\u0015;beR\u001c\u0005.\u00198hK6+G/\u00193bi\u0006\f!\"\\1z!J|7-Z:t)\ri\u0018\u0011\u0001\t\u0003OyL!a \u0015\u0003\u000f\t{w\u000e\\3b]\"1qO\u0003a\u0001\u0003\u0007\u00012aFA\u0003\u0013\r\t9A\u0004\u0002\u000f\u0007\"\fgnZ3NKR\fG-\u0019;b\u0001")
public class CompactionTaskQueue
extends TierTaskQueue<CompactionTask> {
    private final CancellationContext ctx;
    private final Time time;
    private final Function2<CompactionTask, Object, Option<TierLogToClean>> logToClean;
    private final OffsetMapSupplier offsetMapSupplier;
    private final TierCompactionMetrics tierCompactionMetrics;

    @Override
    public List<CompactionTask> sortTasks(List<CompactionTask> tasks) {
        long now = this.time.milliseconds();
        Object updated = tasks.map((Function1<CompactionTask, Tuple2> & Serializable)task -> new Tuple2<CompactionTask, Option<TierLogToClean>>((CompactionTask)task, $this.logToClean.apply((CompactionTask)task, BoxesRunTime.boxToLong(now))));
        this.debug(() -> CompactionTaskQueue.$anonfun$sortTasks$2((List)updated));
        return ((List)((AbstractSeq)((List)((List)updated).filter((Function1<Tuple2, Object> & Serializable)x0$1 -> BoxesRunTime.boxToBoolean(CompactionTaskQueue.$anonfun$sortTasks$3(x0$1)))).map((Function1<Tuple2, Tuple2> & Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 != null) {
                CompactionTask task = (CompactionTask)tuple2._1();
                Option toCleanOpt = (Option)tuple2._2();
                return new Tuple2(task, toCleanOpt.get());
            }
            throw new MatchError(tuple2);
        })).sortBy((Function1<Tuple2, TierLogToClean> & Serializable)x0$3 -> {
            Tuple2 tuple2 = x0$3;
            if (tuple2 != null) {
                TierLogToClean toClean = (TierLogToClean)tuple2._2();
                return toClean;
            }
            throw new MatchError(tuple2);
        }, Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms()))).map((Function1<Tuple2, CompactionTask> & Serializable)x0$4 -> {
            Tuple2 tuple2 = x0$4;
            if (tuple2 != null) {
                CompactionTask task = (CompactionTask)tuple2._1();
                return task;
            }
            throw new MatchError(tuple2);
        });
    }

    @Override
    public CompactionTask newTask(TopicIdPartition topicIdPartition, StartChangeMetadata metadata) {
        StartChangeMetadata startChangeMetadata = metadata;
        if (startChangeMetadata instanceof StartLeadership) {
            StartLeadership startLeadership = (StartLeadership)startChangeMetadata;
            return new CompactionTask(this.ctx.subContext(), topicIdPartition, this.offsetMapSupplier, new CompactionTask.CleanLog(startLeadership.leaderEpoch(), None$.MODULE$), this.tierCompactionMetrics, this.time);
        }
        throw new IllegalStateException("Unexpected change " + startChangeMetadata);
    }

    @Override
    public boolean mayProcess(ChangeMetadata metadata) {
        ChangeMetadata changeMetadata = metadata;
        return changeMetadata instanceof LeadershipChange;
    }

    public static final /* synthetic */ String $anonfun$sortTasks$2(List updated$1) {
        return "Ordering between task tier log to cleans: " + updated$1;
    }

    public static final /* synthetic */ boolean $anonfun$sortTasks$3(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            CompactionTask task = (CompactionTask)tuple2._1();
            Option toCleanOpt = (Option)tuple2._2();
            return toCleanOpt.exists((Function1<TierLogToClean, Object> & Serializable)x$1 -> BoxesRunTime.boxToBoolean(x$1.cleanable(task.taskCreationTime())));
        }
        throw new MatchError(tuple2);
    }

    public CompactionTaskQueue(CancellationContext ctx, int maxTasks, Time time, Function2<CompactionTask, Object, Option<TierLogToClean>> logToClean, OffsetMapSupplier offsetMapSupplier, TierCompactionMetrics tierCompactionMetrics) {
        this.ctx = ctx;
        this.time = time;
        this.logToClean = logToClean;
        this.offsetMapSupplier = offsetMapSupplier;
        this.tierCompactionMetrics = tierCompactionMetrics;
        super(ctx, maxTasks, time);
    }
}

